/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.ITypeFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTypeFormatter
implements ITypeFormatter<Date> {
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String toString(Date o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return this.dateformat.format(o);
    }

    @Override
    public String toSQLString(Date o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Date o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case POSTGRESQL: {
                return "timestamp '" + this.toString(o) + "'";
            }
        }
        return "'" + this.toString(o) + "'";
    }

    @Override
    public Date toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return this.dateformat.parse(o);
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Date> getTypeSupported() {
        return Date.class;
    }
}

