/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.ITypeFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.StringTypeFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;

public class CharacterTypeFormatter
implements ITypeFormatter<Character> {
    @Override
    public String toString(Character o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return "" + o.charValue();
    }

    @Override
    public String toSQLString(Character o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Character o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case POSTGRESQL: {
                return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'::text";
            }
        }
        return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'";
    }

    @Override
    public Character toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        if (o.length() != 1) {
            throw new ExpressionException("Object parameter has wrong length (" + o.length() + ") (required 1 for character object)");
        }
        try {
            return Character.valueOf(o.charAt(0));
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Character> getTypeSupported() {
        return Character.class;
    }
}

