/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.ITypeFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.StringTypeFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;

public class ByteArrayTypeFormatter
implements ITypeFormatter<byte[]> {
    @Override
    public String toString(byte[] o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        int max = 5120;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append('\'').append(Utilities.convertToPrintableText(o, max)).append('\'');
        }
        catch (Exception e) {
            sb.append("bytes[] not printable (" + e.getMessage() + ")");
        }
        return sb.toString();
    }

    @Override
    public String toSQLString(byte[] o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(byte[] o, TipiDatabase databaseType) throws ExpressionException {
        return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'";
    }

    @Override
    public byte[] toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return o.getBytes();
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<byte[]> getTypeSupported() {
        return byte[].class;
    }
}

