/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.ITypeFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;

public class BooleanTypeFormatter
implements ITypeFormatter<Boolean> {
    @Override
    public String toString(Boolean o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        if (o.booleanValue()) {
            return "t";
        }
        return "f";
    }

    @Override
    public String toSQLString(Boolean o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Boolean o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case ORACLE: {
                if (o != null && o.booleanValue()) {
                    return "1";
                }
                return "0";
            }
            case POSTGRESQL: 
            case MYSQL: 
            case HSQL: {
                if (o != null && o.booleanValue()) {
                    return "true";
                }
                return "false";
            }
            case SQLSERVER: {
                if (o != null && o.booleanValue()) {
                    return "'true'";
                }
                return "'false'";
            }
        }
        return "'" + this.toString(o) + "'";
    }

    @Override
    public Boolean toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            if ("t".equalsIgnoreCase(o)) {
                return true;
            }
            if ("f".equalsIgnoreCase(o)) {
                return false;
            }
            throw new Exception("String format error (expect 't' or 'f')");
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Boolean> getTypeSupported() {
        return Boolean.class;
    }
}

