/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.ComplexField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IModel;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionNotImplementedException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.LikeMode;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.AbstractBaseExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.EscapeSQLPattern;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.util.ArrayList;
import java.util.List;

public class LikeExpressionImpl
extends AbstractBaseExpressionImpl {
    private IField field;
    private String value;
    private LikeMode mode;
    private boolean caseInsensitive;

    public LikeExpressionImpl(IObjectFormatter objectFormatter, IField field, String value, LikeMode mode, boolean caseInsensitive) {
        super(objectFormatter);
        this.field = field;
        this.value = value;
        this.mode = mode;
        this.caseInsensitive = caseInsensitive;
    }

    public IField getField() {
        return this.field;
    }

    public void setField(IField field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LikeMode getMode() {
        return this.mode;
    }

    public void setMode(LikeMode mode) {
        this.mode = mode;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.caseInsensitive) {
            bf.append("lower(");
        }
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        if (this.caseInsensitive) {
            bf.append(")");
        }
        bf.append(" like '");
        String likeValue = this.value;
        Object escapeClausole = "";
        try {
            ISQLQueryObject sqlQueryObjectForEscape = SQLObjectFactory.createSQLQueryObject(TipiDatabase.POSTGRESQL);
            EscapeSQLPattern escapePattern = sqlQueryObjectForEscape.escapePatternValue(likeValue);
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            likeValue = escapePattern.getEscapeValue();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        Object likeParam = null;
        switch (this.mode) {
            case EXACT: {
                if (this.caseInsensitive) {
                    likeParam = likeValue.toLowerCase();
                    break;
                }
                likeParam = likeValue;
                break;
            }
            case ANYWHERE: {
                if (this.caseInsensitive) {
                    likeParam = "%" + likeValue.toLowerCase() + "%";
                    break;
                }
                likeParam = "%" + likeValue + "%";
                break;
            }
            case END: {
                if (this.caseInsensitive) {
                    likeParam = "%" + likeValue.toLowerCase();
                    break;
                }
                likeParam = "%" + likeValue;
                break;
            }
            case START: {
                if (this.caseInsensitive) {
                    likeParam = likeValue.toLowerCase() + "%";
                    break;
                }
                likeParam = likeValue + "%";
                break;
            }
        }
        bf.append((String)likeParam);
        bf.append("'");
        bf.append((String)escapeClausole);
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public boolean inUseField(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        return this.field.equals(field);
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        if (this.field.equals(field)) {
            ArrayList<Object> lista = new ArrayList<Object>();
            lista.add(this.value);
            return lista;
        }
        return null;
    }

    @Override
    public boolean inUseModel(IModel<?> model) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        if (model.getBaseField() != null) {
            if (this.field instanceof ComplexField) {
                ComplexField c = (ComplexField)this.field;
                return c.getFather().equals(model.getBaseField());
            }
            return model.getModeledClass().getName().equals(this.field.getClassType().getName());
        }
        return model.getModeledClass().getName().equals(this.field.getClassType().getName());
    }

    @Override
    public List<IField> getFields() throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        ArrayList<IField> lista = new ArrayList<IField>();
        lista.add(this.field);
        return lista;
    }
}

