/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.ComplexField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IModel;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionNotImplementedException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.AbstractBaseExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import java.util.ArrayList;
import java.util.List;

public class BetweenExpressionImpl
extends AbstractBaseExpressionImpl {
    private IField field;
    private Object lower;
    private Object high;

    public BetweenExpressionImpl(IObjectFormatter objectFormatter, IField field, Object lower, Object high) {
        super(objectFormatter);
        this.field = field;
        this.lower = lower;
        this.high = high;
    }

    public IField getField() {
        return this.field;
    }

    public void setField(IField field) {
        this.field = field;
    }

    public Object getLower() {
        return this.lower;
    }

    public void setLower(Object lower) {
        this.lower = lower;
    }

    public Object getHigh() {
        return this.high;
    }

    public void setHigh(Object high) {
        this.high = high;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        bf.append(" BETWEEN ");
        bf.append(" ");
        try {
            bf.append(super.getObjectFormatter().toString(this.lower));
        }
        catch (Exception e) {
            return "ERROR-LOWER: " + e.getMessage();
        }
        bf.append(" AND ");
        try {
            bf.append(super.getObjectFormatter().toString(this.high));
        }
        catch (Exception e) {
            return "ERROR-HIGH: " + e.getMessage();
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public boolean inUseField(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        return this.field.equals(field);
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        if (this.field.equals(field)) {
            ArrayList<Object> lista = new ArrayList<Object>();
            lista.add(this.lower);
            lista.add(this.high);
        }
        return null;
    }

    @Override
    public boolean inUseModel(IModel<?> model) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        if (model.getBaseField() != null) {
            if (this.field instanceof ComplexField) {
                ComplexField c = (ComplexField)this.field;
                return c.getFather().equals(model.getBaseField());
            }
            return model.getModeledClass().getName().equals(this.field.getClassType().getName());
        }
        return model.getModeledClass().getName().equals(this.field.getClassType().getName());
    }

    @Override
    public List<IField> getFields() throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return null;
        }
        ArrayList<IField> lista = new ArrayList<IField>();
        lista.add(this.field);
        return lista;
    }
}

