/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.dao.xml;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IProjectInfo;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ServiceException;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.LoaderProperties;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.Utilities;

public class XMLProperties
extends LoaderProperties {
    public XMLProperties(IProjectInfo project) throws ServiceException {
        super(Utilities.normalizedProjectName(project.getProjectName()) + ".dao.xml.properties");
    }

    public static XMLProperties getInstance(IProjectInfo project) throws ServiceException {
        return new XMLProperties(project);
    }

    public <CRUD> Class<CRUD> getServiceCRUDClass(String object) throws ServiceException {
        try {
            String p = this.properties.getProperty("service.crud." + object);
            if (p == null) {
                throw new ServiceException("Property 'service.crud." + object + "' not found in the file properties " + this.filePropertiesName);
            }
            p = p.trim();
            Class<?> serviceClass = Class.forName(p);
            return serviceClass;
        }
        catch (Exception e) {
            throw new ServiceException("Loading service CRUD class failed: " + e.getMessage(), e);
        }
    }

    public <CRUD> CRUD getServiceCRUD(String object) throws ServiceException {
        try {
            return this.getServiceCRUDClass(object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Loading service CRUD class failed: " + e.getMessage(), e);
        }
    }

    public <SEARCH> Class<SEARCH> getServiceSearchClass(String object) throws ServiceException {
        try {
            String p = this.properties.getProperty("service.search." + object);
            if (p == null) {
                throw new ServiceException("Property 'service.search." + object + "' not found in the file properties " + this.filePropertiesName);
            }
            p = p.trim();
            Class<?> serviceClass = Class.forName(p);
            return serviceClass;
        }
        catch (Exception e) {
            throw new ServiceException("Loading service Search class failed: " + e.getMessage(), e);
        }
    }

    public <SEARCH> SEARCH getServiceSearch(String object) throws ServiceException {
        try {
            return this.getServiceSearchClass(object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Loading service Search class failed: " + e.getMessage(), e);
        }
    }
}

