/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils;

import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_DB2SQLQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_DerbyQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_HyperQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_MySQLQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_OracleQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_PostgreSQLQueryObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBC_SQLServerQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectCore;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;

public class JDBC_SQLObjectFactory {
    private boolean selectForUpdate = false;

    public boolean isSelectForUpdate() {
        return this.selectForUpdate;
    }

    public void setSelectForUpdate(boolean selectForUpdate) {
        this.selectForUpdate = selectForUpdate;
    }

    public ISQLQueryObject createSQLQueryObject(TipiDatabase tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = null;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                sqlQueryObject = new JDBC_PostgreSQLQueryObject(this);
                break;
            }
            case MYSQL: {
                sqlQueryObject = new JDBC_MySQLQueryObject(this);
                break;
            }
            case ORACLE: {
                sqlQueryObject = new JDBC_OracleQueryObject(this);
                break;
            }
            case HSQL: {
                sqlQueryObject = new JDBC_HyperQueryObject(this);
                break;
            }
            case DERBY: {
                sqlQueryObject = new JDBC_DerbyQueryObject(this);
                break;
            }
            case SQLSERVER: {
                sqlQueryObject = new JDBC_SQLServerQueryObject(this);
                break;
            }
            case DB2: {
                sqlQueryObject = new JDBC_DB2SQLQueryObject(this);
                break;
            }
            case DEFAULT: {
                throw new SQLQueryObjectException("Tipo database non gestito [" + tipoDatabase + "]");
            }
        }
        sqlQueryObject.setSelectForUpdate(this.selectForUpdate);
        ((SQLQueryObjectCore)sqlQueryObject).setForceSelectForUpdateDisabledForNotQueryMethod(true);
        return sqlQueryObject;
    }
}

