/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IEnumeration;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCObject;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;

public class JDBCSqlLogger {
    private Logger log = null;
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public JDBCSqlLogger(Logger log) {
        this.log = log;
    }

    public void debug(String msg) {
        this.log.debug(msg);
    }

    public void debugSql(String sql) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.sqlLog(sql, new JDBCObject[0]));
        }
    }

    public void debugSql(String sql, JDBCObject ... param) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.sqlLog(sql, param));
        }
    }

    public void info(String msg) {
        this.log.info(msg);
    }

    public void infoSql(String sql) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.sqlLog(sql, new JDBCObject[0]));
        }
    }

    public void infoSql(String sql, JDBCObject ... param) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.sqlLog(sql, param));
        }
    }

    public void error(String msg) {
        this.log.error(msg);
    }

    public void error(String msg, Throwable t) {
        this.log.error(msg, t);
    }

    public void errorSql(Throwable t, String sql) {
        this.log.error(this.sqlLog(sql, new JDBCObject[0]), t);
    }

    public void errorSql(Throwable t, String sql, JDBCObject ... param) {
        this.log.error(this.sqlLog(sql, param), t);
    }

    public String sqlLog(String sql, JDBCObject ... params) {
        String ret = "SQL: " + sql;
        if (params == null || params.length == 0) {
            return ret;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            if (sb.length() != 0) {
                sb.append(",\n");
            }
            Object object = params[i].getObject();
            Class<?> type = params[i].getTypeObject();
            sb.append("\t- param(" + (i + 1) + ") type(" + type + ") value(");
            this.logParam(object, type, sb);
            sb.append(")");
        }
        return ret + "; PARAMS: \n" + sb.toString();
    }

    private void logParam(Object object, Class<?> type, StringBuffer sb) {
        if (object == null) {
            sb.append("null");
        } else if (type.getName().equals(String.class.getName())) {
            sb.append('\'').append(object).append('\'');
        } else if (type.getName().equals(Character.class.getName())) {
            Character valueWrapped = (Character)object;
            char charPrimitiveValue = valueWrapped.charValue();
            String charValue = "" + valueWrapped.charValue();
            if (charPrimitiveValue == '\u0000') {
                charValue = null;
            }
            if (charValue != null) {
                sb.append('\'').append(charValue).append('\'');
            } else {
                sb.append("null");
            }
        } else if (type.getName().equals(Character.TYPE.getName())) {
            Character valueWrapped = (Character)object;
            char charPrimitiveValue = valueWrapped.charValue();
            String charValue = "" + valueWrapped.charValue();
            if (charPrimitiveValue == '\u0000') {
                charValue = null;
            }
            if (charValue != null) {
                sb.append('\'').append(charValue).append('\'');
            } else {
                sb.append("null");
            }
        } else if (type.getName().equals(Boolean.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Boolean.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Byte.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Byte.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Short.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Short.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Integer.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Integer.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Long.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Long.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Double.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Double.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(Float.class.getName())) {
            sb.append(object.toString());
        } else if (type.getName().equals(Float.TYPE.getName())) {
            sb.append(object);
        } else if (type.getName().equals(java.util.Date.class.getName())) {
            sb.append('\'').append(this.dateformat.format((java.util.Date)object)).append('\'');
        } else if (type.getName().equals(Date.class.getName())) {
            sb.append('\'').append(this.dateformat.format((Date)object)).append('\'');
        } else if (type.getName().equals(Timestamp.class.getName())) {
            sb.append('\'').append(this.dateformat.format(new java.util.Date(((Timestamp)object).getTime()))).append('\'');
        } else if (type.getName().equals(Calendar.class.getName())) {
            sb.append('\'').append(this.dateformat.format(new java.util.Date(((Calendar)object).getTime().getTime()))).append('\'');
        } else if (type.getName().equals(byte[].class.getName())) {
            int max = 5120;
            try {
                sb.append('\'').append(Utilities.convertToPrintableText((byte[])object, max)).append('\'');
            }
            catch (Exception e) {
                sb.append("bytes[] not printable (" + e.getMessage() + ")");
            }
        } else if (type.getName().equals(URI.class.getName())) {
            sb.append('\'').append(object).append('\'');
        } else if (object != null && object instanceof IEnumeration) {
            IEnumeration enumObject = (IEnumeration)object;
            Object value = enumObject.getValue();
            Class<?> cValue = null;
            if (value != null) {
                cValue = value.getClass();
            }
            sb.append("IEnumeration ");
            this.logParam(value, cValue, sb);
        } else {
            sb.append("!!ERROR Print not supported for this type");
        }
    }
}

