/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IProjectInfo;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.JDBCLoggerProperties;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.JDBCServiceManagerTipoCostruttore;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ServiceException;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.ServiceManagerProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class JDBCServiceManager {
    protected DataSource datasource;
    protected Connection connection = null;
    protected Logger log = null;
    protected JDBCServiceManagerProperties jdbcProperties = null;
    private JDBCServiceManagerTipoCostruttore tipoCostruttore = null;

    protected JDBCServiceManager() {
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(jndiName, contextJNDI, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(jndiName, contextJNDI, jdbcProperties, null);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(jndiName, contextJNDI, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManager(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.DATASOURCE_CFG;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManager.class) : alog;
        try {
            GestoreJNDI gestoreJNDI = new GestoreJNDI(contextJNDI);
            this.datasource = (DataSource)gestoreJNDI.lookup(jndiName);
            if (this.datasource == null) {
                throw new Exception("Datasource is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.log.error("Creating failure: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("Creating failure: " + e.getMessage(), e);
        }
    }

    public JDBCServiceManager(DataSource ds, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(ds, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManager(DataSource ds, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(ds, jdbcProperties, null);
    }

    public JDBCServiceManager(DataSource ds, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(ds, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManager(DataSource ds, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.DATASOURCE_OBJECT;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManager.class) : alog;
        try {
            this.datasource = ds;
            if (this.datasource == null) {
                throw new Exception("Datasource is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.log.error("Creating failure: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("Creating failure: " + e.getMessage(), e);
        }
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, jdbcProperties, null);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManager(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.CONNECTION_CFG;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManager.class) : alog;
        try {
            Class.forName(driverJDBC).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.connection = username != null ? DriverManager.getConnection(connectionUrl, username, password) : DriverManager.getConnection(connectionUrl);
            if (this.connection == null) {
                throw new Exception("Connection is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.log.error("Creating failure: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("Creating failure: " + e.getMessage(), e);
        }
    }

    public JDBCServiceManager(Connection connection, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(connection, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(connection, jdbcProperties, null);
    }

    public JDBCServiceManager(Connection connection, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(connection, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.CONNECTION_OBJECT;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManager.class) : alog;
        try {
            this.connection = connection;
            if (this.connection == null) {
                throw new Exception("Connection is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.log.error("Creating failure: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("Creating failure: " + e.getMessage(), e);
        }
    }

    public void close() throws ServiceException {
        try {
            if (this.tipoCostruttore != null) {
                switch (this.tipoCostruttore) {
                    case CONNECTION_CFG: {
                        if (this.connection == null) break;
                        this.connection.close();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("Close failure: " + e.getMessage(), e);
        }
    }

    protected Connection getConnection() throws ServiceException {
        try {
            if (this.datasource != null) {
                return this.datasource.getConnection();
            }
            if (this.connection != null) {
                return this.connection;
            }
            throw new Exception("ServiceManager not initialized");
        }
        catch (Exception e) {
            throw new ServiceException("Get Connection failure: " + e.getMessage(), e);
        }
    }

    protected void closeConnection(Connection connection) throws ServiceException {
        block6: {
            try {
                if (connection == null) {
                    throw new ServiceException("Connection is null");
                }
                if (this.datasource != null) {
                    connection.close();
                    break block6;
                }
                if (this.connection != null) {
                    if (connection.isClosed()) {
                        throw new Exception("The connection provided shall not be closed");
                    }
                    break block6;
                }
                throw new Exception("ServiceManager not initialized");
            }
            catch (Exception e) {
                throw new ServiceException("Get Connection failure: " + e.getMessage(), e);
            }
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public JDBCServiceManagerProperties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public static void configureDefaultLog4jProperties(IProjectInfo project) throws ServiceException {
        JDBCLoggerProperties loggerProperties = new JDBCLoggerProperties(project);
        loggerProperties.configureLog4j();
    }

    public static void configureLog4jProperties(File log4jProperties) throws ServiceException {
        JDBCLoggerProperties loggerProperties = new JDBCLoggerProperties(null, log4jProperties);
        loggerProperties.configureLog4j();
    }
}

