/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IProjectInfo;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ServiceException;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.LoaderProperties;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.Utilities;
import java.util.Hashtable;

public class JDBCProperties
extends LoaderProperties {
    private static Hashtable<String, JDBCProperties> mapJDBCProperties = new Hashtable();

    public JDBCProperties(IProjectInfo project) throws ServiceException {
        super(Utilities.normalizedProjectName(project.getProjectName()) + ".dao.jdbc.properties");
    }

    private static synchronized void initJDBCProperties(IProjectInfo project) throws ServiceException {
        String key = project.getProjectName();
        if (!mapJDBCProperties.containsKey(key)) {
            mapJDBCProperties.put(key, new JDBCProperties(project));
        }
    }

    public static JDBCProperties getInstance(IProjectInfo project) throws ServiceException {
        String key = project.getProjectName();
        if (!mapJDBCProperties.containsKey(key)) {
            JDBCProperties.initJDBCProperties(project);
        }
        return mapJDBCProperties.get(key);
    }

    public <CRUD> Class<CRUD> getServiceCRUDClass(String object) throws ServiceException {
        try {
            String p = this.properties.getProperty("service.crud." + object);
            if (p == null) {
                throw new ServiceException("Property 'service.crud." + object + "' not found in the file properties " + this.filePropertiesName);
            }
            p = p.trim();
            Class<?> serviceClass = Class.forName(p);
            return serviceClass;
        }
        catch (Exception e) {
            throw new ServiceException("Loading service CRUD class failed: " + e.getMessage(), e);
        }
    }

    public <CRUD> CRUD getServiceCRUD(String object) throws ServiceException {
        try {
            return this.getServiceCRUDClass(object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Loading service CRUD class failed: " + e.getMessage(), e);
        }
    }

    public <SEARCH> Class<SEARCH> getServiceSearchClass(String object) throws ServiceException {
        try {
            String p = this.properties.getProperty("service.search." + object);
            if (p == null) {
                throw new ServiceException("Property 'service.search." + object + "' not found in the file properties " + this.filePropertiesName);
            }
            p = p.trim();
            Class<?> serviceClass = Class.forName(p);
            return serviceClass;
        }
        catch (Exception e) {
            throw new ServiceException("Loading service Search class failed: " + e.getMessage(), e);
        }
    }

    public <SEARCH> SEARCH getServiceSearch(String object) throws ServiceException {
        try {
            return this.getServiceSearchClass(object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Loading service Search class failed: " + e.getMessage(), e);
        }
    }
}

