/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.beans;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.CustomField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.util.Date;

public class UnixTimestampIntervalField
extends CustomField {
    private static int counter = 0;
    private String alias = null;

    public UnixTimestampIntervalField(String fieldName, ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        super(fieldName, Long.class, UnixTimestampIntervalField.buildFunction(fieldConverter, appendTablePrefix, maxInterval, minInterval), fieldName, "", "");
    }

    private static String buildFunction(ISQLFieldConverter fieldConverter, boolean appendTablePrefix, IField maxInterval, IField minInterval) throws ExpressionException, SQLQueryObjectException {
        if (maxInterval == null) {
            throw new ExpressionException("MaxInterval is null");
        }
        if (minInterval == null) {
            throw new ExpressionException("MinInterval is null");
        }
        if (!Date.class.getName().equals(maxInterval.getFieldType().getName())) {
            throw new ExpressionException("MaxInterval with wrong type, expected:" + Date.class.getName() + " found:" + maxInterval.getFieldType());
        }
        if (!Date.class.getName().equals(minInterval.getFieldType().getName())) {
            throw new ExpressionException("MinInterval with wrong type, expected:" + Date.class.getName() + " found:" + minInterval.getFieldType());
        }
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(fieldConverter.getDatabaseType());
        return sqlQueryObject.getDiffUnixTimestamp(fieldConverter.toColumn(maxInterval, appendTablePrefix), fieldConverter.toColumn(minInterval, appendTablePrefix));
    }

    private static synchronized int getNextCounter() {
        if (++counter > 1000) {
            counter = 0;
        }
        return counter;
    }

    public boolean existsAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public synchronized void buildAlias() {
        if (this.alias == null) {
            this.alias = "TS" + UnixTimestampIntervalField.getNextCounter();
        }
    }
}

