/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.beans;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.Function;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import java.util.ArrayList;
import java.util.List;

public class FunctionField {
    private String functionValue;
    private Class<?> functionValueType;
    private List<IField> fields = new ArrayList<IField>();
    private String operator;
    private Function function;
    private boolean customFunction;
    private String prefixFunctionCustom;
    private String suffixFunctionCustom;
    private String alias;

    private void checkAlias() throws ExpressionException {
        if (this.function != null && this.alias != null) {
            if ("count".equalsIgnoreCase(this.alias) && Function.COUNT.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function COUNT");
            }
            if ("count".equalsIgnoreCase(this.alias) && Function.COUNT_DISTINCT.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function COUNT");
            }
            if ("avg".equalsIgnoreCase(this.alias) && Function.AVG.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function AVG");
            }
            if ("avg".equalsIgnoreCase(this.alias) && Function.AVG_DOUBLE.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function AVG_DOUBLE");
            }
            if ("max".equalsIgnoreCase(this.alias) && Function.MAX.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function MAX");
            }
            if ("min".equalsIgnoreCase(this.alias) && Function.MIN.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function MIN");
            }
            if ("sum".equalsIgnoreCase(this.alias) && Function.SUM.equals((Object)this.function)) {
                throw new ExpressionException("Alias [" + this.alias + "] is not allowed with the function SUM");
            }
        }
    }

    public FunctionField(IField field, Function function, String alias) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("IField is null");
        }
        if (function == null) {
            throw new ExpressionException("Function is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        this.fields.add(field);
        this.function = function;
        this.alias = alias;
        this.customFunction = false;
        this.checkAlias();
    }

    public FunctionField(Function function, String alias, String operator, IField ... field) throws ExpressionException {
        if (function == null) {
            throw new ExpressionException("Function is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        if (operator == null) {
            throw new ExpressionException("Operator is null");
        }
        if (field == null || field.length <= 0) {
            throw new ExpressionException("IField is null");
        }
        if (field.length < 2) {
            throw new ExpressionException("IField less then 2. With operator constructor is required almost two field");
        }
        Class<?> cField = null;
        for (int i = 0; i < field.length; ++i) {
            if (i == 0) {
                cField = field[i].getFieldType();
            } else if (!cField.getName().equals(field[i].getFieldType().getName())) {
                throw new ExpressionException("Fields aren't same type [0]=" + cField.getClass().getName() + " [" + i + "]=" + field[i].getFieldType().getName());
            }
            this.fields.add(field[i]);
        }
        this.function = function;
        this.alias = alias;
        this.operator = operator;
        this.customFunction = false;
        this.checkAlias();
    }

    public FunctionField(String functionValue, Class<?> functionValueType, Function function, String alias) throws ExpressionException {
        if (functionValue == null) {
            throw new ExpressionException("functionValue is null");
        }
        if (functionValueType == null) {
            throw new ExpressionException("functionValueType is null");
        }
        if (function == null) {
            throw new ExpressionException("Function is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        this.functionValue = functionValue;
        this.functionValueType = functionValueType;
        this.function = function;
        this.alias = alias;
        this.customFunction = false;
        this.checkAlias();
    }

    public FunctionField(IField field, String prefixFunctionCustom, String suffixFunctionCustom, String alias) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("IField is null");
        }
        if (prefixFunctionCustom == null) {
            throw new ExpressionException("prefixFunctionCustom is null");
        }
        if (suffixFunctionCustom == null) {
            throw new ExpressionException("suffixFunctionCustom is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        this.fields.add(field);
        this.prefixFunctionCustom = prefixFunctionCustom;
        this.suffixFunctionCustom = suffixFunctionCustom;
        this.alias = alias;
        this.customFunction = true;
        this.checkAlias();
    }

    public FunctionField(String prefixFunctionCustom, String suffixFunctionCustom, String alias, String operator, IField ... field) throws ExpressionException {
        if (prefixFunctionCustom == null) {
            throw new ExpressionException("prefixFunctionCustom is null");
        }
        if (suffixFunctionCustom == null) {
            throw new ExpressionException("suffixFunctionCustom is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        if (operator == null) {
            throw new ExpressionException("Operator is null");
        }
        if (field == null || field.length <= 0) {
            throw new ExpressionException("IField is null");
        }
        if (field.length < 2) {
            throw new ExpressionException("IField less then 2. With operator constructor is required almost two field");
        }
        Class<?> cField = null;
        for (int i = 0; i < field.length; ++i) {
            if (i == 0) {
                cField = field[i].getFieldType();
            } else if (!cField.getName().equals(field[i].getFieldType().getName())) {
                throw new ExpressionException("Fields aren't same type [0]=" + cField.getClass().getName() + " [" + i + "]=" + field[i].getFieldType().getName());
            }
            this.fields.add(field[i]);
        }
        this.prefixFunctionCustom = prefixFunctionCustom;
        this.suffixFunctionCustom = suffixFunctionCustom;
        this.alias = alias;
        this.operator = operator;
        this.customFunction = true;
        this.checkAlias();
    }

    public FunctionField(String functionValue, Class<?> functionValueType, String prefixFunctionCustom, String suffixFunctionCustom, String alias) throws ExpressionException {
        if (functionValue == null) {
            throw new ExpressionException("functionValue is null");
        }
        if (functionValueType == null) {
            throw new ExpressionException("functionValueType is null");
        }
        if (prefixFunctionCustom == null) {
            throw new ExpressionException("prefixFunctionCustom is null");
        }
        if (suffixFunctionCustom == null) {
            throw new ExpressionException("suffixFunctionCustom is null");
        }
        if (alias == null) {
            throw new ExpressionException("Alias is null");
        }
        this.functionValue = functionValue;
        this.functionValueType = functionValueType;
        this.prefixFunctionCustom = prefixFunctionCustom;
        this.suffixFunctionCustom = suffixFunctionCustom;
        this.alias = alias;
        this.customFunction = true;
        this.checkAlias();
    }

    public String getFunctionValue() {
        return this.functionValue;
    }

    public Class<?> getFunctionValueType() {
        return this.functionValueType;
    }

    public List<IField> getFields() {
        return this.fields;
    }

    public String getOperator() {
        return this.operator;
    }

    public Class<?> getFieldType() {
        if (this.functionValueType != null) {
            return this.functionValueType;
        }
        if (this.function != null && Function.AVG_DOUBLE.equals((Object)this.function)) {
            return Double.class;
        }
        return this.fields.get(0).getFieldType();
    }

    public boolean isCustomFunction() {
        return this.customFunction;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getPrefixFunctionCustom() {
        return this.prefixFunctionCustom;
    }

    public String getSuffixFunctionCustom() {
        return this.suffixFunctionCustom;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o instanceof FunctionField) {
            return this.equals((FunctionField)o);
        }
        return false;
    }

    public boolean equals(FunctionField o) {
        boolean find;
        if (o == null) {
            return false;
        }
        if (this.functionValue == null ? o.getFunctionValue() != null : !this.functionValue.equals(o.getFunctionValue())) {
            return false;
        }
        if (this.functionValueType == null) {
            if (o.getFunctionValueType() != null) {
                return false;
            }
        } else {
            if (o.getFunctionValueType() == null) {
                return false;
            }
            if (!this.functionValueType.getName().equals(o.getFunctionValueType().getName())) {
                return false;
            }
        }
        if (o.getFields().size() != o.getFields().size()) {
            return false;
        }
        for (IField field : this.fields) {
            find = false;
            for (IField fieldParam : o.getFields()) {
                if (!fieldParam.equals(field)) continue;
                find = true;
                break;
            }
            if (find) continue;
            return false;
        }
        for (IField fieldParam : o.getFields()) {
            find = false;
            for (IField field : this.fields) {
                if (!fieldParam.equals(field)) continue;
                find = true;
                break;
            }
            if (find) continue;
            return false;
        }
        if (o.getOperator() == null ? this.operator != null : !o.getOperator().equals(this.operator)) {
            return false;
        }
        if (this.customFunction != o.isCustomFunction()) {
            return false;
        }
        if (this.function == null) {
            if (o.getFunction() != null) {
                return false;
            }
        } else {
            if (o.getFunction() == null) {
                return false;
            }
            if (!this.function.name().equals(o.getFunction().name())) {
                return false;
            }
        }
        if (this.prefixFunctionCustom == null ? o.getPrefixFunctionCustom() != null : !this.prefixFunctionCustom.equals(o.getPrefixFunctionCustom())) {
            return false;
        }
        if (this.suffixFunctionCustom == null ? o.getSuffixFunctionCustom() != null : !this.suffixFunctionCustom.equals(o.getSuffixFunctionCustom())) {
            return false;
        }
        return !(this.alias == null ? o.getAlias() != null : !this.alias.equals(o.getAlias()));
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append("- Alias: " + this.alias);
        bf.append("\n");
        if (this.customFunction) {
            bf.append("- CustomFunction: " + this.prefixFunctionCustom + " @VALUE@ " + this.suffixFunctionCustom);
        } else {
            bf.append("- Function: " + this.function);
        }
        bf.append("\n");
        if (this.functionValue != null) {
            bf.append("- FunctionValue (type:" + this.functionValueType + "): " + this.functionValue);
        } else {
            if (this.operator != null) {
                bf.append("- Operator: " + this.operator);
                bf.append("\n");
            }
            if (this.fields.size() == 1) {
                bf.append(this.fields.get(0).toString());
            } else {
                for (int i = 0; i < this.fields.size(); ++i) {
                    bf.append("- Field[" + i + "]: " + this.fields.get(i));
                    bf.append("\n");
                }
            }
        }
        return bf.toString();
    }
}

