/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openspcoop2.core.config.rs.server.model.BaseCredenziali;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ModISoggetto;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000OpzioneCifratura;

public class Soggetto
extends BaseCredenziali {
    @Schema(required=true, description="")
    private String nome = null;
    @Schema(description="")
    private DominioEnum dominio = null;
    @Schema(example="descrizione del soggetto EnteEsterno", description="")
    private String descrizione = null;
    @Schema(example="[\"ruolo1\",\"ruolo2\"]", description="")
    private List<String> ruoli = null;
    @Schema(description="")
    private List<Proprieta4000OpzioneCifratura> proprieta = null;
    @Schema(description="")
    private ModISoggetto modi = null;

    @JsonProperty(value="nome")
    @NotNull
    @Valid
    @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$")
    @Size(max=255)
    public @NotNull @Valid @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Soggetto nome(String nome) {
        this.nome = nome;
        return this;
    }

    @JsonProperty(value="dominio")
    @Valid
    public DominioEnum getDominio() {
        return this.dominio;
    }

    public void setDominio(DominioEnum dominio) {
        this.dominio = dominio;
    }

    public Soggetto dominio(DominioEnum dominio) {
        this.dominio = dominio;
        return this;
    }

    @JsonProperty(value="descrizione")
    @Valid
    @Size(max=4000)
    public @Valid @Size(max=4000) String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public Soggetto descrizione(String descrizione) {
        this.descrizione = descrizione;
        return this;
    }

    @JsonProperty(value="ruoli")
    @Valid
    public List<String> getRuoli() {
        return this.ruoli;
    }

    public void setRuoli(List<String> ruoli) {
        this.ruoli = ruoli;
    }

    public Soggetto ruoli(List<String> ruoli) {
        this.ruoli = ruoli;
        return this;
    }

    public Soggetto addRuoliItem(String ruoliItem) {
        this.ruoli.add(ruoliItem);
        return this;
    }

    @JsonProperty(value="proprieta")
    @Valid
    public List<Proprieta4000OpzioneCifratura> getProprieta() {
        return this.proprieta;
    }

    public void setProprieta(List<Proprieta4000OpzioneCifratura> proprieta) {
        this.proprieta = proprieta;
    }

    public Soggetto proprieta(List<Proprieta4000OpzioneCifratura> proprieta) {
        this.proprieta = proprieta;
        return this;
    }

    public Soggetto addProprietaItem(Proprieta4000OpzioneCifratura proprietaItem) {
        this.proprieta.add(proprietaItem);
        return this;
    }

    @JsonProperty(value="modi")
    @Valid
    public ModISoggetto getModi() {
        return this.modi;
    }

    public void setModi(ModISoggetto modi) {
        this.modi = modi;
    }

    public Soggetto modi(ModISoggetto modi) {
        this.modi = modi;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Soggetto {\n");
        sb.append("    ").append(Soggetto.toIndentedString(super.toString())).append("\n");
        sb.append("    nome: ").append(Soggetto.toIndentedString(this.nome)).append("\n");
        sb.append("    dominio: ").append(Soggetto.toIndentedString((Object)this.dominio)).append("\n");
        sb.append("    descrizione: ").append(Soggetto.toIndentedString(this.descrizione)).append("\n");
        sb.append("    ruoli: ").append(Soggetto.toIndentedString(this.ruoli)).append("\n");
        sb.append("    proprieta: ").append(Soggetto.toIndentedString(this.proprieta)).append("\n");
        sb.append("    modi: ").append(Soggetto.toIndentedString(this.modi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

