/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openspcoop2.core.config.rs.server.model.ConnettoreApplicativoServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEcho;
import org.openspcoop2.core.config.rs.server.model.ConnettoreFile;
import org.openspcoop2.core.config.rs.server.model.ConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.ConnettoreJms;
import org.openspcoop2.core.config.rs.server.model.ConnettoreMessageBox;
import org.openspcoop2.core.config.rs.server.model.ConnettoreNull;
import org.openspcoop2.core.config.rs.server.model.ConnettorePlugin;
import org.openspcoop2.core.config.rs.server.model.ConnettoreStatus;
import org.openspcoop2.core.config.rs.server.model.OneOfApplicativoServerConnettore;
import org.openspcoop2.core.config.rs.server.model.Proprieta4000;

public class ApplicativoServer {
    @Schema(required=true, description="")
    private String nome = null;
    @Schema(example="descrizione dell'applicativo", description="")
    private String descrizione = null;
    @Schema(description="")
    private List<Proprieta4000> proprieta = null;
    @Schema(description="")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="tipo", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ConnettoreHttp.class, name="http"), @JsonSubTypes.Type(value=ConnettoreFile.class, name="file"), @JsonSubTypes.Type(value=ConnettoreJms.class, name="jms"), @JsonSubTypes.Type(value=ConnettoreNull.class, name="null"), @JsonSubTypes.Type(value=ConnettoreStatus.class, name="status"), @JsonSubTypes.Type(value=ConnettoreEcho.class, name="echo"), @JsonSubTypes.Type(value=ConnettorePlugin.class, name="plugin"), @JsonSubTypes.Type(value=ConnettoreApplicativoServer.class, name="applicativo-server"), @JsonSubTypes.Type(value=ConnettoreMessageBox.class, name="message-box")})
    private OneOfApplicativoServerConnettore connettore = null;

    @JsonProperty(value="nome")
    @NotNull
    @Valid
    @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$")
    @Size(max=255)
    public @NotNull @Valid @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public ApplicativoServer nome(String nome) {
        this.nome = nome;
        return this;
    }

    @JsonProperty(value="descrizione")
    @Valid
    @Size(max=4000)
    public @Valid @Size(max=4000) String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public ApplicativoServer descrizione(String descrizione) {
        this.descrizione = descrizione;
        return this;
    }

    @JsonProperty(value="proprieta")
    @Valid
    public List<Proprieta4000> getProprieta() {
        return this.proprieta;
    }

    public void setProprieta(List<Proprieta4000> proprieta) {
        this.proprieta = proprieta;
    }

    public ApplicativoServer proprieta(List<Proprieta4000> proprieta) {
        this.proprieta = proprieta;
        return this;
    }

    public ApplicativoServer addProprietaItem(Proprieta4000 proprietaItem) {
        this.proprieta.add(proprietaItem);
        return this;
    }

    @JsonProperty(value="connettore")
    @Valid
    public OneOfApplicativoServerConnettore getConnettore() {
        return this.connettore;
    }

    public void setConnettore(OneOfApplicativoServerConnettore connettore) {
        this.connettore = connettore;
    }

    public ApplicativoServer connettore(OneOfApplicativoServerConnettore connettore) {
        this.connettore = connettore;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicativoServer {\n");
        sb.append("    nome: ").append(ApplicativoServer.toIndentedString(this.nome)).append("\n");
        sb.append("    descrizione: ").append(ApplicativoServer.toIndentedString(this.descrizione)).append("\n");
        sb.append("    proprieta: ").append(ApplicativoServer.toIndentedString(this.proprieta)).append("\n");
        sb.append("    connettore: ").append(ApplicativoServer.toIndentedString(this.connettore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

