/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreEchoApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreFileApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreHTTPApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreJmsApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreMessageBoxApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreNullApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettorePluginApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreStatusApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.IConnettoreApiHelper;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreErogazione;
import org.openspcoop2.core.config.rs.server.model.ConnettoreFruizione;
import org.openspcoop2.core.config.rs.server.model.OneOfApplicativoServerConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreErogazioneConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreFruizioneConnettore;
import org.openspcoop2.core.constants.TipiConnettore;

public class ConnettoreAPIHelper {
    private static String CUSTOM_KEY = "CUSTOM";
    private static Map<String, IConnettoreApiHelper> helpers;
    private static Map<ConnettoreEnum, IConnettoreApiHelper> helpersByEnum;

    public static String getUrlConnettore(ServizioApplicativo sa, boolean isRidefinito) throws Exception {
        if (isRidefinito) {
            return "Connettori ridefiniti nei gruppi";
        }
        return ConnettoreAPIHelper.getUrlConnettore(sa.getInvocazioneServizio().getConnettore().getProperties(), sa.getInvocazioneServizio().getConnettore().getTipo(), sa.getInvocazioneServizio().getConnettore().getCustom(), sa.getInvocazioneServizio().getGetMessage().equals((Object)StatoFunzionalita.ABILITATO));
    }

    private static String getUrlConnettore(Map<String, String> properties, String tipo, Boolean custom, boolean isMessageBox) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(tipo, custom, isMessageBox);
        if (helper == null) {
            return null;
        }
        return helper.getUrlConnettore(properties, tipo);
    }

    private static synchronized void initHelper() {
        if (helpers == null) {
            helpers = new HashMap<String, IConnettoreApiHelper>();
            ConnettoreHTTPApiHelper connHttpApiHelper = new ConnettoreHTTPApiHelper();
            helpers.put(TipiConnettore.HTTP.toString(), connHttpApiHelper);
            helpers.put(TipiConnettore.HTTPS.toString(), connHttpApiHelper);
            helpers.put(TipiConnettore.FILE.toString(), new ConnettoreFileApiHelper());
            helpers.put(TipiConnettore.JMS.toString(), new ConnettoreJmsApiHelper());
            helpers.put(TipiConnettore.NULL.toString(), new ConnettoreNullApiHelper());
            helpers.put(TipiConnettore.NULLECHO.toString(), new ConnettoreEchoApiHelper());
            helpers.put(TipiConnettore.STATUS.toString(), new ConnettoreStatusApiHelper());
            helpers.put(TipiConnettore.DISABILITATO.toString(), new ConnettoreMessageBoxApiHelper());
            helpers.put(CUSTOM_KEY, new ConnettorePluginApiHelper());
        }
    }

    private static IConnettoreApiHelper getHelper(String tipo, Boolean custom, boolean isMessageBox) throws Exception {
        if (helpers == null) {
            ConnettoreAPIHelper.initHelper();
        }
        if (helpers.containsKey(tipo)) {
            IConnettoreApiHelper iConnettoreApiHelper = helpers.get(tipo);
            if (iConnettoreApiHelper instanceof ConnettoreMessageBoxApiHelper && !isMessageBox) {
                return null;
            }
            return iConnettoreApiHelper;
        }
        if (custom.booleanValue() && helpers.containsKey(CUSTOM_KEY)) {
            return helpers.get(CUSTOM_KEY);
        }
        return null;
    }

    private static synchronized void initHelperByEnum() {
        if (helpersByEnum == null) {
            helpersByEnum = new HashMap<ConnettoreEnum, IConnettoreApiHelper>();
            helpersByEnum.put(ConnettoreEnum.HTTP, new ConnettoreHTTPApiHelper());
            helpersByEnum.put(ConnettoreEnum.FILE, new ConnettoreFileApiHelper());
            helpersByEnum.put(ConnettoreEnum.JMS, new ConnettoreJmsApiHelper());
            helpersByEnum.put(ConnettoreEnum.NULL, new ConnettoreNullApiHelper());
            helpersByEnum.put(ConnettoreEnum.ECHO, new ConnettoreEchoApiHelper());
            helpersByEnum.put(ConnettoreEnum.STATUS, new ConnettoreStatusApiHelper());
            helpersByEnum.put(ConnettoreEnum.PLUGIN, new ConnettorePluginApiHelper());
            helpersByEnum.put(ConnettoreEnum.MESSAGE_BOX, new ConnettoreMessageBoxApiHelper());
        }
    }

    private static IConnettoreApiHelper getHelper(ConnettoreEnum tipo) throws Exception {
        if (helpersByEnum == null) {
            ConnettoreAPIHelper.initHelperByEnum();
        }
        if (helpersByEnum.containsKey((Object)tipo)) {
            return helpersByEnum.get((Object)tipo);
        }
        throw new Exception("Connettore tipo [" + tipo + "] non supportato");
    }

    public static String getUrlConnettore(org.openspcoop2.core.registry.Connettore connettore, boolean isRidefinito) throws Exception {
        if (isRidefinito) {
            return "Connettori ridefiniti nei gruppi";
        }
        if (connettore == null) {
            return null;
        }
        boolean isMessageBox = false;
        return ConnettoreAPIHelper.getUrlConnettore(connettore.getProperties(), connettore.getTipo(), connettore.getCustom(), isMessageBox);
    }

    public static final ConnettoreErogazione buildConnettoreErogazione(ServizioApplicativo sa) throws Exception {
        ConnettoreErogazione connettoreErogazione = new ConnettoreErogazione();
        connettoreErogazione.setConnettore(ConnettoreAPIHelper.getConnettoreErogazione(sa));
        return connettoreErogazione;
    }

    public static final ConnettoreFruizione buildConnettoreFruizione(org.openspcoop2.core.registry.Connettore connettore) throws Exception {
        ConnettoreFruizione connettoreFruizione = new ConnettoreFruizione();
        connettoreFruizione.setConnettore(ConnettoreAPIHelper.getConnettoreFruizione(connettore));
        return connettoreFruizione;
    }

    private static OneOfConnettoreFruizioneConnettore getConnettoreFruizione(org.openspcoop2.core.registry.Connettore connettore) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo(), connettore.getCustom(), false);
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreFruizione(connettore.getProperties(), connettore.getTipo());
    }

    private static OneOfConnettoreErogazioneConnettore getConnettoreErogazione(ServizioApplicativo sa) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(sa.getInvocazioneServizio().getConnettore().getTipo(), sa.getInvocazioneServizio().getConnettore().getCustom(), sa.getInvocazioneServizio().getGetMessage().equals((Object)StatoFunzionalita.ABILITATO));
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreErogazione(sa);
    }

    public static OneOfApplicativoServerConnettore getConnettoreApplicativoServer(ServizioApplicativo sa) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(sa.getInvocazioneServizio().getConnettore().getTipo(), sa.getInvocazioneServizio().getConnettore().getCustom(), sa.getInvocazioneServizio().getGetMessage().equals((Object)StatoFunzionalita.ABILITATO));
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreApplicativoServer(sa);
    }

    public static boolean connettoreCheckData(OneOfApplicativoServerConnettore connettore, ErogazioniEnv erogEnv, boolean erogazione) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return true;
        }
        return helper.connettoreCheckData(connettore, erogEnv, erogazione);
    }

    public static boolean connettoreCheckData(OneOfConnettoreErogazioneConnettore connettore, ErogazioniEnv erogEnv, boolean erogazione) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return true;
        }
        return helper.connettoreCheckData(connettore, erogEnv, erogazione);
    }

    public static boolean connettoreCheckData(OneOfConnettoreFruizioneConnettore connettore, ErogazioniEnv erogEnv, boolean erogazione) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return true;
        }
        return helper.connettoreCheckData(connettore, erogEnv, erogazione);
    }

    public static void fillConnettoreConfigurazione(ServizioApplicativo sa, ErogazioniEnv erogEnv, OneOfApplicativoServerConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.buildConnettoreConfigurazione(sa, erogEnv, connettore, oldConnT);
    }

    public static void fillConnettoreConfigurazione(ServizioApplicativo sa, ErogazioniEnv erogEnv, OneOfConnettoreErogazioneConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.buildConnettoreConfigurazione(sa, erogEnv, connettore, oldConnT);
    }

    public static void fillConnettoreConfigurazione(Connettore connis, ErogazioniEnv erogEnv, OneOfConnettoreFruizioneConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.buildConnettoreConfigurazione(connis, erogEnv, connettore, oldConnT);
    }

    public static void fillConnettoreRegistro(org.openspcoop2.core.registry.Connettore connis, ErogazioniEnv erogEnv, OneOfApplicativoServerConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.fillConnettoreRegistro(connis, erogEnv, connettore, oldConnT);
    }

    public static void fillConnettoreRegistro(org.openspcoop2.core.registry.Connettore connis, ErogazioniEnv erogEnv, OneOfConnettoreErogazioneConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.fillConnettoreRegistro(connis, erogEnv, connettore, oldConnT);
    }

    public static void fillConnettoreRegistro(org.openspcoop2.core.registry.Connettore connis, ErogazioniEnv erogEnv, OneOfConnettoreFruizioneConnettore connettore, String oldConnT) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return;
        }
        helper.fillConnettoreRegistro(connis, erogEnv, connettore, oldConnT);
    }

    public static org.openspcoop2.core.registry.Connettore buildConnettoreRegistro(ErogazioniEnv erogEnv, OneOfApplicativoServerConnettore connettore) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreRegistro(erogEnv, connettore);
    }

    public static org.openspcoop2.core.registry.Connettore buildConnettoreRegistro(ErogazioniEnv erogEnv, OneOfConnettoreErogazioneConnettore connettore) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreRegistro(erogEnv, connettore);
    }

    public static org.openspcoop2.core.registry.Connettore buildConnettoreRegistro(ErogazioniEnv erogEnv, OneOfConnettoreFruizioneConnettore connettore) throws Exception {
        IConnettoreApiHelper helper = ConnettoreAPIHelper.getHelper(connettore.getTipo());
        if (helper == null) {
            return null;
        }
        return helper.buildConnettoreRegistro(erogEnv, connettore);
    }
}

