/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.rs.server.api.ApiApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiEnv;
import org.openspcoop2.core.config.rs.server.api.impl.api.ModiApiApiHelper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.Api;
import org.openspcoop2.core.config.rs.server.model.ApiAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiAzione;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.ApiInformazioniGenerali;
import org.openspcoop2.core.config.rs.server.model.ApiInformazioniGeneraliView;
import org.openspcoop2.core.config.rs.server.model.ApiInterfaccia;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaRest;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaSoap;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaView;
import org.openspcoop2.core.config.rs.server.model.ApiItem;
import org.openspcoop2.core.config.rs.server.model.ApiModI;
import org.openspcoop2.core.config.rs.server.model.ApiReferenteView;
import org.openspcoop2.core.config.rs.server.model.ApiRisorsa;
import org.openspcoop2.core.config.rs.server.model.ApiServizio;
import org.openspcoop2.core.config.rs.server.model.ApiTags;
import org.openspcoop2.core.config.rs.server.model.ApiViewItem;
import org.openspcoop2.core.config.rs.server.model.CanaleEnum;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneApiCanale;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneCanaleEnum;
import org.openspcoop2.core.config.rs.server.model.HttpMethodEnum;
import org.openspcoop2.core.config.rs.server.model.ListaApi;
import org.openspcoop2.core.config.rs.server.model.ListaApiAllegati;
import org.openspcoop2.core.config.rs.server.model.ListaApiAzioni;
import org.openspcoop2.core.config.rs.server.model.ListaApiRisorse;
import org.openspcoop2.core.config.rs.server.model.ListaApiServizi;
import org.openspcoop2.core.config.rs.server.model.RuoloAllegatoAPI;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.basic.archive.APIUtils;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloCollaborazioneEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.SerialiableFormFile;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class ApiApiServiceImpl
extends BaseImpl
implements ApiApi {
    public ApiApiServiceImpl() {
        super(LoggerFactory.getLogger(ApiApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void createApi(Api body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            IDAccordo idAccordoFromAccordo;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            if (body.getReferente() == null || "".equals(body.getReferente().trim())) {
                body.setReferente(soggetto);
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.accordoApiToRegistro(body, env);
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApiApiHelper.getProtocolProperties(body, profilo)) != null) {
                as.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            if (env.apcCore.existsAccordoServizio(idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as))) {
                throw FaultCode.CONFLITTO.toException("Api gi\u00e0 esistente");
            }
            boolean validazioneDocumenti = ServerProperties.getInstance().isValidazioneDocumenti();
            StringBuilder bfTags = new StringBuilder();
            if (body != null && body.getTags() != null && !body.getTags().isEmpty()) {
                for (String tag : body.getTags()) {
                    if (bfTags.length() > 0) {
                        bfTags.append(",");
                    }
                    bfTags.append(tag);
                }
            }
            boolean gestioneCanaliEnabled = env.gestioneCanali;
            String canale = as.getCanale();
            String canaleStato = null;
            canaleStato = canale == null ? "default" : "ridefinito";
            if (!env.apcHelper.accordiCheckData(TipoOperazione.ADD, as.getNome(), as.getDescrizione(), as.getProfiloCollaborazione().toString(), Helper.toBinaryParameter(as.getByteWsdlDefinitorio()), Helper.toBinaryParameter(as.getByteWsdlConcettuale()), Helper.toBinaryParameter(as.getByteWsdlLogicoErogatore()), Helper.toBinaryParameter(as.getByteWsdlLogicoFruitore()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConsegnaInOrdine()), "", "0", as.getSoggettoReferente().getId().toString(), as.getVersione().toString(), null, false, false, null, new BinaryParameter(), new BinaryParameter(), new BinaryParameter(), validazioneDocumenti, env.tipo_protocollo, null, env.apcCore.toMessageServiceBinding(as.getServiceBinding()), null, Enums.interfaceTypeFromFormatoSpecifica.get(as.getFormatoSpecifica()), env.gestisciSoggettoReferente, bfTags.toString(), canaleStato, canale, gestioneCanaliEnabled)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            ApiApiHelper.validateProperties(env, protocolProperties, idAccordoFromAccordo, ConsoleOperationType.ADD);
            ArrayList<Object> objectToCreate = new ArrayList<Object>();
            if (body.getTags() != null && !body.getTags().isEmpty()) {
                as.setGruppi(new GruppiAccordo());
                GruppiCore gruppiCore = new GruppiCore(env.stationCore);
                for (String tag : body.getTags()) {
                    GruppoAccordo gruppo = new GruppoAccordo();
                    gruppo.setNome(tag);
                    as.getGruppi().addGruppo(gruppo);
                    if (gruppiCore.existsGruppo(tag)) continue;
                    Gruppo nuovoGruppo = new Gruppo();
                    nuovoGruppo.setNome(tag);
                    nuovoGruppo.setSuperUser(as.getSuperUser());
                    objectToCreate.add(nuovoGruppo);
                }
            }
            objectToCreate.add(as);
            env.apcCore.performCreateOperation(env.userLogin, false, objectToCreate.toArray(new Object[objectToCreate.size()]));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createApiAllegato(ApiAllegato body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Body non presente");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = Helper.getAccordoFull(nome, versione, env.idSoggetto.toIDSoggetto(), env.apcCore);
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api corrisponde ai parametri indicati");
            }
            Documento documento = ApiApiHelper.apiAllegatoToDocumento(body, as, env);
            if (RuoloAllegatoAPI.ALLEGATO.equals((Object)body.getAllegato().getRuolo())) {
                as.addAllegato(documento);
            } else if (RuoloAllegatoAPI.SPECIFICASEMIFORMALE.equals((Object)body.getAllegato().getRuolo())) {
                as.addSpecificaSemiformale(documento);
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Ruolo " + body.getAllegato().getRuolo() + " sconosciuto");
            }
            ArchiviCore archiviCore = new ArchiviCore(env.stationCore);
            SerialiableFormFile filewrap = new SerialiableFormFile(documento.getFile(), documento.getByteContenuto());
            env.requestWrapper.overrideParameter("ruolo", documento.getRuolo());
            ArchiviHelper archiviHelper = new ArchiviHelper(env.stationCore, (HttpServletRequest)env.requestWrapper, env.pd, env.requestWrapper.getSession());
            boolean documentoUnivocoIndipendentementeTipo = true;
            if (archiviCore.existsDocumento(documento, ProprietariDocumento.accordoServizio, documentoUnivocoIndipendentementeTipo)) {
                throw FaultCode.CONFLITTO.toException("Allegato con nome " + documento.getFile() + " gi\u00e0 presente nella API");
            }
            if (!archiviHelper.accordiAllegatiCheckData(TipoOperazione.ADD, (FormFile)filewrap, documento, ProprietariDocumento.accordoServizio, env.protocolFactory)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createApiAzione(ApiAzione body, String nome, Integer versione, String nomeServizio, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api con nome: " + nome + " e versione " + versione);
            }
            if (as.getServiceBinding() == ServiceBinding.REST) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 possibile registrare Azioni e Servizi su Api con interfaccia REST");
            }
            PortType pt = as.getPortTypeList().stream().filter(p -> nomeServizio.equals(p.getNome())).findFirst().orElse(null);
            if (pt == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio con nome: " + nomeServizio);
            }
            Operation newOp = ApiApiHelper.apiAzioneToOperazione(body, pt);
            if (env.apcCore.existsAccordoServizioPorttypeOperation(newOp.getNome(), pt.getId().longValue())) {
                throw FaultCode.CONFLITTO.toException("L'azione " + newOp.getNome() + " \u00e8 gi\u00e0 stata associata alla Api");
            }
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApiApiHelper.getProtocolProperties(body, profilo, as, newOp, env)) != null) {
                newOp.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            pt.addAzione(newOp);
            ProfiloCollaborazioneEnum profiloBody = body.getProfiloCollaborazione() != null ? body.getProfiloCollaborazione() : ProfiloCollaborazioneEnum.SINCRONO;
            if (!env.apcHelper.accordiPorttypeOperationCheckData(TipoOperazione.ADD, as.getId().toString(), nomeServizio, newOp.getNome(), newOp.getProfAzione(), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getConsegnaInOrdine()), newOp.getScadenza() != null ? newOp.getScadenza() : "", "-", "-", Enums.profiloCollaborazioneFromApiEnum.get(profiloBody).toString(), "0", "", "literal", null, "")) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            IDPortType idPT = new IDPortType();
            idPT.setNome(pt.getNome());
            idPT.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as));
            IDPortTypeAzione idAccordoAzione = new IDPortTypeAzione();
            idAccordoAzione.setNome(newOp.getNome());
            idAccordoAzione.setIdPortType(idPT);
            ApiApiHelper.validateProperties(env, protocolProperties, idAccordoAzione, ConsoleOperationType.ADD);
            AccordiServizioParteComuneUtilities.createPortTypeOperation((boolean)env.apcCore.isEnableAutoMappingWsdlIntoAccordo(), (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (AccordoServizioParteComune)as, (PortType)pt, (String)env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createApiRisorsa(ApiRisorsa body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api con nome: " + nome + " e versione " + versione);
            }
            if (as.getServiceBinding() != ServiceBinding.REST) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("E' possibile registrare risorse solo su API con interfaccia REST");
            }
            Resource newRes = ApiApiHelper.apiRisorsaToRegistro(body, as);
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApiApiHelper.getProtocolProperties(body, profilo, newRes, env)) != null) {
                newRes.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            if (StringUtils.isEmpty((String)newRes.getNome()) && newRes.getMethod() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il campo nome non \u00e8 stato definito");
            }
            if (env.apcCore.existsAccordoServizioResource(newRes.getMethodRawEnumValue(), newRes.getPath(), as.getId().longValue(), null)) {
                throw FaultCode.CONFLITTO.toException("La risorsa " + newRes.getNome() + " \u00e8 gi\u00e0 stata associata alla Api");
            }
            if (!env.apcHelper.accordiResourceCheckData(TipoOperazione.ADD, as.getId().toString(), body.getNome() != null ? body.getNome() : "", newRes.getNome(), newRes.getPath(), newRes.getMethodRawEnumValue(), newRes.getDescrizione(), env.apcCore.toMessageMessageType(newRes.getMessageType()), null, null, null, null, "default", AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getConsegnaInOrdine()), "")) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            IDResource idResource = new IDResource();
            idResource.setNome(newRes.getNome());
            idResource.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as));
            ApiApiHelper.validateProperties(env, protocolProperties, idResource, newRes.getMethod() != null ? newRes.getMethod().toString() : null, newRes.getPath(), ConsoleOperationType.ADD);
            as.addResource(newRes);
            AccordiServizioParteComuneUtilities.createResource((boolean)env.apcCore.isEnableAutoMappingWsdlIntoAccordo(), (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (AccordoServizioParteComune)as, (String)env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createApiServizio(ApiServizio body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api con nome: " + nome + " e versione " + versione);
            }
            if (as.getServiceBinding() == ServiceBinding.REST) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 possibile associare un servizio ad una api REST");
            }
            PortType newPT = ApiApiHelper.apiServizioToRegistro(body, as, env);
            if (env.apcCore.existsAccordoServizioPorttype(newPT.getNome(), as.getId().longValue())) {
                throw FaultCode.CONFLITTO.toException("Il servizio " + newPT.getNome() + " \u00e8 gi\u00e0 stato associato alla API");
            }
            if (!env.apcHelper.accordiPorttypeCheckData(TipoOperazione.ADD, as.getId().toString(), newPT.getNome(), newPT.getDescrizione(), "ridefinito", AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPT.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPT.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPT.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPT.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPT.getConsegnaInOrdine()), newPT.getScadenza())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.addPortType(newPT);
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApi(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComune((AccordoServizioParteComune)as, (String)env.userLogin, (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            }
            if (env.delete_404 && as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApiAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = (AccordoServizioParteComune)BaseHelper.supplyOrNotFound(() -> ApiApiHelper.getAccordoFull(nome, versione, env), (String)"API");
            Documento toDel = (Documento)BaseHelper.evalnull(() -> env.archiviCore.getDocumento(nomeAllegato, null, null, as.getId().longValue(), false, ProprietariDocumento.accordoServizio));
            if (toDel != null) {
                AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComuneAllegati((AccordoServizioParteComune)as, (String)env.userLogin, (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, Arrays.asList(toDel.getId()));
            }
            if (env.delete_404 && toDel == null) {
                throw FaultCode.NOT_FOUND.toException("Allegato con nome " + nomeAllegato + " non presente per il servizio applicativo scelto.");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApiAzione(String nome, Integer versione, String nomeServizio, String nomeAzione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = (AccordoServizioParteComune)BaseHelper.supplyOrNotFound(() -> ApiApiHelper.getAccordoFull(nome, versione, env), (String)"API");
            PortType pt = null;
            for (int i = 0; i < as.sizePortTypeList() && !nomeServizio.equals((pt = as.getPortType(i)).getNome()); ++i) {
            }
            if (pt == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio registrato sulla api con nome " + nomeServizio);
            }
            if (BaseHelper.findFirst((Iterable)pt.getAzioneList(), op -> op.getNome().equals(nomeAzione)).isPresent()) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComuneOperations((AccordoServizioParteComune)as, (String)env.userLogin, (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (StringBuilder)inUsoMessage, (String)"\n", (PortType)pt, Arrays.asList(nomeAzione));
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Azione " + nomeAzione + " non registrata sul servizio " + nomeServizio);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApiRisorsa(String nome, Integer versione, String nomeRisorsa, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = (AccordoServizioParteComune)BaseHelper.supplyOrNotFound(() -> ApiApiHelper.getAccordoFull(nome, versione, env), (String)"API");
            if (BaseHelper.findFirst((Iterable)as.getResourceList(), res -> res.getNome().equals(nomeRisorsa)).isPresent()) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComuneRisorse((AccordoServizioParteComune)as, (String)env.userLogin, (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (StringBuilder)inUsoMessage, (String)"\n", Arrays.asList(nomeRisorsa));
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Risorsa " + nomeRisorsa + " non associata alla API ");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteApiServizio(String nome, Integer versione, String nomeServizio, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = (AccordoServizioParteComune)BaseHelper.supplyOrNotFound(() -> ApiApiHelper.getAccordoFull(nome, versione, env), (String)"API");
            if (BaseHelper.findFirst((Iterable)as.getPortTypeList(), pt -> pt.getNome().equals(nomeServizio)).isPresent()) {
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteComuneUtilities.deleteAccordoServizioParteComunePortTypes((AccordoServizioParteComune)as, (String)env.userLogin, (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (StringBuilder)inUsoMessage, (String)"\n", Arrays.asList(nomeServizio));
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Servizio " + nomeServizio + " non associato alla API");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadApiAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            Documento doc = as.getAllegatoList().stream().filter(a -> nomeAllegato.equals(a.getFile())).findFirst().orElse(null);
            if (doc == null) {
                doc = as.getSpecificaSemiformaleList().stream().filter(a -> nomeAllegato.equals(a.getFile())).findFirst().orElse(null);
            }
            if (doc == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun allegato con nome " + nomeAllegato + " registrato per la Api specificata");
            }
            doc = env.archiviCore.getDocumento(doc.getFile(), doc.getTipo(), doc.getRuolo(), doc.getIdProprietarioDocumento().longValue(), true, ProprietariDocumento.accordoServizio);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            Helper.setContentType(context, doc.getFile());
            return doc.getByteContenuto();
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadApiInterfaccia(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            byte[] spec = null;
            switch (as.getServiceBinding()) {
                case REST: {
                    spec = as.getByteWsdlConcettuale();
                    break;
                }
                case SOAP: {
                    spec = as.getByteWsdlLogicoErogatore();
                }
            }
            String fileName = null;
            switch (as.getFormatoSpecifica()) {
                case WSDL_11: {
                    fileName = "InterfacciaConcettuale.wsdl";
                    break;
                }
                case OPEN_API_3: {
                    YAMLUtils yamlUtils = YAMLUtils.getInstance();
                    if (yamlUtils.isYaml(spec)) {
                        fileName = "InterfacciaOpenAPI.yaml";
                        break;
                    }
                    fileName = "InterfacciaOpenAPI.json";
                    break;
                }
                case SWAGGER_2: {
                    YAMLUtils yamlUtils = YAMLUtils.getInstance();
                    if (yamlUtils.isYaml(spec)) {
                        fileName = "InterfacciaSwagger.yaml";
                        break;
                    }
                    fileName = "InterfacciaSwagger.json";
                    break;
                }
                case WADL: {
                    fileName = "Interfaccia.wadl";
                }
            }
            if (fileName != null) {
                Helper.setContentType(context, fileName);
            }
            return spec;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApi findAllApi(ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, TipoApiEnum tipoApi, String tag, Boolean profiloQualsiasi) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            int idLista = Liste.ACCORDI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (tipoApi != null) {
                ricerca.addFilter(idLista, "filtroServiceBinding", Enums.serviceBindingFromTipo.get((Object)tipoApi).toString().toLowerCase());
            }
            if (tag != null) {
                ricerca.addFilter(idLista, "filtroGruppo", tag);
            }
            String tipoAccordo = "apc";
            List lista = AccordiServizioParteComuneUtilities.accordiList((AccordiServizioParteComuneCore)env.apcCore, (String)env.userLogin, (ConsoleSearch)ricerca, (String)"apc");
            ListaApi ret = (ListaApi)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApi.class);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api corrisponde ai criteri di ricerca");
            }
            lista.forEach(as -> ret.addItemsItem(ApiApiHelper.apiToItem(ApiApiHelper.accordoSpcRegistroToApi(as, env.soggettiCore), as, env)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiAllegati findAllApiAllegati(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            int idLista = Liste.ACCORDI_ALLEGATI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List docsRegistro = env.apcCore.accordiAllegatiList((long)as.getId().intValue(), (ISearch)ricerca);
            if (docsRegistro.size() == 0 && env.findall_404) {
                throw FaultCode.NOT_FOUND.toException("Nessun allegato dell'Api specificata corrisponde ai criteri di ricerca");
            }
            ListaApiAllegati ret = (ListaApiAllegati)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApiAllegati.class);
            docsRegistro.forEach(d -> ret.addItemsItem(ApiApiHelper.documentoToApiAllegatoItem(d)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiAzioni findAllApiAzioni(String nome, Integer versione, String nomeServizio, ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            int idLista = Liste.ACCORDI_PORTTYPE_AZIONI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            PortType pt = as.getPortTypeList().stream().filter(p -> nomeServizio.equals(p.getNome())).findFirst().orElse(null);
            if (pt == null) {
                throw FaultCode.NOT_FOUND.toException("Non \u00e8 stato trovato alcun servizio con nome " + nomeServizio + " legato alla Api");
            }
            List azioniServizio = env.apcCore.accordiPorttypeOperationList((long)pt.getId().intValue(), (ISearch)ricerca);
            if (azioniServizio.size() == 0 && env.findall_404) {
                throw FaultCode.NOT_FOUND.toException("Nessua azione dell'Api specificata corrisponde ai criteri di ricerca");
            }
            ListaApiAzioni ret = (ListaApiAzioni)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApiAzioni.class);
            azioniServizio.forEach(op -> ret.addItemsItem(ApiApiHelper.operazioneToApiAzione(op)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiRisorse findAllApiRisorse(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, HttpMethodEnum httpMethod) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            int idLista = Liste.ACCORDI_API_RESOURCES;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (httpMethod != null) {
                ricerca.addFilter(idLista, "filtroHttpMethod", httpMethod.toString());
            }
            ListaApiRisorse ret = (ListaApiRisorse)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApiRisorse.class);
            List risorse = env.apcCore.accordiResourceList((long)as.getId().intValue(), (ISearch)ricerca);
            if (risorse.size() == 0 && env.findall_404) {
                throw FaultCode.NOT_FOUND.toException("Nessun allegato dell'Api specificata corrisponde ai criteri di ricerca");
            }
            risorse.forEach(r -> ret.addItemsItem(ApiApiHelper.risorsaRegistroToApi(r)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiServizi findAllApiServizi(String nome, Integer versione, ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Api non trovata");
            }
            int idLista = Liste.ACCORDI_PORTTYPE;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List servizi = env.apcCore.accordiPorttypeList((long)as.getId().intValue(), (ISearch)ricerca);
            ListaApiServizi ret = (ListaApiServizi)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApiServizi.class);
            if (servizi.size() == 0 && env.findall_404) {
                throw FaultCode.NOT_FOUND.toException("Nessun allegato dell'Api specificata corrisponde ai criteri di ricerca");
            }
            servizi.forEach(s -> ret.addItemsItem(ApiApiHelper.servizioRegistroToApi(s)));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiViewItem getApi(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComuneSintetico as = ApiApiHelper.getAccordoSintetico(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiItem item = ApiApiHelper.apiToItem(ApiApiHelper.accordoSpcRegistroToApi(as, env.soggettiCore), as, env);
            ApiViewItem ret = new ApiViewItem();
            ret.setDescrizione(item.getDescrizione());
            ret.setTipoInterfaccia(item.getTipoInterfaccia());
            ret.setNome(item.getNome());
            ret.setProfilo(item.getProfilo());
            ret.setReferente(item.getSoggetto());
            ret.setSoggetto(item.getSoggetto());
            ret.setVersione(item.getVersione());
            ret.setStato(item.getStato());
            ret.setStatoDescrizione(item.getStatoDescrizione());
            ret.setTags(item.getTags());
            ret.setCanale(item.getCanale());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiAllegato getApiAllegato(String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiAllegato ret = as.getAllegatoList().stream().filter(a -> nomeAllegato.equals(a.getFile())).map(a -> {
                try {
                    return ApiApiHelper.documentoToApiAllegato(env.archiviCore.getDocumento(a.getId().longValue(), true));
                }
                catch (Exception e) {
                    return null;
                }
            }).findFirst().orElse(null);
            if (ret == null) {
                ret = as.getSpecificaSemiformaleList().stream().filter(a -> nomeAllegato.equals(a.getFile())).map(a -> {
                    try {
                        return ApiApiHelper.documentoToApiAllegato(env.archiviCore.getDocumento(a.getId().longValue(), true));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).findFirst().orElse(null);
            }
            if (ret == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun allegato con nome " + nomeAllegato + " registrato per la Api specificata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiAzione getApiAzione(String nome, Integer versione, String nomeServizio, String nomeAzione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            PortType pt = as.getPortTypeList().stream().filter(p -> nomeServizio.equals(p.getNome())).findFirst().orElse(null);
            if (pt == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio con nome: " + nomeServizio);
            }
            Operation az = pt.getAzioneList().stream().filter(a -> nomeAzione.equals(a.getNome())).findFirst().orElse(null);
            if (az == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna azione con nome " + nomeAzione + " registrato per il servizio " + nomeServizio);
            }
            ApiAzione ret = ApiApiHelper.operazioneToApiAzione(az);
            ApiApiHelper.populateApiAzioneWithProtocolInfo(as, az, env, profilo, ret);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiCanale getApiCanale(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiCanale canale = null;
            if (env.gestioneCanali) {
                canale = new ApiCanale();
                if (as.getCanale() != null && !"".equals(as.getCanale())) {
                    canale.setNome(as.getCanale());
                    canale.setConfigurazione(CanaleEnum.API);
                } else {
                    canale.setNome(env.canaleDefault);
                    canale.setConfigurazione(CanaleEnum.DEFAULT);
                }
            } else {
                throw new Exception("Gestione dei canali non abilitata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return canale;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiDescrizione getApiDescrizione(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiDescrizione ret = new ApiDescrizione();
            ret.setDescrizione(as.getDescrizione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiInformazioniGeneraliView getApiInformazioniGenerali(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiInformazioniGeneraliView ret = new ApiInformazioniGeneraliView();
            ret.setNome(as.getNome());
            ret.setProfilo(env.profilo);
            ret.setVersione(as.getVersione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiInterfacciaView getApiInterfaccia(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiInterfacciaView ret = new ApiInterfacciaView();
            ret.setProfilo(env.profilo);
            TipoApiEnum protocollo = as.getServiceBinding() == ServiceBinding.REST ? TipoApiEnum.REST : TipoApiEnum.SOAP;
            switch (protocollo) {
                case REST: {
                    ApiInterfacciaRest iRest = new ApiInterfacciaRest();
                    iRest.setProtocollo(protocollo);
                    iRest.setFormato(Enums.formatoRestFromSpecifica.get(as.getFormatoSpecifica()));
                    ret.setTipoInterfaccia(iRest);
                    ret.setInterfaccia(as.getByteWsdlConcettuale());
                    break;
                }
                case SOAP: {
                    ApiInterfacciaSoap iSoap = new ApiInterfacciaSoap();
                    iSoap.setProtocollo(protocollo);
                    iSoap.setFormato(Enums.formatoSoapFromSpecifica.get(as.getFormatoSpecifica()));
                    ret.setTipoInterfaccia(iSoap);
                    ret.setInterfaccia(as.getByteWsdlLogicoErogatore());
                    break;
                }
                default: {
                    throw FaultCode.ERRORE_INTERNO.toException("Tipologia interfaccia registro sconosciuta: " + as.getServiceBinding().name());
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiModI getApiModI(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiModI ret = ModiApiApiHelper.getApiModI(as, profilo, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiReferenteView getApiReferente(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiReferenteView ret = new ApiReferenteView();
            ret.setProfilo(env.profilo);
            ret.setReferente(as.getSoggettoReferente().getNome());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiRisorsa getApiRisorsa(String nome, Integer versione, String nomeRisorsa, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            Resource res = as.getResourceList().stream().filter(r -> nomeRisorsa.equals(r.getNome())).findFirst().orElse(null);
            if (res == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna risorsa con nome " + nomeRisorsa + " \u00e8 registrata per la Api indicata");
            }
            ApiRisorsa ret = ApiApiHelper.risorsaRegistroToApi(res);
            ApiApiHelper.populateApiRisorsaWithProtocolInfo(as, res, env, profilo, ret);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiServizio getApiServizio(String nome, Integer versione, String nomeServizio, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiServizio ret = as.getPortTypeList().stream().filter(p -> nomeServizio.equals(p.getNome())).map(p -> ApiApiHelper.servizioRegistroToApi(p)).findFirst().orElse(null);
            if (ret == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio con nome: " + nomeServizio);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiTags getApiTags(String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ApiTags ret = new ApiTags();
            if (as.getGruppi() != null && as.getGruppi().getGruppoList() != null && !as.getGruppi().getGruppoList().isEmpty()) {
                for (GruppoAccordo tag : as.getGruppi().getGruppoList()) {
                    ret.addTagsItem(tag.getNome());
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiAllegato(ApiAllegato body, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            Documento oldDoc = (Documento)BaseHelper.supplyOrNotFound(() -> env.archiviCore.getDocumento(nomeAllegato, null, null, as.getId().longValue(), false, ProprietariDocumento.accordoServizio), (String)("Allegato con nome " + nomeAllegato + " per la API scelta."));
            Documento newDoc = ApiApiHelper.apiAllegatoToDocumento(body, as, env);
            newDoc.setId(oldDoc.getId());
            if (!newDoc.getRuolo().equals(oldDoc.getRuolo())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non puoi modificare il ruolo di un allegato");
            }
            SerialiableFormFile filewrap = new SerialiableFormFile(newDoc.getFile(), newDoc.getByteContenuto());
            env.requestWrapper.overrideParameter("ruolo", newDoc.getRuolo());
            ArchiviHelper archiviHelper = new ArchiviHelper(env.stationCore, (HttpServletRequest)env.requestWrapper, env.pd, env.requestWrapper.getSession());
            if (!archiviHelper.accordiAllegatiCheckData(TipoOperazione.CHANGE, (FormFile)filewrap, newDoc, ProprietariDocumento.accordoServizio, env.protocolFactory)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            AccordiServizioParteComuneUtilities.updateAccordoServizioParteComuneAllegati((AccordoServizioParteComune)as, (Documento)oldDoc, (Documento)newDoc);
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiAzione(ApiAzione body, String nome, Integer versione, String nomeServizio, String nomeAzione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            PortType pt = as.getPortTypeList().stream().filter(p -> nomeServizio.equals(p.getNome())).findFirst().orElse(null);
            if (pt == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio con nome: " + nomeServizio);
            }
            Operation oldOp = (Operation)BaseHelper.findAndRemoveFirst((Iterable)pt.getAzioneList(), op -> nomeAzione.equals(op.getNome()));
            if (oldOp == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Azione con nome: " + nomeAzione + " associata al servizio " + nomeServizio);
            }
            if (!nomeAzione.equals(oldOp.getNome())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non puoi modificare il nome dell'azione");
            }
            ApiApiHelper.updateOperation(body, pt, oldOp);
            Operation newOp = oldOp;
            ProfiloCollaborazioneEnum profiloBody = body.getProfiloCollaborazione() != null ? body.getProfiloCollaborazione() : ProfiloCollaborazioneEnum.SINCRONO;
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApiApiHelper.getProtocolProperties(body, profilo, as, newOp, env)) != null) {
                newOp.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.CHANGE, null));
            }
            if (!env.apcHelper.accordiPorttypeOperationCheckData(TipoOperazione.CHANGE, as.getId().toString(), nomeServizio, newOp.getNome(), newOp.getProfAzione(), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newOp.getConsegnaInOrdine()), newOp.getScadenza() != null ? newOp.getScadenza() : "", "-", "-", Enums.profiloCollaborazioneFromApiEnum.get(profiloBody).toString(), "0", "", "literal", null, "")) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            IDPortType idPT = new IDPortType();
            idPT.setNome(pt.getNome());
            idPT.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as));
            IDPortTypeAzione idAccordoAzione = new IDPortTypeAzione();
            idAccordoAzione.setNome(oldOp.getNome());
            idAccordoAzione.setIdPortType(idPT);
            ApiApiHelper.validateProperties(env, protocolProperties, idAccordoAzione, ConsoleOperationType.CHANGE);
            pt.addAzione(newOp);
            AccordiServizioParteComuneUtilities.createPortTypeOperation((boolean)env.apcCore.isEnableAutoMappingWsdlIntoAccordo(), (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (AccordoServizioParteComune)as, (PortType)pt, (String)env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiCanale(ConfigurazioneApiCanale body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            IDAccordo oldIdAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            if (!env.gestioneCanali) {
                throw new Exception("Gestione dei canali non abilitata");
            }
            if (ConfigurazioneCanaleEnum.RIDEFINITO.equals((Object)body.getConfigurazione())) {
                if (body.getCanale() == null || "".equals(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un canale");
                }
                if (!env.canali.contains(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il canale fornito '" + body.getCanale() + "' non \u00e8 presente nel registro");
                }
                as.setCanale(body.getCanale());
            } else {
                as.setCanale(null);
            }
            boolean validazioneDocumenti = ServerProperties.getInstance().isValidazioneDocumenti();
            BinaryParameter wsdlserv = new BinaryParameter();
            wsdlserv.setValue(as.getByteWsdlLogicoErogatore());
            BinaryParameter wsdlconc = new BinaryParameter();
            wsdlconc.setValue(as.getByteWsdlConcettuale());
            BinaryParameter wsdldef = new BinaryParameter();
            wsdldef.setValue(as.getByteWsdlDefinitorio());
            StringBuilder bfTags = new StringBuilder();
            if (as.getGruppi() != null && as.getGruppi().getGruppoList() != null && !as.getGruppi().getGruppoList().isEmpty()) {
                for (GruppoAccordo tag : as.getGruppi().getGruppoList()) {
                    if (bfTags.length() > 0) {
                        bfTags.append(",");
                    }
                    bfTags.append(tag.getNome());
                }
            }
            boolean gestioneCanaliEnabled = env.gestioneCanali;
            String canale = as.getCanale();
            String canaleStato = null;
            canaleStato = canale == null ? "default" : "ridefinito";
            if (!env.apcHelper.accordiCheckData(TipoOperazione.CHANGE, as.getNome(), as.getDescrizione(), as.getProfiloCollaborazione().toString(), Helper.toBinaryParameter(as.getByteWsdlDefinitorio()), Helper.toBinaryParameter(as.getByteWsdlConcettuale()), Helper.toBinaryParameter(as.getByteWsdlLogicoErogatore()), Helper.toBinaryParameter(as.getByteWsdlLogicoFruitore()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConsegnaInOrdine()), as.getScadenza() == null ? "" : as.getScadenza(), as.getId().toString(), as.getSoggettoReferente().getNome(), as.getVersione().toString(), null, false, false, oldIdAccordo, null, null, null, validazioneDocumenti, env.tipo_protocollo, null, env.apcCore.toMessageServiceBinding(as.getServiceBinding()), null, Enums.interfaceTypeFromFormatoSpecifica.get(as.getFormatoSpecifica()), env.gestisciSoggettoReferente, bfTags.toString(), canaleStato, canale, gestioneCanaliEnabled)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.setOldIDAccordoForUpdate(oldIdAccordo);
            ArrayList<AccordoServizioParteComune> operazioniList = new ArrayList<AccordoServizioParteComune>(Arrays.asList(as));
            IDAccordo idNEW = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            if (!idNEW.equals((Object)oldIdAccordo)) {
                AccordiServizioParteComuneUtilities.findOggettiDaAggiornare((IDAccordo)oldIdAccordo, (AccordoServizioParteComune)as, (AccordiServizioParteComuneCore)env.apcCore, operazioniList);
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, operazioniList.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiDescrizione(ApiDescrizione body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            IDAccordo oldIdAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            as.setDescrizione(body.getDescrizione());
            boolean validazioneDocumenti = ServerProperties.getInstance().isValidazioneDocumenti();
            BinaryParameter wsdlserv = new BinaryParameter();
            wsdlserv.setValue(as.getByteWsdlLogicoErogatore());
            BinaryParameter wsdlconc = new BinaryParameter();
            wsdlconc.setValue(as.getByteWsdlConcettuale());
            BinaryParameter wsdldef = new BinaryParameter();
            wsdldef.setValue(as.getByteWsdlDefinitorio());
            StringBuilder bfTags = new StringBuilder();
            if (as.getGruppi() != null && as.getGruppi().getGruppoList() != null && !as.getGruppi().getGruppoList().isEmpty()) {
                for (GruppoAccordo tag : as.getGruppi().getGruppoList()) {
                    if (bfTags.length() > 0) {
                        bfTags.append(",");
                    }
                    bfTags.append(tag.getNome());
                }
            }
            boolean gestioneCanaliEnabled = env.gestioneCanali;
            String canale = as.getCanale();
            String canaleStato = null;
            canaleStato = canale == null ? "default" : "ridefinito";
            if (!env.apcHelper.accordiCheckData(TipoOperazione.CHANGE, as.getNome(), as.getDescrizione(), as.getProfiloCollaborazione().toString(), Helper.toBinaryParameter(as.getByteWsdlDefinitorio()), Helper.toBinaryParameter(as.getByteWsdlConcettuale()), Helper.toBinaryParameter(as.getByteWsdlLogicoErogatore()), Helper.toBinaryParameter(as.getByteWsdlLogicoFruitore()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConsegnaInOrdine()), as.getScadenza() == null ? "" : as.getScadenza(), as.getId().toString(), as.getSoggettoReferente().getNome(), as.getVersione().toString(), null, false, false, oldIdAccordo, null, null, null, validazioneDocumenti, env.tipo_protocollo, null, env.apcCore.toMessageServiceBinding(as.getServiceBinding()), null, Enums.interfaceTypeFromFormatoSpecifica.get(as.getFormatoSpecifica()), env.gestisciSoggettoReferente, bfTags.toString(), canaleStato, canale, gestioneCanaliEnabled)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.setOldIDAccordoForUpdate(oldIdAccordo);
            ArrayList<AccordoServizioParteComune> operazioniList = new ArrayList<AccordoServizioParteComune>(Arrays.asList(as));
            IDAccordo idNEW = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            if (!idNEW.equals((Object)oldIdAccordo)) {
                AccordiServizioParteComuneUtilities.findOggettiDaAggiornare((IDAccordo)oldIdAccordo, (AccordoServizioParteComune)as, (AccordiServizioParteComuneCore)env.apcCore, operazioniList);
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, operazioniList.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiInformazioniGenerali(ApiInformazioniGenerali body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            IDAccordo oldIdAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            as.setNome(body.getNome());
            as.setVersione(body.getVersione());
            boolean validazioneDocumenti = ServerProperties.getInstance().isValidazioneDocumenti();
            StringBuilder bfTags = new StringBuilder();
            if (as.getGruppi() != null && as.getGruppi().getGruppoList() != null && !as.getGruppi().getGruppoList().isEmpty()) {
                for (GruppoAccordo tag : as.getGruppi().getGruppoList()) {
                    if (bfTags.length() > 0) {
                        bfTags.append(",");
                    }
                    bfTags.append(tag.getNome());
                }
            }
            boolean gestioneCanaliEnabled = env.gestioneCanali;
            String canale = as.getCanale();
            String canaleStato = null;
            canaleStato = canale == null ? "default" : "ridefinito";
            if (!env.apcHelper.accordiCheckData(TipoOperazione.CHANGE, as.getNome(), as.getDescrizione(), as.getProfiloCollaborazione().toString(), Helper.toBinaryParameter(as.getByteWsdlDefinitorio()), Helper.toBinaryParameter(as.getByteWsdlConcettuale()), Helper.toBinaryParameter(as.getByteWsdlLogicoErogatore()), Helper.toBinaryParameter(as.getByteWsdlLogicoFruitore()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConsegnaInOrdine()), as.getScadenza() == null ? "" : as.getScadenza(), as.getId().toString(), as.getSoggettoReferente().getNome(), as.getVersione().toString(), null, false, false, oldIdAccordo, null, null, null, validazioneDocumenti, env.tipo_protocollo, null, env.apcCore.toMessageServiceBinding(as.getServiceBinding()), null, Enums.interfaceTypeFromFormatoSpecifica.get(as.getFormatoSpecifica()), env.gestisciSoggettoReferente, bfTags.toString(), canaleStato, canale, gestioneCanaliEnabled)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.setOldIDAccordoForUpdate(oldIdAccordo);
            ArrayList<AccordoServizioParteComune> operazioniList = new ArrayList<AccordoServizioParteComune>(Arrays.asList(as));
            IDAccordo idNEW = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            if (!idNEW.equals((Object)oldIdAccordo)) {
                AccordiServizioParteComuneUtilities.findOggettiDaAggiornare((IDAccordo)oldIdAccordo, (AccordoServizioParteComune)as, (AccordiServizioParteComuneCore)env.apcCore, operazioniList);
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, operazioniList.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiInterfaccia(ApiInterfaccia body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            ServerProperties serverProperties;
            boolean validazioneDocumenti;
            String wsdl;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            String tipoWsdl = as.getServiceBinding() == ServiceBinding.REST ? "wsdlconc" : "wsdlserv";
            if (!env.apcHelper.accordiWSDLCheckData(env.pd, tipoWsdl, wsdl = new String(body.getInterfaccia()), as, validazioneDocumenti = (serverProperties = ServerProperties.getInstance()).isValidazioneDocumenti(), env.tipo_protocollo)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            boolean facilityUnicoWSDL_interfacciaStandard = as.getServiceBinding() == ServiceBinding.SOAP;
            ServerProperties properties = ServerProperties.getInstance();
            boolean aggiornaEsistenti = serverProperties.isUpdateInterfacciaApiUpdateIfExists();
            boolean eliminaNonPresentiNuovaInterfaccia = serverProperties.isUpdateInterfacciaApiDeleteIfNotFound();
            ArrayList risorseEliminate = new ArrayList();
            ArrayList portTypeEliminati = new ArrayList();
            ArrayList operationEliminate = new ArrayList();
            AccordiServizioParteComuneUtilities.updateInterfacciaAccordoServizioParteComune((String)tipoWsdl, (String)wsdl, (AccordoServizioParteComune)as, (boolean)properties.isEnabledAutoMapping(), (boolean)properties.isValidazioneDocumenti(), (boolean)properties.isEnabledAutoMappingEstraiXsdSchemiFromWsdlTypes(), (boolean)facilityUnicoWSDL_interfacciaStandard, (String)env.tipo_protocollo, (AccordiServizioParteComuneCore)env.apcCore, (boolean)aggiornaEsistenti, (boolean)eliminaNonPresentiNuovaInterfaccia, risorseEliminate, portTypeEliminati, operationEliminate);
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiModI(ApiModI body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            ProtocolProperties updateModiProtocolProperties = ModiApiApiHelper.updateModiProtocolProperties(as, profilo, body);
            IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            ApiApiHelper.validateProperties(env, updateModiProtocolProperties, idAccordoFromAccordo, ConsoleOperationType.CHANGE);
            if (updateModiProtocolProperties != null) {
                as.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)updateModiProtocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiRisorsa(ApiRisorsa body, String nome, Integer versione, String nomeRisorsa, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            Resource oldResource = (Resource)BaseHelper.findAndRemoveFirst((Iterable)as.getResourceList(), r -> nomeRisorsa.equals(r.getNome()));
            if (oldResource == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna risorsa trovata con nome " + nomeRisorsa);
            }
            String oldPath = oldResource.getPath();
            String oldHttpMethod = oldResource.getMethodRawEnumValue();
            String oldNomeRisorsaGenerato = oldHttpMethod != null ? APIUtils.normalizeResourceName((HttpMethod)HttpMethod.toEnumConstant((String)oldHttpMethod), (String)oldPath) : null;
            ApiApiHelper.updateRisorsa(body, oldResource);
            Resource newRes = oldResource;
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ApiApiHelper.getProtocolProperties(body, profilo, newRes, env)) != null) {
                newRes.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.CHANGE, null));
            }
            if (!env.apcHelper.accordiResourceCheckData(TipoOperazione.CHANGE, as.getId().toString(), body.getNome() != null ? body.getNome() : "", newRes.getNome(), newRes.getPath(), newRes.getMethodRawEnumValue(), newRes.getDescrizione(), env.apcCore.toMessageMessageType(newRes.getMessageType()), nomeRisorsa, oldNomeRisorsaGenerato, oldPath, oldHttpMethod, "ridefinito", AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newRes.getConsegnaInOrdine()), newRes.getScadenza() != null ? newRes.getScadenza() : "")) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            IDResource idResource = new IDResource();
            idResource.setNome(oldResource.getNome());
            idResource.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as));
            ApiApiHelper.validateProperties(env, protocolProperties, idResource, newRes.getMethod() != null ? newRes.getMethod().toString() : null, newRes.getPath(), ConsoleOperationType.ADD);
            as.addResource(newRes);
            AccordiServizioParteComuneUtilities.createResource((boolean)env.apcCore.isEnableAutoMappingWsdlIntoAccordo(), (AccordiServizioParteComuneCore)env.apcCore, (AccordiServizioParteComuneHelper)env.apcHelper, (AccordoServizioParteComune)as, (String)env.userLogin);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiServizio(ApiServizio body, String nome, Integer versione, String nomeServizio, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            PortType oldPt = (PortType)BaseHelper.findAndRemoveFirst((Iterable)as.getPortTypeList(), p -> nomeServizio.equals(p.getNome()));
            if (oldPt == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Servizio registrato con nome: " + nomeServizio);
            }
            ApiApiHelper.updatePortType(body, oldPt, env);
            PortType newPt = oldPt;
            if (!env.apcHelper.accordiPorttypeCheckData(TipoOperazione.CHANGE, as.getId().toString(), newPt.getNome(), newPt.getDescrizione(), "ridefinito", AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPt.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPt.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPt.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPt.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)newPt.getConsegnaInOrdine()), newPt.getScadenza() != null ? newPt.getScadenza() : "")) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.addPortType(newPt);
            env.apcCore.performUpdateOperation(env.userLogin, false, new Object[]{as});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateApiTags(ApiTags body, String nome, Integer versione, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            if (body == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un body");
            }
            ApiEnv env = new ApiEnv(profilo, soggetto, context);
            AccordoServizioParteComune as = ApiApiHelper.getAccordoFull(nome, versione, env);
            if (as == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna Api registrata con nome " + nome + " e versione " + versione);
            }
            IDAccordo oldIdAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            ArrayList<Gruppo> objectToCreate = new ArrayList<Gruppo>();
            if (body.getTags() == null || body.getTags().isEmpty()) {
                as.setGruppi(null);
            } else {
                as.setGruppi(new GruppiAccordo());
                GruppiCore gruppiCore = new GruppiCore(env.stationCore);
                for (String tag : body.getTags()) {
                    GruppoAccordo gruppo = new GruppoAccordo();
                    gruppo.setNome(tag);
                    as.getGruppi().addGruppo(gruppo);
                    if (gruppiCore.existsGruppo(tag)) continue;
                    Gruppo nuovoGruppo = new Gruppo();
                    nuovoGruppo.setNome(tag);
                    nuovoGruppo.setSuperUser(as.getSuperUser());
                    objectToCreate.add(nuovoGruppo);
                }
            }
            boolean validazioneDocumenti = ServerProperties.getInstance().isValidazioneDocumenti();
            BinaryParameter wsdlserv = new BinaryParameter();
            wsdlserv.setValue(as.getByteWsdlLogicoErogatore());
            BinaryParameter wsdlconc = new BinaryParameter();
            wsdlconc.setValue(as.getByteWsdlConcettuale());
            BinaryParameter wsdldef = new BinaryParameter();
            wsdldef.setValue(as.getByteWsdlDefinitorio());
            StringBuilder bfTags = new StringBuilder();
            if (as.getGruppi() != null && as.getGruppi().getGruppoList() != null && !as.getGruppi().getGruppoList().isEmpty()) {
                for (GruppoAccordo tag : as.getGruppi().getGruppoList()) {
                    if (bfTags.length() > 0) {
                        bfTags.append(",");
                    }
                    bfTags.append(tag.getNome());
                }
            }
            boolean gestioneCanaliEnabled = env.gestioneCanali;
            String canale = as.getCanale();
            String canaleStato = null;
            canaleStato = canale == null ? "default" : "ridefinito";
            if (!env.apcHelper.accordiCheckData(TipoOperazione.CHANGE, as.getNome(), as.getDescrizione(), as.getProfiloCollaborazione().toString(), Helper.toBinaryParameter(as.getByteWsdlDefinitorio()), Helper.toBinaryParameter(as.getByteWsdlConcettuale()), Helper.toBinaryParameter(as.getByteWsdlLogicoErogatore()), Helper.toBinaryParameter(as.getByteWsdlLogicoFruitore()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getFiltroDuplicati()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConfermaRicezione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdCollaborazione()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getIdRiferimentoRichiesta()), AccordiServizioParteComuneHelper.convertAbilitatoDisabilitatoDB2View((StatoFunzionalita)as.getConsegnaInOrdine()), as.getScadenza() == null ? "" : as.getScadenza(), as.getId().toString(), as.getSoggettoReferente().getNome(), as.getVersione().toString(), null, false, false, oldIdAccordo, null, null, null, validazioneDocumenti, env.tipo_protocollo, null, env.apcCore.toMessageServiceBinding(as.getServiceBinding()), null, Enums.interfaceTypeFromFormatoSpecifica.get(as.getFormatoSpecifica()), env.gestisciSoggettoReferente, bfTags.toString(), canaleStato, canale, gestioneCanaliEnabled)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml((String)env.pd.getMessage()));
            }
            as.setOldIDAccordoForUpdate(oldIdAccordo);
            ArrayList<AccordoServizioParteComune> operazioniList = new ArrayList<AccordoServizioParteComune>(Arrays.asList(as));
            IDAccordo idNEW = env.idAccordoFactory.getIDAccordoFromAccordo(as);
            if (!idNEW.equals((Object)oldIdAccordo)) {
                AccordiServizioParteComuneUtilities.findOggettiDaAggiornare((IDAccordo)oldIdAccordo, (AccordoServizioParteComune)as, (AccordiServizioParteComuneCore)env.apcCore, operazioniList);
            }
            if (objectToCreate.size() > 0) {
                env.apcCore.performCreateOperation(env.userLogin, false, objectToCreate.toArray(new Object[objectToCreate.size()]));
            }
            env.apcCore.performUpdateOperation(env.userLogin, false, operazioniList.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

