/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl;

import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import org.openspcoop2.core.config.rs.server.api.StatusApi;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiEnv;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.beans.BeanUtils;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.slf4j.LoggerFactory;

public class StatusApiServiceImpl
extends BaseImpl
implements StatusApi {
    public StatusApiServiceImpl() {
        super(LoggerFactory.getLogger(StatusApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public Problem getStatus() {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            Problem p = null;
            SoggettiEnv env = new SoggettiEnv(context.getServletRequest(), ProfiloEnum.APIGATEWAY, context);
            IDSoggetto idSogg = env.idSoggetto.toIDSoggetto();
            boolean exists = false;
            try {
                exists = env.soggettiCore.existsSoggetto(idSogg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!exists) {
                throw new Exception("Servizio non disponibile");
            }
            p = new Problem();
            ProblemRFC7807 pUtils = FaultCode.STATUS_OK.toFault();
            ArrayList metodiEsclusi = new ArrayList(0);
            BeanUtils.copy((Object)((Object)p), (Object)pUtils, metodiEsclusi);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return p;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

