/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.File;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiImplStato;
import org.openspcoop2.core.config.rs.server.model.CachingRisposta;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneApiCanale;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativi;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuoli;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuolo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScope;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScopes;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneView;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiGestioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiIdentificazioneAttributi;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ElencoProprieta;
import org.openspcoop2.core.config.rs.server.model.GestioneCors;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ListaRateLimitingPolicy;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.config.rs.server.model.ProprietaOpzioneCifratura;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriMetricaEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneView;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneDiagnosticiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazione;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface FruizioniConfigurazioneApi {
    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di applicativi all'elenco degli applicativi autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneControlloAccessiAutorizzazioneApplicativi(@Valid ControlloAccessiAutorizzazioneApplicativo var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di applicativi all'elenco degli applicativi token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneControlloAccessiAutorizzazioneApplicativiToken(@Valid ControlloAccessiAutorizzazioneApplicativo var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di ruoli all'elenco dei ruoli autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneControlloAccessiAutorizzazioneRuoli(@Valid ControlloAccessiAutorizzazioneRuolo var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di ruoli all'elenco dei ruoli token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneControlloAccessiAutorizzazioneRuoliToken(@Valid ControlloAccessiAutorizzazioneRuolo var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di scope all'elenco degli scope autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneControlloAccessiAutorizzazioneScope(@Valid ControlloAccessiAutorizzazioneScope var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/proprieta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una propriet\u00e0 di configurazione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneProprieta(@Valid ProprietaOpzioneCifratura var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/rate-limiting")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una policy di rate limiting", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneRateLimitingPolicy(@Valid RateLimitingPolicyFruizione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una regola di correlazione applicativa", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneTracciamentoCorrelazioneApplicativaRichiesta(@Valid CorrelazioneApplicativaRichiesta var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Aggiunta di una regola di correlazione applicativa", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void addFruizioneTracciamentoCorrelazioneApplicativaRisposta(@Valid CorrelazioneApplicativaRisposta var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi/{applicativo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina applicativi dall'elenco degli applicativi autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativi eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneControlloAccessiAutorizzazioneApplicativi(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="applicativo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi/{applicativo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina applicativi dall'elenco degli applicativi token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Applicativi eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneControlloAccessiAutorizzazioneApplicativiToken(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="applicativo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli/{ruolo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina ruoli dall'elenco dei ruoli autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Ruoli eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneControlloAccessiAutorizzazioneRuoli(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="ruolo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli/{ruolo_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina ruoli dall'elenco dei ruoli token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Ruoli eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneControlloAccessiAutorizzazioneRuoliToken(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="ruolo_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope/{scope_autorizzato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina scope dall'elenco degli scope autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Scope eliminati con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneControlloAccessiAutorizzazioneScope(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="scope_autorizzato") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la propriet\u00e0 di configurazione dall'elenco di quelle attivate", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Propriet\u00e0 di configurazione eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneProprietaConfigurazione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la policy dall'elenco delle policies attive", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Policy eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneRateLimitingPolicy(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la regola di correlazione applicativa dall'elenco di quelle attivate per la richiesta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Regola eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina la regola di correlazione applicativa dall'elenco di quelle attivate per la risposta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Regola eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/download-xacml-policy")
    @Produces(value={"application/xml", "application/problem+json"})
    @Operation(summary="Restituisce la policy XACML associata all'autorizzazione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Interfaccia dell'API restituita con successo", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] downloadFruizioneControlloAccessiAutorizzazioneXacmlPolicy(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/rate-limiting")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle policy di rate limiting configurate", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco policy di rate limiting restituito con successo", content={@Content(schema=@Schema(implementation=ListaRateLimitingPolicy.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaRateLimitingPolicy findAllFruizioneRateLimitingPolicies(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7, @QueryParam(value="q") String var8, @QueryParam(value="limit") Integer var9, @QueryParam(value="offset") @DefaultValue(value="0") Integer var10, @QueryParam(value="metrica") RateLimitingCriteriMetricaEnum var11);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle regole di correlazione applicativa per la richiesta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco regole di correlazione applicativa restituito con successo", content={@Content(schema=@Schema(implementation=ListaCorrelazioneApplicativaRichiesta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaCorrelazioneApplicativaRichiesta findAllFruizioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7, @QueryParam(value="q") String var8, @QueryParam(value="limit") Integer var9, @QueryParam(value="offset") @DefaultValue(value="0") Integer var10);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco delle regole di correlazione applicativa per la risposta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco regole di correlazione applicativa restituito con successo", content={@Content(schema=@Schema(implementation=ListaCorrelazioneApplicativaRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaCorrelazioneApplicativaRisposta findAllFruizioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7, @QueryParam(value="q") String var8, @QueryParam(value="limit") Integer var9, @QueryParam(value="offset") @DefaultValue(value="0") Integer var10);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/caching-risposta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa al caching delle risposte", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=CachingRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public CachingRisposta getFruizioneCachingRisposta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/canale")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il canale associato alla fruizione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Canale restituito con successo", content={@Content(schema=@Schema(implementation=ApiCanale.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiCanale getFruizioneCanale(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autenticazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'autenticazione per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutenticazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutenticazione getFruizioneControlloAccessiAutenticazione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'autorizzazione per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneView getFruizioneControlloAccessiAutorizzazione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/applicativi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli applicativi autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco applicativi autorizzati restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneApplicativi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneApplicativi getFruizioneControlloAccessiAutorizzazioneApplicativi(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/applicativi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli applicativi token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco applicativi token autorizzati restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneApplicativi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneApplicativi getFruizioneControlloAccessiAutorizzazioneApplicativiToken(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/ruoli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco dei ruoli autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco ruoli autorizzati restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneRuoli.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneRuoli getFruizioneControlloAccessiAutorizzazioneRuoli(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/token/ruoli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco dei ruoli token autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco ruoli autorizzati restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneRuoli.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneRuoli getFruizioneControlloAccessiAutorizzazioneRuoliToken(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione/scope")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'elenco degli scope autorizzati", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Elenco scope autorizzati restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiAutorizzazioneScopes.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiAutorizzazioneScopes getFruizioneControlloAccessiAutorizzazioneScope(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/gestione-token")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla gestione dei token per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiGestioneToken.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiGestioneToken getFruizioneControlloAccessiGestioneToken(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/identificazione-attributi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa all'identificazione degli attributi per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=ControlloAccessiIdentificazioneAttributi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ControlloAccessiIdentificazioneAttributi getFruizioneControlloAccessiIdentificazioneAttributi(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/proprieta")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le propriet\u00e0 di configurazione attivate", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=ElencoProprieta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ElencoProprieta getFruizioneElencoProprieta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/gestione-cors")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni sulla configurazione CORS associata alla fruizione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sulla configurazione CORS restituite con successo", content={@Content(schema=@Schema(implementation=GestioneCors.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public GestioneCors getFruizioneGestioneCORS(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una propriet\u00e0 di configurazione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della propriet\u00e0 di configurazione restituiti con successo", content={@Content(schema=@Schema(implementation=ProprietaOpzioneCifratura.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ProprietaOpzioneCifratura getFruizioneProprieta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una policy di rate limiting", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della policy restituiti con successo", content={@Content(schema=@Schema(implementation=RateLimitingPolicyFruizioneView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public RateLimitingPolicyFruizioneView getFruizioneRateLimitingPolicy(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/diagnostici")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione dei diagnostici", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=RegistrazioneDiagnosticiConfigurazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneDiagnosticiConfigurazione getFruizioneRegistrazioneDiagnostici(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/registrazione-messaggi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione dei messaggi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=RegistrazioneMessaggi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneMessaggi getFruizioneRegistrazioneMessaggi(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/transazioni")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla registrazione delle transazioni", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=RegistrazioneTransazioniConfigurazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public RegistrazioneTransazioniConfigurazione getFruizioneRegistrazioneTransazioni(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/stato")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce l'indicazione sullo stato del gruppo", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio dello stato restituito con successo", content={@Content(schema=@Schema(implementation=ApiImplStato.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiImplStato getFruizioneStato(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una regola di correlazione applicativa per la richiesta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della regola restituiti con successo", content={@Content(schema=@Schema(implementation=CorrelazioneApplicativaRichiesta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public CorrelazioneApplicativaRichiesta getFruizioneTracciamentoCorrelazioneApplicativaRichiesta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di una regola di correlazione applicativa per la risposta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della regola restituiti con successo", content={@Content(schema=@Schema(implementation=CorrelazioneApplicativaRisposta.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public CorrelazioneApplicativaRisposta getFruizioneTracciamentoCorrelazioneApplicativaRisposta(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/validazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la configurazione relativa alla validazione dei contenuti applicativi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettaglio della configurazione restituito con successo", content={@Content(schema=@Schema(implementation=Validazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public Validazione getFruizioneValidazione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/caching-risposta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa al caching delle risposte", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneCachingRisposta(@Valid CachingRisposta var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/canale")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare il canale associato alla fruizione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Il canale \u00e8 stato aggiornato correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneCanale(@Valid ConfigurazioneApiCanale var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autenticazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'autenticazione per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneControlloAccessiAutenticazione(@Valid ControlloAccessiAutenticazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/autorizzazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'autorizzazione per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneControlloAccessiAutorizzazione(@Valid ControlloAccessiAutorizzazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/gestione-token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla gestione dei token per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneControlloAccessiGestioneToken(@Valid ControlloAccessiGestioneToken var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/controllo-accessi/identificazione-attributi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa all'identificazione degli attributi per quanto concerne il controllo degli accessi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneControlloAccessiIdentificazioneAttributi(@Valid ControlloAccessiIdentificazioneAttributi var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/gestione-cors")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione CORS associata alla fruizione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione della fruizione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneGestioneCORS(@Valid GestioneCors var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/proprieta/{proprieta}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una propriet\u00e0 di configurazione", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La propriet\u00e0 di configurazione \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneProprieta(@Valid ProprietaOpzioneCifratura var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @PathParam(value="proprieta") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var8, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var9);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/rate-limiting/{id_policy}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una policy di rate limiting", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La policy \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneRateLimitingPolicy(@Valid RateLimitingPolicyFruizioneUpdate var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @PathParam(value="id_policy") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var8, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var9);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/diagnostici")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione dei diagnostici", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneRegistrazioneDiagnostici(@Valid RegistrazioneDiagnosticiConfigurazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/registrazione-messaggi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione dei messaggi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneRegistrazioneMessaggi(@Valid RegistrazioneMessaggi var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/transazioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla registrazione delle transazioni", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneRegistrazioneTransazioni(@Valid RegistrazioneTransazioniConfigurazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/stato")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare lo stato del gruppo", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione del gruppo aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneStato(@Valid ApiImplStato var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/richiesta/{elemento}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una regola di correlazione applicativa per la richiesta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La regola \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneTracciamentoCorrelazioneApplicativaRichiesta(@Valid CorrelazioneApplicativaRichiesta var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var8, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var9);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/tracciamento/correlazione-applicativa/risposta/{elemento}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di una regola di correlazione applicativa per la risposta", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La regola \u00e8 stata aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneTracciamentoCorrelazioneApplicativaRisposta(@Valid CorrelazioneApplicativaRisposta var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @PathParam(value="elemento") @Size(max=255) @Size(max=255) String var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var8, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var9);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/configurazioni/validazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione relativa alla validazione dei contenuti applicativi", tags={"fruizioni-configurazione"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneValidazione(@Valid Validazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);
}

