/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_2.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.reader.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.v2_2.drivers.DriverConfigurazioneServiziOpenSPCoopV1;
import it.link.pdd.tools.migrazione_govway.v2_2.reader.ConfigurazioneServiziConverter;
import it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDominioV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class ConfigurazioneServiziReader
implements IConfigurazioneServiziReader {
    private IDriverRegistroServiziGet driverRegistro;
    private IDriverConfigurazioneGet driverConfigurazione;
    private DriverConfigurazioneServiziOpenSPCoopV1 driverAvanzato;
    private boolean dsMode;
    private Connection connection;
    private ConfigurazioneServiziConverter converter;

    public void closeConnection() throws SQLException {
        if (!this.dsMode) {
            this.connection.close();
        }
    }

    public ConfigurazioneServiziReader(DatabaseProperties initIn, DatabaseProperties initOut, Logger log) throws Exception {
        try {
            this.dsMode = initIn.isDataSourceMode();
            this.converter = new ConfigurazioneServiziConverter(initIn, initOut);
            if (this.dsMode) {
                this.driverRegistro = new DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV1(initIn.getJndiName(), initIn.getJndiProp(), log, initIn.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connection, initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(this.connection, initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV1(this.connection, log, initIn.getTipoDatabase());
            }
            ExtendedInfoManager.initialize((Loader)new Loader(Utilities.class.getClassLoader()), null, null, null);
        }
        catch (Exception e) {
            log.error("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), e);
        }
    }

    public List<PortaDominioV2Wrapper> findAllPdD() throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDominioV2Wrapper> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDominioV2Wrapper>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdPorteDominio(new FiltroRicerca());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (String id : allId) {
                it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDominioV2Wrapper wrapper = new it.link.pdd.tools.migrazione_govway.v2_2.wrapper.PortaDominioV2Wrapper();
                PortaDominio portaDominio = this.driverRegistro.getPortaDominio(id);
                wrapper.setPorta(portaDominio);
                wrapper.setTipo(PortaDominioV2Wrapper.TIPO.fromValue(this.driverAvanzato.getTipoPortaDominio(id)));
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPdD(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> findAllSoggettiRegistro() throws Exception {
        ArrayList<Soggetto> lst = new ArrayList<Soggetto>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdSoggetti(new org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDSoggetto id : allId) {
                lst.add(this.driverRegistro.getSoggetto(id));
            }
        }
        return this.converter.convertListSoggettiRegistro(lst);
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneNonComposti() throws Exception {
        ArrayList<org.openspcoop2.core.registry.AccordoServizioParteComune> lst = new ArrayList<org.openspcoop2.core.registry.AccordoServizioParteComune>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDAccordo id : allId) {
                org.openspcoop2.core.registry.AccordoServizioParteComune accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(id, true);
                if (accordo.getServizioComposto() != null) continue;
                lst.add(accordo);
            }
        }
        return this.converter.convertListAccordiParteComune(lst);
    }

    public List<AccordoServizioParteSpecifica> findAllServizi(List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> lstIds) throws Exception {
        ArrayList<org.openspcoop2.core.registry.AccordoServizioParteSpecifica> lst = new ArrayList<org.openspcoop2.core.registry.AccordoServizioParteSpecifica>();
        for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo idAccordo : lstIds) {
            FiltroRicercaServizi filtro = new FiltroRicercaServizi();
            filtro.setIdAccordo(this.converter.toIdAccordoV1(idAccordo));
            filtro.setTipologiaServizio(StatoFunzionalita.DISABILITATO.getValue());
            try {
                List allId = this.driverRegistro.getAllIdServizi(filtro);
                if (allId == null) continue;
                for (IDServizio id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteSpecifica(id, true));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
        }
        return this.converter.convertListServizi(lst);
    }

    public List<AccordoServizioParteSpecifica> findAllServiziCorrelati(List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> lstIds) throws Exception {
        ArrayList<org.openspcoop2.core.registry.AccordoServizioParteSpecifica> lst = new ArrayList<org.openspcoop2.core.registry.AccordoServizioParteSpecifica>();
        for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo idAccordo : lstIds) {
            FiltroRicercaServizi filtro = new FiltroRicercaServizi();
            filtro.setIdAccordo(this.converter.toIdAccordoV1(idAccordo));
            filtro.setTipologiaServizio(StatoFunzionalita.ABILITATO.getValue());
            try {
                List allId = this.driverRegistro.getAllIdServizi(filtro);
                if (allId == null) continue;
                for (IDServizio id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteSpecifica(id, true));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
        }
        return this.converter.convertListServizi(lst);
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneComposti() throws Exception {
        ArrayList<org.openspcoop2.core.registry.AccordoServizioParteComune> lst = new ArrayList<org.openspcoop2.core.registry.AccordoServizioParteComune>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDAccordo id : allId) {
                org.openspcoop2.core.registry.AccordoServizioParteComune accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizioParteComune(id, true);
                if (accordo.getServizioComposto() == null) continue;
                lst.add(accordo);
            }
        }
        return this.converter.convertListAccordiParteComune(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione> findAllAccordiCooperazione() throws Exception {
        ArrayList<AccordoCooperazione> lst = new ArrayList<AccordoCooperazione>();
        try {
            List allId = this.driverRegistro.getAllIdAccordiCooperazione(new FiltroRicercaAccordi());
            if (allId != null) {
                for (IDAccordoCooperazione id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoCooperazione(id, true));
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return this.converter.convertListAccordiCooperazione(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto> findAllSoggettiConfig() throws Exception {
        ArrayList<org.openspcoop2.core.config.Soggetto> lst = new ArrayList<org.openspcoop2.core.config.Soggetto>();
        List allId = this.driverConfigurazione.getAllIdSoggetti(new FiltroRicercaSoggetti());
        if (allId != null) {
            for (IDSoggetto id : allId) {
                lst.add(this.driverConfigurazione.getSoggetto(id));
            }
        }
        return this.converter.convertListSoggettiConfig(lst);
    }

    public List<ServizioApplicativo> findAllServiziApplicativi() throws Exception {
        ArrayList<org.openspcoop2.core.config.ServizioApplicativo> lst = new ArrayList<org.openspcoop2.core.config.ServizioApplicativo>();
        List allId = this.driverConfigurazione.getAllIdServiziApplicativi(new FiltroRicercaServiziApplicativi());
        if (allId != null) {
            for (IDServizioApplicativo id : allId) {
                lst.add(this.driverConfigurazione.getServizioApplicativo(id));
            }
        }
        return this.converter.convertListServiziApplicativi(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper> findAllPorteApplicative() throws Exception {
        ArrayList<PortaApplicativaV2Wrapper> lst = new ArrayList<PortaApplicativaV2Wrapper>();
        List allId = this.driverConfigurazione.getAllIdPorteApplicative(new FiltroRicercaPorteApplicative());
        if (allId != null) {
            for (IDPortaApplicativaByNome id : allId) {
                PortaApplicativaV2Wrapper wrapper = new PortaApplicativaV2Wrapper();
                PortaApplicativa pa = this.driverConfigurazione.getPortaApplicativa(id);
                wrapper.setPortaApplicativa(pa);
                wrapper.setCorrelazioneRisposta(this.driverAvanzato.getPACorrelazioneRisposta(pa));
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPorteApplicative(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper> findAllPorteDelegate() throws Exception {
        ArrayList<PortaDelegataV2Wrapper> lst = new ArrayList<PortaDelegataV2Wrapper>();
        List allId = this.driverConfigurazione.getAllIdPorteDelegate(new FiltroRicercaPorteDelegate());
        if (allId != null) {
            for (IDPortaDelegata id : allId) {
                PortaDelegataV2Wrapper wrapper = new PortaDelegataV2Wrapper();
                PortaDelegata pd = this.driverConfigurazione.getPortaDelegata(id);
                if (pd.getAutorizzazione() != null && "openspcoop".equals(pd.getAutorizzazione())) {
                    pd.setAutorizzazione("authenticated");
                }
                if (pd.getAutorizzazione() == null || "".equals(pd.getAutorizzazione())) {
                    pd.setAutorizzazione("none");
                }
                wrapper.setPortaDelegata(pd);
                wrapper.setCorrelazioneRisposta(this.driverAvanzato.getPDCorrelazioneRisposta(pd));
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPorteDelegate(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> findIdAccordiNonComposti() throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo>();
        List allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
        if (allId != null) {
            for (IDAccordo id : allId) {
                org.openspcoop2.core.registry.AccordoServizioParteComune accordo = this.driverRegistro.getAccordoServizioParteComune(id);
                if (accordo.getServizioComposto() != null) continue;
                lst.add(this.converter.toIdAccordoV2(id));
            }
        }
        return lst;
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> findIdAccordiComposti() throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo>();
        List allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDAccordo id : allId) {
                org.openspcoop2.core.registry.AccordoServizioParteComune accordo = this.driverRegistro.getAccordoServizioParteComune(id);
                if (accordo.getServizioComposto() == null) continue;
                lst.add(this.converter.toIdAccordoV2(id));
            }
        }
        return lst;
    }

    public List<ConnettoriProperty> findAllConnettoriProperties() throws Exception {
        ArrayList<ConnettoriProperty> lst = new ArrayList<ConnettoriProperty>();
        List<String> ids = this.driverAvanzato.findAllIdConnettoreProperties();
        for (String id : ids) {
            lst.add(this.driverAvanzato.getConnettoreProperties(id));
        }
        return lst;
    }

    public List<Ruolo> findAllRuoli() throws Exception {
        return new ArrayList<Ruolo>();
    }
}

