/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v1_4.drivers;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB_LIB;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.CorrelazioneRisposta;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.config.driver.IDServizioApplicativo;
import org.slf4j.Logger;

public class DriverConfigurazioneServiziOpenSPCoopV1 {
    public DataSource datasource = null;
    protected Connection globalConnection = null;
    protected boolean atomica = true;
    protected Logger log = null;
    protected String tipoDB = null;

    public DriverConfigurazioneServiziOpenSPCoopV1(String nomeDataSource, Properties context, String tipoDB) throws Exception {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverConfigurazioneServiziOpenSPCoopV1(String nomeDataSource, Properties context, Logger alog, String tipoDB) throws Exception {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverConfigurazioneServiziOpenSPCoopV1(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        this.initDriverConfigurazioneFindAll(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD);
    }

    public DriverConfigurazioneServiziOpenSPCoopV1(Connection connection, Logger alog, String tipoDB) throws Exception {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
        }
        if (connection == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.atomica = false;
        this.tipoDB = tipoDB;
    }

    private void initDriverConfigurazioneFindAll(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws Exception {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDB_LIB.initStaticLogger((Logger)this.log);
            }
            InitialContext initCtx = new InitialContext(context);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error("Impossibile recuperare il context: " + ne.getMessage());
            throw new Exception("Impossibile recuperare il context: " + ne.getMessage());
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            throw new Exception("Il tipoDatabase non puo essere null.");
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
    }

    public IDSoggetto[] getAllIdSoggettiConfig() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdSoggetti...");
        try {
            IDSoggetto[] iDSoggettoArray;
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("identificativo_porta");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("identificativo_porta"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() > 0) {
                iDSoggettoArray = idSoggetti.toArray(new IDSoggetto[1]);
                return iDSoggettoArray;
            }
            iDSoggettoArray = null;
            return iDSoggettoArray;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdSoggetti error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDPortaDelegata[] getAllIdPorteDelegata() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdPorteDelegate...");
        try {
            IDPortaDelegata[] iDPortaDelegataArray;
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addSelectField("porte_delegate.location");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            Vector<IDPortaDelegata> idsPD = new Vector<IDPortaDelegata>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setSoggettoFruitore(idS);
                String location = rs.getString("location");
                if (location != null && !"".equals(location)) {
                    idPD.setLocationPD(location);
                } else {
                    idPD.setLocationPD(rs.getString("nome_porta"));
                }
                idsPD.add(idPD);
            }
            if (idsPD.size() > 0) {
                iDPortaDelegataArray = idsPD.toArray(new IDPortaDelegata[1]);
                return iDPortaDelegataArray;
            }
            iDPortaDelegataArray = null;
            return iDPortaDelegataArray;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdPorteDelegate error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Long[] getAllIdPorteApplicative() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdPorteApplicative...");
        try {
            Long[] longArray;
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("porte_applicative.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            Vector<Long> idsPA = new Vector<Long>();
            while (rs.next()) {
                Long idPA = rs.getLong("id");
                idsPA.add(idPA);
            }
            if (idsPA.size() > 0) {
                longArray = idsPA.toArray(new Long[1]);
                return longArray;
            }
            longArray = null;
            return longArray;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdPorteApplicative error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDServizioApplicativo[] getAllIdServiziApplicativi() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdServiziApplicativi...");
        try {
            IDServizioApplicativo[] iDServizioApplicativoArray;
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_applicativi.nome");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            Vector<IDServizioApplicativo> idsSA = new Vector<IDServizioApplicativo>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idS);
                idSA.setNome(rs.getString("nome"));
                idsSA.add(idSA);
            }
            if (idsSA.size() > 0) {
                iDServizioApplicativoArray = idsSA.toArray(new IDServizioApplicativo[1]);
                return iDServizioApplicativoArray;
            }
            iDServizioApplicativoArray = null;
            return iDServizioApplicativoArray;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdServiziApplicativi error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getTipoPortaDominio(String nomePorta) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getTipoPortaDominio [" + nomePorta + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("pdd.tipo");
            sqlQueryObject.addWhereCondition("pdd.nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                String string = rs.getString("tipo");
                return string;
            }
            try {
                throw new Exception("Porta [" + nomePorta + "] non trovata");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("getTipoPortaDominio [" + nomePorta + "] error", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneRisposta> getPDCorrelazioneRisposta(long idPorta) throws DriverConfigurazioneException {
        return this.getCorrelazioneRisposta(idPorta, "porte_delegate_corr_risp");
    }

    public List<CorrelazioneRisposta> getPACorrelazioneRisposta(long idPorta) throws DriverConfigurazioneException {
        return this.getCorrelazioneRisposta(idPorta, "porte_appl_corr_risp");
    }

    private List<CorrelazioneRisposta> getCorrelazioneRisposta(long idPorta, String nomeTabella) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getCorrelazioneRisposta [" + idPorta + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("nome_elemento");
            sqlQueryObject.addSelectField("mode_correlazione");
            sqlQueryObject.addSelectField("pattern");
            sqlQueryObject.addSelectField("identificazione_fallita");
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPorta);
            rs = stm.executeQuery();
            ArrayList<CorrelazioneRisposta> lst = new ArrayList<CorrelazioneRisposta>();
            while (rs.next()) {
                CorrelazioneRisposta corr = new CorrelazioneRisposta();
                corr.setNomeElemento(rs.getString("nome_elemento"));
                corr.setModeCorrelazione(rs.getString("mode_correlazione"));
                corr.setPattern(rs.getString("pattern"));
                corr.setIdentificazioneFallita(rs.getString("identificazione_fallita"));
                lst.add(corr);
            }
            ArrayList<CorrelazioneRisposta> arrayList = lst;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getCorrelazioneRisposta [" + idPorta + "] error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ConnettoriProperty getConnettoreProperties(String nomeConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getTipoPortaDominio [" + nomeConnettore + "]...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("connettori_properties.nome_connettore");
            sqlQueryObject.addSelectField("connettori_properties.path");
            sqlQueryObject.addWhereCondition("connettori_properties.nome_connettore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeConnettore);
            rs = stm.executeQuery();
            if (rs.next()) {
                ConnettoriProperty connProps = new ConnettoriProperty();
                connProps.setNomeConnettore(rs.getString("nome_connettore"));
                connProps.setPath(rs.getString("path"));
                ConnettoriProperty connettoriProperty = connProps;
                return connettoriProperty;
            }
            try {
                throw new Exception("Connettore [" + nomeConnettore + "] non ha properties");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Connettore [" + nomeConnettore + "] error", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> findAllIdConnettoreProperties() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("findAllIdConnettoreProperties...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("connettori_properties.nome_connettore");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            ArrayList<String> lst = new ArrayList<String>();
            while (rs.next()) {
                lst.add(rs.getString("nome_connettore"));
            }
            ArrayList<String> arrayList = lst;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("findAllIdConnettoreProperties error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

