/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.wsdl;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.openspcoop2.core.registry.wsdl.SchemaXSDAccordoServizio;
import org.openspcoop2.core.registry.wsdl.SchemaXSDNamingException;
import org.openspcoop2.core.registry.wsdl.SplitWSDLException;
import org.openspcoop2.core.registry.wsdl.TipoSchemaXSDAccordoServizio;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SplitWSDL {
    public static final String FOLDER_IMPLEMENTATIVI = "specificaPortiAccesso";
    public static final String IMPLEMENTATIVO_EROGATORE_FILENAME = "PortiAccessoErogatore.wsdl";
    public static final String IMPLEMENTATIVO_FRUITORE_FILENAME = "PortiAccessoFruitore.wsdl";
    public static final String FOLDER_INTERFACCE = "specificaInterfaccia";
    public static final String LOGICO_EROGATORE_FILENAME = "InterfacciaLogicaErogatore.wsdl";
    public static final String LOGICO_FRUITORE_FILENAME = "InterfacciaLogicaFruitore.wsdl";
    public static final String CONCETTUALE_FILENAME = "InterfacciaConcettuale.wsdl";
    public static final String DEFINITORIO_FILENAME = "InterfacciaDefinitoria.xsd";
    private DefinitionWrapper wsdlErogatore;
    private String wsdlErogatorePath;
    private DefinitionWrapper wsdlFruitore;
    private String wsdlFruitorePath;
    private String[] porttypesErogatore;
    private String[] operationPorttypesErogatore;
    private String[] porttypesFruitore;
    private String[] operationPorttypesFruitore;
    private DefinitionWrapper wsdlImplementativoErogatore;
    private DefinitionWrapper wsdlImplementativoFruitore;
    private DefinitionWrapper wsdlLogicoErogatore;
    private DefinitionWrapper wsdlLogicoFruitore;
    private DefinitionWrapper wsdlConcettuale;
    private List<SchemaXSDAccordoServizio> schemiErogatore = new ArrayList<SchemaXSDAccordoServizio>();
    private List<SchemaXSDAccordoServizio> schemiFruitore = new ArrayList<SchemaXSDAccordoServizio>();
    private List<String> schemiNames = new ArrayList<String>();
    private List<Schema> importsSchemiErogatore = new ArrayList<Schema>();
    private List<Schema> importsSchemiFruitore = new ArrayList<Schema>();
    private List<Import> importsWsdlErogatore = new ArrayList<Import>();
    private List<Import> importsWsdlFruitore = new ArrayList<Import>();
    private TipoSchemaXSDAccordoServizio tipoSchema = TipoSchemaXSDAccordoServizio.ALLEGATO;
    private boolean gestisciNomi;
    private XMLUtils xmlUtils = null;
    private WSDLUtilities wsdlUtilities = null;

    public SplitWSDL(String wsdlErogatore) throws SplitWSDLException {
        this(wsdlErogatore, null, null, null, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO, true, false);
    }

    public SplitWSDL(String wsdlErogatore, boolean permettiSchemaLocationNonDefiniti) throws SplitWSDLException {
        this(wsdlErogatore, null, null, null, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO, true, permettiSchemaLocationNonDefiniti);
    }

    public SplitWSDL(String wsdlErogatore, String wsdlFruitore) throws SplitWSDLException {
        this(wsdlErogatore, wsdlFruitore, null, null, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO, true, false);
    }

    public SplitWSDL(String wsdlErogatore, String wsdlFruitore, boolean gestisciNomi) throws SplitWSDLException {
        this(wsdlErogatore, wsdlFruitore, null, null, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO, true, false);
    }

    public SplitWSDL(String wsdlErogatore, String wsdlFruitore, boolean gestisciNomi, boolean permettiSchemaLocationNonDefiniti) throws SplitWSDLException {
        this(wsdlErogatore, wsdlFruitore, null, null, null, null, TipoSchemaXSDAccordoServizio.ALLEGATO, true, permettiSchemaLocationNonDefiniti);
    }

    public SplitWSDL(String wsdlErogatore, String wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema) throws SplitWSDLException {
        this(wsdlErogatore, wsdlFruitore, null, null, null, null, tipoSchema, true, false);
    }

    public SplitWSDL(String wsdlErogatore, String wsdlFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean permettiSchemaLocationNonDefiniti) throws SplitWSDLException {
        this(wsdlErogatore, wsdlFruitore, null, null, null, null, tipoSchema, true, permettiSchemaLocationNonDefiniti);
    }

    public SplitWSDL(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, TipoSchemaXSDAccordoServizio tipoSchema, boolean gestisciNomi) throws SplitWSDLException {
        this(wsdl, null, porttypesErogatore, operationPorttypesErogatore, null, null, tipoSchema, gestisciNomi, false);
    }

    public SplitWSDL(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean gestisciNomi) throws SplitWSDLException {
        this(wsdl, wsdl, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, tipoSchema, gestisciNomi, false);
    }

    public SplitWSDL(String wsdl, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean gestisciNomi, boolean permettiSchemaLocationNonDefiniti) throws SplitWSDLException {
        this(wsdl, wsdl, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore, tipoSchema, gestisciNomi, permettiSchemaLocationNonDefiniti);
    }

    private SplitWSDL(String wsdlErogatore, String wsdlFruitore, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore, TipoSchemaXSDAccordoServizio tipoSchema, boolean gestisciNomi, boolean permettiSchemaLocationNonDefiniti) throws SplitWSDLException {
        this.gestisciNomi = gestisciNomi;
        this.tipoSchema = tipoSchema;
        if (wsdlErogatore == null) {
            throw new SplitWSDLException("WSDL Erogatore non fornito");
        }
        if (porttypesErogatore != null && operationPorttypesErogatore == null) {
            throw new SplitWSDLException("Operations dei PortyTypes per il wsdl erogatore non forniti");
        }
        if (porttypesErogatore != null && porttypesErogatore.length != operationPorttypesErogatore.length) {
            throw new SplitWSDLException("Operations [" + operationPorttypesErogatore.length + "] dei PortyTypes [" + porttypesErogatore.length + "] per il wsdl erogatore non correlate correttamente ai port types");
        }
        if (porttypesFruitore != null) {
            if (operationPorttypesFruitore == null) {
                throw new SplitWSDLException("Operations dei PortyTypes per il wsdl fruitore non forniti");
            }
            if (porttypesFruitore.length != operationPorttypesFruitore.length) {
                throw new SplitWSDLException("Operations [" + operationPorttypesErogatore.length + "] dei PortyTypes [" + porttypesErogatore.length + "] per il wsdl fruitore non correlate correttamente ai port types");
            }
        }
        this.porttypesErogatore = porttypesErogatore;
        this.porttypesFruitore = porttypesFruitore;
        this.operationPorttypesErogatore = operationPorttypesErogatore;
        this.operationPorttypesFruitore = operationPorttypesFruitore;
        try {
            this.xmlUtils = XMLUtils.getInstance();
            this.wsdlUtilities = WSDLUtilities.getInstance((AbstractXMLUtils)this.xmlUtils);
            if (wsdlErogatore != null) {
                this.wsdlErogatorePath = wsdlErogatore;
                this.wsdlErogatore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlErogatore), (AbstractXMLUtils)this.xmlUtils);
                this.wsdlConcettuale = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlErogatore), (AbstractXMLUtils)this.xmlUtils);
                this.wsdlLogicoErogatore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlErogatore), (AbstractXMLUtils)this.xmlUtils);
                this.wsdlImplementativoErogatore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlErogatore), (AbstractXMLUtils)this.xmlUtils);
            }
            if (wsdlFruitore != null) {
                this.wsdlFruitorePath = wsdlFruitore;
                this.wsdlFruitore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlFruitore), (AbstractXMLUtils)this.xmlUtils);
                this.wsdlLogicoFruitore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlFruitore), (AbstractXMLUtils)this.xmlUtils);
                this.wsdlImplementativoFruitore = new DefinitionWrapper(this.wsdlUtilities.readWSDLFromLocation(wsdlFruitore), (AbstractXMLUtils)this.xmlUtils);
            }
            this.creaSchemi(permettiSchemaLocationNonDefiniti);
            this.creaConcettuale();
            this.creaLogicoErogatore();
            this.creaImplementativoErogatore();
            if (wsdlFruitore == null || porttypesErogatore != null && porttypesFruitore == null) {
                return;
            }
            this.creaLogicoFruitore();
            this.creaImplementativoFruitore();
        }
        catch (Exception e) {
            throw new SplitWSDLException(e.getMessage(), e);
        }
    }

    public void writeTo(File dir, boolean prettyPrint) throws WSDLException, IOException, TransformerException, ParserConfigurationException, TransformerFactoryConfigurationError, org.openspcoop2.utils.wsdl.WSDLException, XMLException {
        this.writeSchemiTo(dir, prettyPrint);
        File interfacce = new File(dir.getAbsolutePath() + File.separator + FOLDER_INTERFACCE);
        interfacce.mkdir();
        this.writeConcettualeTo(dir, prettyPrint);
        this.writeLogicoErogatoreTo(dir, prettyPrint);
        this.writeLogicoFruitoreTo(dir, prettyPrint);
        File implementativi = new File(dir.getAbsolutePath() + File.separator + FOLDER_IMPLEMENTATIVI);
        implementativi.mkdir();
        this.writeImplementativoErogatoreTo(dir, prettyPrint);
        this.writeImplementativoFruitoreTo(dir, prettyPrint);
    }

    public DefinitionWrapper getWsdlImplementativoErogatore() {
        return this.wsdlImplementativoErogatore;
    }

    public DefinitionWrapper getWsdlImplementativoFruitore() {
        return this.wsdlImplementativoFruitore;
    }

    public DefinitionWrapper getWsdlLogicoErogatore() {
        return this.wsdlLogicoErogatore;
    }

    public DefinitionWrapper getWsdlLogicoFruitore() {
        return this.wsdlLogicoFruitore;
    }

    public DefinitionWrapper getWsdlConcettuale() {
        return this.wsdlConcettuale;
    }

    public List<SchemaXSDAccordoServizio> getSchemiErogatore() {
        return this.schemiErogatore;
    }

    public List<SchemaXSDAccordoServizio> getSchemiFruitore() {
        return this.schemiFruitore;
    }

    private void creaSchemi(boolean permettiSchemaLocationNonDefiniti) throws TransformerException, SchemaXSDNamingException, ParserConfigurationException, SAXException, IOException, XMLException {
        int flag = 0;
        flag = this.gestisciImportInclude(this.wsdlErogatore, this.wsdlErogatorePath, this.schemiErogatore, this.importsSchemiErogatore, this.importsWsdlErogatore, true, flag, permettiSchemaLocationNonDefiniti);
        if (this.porttypesErogatore != null) {
            this.schemiFruitore = (ArrayList)((ArrayList)this.schemiErogatore).clone();
            this.importsSchemiFruitore = (ArrayList)((ArrayList)this.importsSchemiErogatore).clone();
            this.importsWsdlFruitore = (ArrayList)((ArrayList)this.importsWsdlErogatore).clone();
        } else {
            flag = this.gestisciImportInclude(this.wsdlFruitore, this.wsdlFruitorePath, this.schemiFruitore, this.importsSchemiFruitore, this.importsWsdlFruitore, false, flag, permettiSchemaLocationNonDefiniti);
        }
    }

    private int gestisciImportInclude(DefinitionWrapper input_wsdl, String input_wsdlPath, List<SchemaXSDAccordoServizio> output_schemi, List<Schema> output_importsSchemi, List<Import> output_importsWsdl, boolean isErogatore, int flag, boolean permettiSchemaLocationNonDefiniti) throws ParserConfigurationException, SAXException, IOException, SchemaXSDNamingException, XMLException {
        List schemas;
        int ritorno = 0;
        if (input_wsdl == null) {
            return ritorno;
        }
        if (input_wsdl.getTypes() != null && (schemas = input_wsdl.getTypes().getExtensibilityElements()) != null) {
            for (int i = 0; i < schemas.size(); ++i) {
                Schema schema = (Schema)schemas.get(i);
                String targetNamespace = schema.getElement().getAttribute("targetNamespace");
                Map definitionNamespace = input_wsdl.getWsdlDefinition().getNamespaces();
                Set prefixes = definitionNamespace.keySet();
                for (String prefix : prefixes) {
                    if (prefix.equals("")) {
                        if (!schema.getElement().getAttribute("xmlns").equals("")) continue;
                        schema.getElement().setAttribute("xmlns", (String)definitionNamespace.get(prefix));
                        continue;
                    }
                    if (!schema.getElement().getAttribute("xmlns:" + prefix).equals("")) continue;
                    schema.getElement().setAttribute("xmlns:" + prefix, (String)definitionNamespace.get(prefix));
                }
                String filename = this.getLocalNameSchema(DEFINITORIO_FILENAME, output_schemi, false);
                Element newSchemaElement = schema.getElement().getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
                newSchemaElement.setAttribute("targetNamespace", targetNamespace);
                Element include = schema.getElement().getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:include");
                include.setAttribute("schemaLocation", ".." + File.separator + this.tipoSchema.getDirectory() + File.separator + filename);
                newSchemaElement.appendChild(include);
                SchemaImpl newSchema = new SchemaImpl();
                newSchema.setElement(newSchemaElement);
                newSchema.setElementType(schema.getElementType());
                newSchema.setRequired(schema.getRequired());
                output_importsSchemi.add((Schema)newSchema);
                if (isErogatore) {
                    this.addSchemaErogatore(schema.getElement(), filename, new File(input_wsdlPath), false, permettiSchemaLocationNonDefiniti);
                } else {
                    this.addSchemaFruitore(schema.getElement(), filename, new File(input_wsdlPath), false, permettiSchemaLocationNonDefiniti);
                }
                ++ritorno;
            }
        }
        Map importsMap = input_wsdl.getImports();
        for (List imports : importsMap.values()) {
            for (int i = 0; i < imports.size(); ++i) {
                Import myimport = (Import)imports.get(i);
                String location = myimport.getLocationURI();
                File importedFile = new File(new File(input_wsdlPath).getParentFile(), location);
                String schemaFilename = this.getLocalNameSchema(importedFile, output_schemi, false);
                Import newImport = input_wsdl.createImport();
                newImport.setLocationURI(".." + File.separator + this.tipoSchema.getDirectory() + File.separator + schemaFilename);
                newImport.setNamespaceURI(myimport.getNamespaceURI());
                output_importsWsdl.add(newImport);
                XMLUtils xmlUtils = XMLUtils.getInstance();
                Document doc = xmlUtils.newDocument(importedFile);
                if (isErogatore) {
                    this.addSchemaErogatore(doc.getDocumentElement(), schemaFilename, importedFile, true, permettiSchemaLocationNonDefiniti);
                    continue;
                }
                this.addSchemaFruitore(doc.getDocumentElement(), schemaFilename, importedFile, true, permettiSchemaLocationNonDefiniti);
            }
        }
        return ritorno;
    }

    private String getLocalNameSchema(File file, List<SchemaXSDAccordoServizio> lista, boolean force) throws SchemaXSDNamingException {
        String name = this.getLocalNameSchema(file, null, lista, force, true);
        this.schemiNames.add(name);
        return name;
    }

    private String getLocalNameSchema(String filename, List<SchemaXSDAccordoServizio> lista, boolean force) throws SchemaXSDNamingException {
        String name = this.getLocalNameSchema(null, filename, lista, force, true);
        this.schemiNames.add(name);
        return name;
    }

    private String getLocalNameSchema(File file, String filename, List<SchemaXSDAccordoServizio> lista, boolean force, boolean firstTime) throws SchemaXSDNamingException {
        int i;
        if (force) {
            if (file != null) {
                return file.getName();
            }
            return filename;
        }
        if (firstTime && file != null) {
            for (i = 0; i < lista.size(); ++i) {
                if (file.getAbsolutePath().compareTo(lista.get(i).getSourceAbsolutePath()) != 0) continue;
                return lista.get(i).getFilename();
            }
        }
        if (((Object)lista).equals(this.schemiFruitore) && file != null) {
            for (i = 0; i < this.schemiErogatore.size(); ++i) {
                if (file.getAbsolutePath().compareTo(this.schemiErogatore.get(i).getSourceAbsolutePath()) != 0) continue;
                return this.schemiErogatore.get(i).getFilename();
            }
        }
        if (filename == null) {
            filename = file.getName();
        }
        for (i = 0; i < this.schemiNames.size(); ++i) {
            if (filename.compareTo(this.schemiNames.get(i)) != 0) continue;
            if (this.gestisciNomi) {
                int punto = filename.lastIndexOf(".");
                String filenameSenzaExt = filename.substring(0, punto);
                String filenameExt = filename.substring(punto);
                int underscore = filename.lastIndexOf("_");
                if (underscore < 0) {
                    filename = filenameSenzaExt + "_0" + filenameExt;
                } else {
                    try {
                        int number = Integer.parseInt(filenameSenzaExt.substring(underscore + 1));
                        filename = filenameSenzaExt.substring(0, underscore + 1) + (number + 1) + filenameExt;
                    }
                    catch (Exception e) {
                        filename = filenameSenzaExt + "_0" + filenameExt;
                    }
                }
                if (file != null) {
                    return this.getLocalNameSchema(new File(file.getParentFile(), filename), lista, false);
                }
                return this.getLocalNameSchema(filename, lista, false);
            }
            throw new SchemaXSDNamingException("Ci sono due documenti inclusi/importati che hanno lo stesso nome di file: " + filename);
        }
        return filename;
    }

    private void addSchemaErogatore(Element xml, String filename, File localpath, boolean check, boolean permettiSchemaLocationNonDefiniti) throws ParserConfigurationException, SAXException, IOException, SchemaXSDNamingException, XMLException {
        this.addSchema(xml, filename, localpath, this.schemiErogatore, check, permettiSchemaLocationNonDefiniti);
    }

    private void addSchemaFruitore(Element xml, String filename, File localpath, boolean check, boolean permettiSchemaLocationNonDefiniti) throws ParserConfigurationException, SAXException, IOException, SchemaXSDNamingException, XMLException {
        this.addSchema(xml, filename, localpath, this.schemiFruitore, check, permettiSchemaLocationNonDefiniti);
    }

    private void addSchema(Element xml, String filename, File xmlSource, List<SchemaXSDAccordoServizio> schemi, boolean check, boolean permettiSchemaLocationNonDefiniti) throws ParserConfigurationException, SAXException, IOException, SchemaXSDNamingException, XMLException {
        Document doc;
        String schemaFilename;
        File schema;
        String schemaLocation;
        int i;
        XMLUtils xmlUtils = XMLUtils.getInstance();
        boolean force = false;
        if (check) {
            for (int i2 = 0; i2 < schemi.size(); ++i2) {
                if (xmlSource.getAbsolutePath().compareTo(schemi.get(i2).getSourceAbsolutePath()) != 0) continue;
                return;
            }
        }
        NodeList nl = xml.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (i = 0; i < nl.getLength(); ++i) {
            schemaLocation = ((Element)nl.item(i)).getAttribute("schemaLocation");
            if (schemaLocation == null || "".equals(schemaLocation)) {
                if (permettiSchemaLocationNonDefiniti) continue;
                throw new ParserConfigurationException("attributo 'schemaLocation' non definito in import (file " + filename + ")");
            }
            schema = new File(xmlSource.getParentFile(), schemaLocation);
            schemaFilename = this.getLocalNameSchema(schema, schemi, force);
            ((Element)nl.item(i)).setAttribute("schemaLocation", schemaFilename);
            doc = xmlUtils.newDocument(schema);
            this.addSchema(doc.getDocumentElement(), schemaFilename, schema, schemi, true, permettiSchemaLocationNonDefiniti);
        }
        nl = xml.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (i = 0; i < nl.getLength(); ++i) {
            schemaLocation = ((Element)nl.item(i)).getAttribute("schemaLocation");
            if (schemaLocation == null || "".equals(schemaLocation)) {
                if (permettiSchemaLocationNonDefiniti) continue;
                throw new ParserConfigurationException("attributo 'schemaLocation' non definito in include (file " + filename + ")");
            }
            schema = new File(xmlSource.getParentFile(), schemaLocation);
            schemaFilename = this.getLocalNameSchema(schema, schemi, force);
            ((Element)nl.item(i)).setAttribute("schemaLocation", schemaFilename);
            doc = xmlUtils.newDocument(schema);
            this.addSchema(doc.getDocumentElement(), schemaFilename, schema, schemi, true, permettiSchemaLocationNonDefiniti);
        }
        nl = xml.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        for (i = 0; i < nl.getLength(); ++i) {
            schemaLocation = ((Element)nl.item(i)).getAttribute("location");
            if (schemaLocation == null || "".equals(schemaLocation)) {
                if (permettiSchemaLocationNonDefiniti) continue;
                throw new ParserConfigurationException("attributo 'location' non definito in include (file " + filename + ")");
            }
            schema = new File(xmlSource.getParentFile(), schemaLocation);
            schemaFilename = this.getLocalNameSchema(schema, schemi, force);
            ((Element)nl.item(i)).setAttribute("location", schemaFilename);
            doc = xmlUtils.newDocument(schema);
            this.addSchema(doc.getDocumentElement(), schemaFilename, schema, schemi, true, permettiSchemaLocationNonDefiniti);
        }
        SchemaXSDAccordoServizio schema2 = new SchemaXSDAccordoServizio(xml, filename, xmlSource, this.tipoSchema);
        schemi.add(schema2);
    }

    private void writeSchemiTo(File basedir, boolean prettyPrint) throws TransformerException, IOException, ParserConfigurationException, TransformerFactoryConfigurationError, XMLException {
        int i;
        if (this.schemiErogatore.size() + this.schemiFruitore.size() == 0) {
            return;
        }
        if (!basedir.isDirectory()) {
            throw new IOException("Il path indicato non e' una directory valida.");
        }
        for (i = 0; i < this.schemiErogatore.size(); ++i) {
            this.schemiErogatore.get(i).writeTo(basedir, prettyPrint);
        }
        for (i = 0; i < this.schemiFruitore.size(); ++i) {
            this.schemiFruitore.get(i).writeTo(basedir, prettyPrint);
        }
    }

    private void creaConcettuale() throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        boolean found;
        int i;
        this.wsdlUtilities.removeAllBindings((Definition)this.wsdlConcettuale);
        this.wsdlUtilities.removeAllServices((Definition)this.wsdlConcettuale);
        Types types = this.wsdlConcettuale.getTypes();
        List xsdTypes = types.getExtensibilityElements();
        while (xsdTypes.size() > 0) {
            types.removeExtensibilityElement((ExtensibilityElement)((Schema)xsdTypes.get(0)));
            xsdTypes = types.getExtensibilityElements();
        }
        this.wsdlConcettuale.removeAllImports();
        for (i = 0; i < this.importsWsdlErogatore.size(); ++i) {
            this.wsdlConcettuale.addImport(this.importsWsdlErogatore.get(i));
        }
        for (i = 0; i < this.importsSchemiErogatore.size(); ++i) {
            this.wsdlConcettuale.getTypes().addExtensibilityElement((ExtensibilityElement)this.importsSchemiErogatore.get(i));
        }
        for (i = 0; i < this.importsWsdlFruitore.size(); ++i) {
            found = false;
            for (int j = 0; j < this.importsWsdlErogatore.size(); ++j) {
                if (this.importsWsdlErogatore.get(j).getLocationURI().compareTo(this.importsWsdlFruitore.get(i).getLocationURI()) != 0 || this.importsWsdlErogatore.get(j).getNamespaceURI().compareTo(this.importsWsdlFruitore.get(i).getNamespaceURI()) != 0) continue;
                found = true;
            }
            if (found) continue;
            this.wsdlConcettuale.addImport(this.importsWsdlFruitore.get(i));
        }
        for (i = 0; i < this.importsSchemiFruitore.size(); ++i) {
            found = false;
            Element includeFruitore = (Element)this.importsSchemiFruitore.get(i).getElement().getFirstChild();
            for (int j = 0; j < this.importsSchemiErogatore.size(); ++j) {
                Element includeErogatore = (Element)this.importsSchemiErogatore.get(j).getElement().getFirstChild();
                if (includeFruitore.getAttribute("schemaLocation").compareTo(includeErogatore.getAttribute("schemaLocation")) != 0) continue;
                found = true;
            }
            if (found) continue;
            this.wsdlConcettuale.getTypes().addExtensibilityElement((ExtensibilityElement)this.importsSchemiFruitore.get(i));
        }
        if (this.wsdlFruitore != null) {
            Map m = this.wsdlFruitore.getNamespaces();
            Iterator it = null;
            m = this.wsdlFruitore.getMessages();
            for (Message im : m.values()) {
                this.wsdlConcettuale.addMessage(im);
            }
            m = this.wsdlFruitore.getAllPortTypes();
            for (PortType im : m.values()) {
                this.wsdlConcettuale.addPortType(im);
            }
        }
        if (this.porttypesErogatore != null) {
            String[] portTypes = this.merge(this.porttypesErogatore, this.porttypesFruitore);
            Map m = this.wsdlConcettuale.getAllPortTypes();
            for (PortType now : m.values()) {
                String cuBinName = now.getQName().getLocalPart();
                boolean delete = true;
                for (int i2 = 0; i2 < portTypes.length; ++i2) {
                    String check = portTypes[i2];
                    if (!check.equals(cuBinName)) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                this.wsdlConcettuale.removePortType(now.getQName());
            }
            Vector<Message> mess = new Vector<Message>();
            m = this.wsdlConcettuale.getAllPortTypes();
            for (PortType p : m.values()) {
                List myl = p.getOperations();
                int k = myl.size();
                for (int h = 0; h < k; ++h) {
                    Message output;
                    Message input;
                    Operation operationWSDL = (Operation)myl.get(h);
                    Message message = input = operationWSDL.getInput() == null ? null : operationWSDL.getInput().getMessage();
                    if (input != null) {
                        mess.add(input);
                    }
                    Message message2 = output = operationWSDL.getOutput() == null ? null : operationWSDL.getOutput().getMessage();
                    if (output == null) continue;
                    mess.add(output);
                }
            }
            m = this.wsdlConcettuale.getMessages();
            Iterator it = m.values().iterator();
            Vector<Message> removeM = new Vector<Message>();
            while (it.hasNext()) {
                Message temp = (Message)it.next();
                if (mess.contains(temp)) continue;
                removeM.add(temp);
            }
            int j = removeM.size();
            for (int i3 = 0; i3 < j; ++i3) {
                this.wsdlConcettuale.removeMessage(((Message)removeM.get(i3)).getQName());
            }
        }
    }

    private void writeConcettualeTo(File dir, boolean prettyPrint) throws WSDLException, IOException, org.openspcoop2.utils.wsdl.WSDLException {
        this.wsdlUtilities.writeWsdlTo((Definition)this.wsdlConcettuale, dir.getAbsolutePath() + File.separator + FOLDER_INTERFACCE + File.separator + CONCETTUALE_FILENAME, prettyPrint);
    }

    private void creaLogicoErogatore() throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        this.creaLogico(this.wsdlLogicoErogatore, this.importsSchemiErogatore, this.importsWsdlErogatore, this.porttypesErogatore, this.operationPorttypesErogatore);
    }

    private void creaLogicoFruitore() throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        if (this.wsdlLogicoFruitore == null) {
            return;
        }
        this.creaLogico(this.wsdlLogicoFruitore, this.importsSchemiFruitore, this.importsWsdlFruitore, this.porttypesFruitore, this.operationPorttypesFruitore);
    }

    private void creaLogico(DefinitionWrapper wsdlLogico, List<Schema> importsSchemi, List<Import> importsWsdl, String[] portTypes, String[] operations) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        int i;
        Map m = null;
        Iterator it = null;
        this.wsdlUtilities.removeAllBindings((Definition)wsdlLogico);
        this.wsdlUtilities.removeAllServices((Definition)wsdlLogico);
        this.removeExtensibilityElements((WSDLElement)wsdlLogico.getTypes());
        for (i = 0; i < importsSchemi.size(); ++i) {
            wsdlLogico.getTypes().addExtensibilityElement((ExtensibilityElement)importsSchemi.get(i));
        }
        wsdlLogico.removeAllImports();
        for (i = 0; i < importsWsdl.size(); ++i) {
            wsdlLogico.addImport(importsWsdl.get(i));
        }
        m = wsdlLogico.getPortTypes();
        it = m.values().iterator();
        String prefix = null;
        String namespace = null;
        if (it.hasNext()) {
            PortType p = (PortType)it.next();
            prefix = p.getQName().getPrefix();
            namespace = p.getQName().getNamespaceURI();
        }
        if (prefix == null && namespace == null) {
            throw new WSDLException(namespace, prefix);
        }
        if (portTypes == null) {
            return;
        }
        Vector<PortType> pts = new Vector<PortType>();
        int j = portTypes.length;
        for (int i2 = 0; i2 < j; ++i2) {
            String[] myops;
            QName current = new QName(namespace, portTypes[i2], prefix);
            PortType now = wsdlLogico.getPortType(current);
            String[] stringArray = myops = operations[i2] == null ? null : operations[i2].split(",");
            if (myops == null) {
                return;
            }
            List opts = now.getOperations();
            Operation[] opp = new Operation[opts.size()];
            opts.toArray(opp);
            int y = opts.size();
            for (int x = 0; x < y; ++x) {
                String cur = opp[x].getName();
                boolean delete = true;
                int k = myops.length;
                for (int h = 0; h < k; ++h) {
                    if (!cur.equals(myops[h])) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                now.removeOperation(opp[x].getName(), null, null);
            }
            pts.add(now);
        }
        m = wsdlLogico.getAllPortTypes();
        it = m.values().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Vector<Message> mess = new Vector<Message>();
        int j2 = pts.size();
        for (int i3 = 0; i3 < j2; ++i3) {
            PortType p = (PortType)pts.get(i3);
            List myl = p.getOperations();
            int k = myl.size();
            for (int h = 0; h < k; ++h) {
                Message output;
                Message input;
                Operation operationWSDL = (Operation)myl.get(h);
                Message message = input = operationWSDL.getInput() == null ? null : operationWSDL.getInput().getMessage();
                if (input != null) {
                    mess.add(input);
                }
                Message message2 = output = operationWSDL.getOutput() == null ? null : operationWSDL.getOutput().getMessage();
                if (output == null) continue;
                mess.add(output);
            }
            wsdlLogico.addPortType(p);
        }
        m = wsdlLogico.getMessages();
        it = m.values().iterator();
        Vector<Message> removeM = new Vector<Message>();
        while (it.hasNext()) {
            Message temp = (Message)it.next();
            if (mess.contains(temp)) continue;
            removeM.add(temp);
        }
        int j3 = removeM.size();
        for (int i4 = 0; i4 < j3; ++i4) {
            wsdlLogico.removeMessage(((Message)removeM.get(i4)).getQName());
        }
        m = wsdlLogico.getAllPortTypes();
        for (PortType now : m.values()) {
            String cuBinName = now.getQName().getLocalPart();
            boolean delete = true;
            for (int i5 = 0; i5 < portTypes.length; ++i5) {
                String check = portTypes[i5];
                if (!check.equals(cuBinName)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            wsdlLogico.removePortType(now.getQName());
        }
    }

    private void writeLogicoErogatoreTo(File dir, boolean prettyPrint) throws WSDLException, IOException, org.openspcoop2.utils.wsdl.WSDLException {
        this.wsdlUtilities.writeWsdlTo((Definition)this.wsdlLogicoErogatore, dir.getAbsolutePath() + File.separator + FOLDER_INTERFACCE + File.separator + LOGICO_EROGATORE_FILENAME, prettyPrint);
    }

    private void writeLogicoFruitoreTo(File dir, boolean prettyPrint) throws WSDLException, IOException, org.openspcoop2.utils.wsdl.WSDLException {
        this.wsdlUtilities.writeWsdlTo((Definition)this.wsdlLogicoFruitore, dir.getAbsolutePath() + File.separator + FOLDER_INTERFACCE + File.separator + LOGICO_FRUITORE_FILENAME, prettyPrint);
    }

    private void creaImplementativoErogatore() throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        Import logicoErogatore = this.wsdlImplementativoErogatore.createImport();
        logicoErogatore.setLocationURI(".." + File.separator + FOLDER_INTERFACCE + File.separator + LOGICO_EROGATORE_FILENAME);
        logicoErogatore.setNamespaceURI(this.wsdlLogicoErogatore.getTargetNamespace());
        this.creaImplementativo(this.wsdlImplementativoErogatore, logicoErogatore, this.porttypesErogatore, this.operationPorttypesErogatore);
    }

    private void creaImplementativoFruitore() throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        if (this.wsdlImplementativoFruitore == null) {
            return;
        }
        Import logicoFruitore = this.wsdlImplementativoFruitore.createImport();
        logicoFruitore.setLocationURI(".." + File.separator + FOLDER_INTERFACCE + File.separator + LOGICO_FRUITORE_FILENAME);
        logicoFruitore.setNamespaceURI(this.wsdlLogicoFruitore.getTargetNamespace());
        this.creaImplementativo(this.wsdlImplementativoFruitore, logicoFruitore, this.porttypesFruitore, this.operationPorttypesFruitore);
    }

    private void creaImplementativo(DefinitionWrapper wsdlImplementativo, Import logico, String[] portTypes, String[] operations) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        int i;
        this.wsdlUtilities.removeAllMessages((Definition)wsdlImplementativo);
        this.wsdlUtilities.removeAllPortTypes((Definition)wsdlImplementativo);
        if (portTypes == null) {
            wsdlImplementativo.removeAllImports();
            wsdlImplementativo.addImport(logico);
            this.removeExtensibilityElements((WSDLElement)wsdlImplementativo.getTypes());
            return;
        }
        Map m = wsdlImplementativo.getBindings();
        Iterator it = m.values().iterator();
        Vector<Binding> bnd = new Vector<Binding>();
        while (it.hasNext()) {
            Binding now = wsdlImplementativo.getBinding(((Binding)it.next()).getQName());
            String refPTName = now.getPortType().getQName().getLocalPart();
            boolean found = false;
            int j = portTypes.length;
            for (i = 0; i < j; ++i) {
                if (!refPTName.equals(portTypes[i])) continue;
                found = true;
                break;
            }
            if (found) {
                List ops = now.getBindingOperations();
                String[] myops = operations[i].split(",");
                Vector<String> toDel = new Vector<String>();
                int k = ops.size();
                for (int h = 0; h < k; ++h) {
                    String curName = ((BindingOperation)ops.get(h)).getName();
                    boolean rem = true;
                    int n = myops.length;
                    for (int mm = 0; mm < n; ++mm) {
                        if (!myops[mm].equals(curName)) continue;
                        rem = false;
                        break;
                    }
                    if (!rem) continue;
                    toDel.add(curName);
                }
                int y = toDel.size();
                for (int x = 0; x < y; ++x) {
                    now.removeBindingOperation((String)toDel.get(x), null, null);
                }
            }
            bnd.add(now);
        }
        m = wsdlImplementativo.getAllBindings();
        for (Binding now : m.values()) {
            String cuBinName = now.getPortType().getQName().getLocalPart();
            boolean delete = true;
            for (i = 0; i < portTypes.length; ++i) {
                String check = portTypes[i];
                if (!check.equals(cuBinName)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            wsdlImplementativo.removeBinding(now.getQName());
        }
        m = wsdlImplementativo.getAllServices();
        for (Binding now : m.values()) {
            Map pts = now.getPorts();
            Iterator ports = pts.values().iterator();
            boolean delete = true;
            block8: while (ports.hasNext()) {
                Port cuPor = (Port)ports.next();
                String cuBinName = cuPor.getBinding().getPortType().getQName().getLocalPart();
                for (int i2 = 0; i2 < portTypes.length; ++i2) {
                    String check = portTypes[i2];
                    if (!check.equals(cuBinName)) continue;
                    delete = false;
                    continue block8;
                }
            }
            if (!delete) continue;
            wsdlImplementativo.removeService(now.getQName());
        }
        wsdlImplementativo.removeAllImports();
        wsdlImplementativo.addImport(logico);
        this.removeExtensibilityElements((WSDLElement)wsdlImplementativo.getTypes());
    }

    private void writeImplementativoErogatoreTo(File dir, boolean prettyPrint) throws WSDLException, IOException, org.openspcoop2.utils.wsdl.WSDLException {
        this.wsdlUtilities.writeWsdlTo((Definition)this.wsdlImplementativoErogatore, dir.getAbsolutePath() + File.separator + FOLDER_IMPLEMENTATIVI + File.separator + IMPLEMENTATIVO_EROGATORE_FILENAME, prettyPrint);
    }

    private void writeImplementativoFruitoreTo(File dir, boolean prettyPrint) throws WSDLException, IOException, org.openspcoop2.utils.wsdl.WSDLException {
        this.wsdlUtilities.writeWsdlTo((Definition)this.wsdlImplementativoFruitore, dir.getAbsolutePath() + File.separator + FOLDER_IMPLEMENTATIVI + File.separator + IMPLEMENTATIVO_FRUITORE_FILENAME, prettyPrint);
    }

    private void removeExtensibilityElements(WSDLElement ele) {
        List ext = ele.getExtensibilityElements();
        while (ext.size() > 0) {
            ele.removeExtensibilityElement((ExtensibilityElement)ext.get(0));
            ext = ele.getExtensibilityElements();
        }
    }

    private String[] merge(String[] a, String[] b) {
        int j;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        String[] c = new String[a.length + b.length];
        int i = 0;
        for (j = 0; j < a.length; ++j) {
            c[i] = a[j];
            ++i;
        }
        for (j = 0; j < b.length; ++j) {
            c[i] = b[j];
            ++i;
        }
        return c;
    }
}

