/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ValidazioneSemantica;
import org.openspcoop2.message.ValidatoreXSD;
import org.openspcoop2.utils.date.DateManager;

public class DriverRegistroServiziXML
extends BeanUtilities
implements IDriverRegistroServiziGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private IUnmarshallingContext uctx;
    private String registry_path;
    private RegistroServizi registro;
    private ValidatoreXSD validatoreRegistro = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;
    private boolean validazioneSemanticaDuranteModificaXML = false;
    private boolean verificaURI = false;
    private String[] tipiConnettori = null;
    private String[] tipiSoggetti = null;
    private String[] tipiServizi = null;

    public RegistroServizi getRegistroXML() {
        return this.registro;
    }

    public void parsingXMLRegistroServizi() throws DriverRegistroServiziException {
        FileInputStream fXML = null;
        try {
            if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                this.validatoreRegistro.valida(this.registry_path);
            } else {
                fXML = new FileInputStream(this.registry_path);
                this.validatoreRegistro.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception e) {}
            }
        }
        InputStreamReader iStream = null;
        FileInputStream fin = null;
        HttpURLConnection httpConn = null;
        if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
            try {
                URL url = new URL(this.registry_path);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = new InputStreamReader(httpConn.getInputStream());
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                fin = new FileInputStream(this.registry_path);
                iStream = new InputStreamReader(fin);
            }
            catch (FileNotFoundException e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.registry_path).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del file dove e' allocato il registro dei servizi: " + e.getMessage());
            }
        }
        try {
            this.registro = (RegistroServizi)this.uctx.unmarshalDocument((Reader)iStream, null);
        }
        catch (JiBXException e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception ef) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
        }
        try {
            if (fin != null) {
                fin.close();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream (file): " + e.getMessage());
        }
        try {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream (http): " + e.getMessage());
        }
    }

    public DriverRegistroServiziXML(String path, Logger alog) {
        this.log = alog == null ? Logger.getLogger(DriverRegistroServiziXML.class) : alog;
        if (path == null) {
            this.log.error((Object)"DriverRegistroServizi: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.registry_path = path;
        try {
            this.validatoreRegistro = new ValidatoreXSD(this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage()));
            return;
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            this.log.error((Object)("DriverRegistroServizi: Riscontrato errore durante la creazione del contesto di unmarshall  : \n\n" + e.getMessage()));
            this.create = false;
            return;
        }
        try {
            this.parsingXMLRegistroServizi();
        }
        catch (Exception e) {
            this.log.error((Object)("DriverRegistroServizi: " + e.getMessage()));
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshRegistroServiziXML() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML(true);
    }

    public void refreshRegistroServiziXML() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML(false);
    }

    private synchronized void refreshRegistroServiziXML(boolean refreshForzato) throws DriverRegistroServiziException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.registry_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLRegistroServizi();
            }
            catch (Exception e) {
                this.log.error((Object)("DriverRegistroServizi refreshError: " + e.getMessage()));
                throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: " + e.getMessage());
            }
            if (!this.registry_path.startsWith("http://") && !this.registry_path.startsWith("file://")) {
                this.log.warn((Object)"Reloaded registry context.");
            }
            if (this.validazioneSemanticaDuranteModificaXML) {
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(this.registro, this.verificaURI, this.tipiConnettori, this.tipiSoggetti, this.tipiServizi, this.log);
                try {
                    validazioneSemantica.validazioneSemantica(false);
                }
                catch (Exception e) {
                    this.log.error((Object)("DriverRegistroServizi refreshError(ValidazioneSemantica): " + e.getMessage()));
                    throw new DriverRegistroServiziException("DriverRegistroServizi refreshError(ValidazioneSemantica): " + e.getMessage());
                }
            }
        }
        if (this.registro == null) {
            this.log.error((Object)"DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
            throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
        }
    }

    public void abilitazioneValidazioneSemanticaDuranteModificaXML(boolean verificaURI, String[] tipiConnettori, String[] tipiSoggetti, String[] tipiServizi) {
        this.validazioneSemanticaDuranteModificaXML = true;
        this.verificaURI = verificaURI;
        this.tipiConnettori = tipiConnettori;
        this.tipiSoggetti = tipiSoggetti;
        this.tipiServizi = tipiServizi;
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo non presente");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (ac.getNome() == null || !ac.getNome().equals(idAccordo.getNome()) || (idAccordo.getVersione() == null ? ac.getVersione() != null : !idAccordo.getVersione().equals(ac.getVersione()))) continue;
            String uriAccordoCooperazione = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
            for (int j = 0; j < this.registro.sizeAccordoServizioParteComuneList(); ++j) {
                AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(j);
                if (as.getServizioComposto() == null || !uriAccordoCooperazione.equals(as.getServizioComposto().getAccordoCooperazione())) continue;
                ac.addUriServiziComposti(this.idAccordoFactory.getUriFromAccordo(as));
            }
            return ac;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non Trovato");
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
                String uriAC = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac));
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati");
            }
            return idAccordi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome accordo non presente");
        }
        IDSoggetto soggettoReferenteCheck = idAccordo.getSoggettoReferente();
        if (soggettoReferenteCheck != null) {
            if (soggettoReferenteCheck.getTipo() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Tipo soggetto referente non presente?");
            }
            if (soggettoReferenteCheck.getNome() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome soggetto referente non presente?");
            }
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeAccordoServizioParteComuneList(); ++i) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(i);
            if (as.getNome() == null || !as.getNome().equals(idAccordo.getNome()) || (soggettoReferenteCheck != null ? as.getSoggettoReferente() == null || !soggettoReferenteCheck.getTipo().equals(as.getSoggettoReferente().getTipo()) || !soggettoReferenteCheck.getNome().equals(as.getSoggettoReferente().getNome()) : as.getSoggettoReferente() != null)) continue;
            if (idAccordo.getVersione() == null ? as.getVersione() != null : !idAccordo.getVersione().equals(as.getVersione())) continue;
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo di Servizio non Trovato");
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < this.registro.sizeAccordoServizioParteComuneList(); ++i) {
                AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(i);
                String uriAS = this.idAccordoFactory.getUriFromAccordo(as);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizioParteComune](FiltroByMinDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizioParteComune](FiltroByMaxDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !as.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !as.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (as.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !as.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                    if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                        if (as.getServizioComposto() == null) continue;
                        IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(as.getServizioComposto().getAccordoCooperazione());
                        if (filtroRicerca.getIdAccordoCooperazione().getNome() != null && !idAC.getNome().equals(filtroRicerca.getIdAccordoCooperazione().getNome()) || filtroRicerca.getIdAccordoCooperazione().getVersione() != null && !idAC.getVersione().equals(filtroRicerca.getIdAccordoCooperazione().getVersione())) {
                            continue;
                        }
                    } else if (filtroRicerca.isServizioComposto() != null && (filtroRicerca.isServizioComposto() != false ? as.getServizioComposto() == null : as.getServizioComposto() != null)) continue;
                }
                idAccordi.add(this.idAccordoFactory.getIDAccordoFromAccordo(as));
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            return idAccordi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteComune error", e);
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (pd.getNome() == null || !pd.getNome().equals(nomePdD)) continue;
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata");
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<String> nomiPorteDiDominio = new Vector<String>();
            for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
                PortaDominio pd = this.registro.getPortaDominio(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPorteDiDominio.add(pd.getNome());
            }
            if (nomiPorteDiDominio.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
            }
            return nomiPorteDiDominio;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            Soggetto ss = this.registro.getSoggetto(i);
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoSP) || !ss.getNome().equals(codiceSP)) continue;
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non Trovato");
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
                Soggetto ss = this.registro.getSoggetto(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggetti](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggetti](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ss.getPortaDominio().equals(filtroRicerca.getNomePdd())) continue;
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            return idSoggetti;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdSoggetti error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = this.getSoggetto(idService.getSoggettoErogatore());
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(IDServizio)] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(IDServizio)] Parametri Non Validi");
        }
        for (int i = 0; i < soggetto.sizeAccordoServizioParteSpecificaList(); ++i) {
            AccordoServizioParteSpecifica asps = soggetto.getAccordoServizioParteSpecifica(i);
            Servizio ss = asps.getServizio();
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoServizio) || !ss.getNome().equals(servizio)) continue;
            ss.setTipoSoggettoErogatore(soggetto.getTipo());
            ss.setNomeSoggettoErogatore(soggetto.getNome());
            return asps;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica(IDServizio)] Servizio non Trovato");
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(idAccordo)] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(idAccordo)] Parametri Non Validi");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.registro.getSoggetto(i);
            for (int j = 0; j < soggetto.sizeAccordoServizioParteSpecificaList(); ++j) {
                AccordoServizioParteSpecifica asps = soggetto.getAccordoServizioParteSpecifica(j);
                IDAccordo idAccordoPS = this.idAccordoFactory.getIDAccordoFromAccordo(asps);
                if (!idAccordoPS.equals(idAccordo)) continue;
                return asps;
            }
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica(idAccordo)] Servizio non Trovato");
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = this.getSoggetto(idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizioParteComune);
        for (int i = 0; i < soggetto.sizeAccordoServizioParteSpecificaList(); ++i) {
            AccordoServizioParteSpecifica asps = soggetto.getAccordoServizioParteSpecifica(i);
            if (asps.getAccordoServizioParteComune() == null || !asps.getAccordoServizioParteComune().equals(uriAccordo) || !TipologiaServizio.CORRELATO.equals(asps.getServizio().getTipologiaServizio())) continue;
            asps.getServizio().setTipoSoggettoErogatore(soggetto.getTipo());
            asps.getServizio().setNomeSoggettoErogatore(soggetto.getNome());
            return asps;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio non Trovato");
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDAccordo> idAccordiServizi = new Vector<IDAccordo>();
            for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
                Soggetto ss = this.registro.getSoggetto(i);
                if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoErogatore() != null && !ss.getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !ss.getNome().equals(filtroRicerca.getNomeSoggettoErogatore()))) continue;
                for (int j = 0; j < ss.sizeAccordoServizioParteSpecificaList(); ++j) {
                    AccordoServizioParteSpecifica asps = ss.getAccordoServizioParteSpecifica(j);
                    Servizio serv = asps.getServizio();
                    if (filtroRicerca != null) {
                        if (filtroRicerca.getMinDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMinDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (asps.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                        }
                        if (filtroRicerca.getMaxDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMaxDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (asps.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                        }
                        if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome())) continue;
                        if (filtroRicerca.getIdAccordo() != null) {
                            String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                            if (!asps.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                        }
                    }
                    idAccordiServizi.add(this.idAccordoFactory.getIDAccordoFromAccordo(asps));
                }
            }
            if (idAccordiServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi non trovati");
            }
            return idAccordiServizi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
                Soggetto ss = this.registro.getSoggetto(i);
                if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoErogatore() != null && !ss.getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !ss.getNome().equals(filtroRicerca.getNomeSoggettoErogatore()))) continue;
                IDSoggetto idSoggetto = new IDSoggetto(ss.getTipo(), ss.getNome());
                for (int j = 0; j < ss.sizeAccordoServizioParteSpecificaList(); ++j) {
                    AccordoServizioParteSpecifica asps = ss.getAccordoServizioParteSpecifica(j);
                    Servizio serv = asps.getServizio();
                    if (filtroRicerca != null) {
                        if (filtroRicerca.getMinDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMinDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (asps.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                        }
                        if (filtroRicerca.getMaxDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMaxDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (asps.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                        }
                        if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome())) continue;
                        if (filtroRicerca.getIdAccordo() != null) {
                            String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                            if (!asps.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                        }
                    }
                    IDServizio idServ = new IDServizio(idSoggetto, serv.getTipo(), serv.getNome());
                    idServ.setUriAccordo(asps.getAccordoServizioParteComune());
                    idServ.setTipologiaServizio(serv.getTipologiaServizio().toString());
                    idServizi.add(idServ);
                }
            }
            if (idServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi non trovati");
            }
            return idServizi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshRegistroServiziXML();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    @Override
    public RegistroServizi getImmagineCompletaRegistroServizi() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML();
        return this.registro;
    }
}

