/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.web;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.utils.CleanerOpenSPCoop2Extensions;
import org.openspcoop2.utils.xml.JiBXUtils;

public class XMLLib {
    private String pathPrefix;
    private String urlPrefix;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private CleanerOpenSPCoop2Extensions cleanerOpenSPCoop2ExtensionsRegistry = new CleanerOpenSPCoop2Extensions();

    public XMLLib(String path, String url) throws DriverRegistroServiziException {
        if (path != null) {
            this.pathPrefix = !path.endsWith(File.separator) ? path + File.separator : path;
        }
        if (url != null) {
            this.urlPrefix = !url.endsWith("/") ? url + "/" : url;
        }
        if (path != null) {
            File dir;
            try {
                dir = new File(this.pathPrefix + "accordi");
                if (!dir.exists() && !dir.mkdir()) {
                    throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per gli accordi di servizio [" + this.pathPrefix + "accordi" + "]");
                }
            }
            catch (DriverRegistroServiziException e) {
                throw e;
            }
            catch (Exception io) {
                throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per gli accordi di servizio [" + this.pathPrefix + "accordi" + "]: " + io.getMessage());
            }
            try {
                dir = new File(this.pathPrefix + "accordi_cooperazione");
                if (!dir.exists() && !dir.mkdir()) {
                    throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per gli accordi di cooperazione [" + this.pathPrefix + "accordi_cooperazione" + "]");
                }
            }
            catch (DriverRegistroServiziException e) {
                throw e;
            }
            catch (Exception io) {
                throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per gli accordi di servizio [" + this.pathPrefix + "accordi" + "]: " + io.getMessage());
            }
            try {
                File dirPDD = new File(this.pathPrefix + "porte_di_dominio");
                if (!dirPDD.exists() && !dirPDD.mkdir()) {
                    throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per le porte di dominio [" + this.pathPrefix + "porte_di_dominio" + "]");
                }
            }
            catch (DriverRegistroServiziException e) {
                throw e;
            }
            catch (Exception io) {
                throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la creazione della directory per le porte di dominio [" + this.pathPrefix + "porte_di_dominio" + "]: " + io.getMessage());
            }
        }
    }

    public void generaFile(byte[] date, String fileName) throws DriverRegistroServiziException {
        FileOutputStream fos = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            fos = new FileOutputStream(fileName);
            fos.write(date);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante il salvataggio del file (" + fileName + "): " + e.getMessage(), e);
        }
    }

    public String getContenutoIndexServizi(String directoryServiziSoggetto) throws DriverRegistroServiziException {
        String indexServizi = directoryServiziSoggetto;
        if (!directoryServiziSoggetto.endsWith(File.separator)) {
            indexServizi = directoryServiziSoggetto + File.separator;
        }
        indexServizi = indexServizi + "servizi.index";
        BufferedReader bf = null;
        InputStreamReader fr = null;
        try {
            File f = new File(indexServizi);
            StringBuffer contenuto = new StringBuffer();
            if (f.exists()) {
                if (!f.isFile()) {
                    throw new Exception("Non e' un file regolare");
                }
                fr = new FileReader(f);
                bf = new BufferedReader(fr);
                char[] buffer = new char[1024];
                int byteLetti = -1;
                while ((byteLetti = fr.read(buffer)) != -1) {
                    contenuto.append(buffer, 0, byteLetti);
                }
            }
            if (contenuto.length() > 0) {
                return contenuto.toString();
            }
            return null;
        }
        catch (Exception e) {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la elaborazione del file di index (" + indexServizi + "): " + e.getMessage(), e);
        }
    }

    private void setContenutoIndexServizi(String directoryServiziSoggetto, String contenuto) throws DriverRegistroServiziException {
        String indexServizi = directoryServiziSoggetto;
        if (!directoryServiziSoggetto.endsWith(File.separator)) {
            indexServizi = directoryServiziSoggetto + File.separator;
        }
        indexServizi = indexServizi + "servizi.index";
        if (contenuto == null) {
            throw new DriverRegistroServiziException("Contenuto da inserire nell'indice dei servizi is null");
        }
        String content = null;
        content = !contenuto.startsWith("----------------------------------------------------------------------------------------------------\nFile di index dei servizi erogati da un soggetto.\n----------------------------------------------------------------------------------------------------\nLegenda: uriAccordo#tipoSoggetto/nomeSoggetto#tipoServizio/nomeServizio#indicazioneServizioCorrelato\n----------------------------------------------------------------------------------------------------\n\n") ? "----------------------------------------------------------------------------------------------------\nFile di index dei servizi erogati da un soggetto.\n----------------------------------------------------------------------------------------------------\nLegenda: uriAccordo#tipoSoggetto/nomeSoggetto#tipoServizio/nomeServizio#indicazioneServizioCorrelato\n----------------------------------------------------------------------------------------------------\n\n" + contenuto : contenuto;
        FileOutputStream fos = null;
        try {
            File f = new File(indexServizi);
            if (f.exists()) {
                f.delete();
            }
            fos = new FileOutputStream(f);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'impostazione del file di index (" + indexServizi + "): " + e.getMessage(), e);
        }
    }

    private void setContenutoIndexServizi(String directoryServiziSoggetto, IDServizio[] index) throws DriverRegistroServiziException {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < index.length; ++i) {
            bf.append(this.generaIndexServiziLine(index[i]));
        }
        this.setContenutoIndexServizi(directoryServiziSoggetto, bf.toString());
    }

    private String generaIndexServiziLine(IDServizio idS) throws DriverRegistroServiziException {
        if (idS.getUriAccordo() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] uri accordo is null");
        }
        if (idS.getTipoServizio() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] tipo Servizio is null");
        }
        if (idS.getServizio() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] nome Servizio is null");
        }
        if (idS.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] soggetto Erogatore is null");
        }
        if (idS.getSoggettoErogatore().getTipo() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] tipo soggetto Erogatore is null");
        }
        if (idS.getSoggettoErogatore().getNome() == null) {
            throw new DriverRegistroServiziException("[generaIndexServiziLine] nome soggetto Erogatore is null");
        }
        return idS.getUriAccordo() + "#" + idS.getSoggettoErogatore().getTipo() + "/" + idS.getSoggettoErogatore().getNome() + "#" + idS.getTipoServizio() + "/" + idS.getServizio() + "#" + "tipologiaServizio(" + idS.getTipologiaServizio() + ")" + "\n";
    }

    private boolean existsIndexServizi(String directoryServiziSoggetto) {
        String indexServizi = directoryServiziSoggetto;
        if (!directoryServiziSoggetto.endsWith(File.separator)) {
            indexServizi = directoryServiziSoggetto + File.separator;
        }
        indexServizi = indexServizi + "servizi.index";
        File f = new File(indexServizi);
        return f.exists();
    }

    private boolean isIndexServizi(File file) throws DriverRegistroServiziException {
        FileInputStream fin = null;
        ByteArrayOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            byte[] readB = new byte[1024];
            int letti = 0;
            bout = new ByteArrayOutputStream();
            while ((letti = fin.read(readB)) != -1) {
                bout.write(readB, 0, letti);
            }
            fin.close();
            return bout.size() > 0 && bout.toString() != null && bout.toString().startsWith("----------------------------------------------------------------------------------------------------\nFile di index dei servizi erogati da un soggetto.\n----------------------------------------------------------------------------------------------------\nLegenda: uriAccordo#tipoSoggetto/nomeSoggetto#tipoServizio/nomeServizio#indicazioneServizioCorrelato\n----------------------------------------------------------------------------------------------------\n\n");
        }
        catch (Exception e) {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante il check del file di index (" + file.getName() + "): " + e.getMessage(), e);
        }
    }

    private void deleteIndexServizi(String directoryServiziSoggetto) throws DriverRegistroServiziException {
        String indexServizi = directoryServiziSoggetto;
        if (!directoryServiziSoggetto.endsWith(File.separator)) {
            indexServizi = directoryServiziSoggetto + File.separator;
        }
        indexServizi = indexServizi + "servizi.index";
        try {
            File f = new File(indexServizi);
            if (f.exists() && !f.delete()) {
                throw new DriverRegistroServiziException("Eliminazione file di index [" + indexServizi + "] non riuscita");
            }
        }
        catch (DriverRegistroServiziException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'eliminazione del file di index (" + indexServizi + "): " + e.getMessage(), e);
        }
    }

    public static IDServizio[] mappingIndexServizi(String contenuto) throws DriverRegistroServiziException {
        XMLLib xmlLib = new XMLLib(null, null);
        return xmlLib.readIndexServizi(contenuto);
    }

    private IDServizio[] readIndexServizi(String contenuto) throws DriverRegistroServiziException {
        try {
            if (!contenuto.toString().startsWith("----------------------------------------------------------------------------------------------------\nFile di index dei servizi erogati da un soggetto.\n----------------------------------------------------------------------------------------------------\nLegenda: uriAccordo#tipoSoggetto/nomeSoggetto#tipoServizio/nomeServizio#indicazioneServizioCorrelato\n----------------------------------------------------------------------------------------------------\n\n")) {
                throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop");
            }
            String cont = contenuto.replace("----------------------------------------------------------------------------------------------------\nFile di index dei servizi erogati da un soggetto.\n----------------------------------------------------------------------------------------------------\nLegenda: uriAccordo#tipoSoggetto/nomeSoggetto#tipoServizio/nomeServizio#indicazioneServizioCorrelato\n----------------------------------------------------------------------------------------------------\n\n", "");
            StringTokenizer st = new StringTokenizer(cont, "\n");
            Vector<IDServizio> ids = new Vector<IDServizio>();
            while (st.hasMoreTokens()) {
                String line = null;
                try {
                    line = st.nextToken();
                }
                catch (Exception e) {
                    break;
                }
                byte condizioneUscita = 0;
                if (line != null && line.length() > 0 && line.getBytes()[0] == condizioneUscita) break;
                String[] splitLine = line.split("#");
                if (splitLine == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "]");
                }
                if (splitLine.length != 4) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "][lenght:" + splitLine.length + "]");
                }
                if (splitLine[0] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "][split[0]:" + splitLine[0] + "]");
                }
                if (splitLine[1] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "][split[1]:" + splitLine[1] + "]");
                }
                if (splitLine[2] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "][split[2]:" + splitLine[2] + "]");
                }
                if (splitLine[3] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') [" + line + "][split[3]:" + splitLine[3] + "]");
                }
                if (splitLine[1].indexOf("/") == -1) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') '/' [" + line + "][split[1]:" + splitLine[1] + "]");
                }
                if (splitLine[2].indexOf("/") == -1) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') '/' [" + line + "][split[2]:" + splitLine[2] + "]");
                }
                if (!splitLine[3].equals("tipologiaServizio(normale)") && !splitLine[3].equals("tipologiaServizio(correlato)")) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read line '#') 'tipologiaServizio' [" + line + "][split[3]:" + splitLine[3] + "]");
                }
                IDServizio idServ = new IDServizio();
                idServ.setUriAccordo(splitLine[0]);
                String[] splitSoggetto = splitLine[1].split("/");
                if (splitSoggetto == null || splitSoggetto.length != 2 || splitSoggetto[0] == null || splitSoggetto[1] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read soggetto ':') [" + splitLine[1] + "]");
                }
                idServ.setSoggettoErogatore(splitSoggetto[0], splitSoggetto[1]);
                String[] splitServizio = splitLine[2].split("/");
                if (splitServizio == null || splitServizio.length != 2 || splitServizio[0] == null || splitServizio[1] == null) {
                    throw new Exception("Non e' un file index servizi del registro dei servizi di OpenSPCoop (read servizio ':') [" + splitLine[2] + "]");
                }
                idServ.setTipoServizio(splitServizio[0]);
                idServ.setServizio(splitServizio[1]);
                if (splitLine[3].equals("tipologiaServizio(correlato)")) {
                    idServ.setTipologiaServizio(TipologiaServizio.CORRELATO.toString());
                } else {
                    idServ.setTipologiaServizio(TipologiaServizio.NORMALE.toString());
                }
                ids.add(idServ);
            }
            if (ids.size() == 0) {
                return null;
            }
            IDServizio[] rIDS = new IDServizio[1];
            return ids.toArray(rIDS);
        }
        catch (DriverRegistroServiziException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la lettura del file di index: " + e.getMessage(), e);
        }
    }

    private IDServizio[] readIndexServiziFromFile(String directoryServiziSoggetto) throws DriverRegistroServiziException {
        String indexServizi = directoryServiziSoggetto;
        if (!directoryServiziSoggetto.endsWith(File.separator)) {
            indexServizi = directoryServiziSoggetto + File.separator;
        }
        indexServizi = indexServizi + "servizi.index";
        BufferedReader bf = null;
        InputStreamReader fr = null;
        try {
            File f = new File(indexServizi);
            StringBuffer contenuto = new StringBuffer();
            if (f.exists()) {
                if (!f.isFile()) {
                    throw new Exception("Non e' un file regolare");
                }
                fr = new FileReader(f);
                bf = new BufferedReader(fr);
                char[] buffer = new char[1024];
                int letti = 0;
                while ((letti = fr.read(buffer)) != -1) {
                    contenuto.append(buffer, 0, letti);
                }
            } else {
                throw new DriverRegistroServiziException("File di index non esistente");
            }
            IDServizio[] iDServizioArray = this.readIndexServizi(contenuto.toString());
            return iDServizioArray;
        }
        catch (DriverRegistroServiziException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la lettura del file di index (" + indexServizi + "): " + e.getMessage(), e);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception er) {}
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (Exception er) {}
        }
    }

    public String mappingIDAccordoCooperazioneToFileName(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        return this.mappingUriToFileName_accordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordo));
    }

    public String mappingUriToFileName_accordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        String tmp = uriAccordo.replaceAll("/", "_");
        tmp = tmp.replaceAll(":", "_");
        return tmp;
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            fileNameAccordo = this.mappingIDAccordoCooperazioneToFileName(idAccordo);
            File fileXML = new File(this.pathPrefix + "accordi_cooperazione" + File.separator + fileNameAccordo + ".xml");
            File dirAllegati = new File(this.pathPrefix + "accordi_cooperazione" + File.separator + "allegati" + fileNameAccordo);
            File dirSpecificheSemiformali = new File(this.pathPrefix + "accordi_cooperazione" + File.separator + "specificheSemiformali" + fileNameAccordo);
            return fileXML.exists() && dirAllegati.exists() && dirSpecificheSemiformali.exists();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca (accordi_cooperazione)  [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void createAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            String url;
            String path;
            int i;
            File file;
            int i2;
            String[] files;
            fileNameAccordo = this.mappingIDAccordoCooperazioneToFileName(idAccordo);
            String accordoDir = this.pathPrefix + "accordi_cooperazione" + File.separator;
            String accordoOLD = fileNameAccordo;
            String accordoNEW = this.mappingUriToFileName_accordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromAccordo(accordo));
            if (!accordoOLD.equals(accordoNEW)) {
                File fileXML = new File(accordoDir + accordoOLD + ".xml");
                File dirAllegati = new File(accordoDir + "allegati" + accordoOLD);
                File dirSpecificheSemiformali = new File(accordoDir + "specificheSemiformali" + accordoOLD);
                if (!(fileXML.exists() && dirAllegati.exists() && dirSpecificheSemiformali.exists())) {
                    throw new DriverRegistroServiziException("Richiesta modifica di un accordo non registrato [" + accordoOLD + "]");
                }
                try {
                    if (!fileXML.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per l'accordo [" + fileXML.getAbsolutePath() + "] non riuscita");
                    }
                    String[] listAllegati = dirAllegati.list();
                    for (int j = 0; j < listAllegati.length; ++j) {
                        File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                        if (fileAllegati.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirAllegati.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                    String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
                    for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                        File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                        if (fileSpecificheSemiformali.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirSpecificheSemiformali.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Rinominazione della directory/file per l'accordo [" + accordoOLD + "] non riuscita: " + io.toString());
                }
            }
            File dirAllegati = new File(accordoDir + "allegati" + accordoNEW);
            File dirSpecificheSemiformali = new File(accordoDir + "specificheSemiformali" + accordoNEW);
            String prefixUrlAllegato = this.urlPrefix + "accordi_cooperazione" + "/" + "allegati" + accordoNEW + "/";
            String prefixUrlSpecificaSemiformale = this.urlPrefix + "accordi_cooperazione" + "/" + "specificheSemiformali" + accordoNEW + "/";
            if (!dirAllegati.exists()) {
                if (!dirAllegati.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per gli allegati dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                files = dirAllegati.list();
                if (files != null) {
                    for (i2 = 0; i2 < files.length; ++i2) {
                        file = new File(files[i2]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione allegato [" + files[i2] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheSemiformali.exists()) {
                if (!dirSpecificheSemiformali.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche semiformali dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                files = dirSpecificheSemiformali.list();
                if (files != null) {
                    for (i2 = 0; i2 < files.length; ++i2) {
                        file = new File(files[i2]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica semiformale [" + files[i2] + "] non riuscita");
                    }
                }
            }
            String fileXML = accordoDir + accordoNEW + ".xml";
            RegistroServizi registroXML = new RegistroServizi();
            for (i = 0; i < accordo.sizeAllegatoList(); ++i) {
                path = null;
                path = accordo.getAllegato(i).getFile().startsWith(prefixUrlAllegato) ? dirAllegati.getAbsolutePath() + File.separator + accordo.getAllegato(i).getFile().substring(prefixUrlAllegato.length()) : dirAllegati.getAbsolutePath() + File.separator + accordo.getAllegato(i).getFile();
                this.generaFile(accordo.getAllegato(i).getByteContenuto(), path);
                url = prefixUrlAllegato + accordo.getAllegato(i).getFile();
                accordo.getAllegato(i).setFile(url);
            }
            for (i = 0; i < accordo.sizeSpecificaSemiformaleList(); ++i) {
                path = null;
                path = accordo.getSpecificaSemiformale(i).getFile().startsWith(prefixUrlSpecificaSemiformale) ? dirSpecificheSemiformali.getAbsolutePath() + File.separator + accordo.getSpecificaSemiformale(i).getFile().substring(prefixUrlSpecificaSemiformale.length()) : dirSpecificheSemiformali.getAbsolutePath() + File.separator + accordo.getSpecificaSemiformale(i).getFile();
                this.generaFile(accordo.getSpecificaSemiformale(i).getByteContenuto(), path);
                url = prefixUrlSpecificaSemiformale + accordo.getSpecificaSemiformale(i).getFile();
                accordo.getSpecificaSemiformale(i).setFile(url);
            }
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(accordo);
            registroXML.addAccordoCooperazione(accordo);
            JiBXUtils.objToXml((String)fileXML, RegistroServizi.class, (Object)registroXML);
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'elaborazione XML dell'accordo  [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void deleteAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            fileNameAccordo = this.mappingIDAccordoCooperazioneToFileName(idAccordo);
            String fileXML = this.pathPrefix + "accordi_cooperazione" + File.separator + fileNameAccordo + ".xml";
            File dirAllegati = new File(this.pathPrefix + "accordi_cooperazione" + File.separator + "allegati" + fileNameAccordo);
            File dirSpecificheSemiformali = new File(this.pathPrefix + "accordi_cooperazione" + File.separator + "specificheSemiformali" + fileNameAccordo);
            File accordo = new File(fileXML);
            if (!accordo.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML dell'accordo [" + fileNameAccordo + "] non riuscta");
            }
            String[] listAllegati = dirAllegati.list();
            for (int j = 0; j < listAllegati.length; ++j) {
                File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                if (fileAllegati.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirAllegati.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
            String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
            for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                if (fileSpecificheSemiformali.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirSpecificheSemiformali.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLlib] Riscontrato errore durante l'eliminazione XML dell'accordo [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public AccordoCooperazione[] getAccordiCooperazione() throws DriverRegistroServiziException {
        AccordoCooperazione[] accordiRegistrati = null;
        try {
            int i;
            File dir = new File(this.pathPrefix + "accordi_cooperazione");
            if (!dir.exists()) {
                return null;
            }
            File[] accordi = dir.listFiles();
            int numAccordi = 0;
            if (accordi != null) {
                for (i = 0; i < accordi.length; ++i) {
                    if (!accordi[i].isFile()) continue;
                    ++numAccordi;
                }
            }
            if (numAccordi > 0) {
                accordiRegistrati = new AccordoCooperazione[numAccordi];
                int index = 0;
                for (i = 0; i < accordi.length; ++i) {
                    if (!accordi[i].isFile()) continue;
                    RegistroServizi r = (RegistroServizi)JiBXUtils.xmlToObj((String)accordi[i].getAbsolutePath(), RegistroServizi.class);
                    accordiRegistrati[index] = r.getAccordoCooperazione(0);
                    ++index;
                }
            }
            return accordiRegistrati;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca degli accordi di cooperazione: " + e.getMessage(), e);
        }
    }

    public String mappingIDAccordoToFileName(IDAccordo idAccordo) throws DriverRegistroServiziException {
        return this.mappingUriToFileName(this.idAccordoFactory.getUriFromIDAccordo(idAccordo));
    }

    public String mappingUriToFileName(String uriAccordo) throws DriverRegistroServiziException {
        String tmp = uriAccordo.replaceAll("/", "_");
        tmp = tmp.replaceAll(":", "_");
        return tmp;
    }

    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            fileNameAccordo = this.mappingIDAccordoToFileName(idAccordo);
            File fileXML = new File(this.pathPrefix + "accordi" + File.separator + fileNameAccordo + ".xml");
            File dirWSDL = new File(this.pathPrefix + "accordi" + File.separator + "wsdl" + fileNameAccordo);
            File dirSpecificheConversazioni = new File(this.pathPrefix + "accordi" + File.separator + "specificheConversazioni" + fileNameAccordo);
            File dirAllegati = new File(this.pathPrefix + "accordi" + File.separator + "allegati" + fileNameAccordo);
            File dirSpecificheSemiformali = new File(this.pathPrefix + "accordi" + File.separator + "specificheSemiformali" + fileNameAccordo);
            return fileXML.exists() && dirWSDL.exists() && dirSpecificheConversazioni.exists() && dirAllegati.exists() && dirSpecificheSemiformali.exists();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca (accordi)  [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void createAccordoServizioParteComune(IDAccordo idAccordo, AccordoServizioParteComune accordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            String url;
            String path;
            int i;
            String url2;
            String path2;
            File file;
            fileNameAccordo = this.mappingIDAccordoToFileName(idAccordo);
            String accordoDir = this.pathPrefix + "accordi" + File.separator;
            String accordoOLD = fileNameAccordo;
            String accordoNEW = this.mappingUriToFileName(this.idAccordoFactory.getUriFromAccordo(accordo));
            if (!accordoOLD.equals(accordoNEW)) {
                File fileXML = new File(accordoDir + accordoOLD + ".xml");
                File dirWSDL = new File(accordoDir + "wsdl" + accordoOLD);
                File dirSpecificheConversazioni = new File(accordoDir + "specificheConversazioni" + accordoOLD);
                File dirAllegati = new File(accordoDir + "allegati" + accordoOLD);
                File dirSpecificheSemiformali = new File(accordoDir + "specificheSemiformali" + accordoOLD);
                File dirSpecificheCoordinamento = new File(accordoDir + "specificheCoordinamento" + accordoOLD);
                if (!(fileXML.exists() && dirWSDL.exists() && dirSpecificheConversazioni.exists() && dirAllegati.exists() && dirSpecificheSemiformali.exists())) {
                    throw new DriverRegistroServiziException("Richiesta modifica di un accordo non registrato [" + accordoOLD + "]");
                }
                try {
                    if (!fileXML.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per l'accordo [" + fileXML.getAbsolutePath() + "] non riuscita");
                    }
                    String[] listWSDL = dirWSDL.list();
                    for (int j = 0; j < listWSDL.length; ++j) {
                        File fileWSDL = new File(dirWSDL.getAbsolutePath() + File.separator + listWSDL[j]);
                        if (fileWSDL.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileWSDL.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirWSDL.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per i WSDL dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                    String[] listSpecificheConversazione = dirSpecificheConversazioni.list();
                    for (int j = 0; j < listSpecificheConversazione.length; ++j) {
                        File fileSpecificaConversazione = new File(dirSpecificheConversazioni.getAbsolutePath() + File.separator + listSpecificheConversazione[j]);
                        if (fileSpecificaConversazione.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione del file di specifica conversazione [" + fileSpecificaConversazione.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirSpecificheConversazioni.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche di conversazione dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                    String[] listAllegati = dirAllegati.list();
                    for (int j = 0; j < listAllegati.length; ++j) {
                        File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                        if (fileAllegati.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirAllegati.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                    String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
                    for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                        File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                        if (fileSpecificheSemiformali.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (!dirSpecificheSemiformali.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + accordoOLD + "] non riuscita");
                    }
                    if (dirSpecificheCoordinamento.exists()) {
                        String[] listSpecificheCoordinamento = dirSpecificheCoordinamento.list();
                        for (int j = 0; j < listSpecificheCoordinamento.length; ++j) {
                            File fileSpecificheCoordinamento = new File(dirSpecificheCoordinamento.getAbsolutePath() + File.separator + listSpecificheCoordinamento[j]);
                            if (fileSpecificheCoordinamento.delete()) continue;
                            throw new DriverRegistroServiziException("Eliminazione della specifica coordinamento [" + fileSpecificheCoordinamento.getAbsolutePath() + "] per l'accordo [" + accordoOLD + "] non riuscita");
                        }
                        if (!dirSpecificheCoordinamento.delete()) {
                            throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche coordinamento dell'accordo [" + accordoOLD + "] non riuscita");
                        }
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Rinominazione della directory/file per l'accordo [" + accordoOLD + "] non riuscita: " + io.toString());
                }
            }
            File dirWSDL = new File(accordoDir + "wsdl" + accordoNEW);
            File dirSpecificaConversazioni = new File(accordoDir + "specificheConversazioni" + accordoNEW);
            File dirAllegati = new File(accordoDir + "allegati" + accordoNEW);
            File dirSpecificheSemiformali = new File(accordoDir + "specificheSemiformali" + accordoNEW);
            File dirSpecificheCoordinamento = new File(accordoDir + "specificheCoordinamento" + accordoNEW);
            String prefixUrlWSDL = this.urlPrefix + "accordi" + "/" + "wsdl" + accordoNEW + "/";
            String prefixUrlSpecificaConversazione = this.urlPrefix + "accordi" + "/" + "specificheConversazioni" + accordoNEW + "/";
            String prefixUrlAllegato = this.urlPrefix + "accordi" + "/" + "allegati" + accordoNEW + "/";
            String prefixUrlSpecificaSemiformale = this.urlPrefix + "accordi" + "/" + "specificheSemiformali" + accordoNEW + "/";
            String prefixUrlSpecificaCoordinamento = this.urlPrefix + "accordi" + "/" + "specificheCoordinamento" + accordoNEW + "/";
            if (!dirWSDL.exists()) {
                if (!dirWSDL.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per i WSDL dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                String definitorioPath = dirWSDL.getAbsolutePath() + File.separator + "definitorio.xsd";
                File definitorioWSDL = new File(definitorioPath);
                if (definitorioWSDL.exists() && !definitorioWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL definitorio [" + definitorioPath + "] non riuscita");
                }
                String concettualePath = dirWSDL.getAbsolutePath() + File.separator + "concettuale.wsdl";
                File concettualeWSDL = new File(concettualePath);
                if (concettualeWSDL.exists() && !concettualeWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL concettuale [" + concettualePath + "] non riuscita");
                }
                String logicoErogatorePath = dirWSDL.getAbsolutePath() + File.separator + "logicoErogatore.wsdl";
                File logicoErogatoreWSDL = new File(logicoErogatorePath);
                if (logicoErogatoreWSDL.exists() && !logicoErogatoreWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL logico Erogatore [" + logicoErogatorePath + "] non riuscita");
                }
                String logicoFruitorePath = dirWSDL.getAbsolutePath() + File.separator + "logicoFruitore.wsdl";
                File logicoFruitoreWSDL = new File(logicoFruitorePath);
                if (logicoFruitoreWSDL.exists() && !logicoFruitoreWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL logico Fruitore [" + logicoFruitorePath + "] non riuscita");
                }
            }
            if (!dirSpecificaConversazioni.exists()) {
                if (!dirSpecificaConversazioni.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche delle conversazioni dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                String concettualePath = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneConcettuale.xml";
                File concettuale = new File(concettualePath);
                if (concettuale.exists() && !concettuale.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione specifica conversazione concettuale [" + concettualePath + "] non riuscita");
                }
                String erogatorePath = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneErogatore.xml";
                File erogatore = new File(erogatorePath);
                if (erogatore.exists() && !erogatore.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione specifica conversazione erogatore [" + erogatorePath + "] non riuscita");
                }
                String fruitorePath = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneFruitore.xml";
                File fruitore = new File(fruitorePath);
                if (fruitore.exists() && !fruitore.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione specifica conversazione fruitore [" + fruitorePath + "] non riuscita");
                }
            }
            if (!dirAllegati.exists()) {
                if (!dirAllegati.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per gli allegati dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                String[] files = dirAllegati.list();
                if (files != null) {
                    for (int i2 = 0; i2 < files.length; ++i2) {
                        file = new File(files[i2]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione allegato [" + files[i2] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheSemiformali.exists()) {
                if (!dirSpecificheSemiformali.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche semiformali dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                String[] files = dirSpecificheSemiformali.list();
                if (files != null) {
                    for (int i3 = 0; i3 < files.length; ++i3) {
                        file = new File(files[i3]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica semiformale [" + files[i3] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheCoordinamento.exists()) {
                if (accordo.getServizioComposto() != null && !dirSpecificheCoordinamento.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche di coordinamento dell'accordo [" + accordoNEW + "] non riuscita");
                }
            } else {
                String[] files = dirSpecificheCoordinamento.list();
                if (files != null) {
                    for (int i4 = 0; i4 < files.length; ++i4) {
                        file = new File(files[i4]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica di coordinamento [" + files[i4] + "] non riuscita");
                    }
                }
            }
            String fileXML = accordoDir + accordoNEW + ".xml";
            RegistroServizi registroXML = new RegistroServizi();
            if (accordo.getByteWsdlDefinitorio() == null) {
                accordo.setWsdlDefinitorio("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "definitorio.xsd";
                this.generaFile(accordo.getByteWsdlDefinitorio(), path2);
                url2 = prefixUrlWSDL + "definitorio.xsd";
                accordo.setWsdlDefinitorio(url2);
            }
            if (accordo.getByteWsdlConcettuale() == null) {
                accordo.setWsdlConcettuale("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "concettuale.wsdl";
                this.generaFile(accordo.getByteWsdlConcettuale(), path2);
                url2 = prefixUrlWSDL + "concettuale.wsdl";
                accordo.setWsdlConcettuale(url2);
            }
            if (accordo.getByteWsdlLogicoErogatore() == null) {
                accordo.setWsdlLogicoErogatore("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "logicoErogatore.wsdl";
                this.generaFile(accordo.getByteWsdlLogicoErogatore(), path2);
                url2 = prefixUrlWSDL + "logicoErogatore.wsdl";
                accordo.setWsdlLogicoErogatore(url2);
            }
            if (accordo.getByteWsdlLogicoFruitore() == null) {
                accordo.setWsdlLogicoFruitore("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "logicoFruitore.wsdl";
                this.generaFile(accordo.getByteWsdlLogicoFruitore(), path2);
                url2 = prefixUrlWSDL + "logicoFruitore.wsdl";
                accordo.setWsdlLogicoFruitore(url2);
            }
            if (accordo.getByteSpecificaConversazioneConcettuale() == null) {
                accordo.setSpecificaConversazioneConcettuale("http://undefined");
            } else {
                path2 = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneConcettuale.xml";
                this.generaFile(accordo.getByteSpecificaConversazioneConcettuale(), path2);
                url2 = prefixUrlSpecificaConversazione + "specificaConversazioneConcettuale.xml";
                accordo.setSpecificaConversazioneConcettuale(url2);
            }
            if (accordo.getByteSpecificaConversazioneErogatore() == null) {
                accordo.setSpecificaConversazioneErogatore("http://undefined");
            } else {
                path2 = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneErogatore.xml";
                this.generaFile(accordo.getByteSpecificaConversazioneErogatore(), path2);
                url2 = prefixUrlSpecificaConversazione + "specificaConversazioneErogatore.xml";
                accordo.setSpecificaConversazioneErogatore(url2);
            }
            if (accordo.getByteSpecificaConversazioneFruitore() == null) {
                accordo.setSpecificaConversazioneFruitore("http://undefined");
            } else {
                path2 = dirSpecificaConversazioni.getAbsolutePath() + File.separator + "specificaConversazioneFruitore.xml";
                this.generaFile(accordo.getByteSpecificaConversazioneFruitore(), path2);
                url2 = prefixUrlSpecificaConversazione + "specificaConversazioneFruitore.xml";
                accordo.setSpecificaConversazioneFruitore(url2);
            }
            for (i = 0; i < accordo.sizeAllegatoList(); ++i) {
                path = null;
                path = accordo.getAllegato(i).getFile().startsWith(prefixUrlAllegato) ? dirAllegati.getAbsolutePath() + File.separator + accordo.getAllegato(i).getFile().substring(prefixUrlAllegato.length()) : dirAllegati.getAbsolutePath() + File.separator + accordo.getAllegato(i).getFile();
                this.generaFile(accordo.getAllegato(i).getByteContenuto(), path);
                url = prefixUrlAllegato + accordo.getAllegato(i).getFile();
                accordo.getAllegato(i).setFile(url);
            }
            for (i = 0; i < accordo.sizeSpecificaSemiformaleList(); ++i) {
                path = null;
                path = accordo.getSpecificaSemiformale(i).getFile().startsWith(prefixUrlSpecificaSemiformale) ? dirSpecificheSemiformali.getAbsolutePath() + File.separator + accordo.getSpecificaSemiformale(i).getFile().substring(prefixUrlSpecificaSemiformale.length()) : dirSpecificheSemiformali.getAbsolutePath() + File.separator + accordo.getSpecificaSemiformale(i).getFile();
                this.generaFile(accordo.getSpecificaSemiformale(i).getByteContenuto(), path);
                url = prefixUrlSpecificaSemiformale + accordo.getSpecificaSemiformale(i).getFile();
                accordo.getSpecificaSemiformale(i).setFile(url);
            }
            if (accordo.getServizioComposto() != null) {
                for (i = 0; i < accordo.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    path = null;
                    path = accordo.getServizioComposto().getSpecificaCoordinamento(i).getFile().startsWith(prefixUrlSpecificaCoordinamento) ? dirSpecificheCoordinamento.getAbsolutePath() + File.separator + accordo.getServizioComposto().getSpecificaCoordinamento(i).getFile().substring(prefixUrlSpecificaCoordinamento.length()) : dirSpecificheCoordinamento.getAbsolutePath() + File.separator + accordo.getServizioComposto().getSpecificaCoordinamento(i).getFile();
                    this.generaFile(accordo.getServizioComposto().getSpecificaCoordinamento(i).getByteContenuto(), path);
                    url = prefixUrlSpecificaCoordinamento + accordo.getServizioComposto().getSpecificaCoordinamento(i).getFile();
                    accordo.getServizioComposto().getSpecificaCoordinamento(i).setFile(url);
                }
            }
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(accordo);
            registroXML.addAccordoServizioParteComune(accordo);
            JiBXUtils.objToXml((String)fileXML, RegistroServizi.class, (Object)registroXML);
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'elaborazione XML dell'accordo  [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public void deleteAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        String fileNameAccordo = null;
        try {
            fileNameAccordo = this.mappingIDAccordoToFileName(idAccordo);
            String fileXML = this.pathPrefix + "accordi" + File.separator + fileNameAccordo + ".xml";
            File dirWSDL = new File(this.pathPrefix + "accordi" + File.separator + "wsdl" + fileNameAccordo);
            File dirSpecificheConversazione = new File(this.pathPrefix + "accordi" + File.separator + "specificheConversazioni" + fileNameAccordo);
            File dirAllegati = new File(this.pathPrefix + "accordi" + File.separator + "allegati" + fileNameAccordo);
            File dirSpecificheSemiformali = new File(this.pathPrefix + "accordi" + File.separator + "specificheSemiformali" + fileNameAccordo);
            File dirSpecificheCoordinamento = new File(this.pathPrefix + "accordi" + File.separator + "specificheCoordinamento" + fileNameAccordo);
            File accordo = new File(fileXML);
            if (!accordo.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML dell'accordo [" + fileNameAccordo + "] non riuscta");
            }
            String[] listWSDL = dirWSDL.list();
            for (int j = 0; j < listWSDL.length; ++j) {
                File fileWSDL = new File(dirWSDL.getAbsolutePath() + File.separator + listWSDL[j]);
                if (fileWSDL.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileWSDL.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirWSDL.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per i WSDL dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
            String[] listSpecificheConversazione = dirSpecificheConversazione.list();
            for (int j = 0; j < listSpecificheConversazione.length; ++j) {
                File fileSpecificaConversazione = new File(dirSpecificheConversazione.getAbsolutePath() + File.separator + listSpecificheConversazione[j]);
                if (fileSpecificaConversazione.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione del file specifica di conversazione [" + fileSpecificaConversazione.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirSpecificheConversazione.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche di conversazione dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
            String[] listAllegati = dirAllegati.list();
            for (int j = 0; j < listAllegati.length; ++j) {
                File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                if (fileAllegati.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirAllegati.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
            String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
            for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                if (fileSpecificheSemiformali.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (!dirSpecificheSemiformali.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + fileNameAccordo + "] non riuscita");
            }
            if (dirSpecificheCoordinamento.exists()) {
                String[] listSpecificheCoordinamento = dirSpecificheCoordinamento.list();
                for (int j = 0; j < listSpecificheCoordinamento.length; ++j) {
                    File fileSpecificheCoordinamento = new File(dirSpecificheCoordinamento.getAbsolutePath() + File.separator + listSpecificheCoordinamento[j]);
                    if (fileSpecificheCoordinamento.delete()) continue;
                    throw new DriverRegistroServiziException("Eliminazione della specifica coordinamento [" + fileSpecificheCoordinamento.getAbsolutePath() + "] per l'accordo [" + fileNameAccordo + "] non riuscita");
                }
                if (!dirSpecificheCoordinamento.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche coordinamento dell'accordo [" + fileNameAccordo + "] non riuscita");
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLlib] Riscontrato errore durante l'eliminazione XML dell'accordo [" + fileNameAccordo + "]: " + e.getMessage(), e);
        }
    }

    public AccordoServizioParteComune[] getAccordiServizioParteComune() throws DriverRegistroServiziException {
        AccordoServizioParteComune[] accordiRegistrati = null;
        try {
            int i;
            File dir = new File(this.pathPrefix + "accordi");
            if (!dir.exists()) {
                return null;
            }
            File[] accordi = dir.listFiles();
            int numAccordi = 0;
            if (accordi != null) {
                for (i = 0; i < accordi.length; ++i) {
                    if (!accordi[i].isFile()) continue;
                    ++numAccordi;
                }
            }
            if (numAccordi > 0) {
                accordiRegistrati = new AccordoServizioParteComune[numAccordi];
                int index = 0;
                for (i = 0; i < accordi.length; ++i) {
                    if (!accordi[i].isFile()) continue;
                    RegistroServizi r = (RegistroServizi)JiBXUtils.xmlToObj((String)accordi[i].getAbsolutePath(), RegistroServizi.class);
                    accordiRegistrati[index] = r.getAccordoServizioParteComune(0);
                    ++index;
                }
            }
            return accordiRegistrati;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca degli accordi di servizio: " + e.getMessage(), e);
        }
    }

    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        try {
            File fileXML = new File(this.pathPrefix + "porte_di_dominio" + File.separator + nome + ".xml");
            return fileXML.exists();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca (porte_di_dominio)  [" + nome + "]: " + e.getMessage(), e);
        }
    }

    public void createPortaDominio(String nome, PortaDominio pdd) throws DriverRegistroServiziException {
        try {
            String pddDir = this.pathPrefix + "porte_di_dominio" + File.separator;
            String fileXML = pddDir + nome + ".xml";
            File fileXMLF = new File(fileXML);
            if (fileXMLF.exists()) {
                try {
                    if (!fileXMLF.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per la porta di dominio [" + fileXMLF.getAbsolutePath() + "] non riuscita");
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per la porta di dominio [" + nome + "] non riuscita: " + io.toString());
                }
            }
            RegistroServizi registroXML = new RegistroServizi();
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(pdd);
            registroXML.addPortaDominio(pdd);
            JiBXUtils.objToXml((String)fileXML, RegistroServizi.class, (Object)registroXML);
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'elaborazione XML della porta di dominio  [" + nome + "]: " + e.getMessage(), e);
        }
    }

    public void deletePortaDominio(String nome) throws DriverRegistroServiziException {
        try {
            String fileXML = this.pathPrefix + "porte_di_dominio" + File.separator + nome + ".xml";
            File pdd = new File(fileXML);
            if (!pdd.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML della porta di dominio [" + nome + "] non riuscta");
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLlib] Riscontrato errore durante l'eliminazione XML della porta di dominio [" + nome + "]: " + e.getMessage(), e);
        }
    }

    public PortaDominio[] getPorteDominio() throws DriverRegistroServiziException {
        PortaDominio[] pddRegistrate = null;
        try {
            int i;
            File dir = new File(this.pathPrefix + "porte_di_dominio");
            if (!dir.exists()) {
                return null;
            }
            File[] porteDiDominio = dir.listFiles();
            int numPorteDiDominio = 0;
            if (porteDiDominio != null) {
                for (i = 0; i < porteDiDominio.length; ++i) {
                    if (!porteDiDominio[i].isFile()) continue;
                    ++numPorteDiDominio;
                }
            }
            if (numPorteDiDominio > 0) {
                pddRegistrate = new PortaDominio[numPorteDiDominio];
                int index = 0;
                for (i = 0; i < porteDiDominio.length; ++i) {
                    if (!porteDiDominio[i].isFile()) continue;
                    RegistroServizi r = (RegistroServizi)JiBXUtils.xmlToObj((String)porteDiDominio[i].getAbsolutePath(), RegistroServizi.class);
                    pddRegistrate[index] = r.getPortaDominio(0);
                    ++index;
                }
            }
            return pddRegistrate;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca delle porte di dominio: " + e.getMessage(), e);
        }
    }

    public boolean existsSoggetto(IDSoggetto idSogg) throws DriverRegistroServiziException {
        if (idSogg == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggetto = idSogg.getTipo() + idSogg.getNome();
        try {
            File dirSoggetto = new File(this.pathPrefix + idSoggetto);
            return dirSoggetto.exists();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca del soggetto  [" + idSoggetto + "]: " + e.getMessage(), e);
        }
    }

    public void createSoggetto(IDSoggetto idSogg, Soggetto soggetto) throws DriverRegistroServiziException {
        if (idSogg == null || soggetto == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggettoOLD = idSogg.getTipo() + idSogg.getNome();
        String idSoggettoNEW = soggetto.getTipo() + soggetto.getNome();
        try {
            String dirSoggetto;
            String serviceDir;
            File dirS;
            File dir;
            if (idSoggettoOLD.equals(idSoggettoNEW)) {
                dir = new File(this.pathPrefix + idSoggettoNEW);
                if (!dir.exists()) {
                    try {
                        if (!dir.mkdir()) {
                            throw new DriverRegistroServiziException("Creazione della directory per il soggetto [" + dir.getAbsolutePath() + "] non riuscita");
                        }
                    }
                    catch (Exception io) {
                        throw new DriverRegistroServiziException("Creazione della directory per il soggetto [" + dir.getAbsolutePath() + "] non riuscita: " + io.toString());
                    }
                }
            } else {
                dir = new File(this.pathPrefix + idSoggettoOLD);
                if (!dir.exists()) {
                    throw new DriverRegistroServiziException("Modifica di un soggetto non registrato [" + dir.getAbsolutePath() + "] non riuscita");
                }
                File newdir = new File(this.pathPrefix + idSoggettoNEW);
                try {
                    if (!dir.renameTo(newdir)) {
                        throw new DriverRegistroServiziException("Rinominazione della directory per il soggetto [" + dir.getAbsolutePath() + "] in [" + newdir.getAbsolutePath() + "] non riuscita");
                    }
                    File oldXML = new File(this.pathPrefix + idSoggettoNEW + File.separator + idSoggettoOLD + ".xml");
                    if (!oldXML.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per il soggetto [" + oldXML.getAbsolutePath() + "] non riuscita");
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Rinominazione della directory per il soggetto [" + dir.getAbsolutePath() + "] in [" + newdir.getAbsolutePath() + "] non riuscita: " + io.toString());
                }
            }
            if (!(dirS = new File(serviceDir = (dirSoggetto = this.pathPrefix + idSoggettoNEW + File.separator) + "servizi")).exists()) {
                try {
                    if (!dirS.mkdir()) {
                        throw new DriverRegistroServiziException("Creazione della directory per i servizi del soggetto [" + dirS.getAbsolutePath() + "] non riuscita");
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Creazione della directory per i servizi del soggetto [" + dirS.getAbsolutePath() + "] non riuscita: " + io.toString());
                }
            }
            String fileXML = dirSoggetto + idSoggettoNEW + ".xml";
            RegistroServizi registroXML = new RegistroServizi();
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(soggetto);
            registroXML.addSoggetto(soggetto);
            JiBXUtils.objToXml((String)fileXML, RegistroServizi.class, (Object)registroXML);
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'elaborazione XML del soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    public void deleteSoggetto(IDSoggetto idSogg) throws DriverRegistroServiziException {
        if (idSogg == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggetto = idSogg.getTipo() + idSogg.getNome();
        try {
            String dirSoggetto = this.pathPrefix + idSoggetto + File.separator;
            File dirS = new File(dirSoggetto + "servizi");
            File[] dirSserv = dirS.listFiles();
            for (int i = 0; i < dirSserv.length; ++i) {
                if (dirSserv[i].delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione XML del soggetto [" + idSoggetto + "] (eliminazione definizione servizio [" + dirSserv[i].getAbsolutePath() + "]) non riuscita");
            }
            if (!dirS.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML del soggetto [" + idSoggetto + "] (eliminazione directory servizi [" + dirS.getAbsolutePath() + "]) non riuscita");
            }
            File defSoggetto = new File(dirSoggetto + idSoggetto + ".xml");
            if (!defSoggetto.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML del soggetto [" + idSoggetto + "] (eliminazione xml soggetto [" + defSoggetto.getAbsolutePath() + "]) non riuscita");
            }
            File dir = new File(this.pathPrefix + idSoggetto);
            if (!dir.delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML del soggetto [" + idSoggetto + "] (eliminazione directory soggetto [" + dir.getAbsolutePath() + "]) non riuscita");
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'eliminazione XML del soggetto [" + idSoggetto + "]: " + e.getMessage(), e);
        }
    }

    public Soggetto[] getSoggetti() throws DriverRegistroServiziException {
        Soggetto[] soggettiRegistrati = null;
        try {
            int i;
            File dir = new File(this.pathPrefix);
            if (!dir.exists()) {
                return null;
            }
            File[] soggetti = dir.listFiles();
            int numSoggetti = 0;
            if (soggetti != null) {
                for (i = 0; i < soggetti.length; ++i) {
                    if (!soggetti[i].isDirectory() || "accordi".equalsIgnoreCase(soggetti[i].getName()) || "accordi_cooperazione".equalsIgnoreCase(soggetti[i].getName()) || "porte_di_dominio".equalsIgnoreCase(soggetti[i].getName())) continue;
                    ++numSoggetti;
                }
            }
            if (numSoggetti > 0) {
                soggettiRegistrati = new Soggetto[numSoggetti];
                int index = 0;
                block3: for (i = 0; i < soggetti.length; ++i) {
                    if (!soggetti[i].isDirectory() || "accordi".equalsIgnoreCase(soggetti[i].getName()) || "accordi_cooperazione".equalsIgnoreCase(soggetti[i].getName()) || "porte_di_dominio".equalsIgnoreCase(soggetti[i].getName())) continue;
                    File[] fs = soggetti[i].listFiles();
                    for (int j = 0; j < fs.length; ++j) {
                        if (!fs[j].isFile()) continue;
                        RegistroServizi r = (RegistroServizi)JiBXUtils.xmlToObj((String)fs[j].getAbsolutePath(), RegistroServizi.class);
                        soggettiRegistrati[index] = r.getSoggetto(0);
                        ++index;
                        continue block3;
                    }
                }
            }
            return soggettiRegistrati;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca dei soggetti: " + e.getMessage(), e);
        }
    }

    public boolean existsAccordoServizioParteSpecifica(IDServizio idServ) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggetto = idServ.getSoggettoErogatore().getTipo() + idServ.getSoggettoErogatore().getNome();
        String idServizio = idServ.getTipoServizio() + idServ.getServizio();
        try {
            File definizioneXML = new File(this.pathPrefix + idSoggetto + File.separator + "servizi" + File.separator + idServizio + ".xml");
            File dirWSDL = new File(this.pathPrefix + idSoggetto + File.separator + "servizi" + File.separator + "wsdl" + idServizio);
            return definizioneXML.exists() && dirWSDL.exists();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca del servizio [" + idServizio + "]: " + e.getMessage(), e);
        }
    }

    public void createAccordoServizioParteSpecifica(IDServizio idServ, AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getSoggettoErogatore() == null || asps == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggetto = idServ.getSoggettoErogatore().getTipo() + idServ.getSoggettoErogatore().getNome();
        String idServizioOLD = idServ.getTipoServizio() + idServ.getServizio();
        Servizio servizio = asps.getServizio();
        String idServizioNEW = servizio.getTipo() + servizio.getNome();
        String dirSoggetto = this.pathPrefix + idSoggetto + File.separator;
        String dirServiziSoggetto = dirSoggetto + "servizi" + File.separator;
        try {
            String url;
            String path;
            int i;
            String url2;
            String path2;
            File file;
            String[] files;
            Vector<IDServizio> nID = new Vector<IDServizio>();
            if (this.existsIndexServizi(dirServiziSoggetto)) {
                IDServizio[] oldImage = this.readIndexServiziFromFile(dirServiziSoggetto);
                for (int i2 = 0; i2 < oldImage.length; ++i2) {
                    if (oldImage[i2].getTipoServizio().equals(idServ.getTipoServizio()) && oldImage[i2].getServizio().equals(idServ.getServizio())) continue;
                    nID.add(oldImage[i2]);
                }
            }
            if (!idServizioOLD.equals(idServizioNEW)) {
                File definizioneXML = new File(dirServiziSoggetto + idServizioOLD + ".xml");
                File dirWSDL = new File(dirServiziSoggetto + "wsdl" + idServizioOLD);
                File dirAllegati = new File(dirServiziSoggetto + "allegati" + idServizioOLD);
                File dirSpecificheSemiformali = new File(dirServiziSoggetto + "specificheSemiformali" + idServizioOLD);
                File dirSpecificheSicurezza = new File(dirServiziSoggetto + "specificheSicurezza" + idServizioOLD);
                File dirSpecificheLivelliServizio = new File(dirServiziSoggetto + "specificheLivelliServizio" + idServizioOLD);
                if (!(definizioneXML.exists() && dirWSDL.exists() && dirAllegati.exists() && dirSpecificheSemiformali.exists() && dirSpecificheSicurezza.exists() && dirSpecificheLivelliServizio.exists())) {
                    throw new DriverRegistroServiziException("Modifica di un servizio non registrato [" + idServizioOLD + "] non riuscita");
                }
                try {
                    if (!definizioneXML.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della vecchia definizione per il servizio [" + definizioneXML.getAbsolutePath() + "] non riuscita");
                    }
                    String[] listWSDL = dirWSDL.list();
                    for (int j = 0; j < listWSDL.length; ++j) {
                        File fileInterno = new File(dirWSDL.getAbsolutePath() + File.separator + listWSDL[j]);
                        if (fileInterno.isDirectory()) {
                            String[] listFruitoreWSDL = fileInterno.list();
                            for (int k = 0; k < listFruitoreWSDL.length; ++k) {
                                File fileWsdlFruitore = new File(fileInterno.getAbsolutePath() + File.separator + listFruitoreWSDL[k]);
                                if (fileWsdlFruitore.delete()) continue;
                                throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileWsdlFruitore.getAbsolutePath() + "] per il servizio [" + idServizioOLD + "] non riuscita");
                            }
                        }
                        if (fileInterno.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileInterno.getAbsolutePath() + "] per il servizio [" + idServizioOLD + "] non riuscita");
                    }
                    if (!dirWSDL.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per i WSDL del servizio [" + idServizioOLD + "] non riuscita");
                    }
                    String[] listAllegati = dirAllegati.list();
                    for (int j = 0; j < listAllegati.length; ++j) {
                        File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                        if (fileAllegati.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    if (!dirAllegati.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
                    for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                        File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                        if (fileSpecificheSemiformali.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    if (!dirSpecificheSemiformali.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    String[] listSpecificheSicurezza = dirSpecificheSicurezza.list();
                    for (int j = 0; j < listSpecificheSicurezza.length; ++j) {
                        File fileSpecificheSicurezza = new File(dirSpecificheSicurezza.getAbsolutePath() + File.separator + listSpecificheSicurezza[j]);
                        if (fileSpecificheSicurezza.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione della specifica di sicurezza [" + fileSpecificheSicurezza.getAbsolutePath() + "] per l'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    if (!dirSpecificheSicurezza.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche di sicurezza dell'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    String[] listSpecificheLivelliServizio = dirSpecificheLivelliServizio.list();
                    for (int j = 0; j < listSpecificheLivelliServizio.length; ++j) {
                        File fileSpecificheLivelliServizio = new File(dirSpecificheLivelliServizio.getAbsolutePath() + File.separator + listSpecificheLivelliServizio[j]);
                        if (fileSpecificheLivelliServizio.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione della specifica dei livelli di servizio [" + fileSpecificheLivelliServizio.getAbsolutePath() + "] per l'accordo [" + idServizioOLD + "] non riuscita");
                    }
                    if (!dirSpecificheLivelliServizio.delete()) {
                        throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche dei livelli di servizio dell'accordo [" + idServizioOLD + "] non riuscita");
                    }
                }
                catch (Exception io) {
                    throw new DriverRegistroServiziException("Eliminazione del servizio [" + idServizioOLD + "] non riuscita: " + io.toString());
                }
            }
            File dirWSDL = new File(dirServiziSoggetto + "wsdl" + idServizioNEW);
            File dirAllegati = new File(dirServiziSoggetto + "allegati" + idServizioNEW);
            File dirSpecificheSemiformali = new File(dirServiziSoggetto + "specificheSemiformali" + idServizioNEW);
            File dirSpecificheSicurezza = new File(dirServiziSoggetto + "specificheSicurezza" + idServizioNEW);
            File dirSpecificheLivelliServizio = new File(dirServiziSoggetto + "specificheLivelliServizio" + idServizioNEW);
            String prefixUrlWSDL = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "wsdl" + idServizioNEW + "/";
            String prefixUrlAllegato = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "allegati" + idServizioNEW + "/";
            String prefixUrlSpecificaSemiformale = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "specificheSemiformali" + idServizioNEW + "/";
            String prefixUrlSpecificaSicurezza = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "specificheSicurezza" + idServizioNEW + "/";
            String prefixUrlSpecificaLivelliServizio = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "specificheLivelliServizio" + idServizioNEW + "/";
            if (!dirWSDL.exists()) {
                if (!dirWSDL.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per i WSDL del servizio [" + idServizioNEW + "]");
                }
            } else {
                String implementativoErogatorePath = dirWSDL.getAbsolutePath() + File.separator + "implementazioneErogatore.wsdl";
                File implementativoErogatoreWSDL = new File(implementativoErogatorePath);
                if (implementativoErogatoreWSDL.exists() && !implementativoErogatoreWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL implementativo Erogatore del servizio [" + implementativoErogatorePath + "] non riuscita");
                }
                String implementativoFruitorePath = dirWSDL.getAbsolutePath() + File.separator + "implementazioneFruitore.wsdl";
                File implementativoFruitoreWSDL = new File(implementativoFruitorePath);
                if (implementativoFruitoreWSDL.exists() && !implementativoFruitoreWSDL.delete()) {
                    throw new DriverRegistroServiziException("Eliminazione WSDL implementativo Fruitore del servizio [" + implementativoFruitorePath + "] non riuscita");
                }
            }
            if (!dirAllegati.exists()) {
                if (!dirAllegati.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per gli allegati dell'accordo [" + idServizioNEW + "] non riuscita");
                }
            } else {
                files = dirAllegati.list();
                if (files != null) {
                    for (int i3 = 0; i3 < files.length; ++i3) {
                        file = new File(files[i3]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione allegato [" + files[i3] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheSemiformali.exists()) {
                if (!dirSpecificheSemiformali.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche semiformali dell'accordo [" + idServizioNEW + "] non riuscita");
                }
            } else {
                files = dirSpecificheSemiformali.list();
                if (files != null) {
                    for (int i4 = 0; i4 < files.length; ++i4) {
                        file = new File(files[i4]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica semiformale [" + files[i4] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheSicurezza.exists()) {
                if (!dirSpecificheSicurezza.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche di sicurezza dell'accordo [" + idServizioNEW + "] non riuscita");
                }
            } else {
                files = dirSpecificheSicurezza.list();
                if (files != null) {
                    for (int i5 = 0; i5 < files.length; ++i5) {
                        file = new File(files[i5]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica di sicurezza [" + files[i5] + "] non riuscita");
                    }
                }
            }
            if (!dirSpecificheLivelliServizio.exists()) {
                if (!dirSpecificheLivelliServizio.mkdir()) {
                    throw new DriverRegistroServiziException("Creazione della directory per le specifiche dei livelli di servizio dell'accordo [" + idServizioNEW + "] non riuscita");
                }
            } else {
                files = dirSpecificheLivelliServizio.list();
                if (files != null) {
                    for (int i6 = 0; i6 < files.length; ++i6) {
                        file = new File(files[i6]);
                        if (!file.exists() || file.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione spacifica del livello di servizio [" + files[i6] + "] non riuscita");
                    }
                }
            }
            String[] listWSDLFruitori = dirWSDL.list();
            for (int j = 0; j < listWSDLFruitori.length; ++j) {
                File fileInterno = new File(dirWSDL.getAbsolutePath() + File.separator + listWSDLFruitori[j]);
                if (!fileInterno.isDirectory()) continue;
                boolean definizioneTrovata = false;
                for (int h = 0; h < asps.sizeFruitoreList(); ++h) {
                    String idFruitore = asps.getFruitore(h).getTipo() + asps.getFruitore(h).getNome();
                    if (!idFruitore.equals(fileInterno.getName())) continue;
                    definizioneTrovata = true;
                    break;
                }
                String[] listWSDLFruitoreEliminato = fileInterno.list();
                for (int n = 0; n < listWSDLFruitoreEliminato.length; ++n) {
                    File fileWsdlFruitoreEliminato = new File(fileInterno.getAbsolutePath() + File.separator + listWSDLFruitoreEliminato[n]);
                    if (fileWsdlFruitoreEliminato.delete()) continue;
                    throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileWsdlFruitoreEliminato.getAbsolutePath() + "] per il servizio [" + idServizioNEW + "] (Fruitore) non riuscita");
                }
                if (definizioneTrovata || fileInterno.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileInterno.getAbsolutePath() + "] per il servizio [" + idServizioNEW + "] (Fruitore) non riuscita");
            }
            IDServizio[] newImage = new IDServizio[nID.size() + 1];
            for (int imageIndex = 0; imageIndex < nID.size(); ++imageIndex) {
                newImage[imageIndex] = (IDServizio)nID.get(imageIndex);
            }
            IDServizio newImageS = idServ.clone();
            newImageS.setUriAccordo(asps.getAccordoServizioParteComune());
            newImageS.setTipologiaServizio(servizio.getTipologiaServizio().toString());
            newImageS.setTipoServizio(servizio.getTipo());
            newImageS.setServizio(servizio.getNome());
            newImage[imageIndex] = newImageS;
            this.setContenutoIndexServizi(dirServiziSoggetto, newImage);
            String fileXML = dirServiziSoggetto + idServizioNEW + ".xml";
            RegistroServizi registroXML = new RegistroServizi();
            Soggetto soggXML = new Soggetto();
            soggXML.setTipo(servizio.getTipoSoggettoErogatore());
            soggXML.setNome(servizio.getNomeSoggettoErogatore());
            if (asps.getByteWsdlImplementativoErogatore() == null) {
                asps.setWsdlImplementativoErogatore("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "implementazioneErogatore.wsdl";
                this.generaFile(asps.getByteWsdlImplementativoErogatore(), path2);
                url2 = prefixUrlWSDL + "implementazioneErogatore.wsdl";
                asps.setWsdlImplementativoErogatore(url2);
            }
            if (asps.getByteWsdlImplementativoFruitore() == null) {
                asps.setWsdlImplementativoFruitore("http://undefined");
            } else {
                path2 = dirWSDL.getAbsolutePath() + File.separator + "implementazioneFruitore.wsdl";
                this.generaFile(asps.getByteWsdlImplementativoFruitore(), path2);
                url2 = prefixUrlWSDL + "implementazioneFruitore.wsdl";
                asps.setWsdlImplementativoFruitore(url2);
            }
            for (i = 0; i < asps.sizeAllegatoList(); ++i) {
                path = null;
                path = asps.getAllegato(i).getFile().startsWith(prefixUrlAllegato) ? dirAllegati.getAbsolutePath() + File.separator + asps.getAllegato(i).getFile().substring(prefixUrlAllegato.length()) : dirAllegati.getAbsolutePath() + File.separator + asps.getAllegato(i).getFile();
                this.generaFile(asps.getAllegato(i).getByteContenuto(), path);
                url = prefixUrlAllegato + asps.getAllegato(i).getFile();
                asps.getAllegato(i).setFile(url);
            }
            for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                path = null;
                path = asps.getSpecificaSemiformale(i).getFile().startsWith(prefixUrlSpecificaSemiformale) ? dirSpecificheSemiformali.getAbsolutePath() + File.separator + asps.getSpecificaSemiformale(i).getFile().substring(prefixUrlSpecificaSemiformale.length()) : dirSpecificheSemiformali.getAbsolutePath() + File.separator + asps.getSpecificaSemiformale(i).getFile();
                this.generaFile(asps.getSpecificaSemiformale(i).getByteContenuto(), path);
                url = prefixUrlSpecificaSemiformale + asps.getSpecificaSemiformale(i).getFile();
                asps.getSpecificaSemiformale(i).setFile(url);
            }
            for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                path = null;
                path = asps.getSpecificaSicurezza(i).getFile().startsWith(prefixUrlSpecificaSicurezza) ? dirSpecificheSicurezza.getAbsolutePath() + File.separator + asps.getSpecificaSicurezza(i).getFile().substring(prefixUrlSpecificaSicurezza.length()) : dirSpecificheSicurezza.getAbsolutePath() + File.separator + asps.getSpecificaSicurezza(i).getFile();
                this.generaFile(asps.getSpecificaSicurezza(i).getByteContenuto(), path);
                url = prefixUrlSpecificaSicurezza + asps.getSpecificaSicurezza(i).getFile();
                asps.getSpecificaSicurezza(i).setFile(url);
            }
            for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                path = null;
                path = asps.getSpecificaLivelloServizio(i).getFile().startsWith(prefixUrlSpecificaLivelliServizio) ? dirSpecificheLivelliServizio.getAbsolutePath() + File.separator + asps.getSpecificaLivelloServizio(i).getFile().substring(prefixUrlSpecificaLivelliServizio.length()) : dirSpecificheLivelliServizio.getAbsolutePath() + File.separator + asps.getSpecificaLivelloServizio(i).getFile();
                this.generaFile(asps.getSpecificaLivelloServizio(i).getByteContenuto(), path);
                url = prefixUrlSpecificaLivelliServizio + asps.getSpecificaLivelloServizio(i).getFile();
                asps.getSpecificaLivelloServizio(i).setFile(url);
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                String url3;
                String path3;
                Fruitore fr = asps.getFruitore(i);
                String idFruitore = fr.getTipo() + fr.getNome();
                File dirWSDLFruitore = new File(dirServiziSoggetto + "wsdl" + idServizioNEW + File.separator + idFruitore);
                String prefixUrlWSDLFruitore = this.urlPrefix + idSoggetto + "/" + "servizi" + "/" + "wsdl" + idServizioNEW + "/" + idFruitore + "/";
                if (!(fr.getByteWsdlImplementativoErogatore() == null && fr.getByteWsdlImplementativoFruitore() == null || dirWSDLFruitore.exists() || dirWSDLFruitore.mkdir())) {
                    throw new DriverRegistroServiziException("Creazione della directory per i WSDL del servizio (Fruitore " + idFruitore + ") [" + idServizioNEW + "] fallita");
                }
                if (fr.getByteWsdlImplementativoErogatore() == null) {
                    asps.getFruitore(i).setWsdlImplementativoErogatore("http://undefined");
                } else {
                    path3 = dirWSDLFruitore.getAbsolutePath() + File.separator + "implementazioneErogatore.wsdl";
                    this.generaFile(fr.getByteWsdlImplementativoErogatore(), path3);
                    url3 = prefixUrlWSDLFruitore + "implementazioneErogatore.wsdl";
                    asps.getFruitore(i).setWsdlImplementativoErogatore(url3);
                }
                if (fr.getByteWsdlImplementativoFruitore() == null) {
                    asps.getFruitore(i).setWsdlImplementativoFruitore("http://undefined");
                    continue;
                }
                path3 = dirWSDLFruitore.getAbsolutePath() + File.separator + "implementazioneFruitore.wsdl";
                this.generaFile(fr.getByteWsdlImplementativoFruitore(), path3);
                url3 = prefixUrlWSDLFruitore + "implementazioneFruitore.wsdl";
                asps.getFruitore(i).setWsdlImplementativoFruitore(url3);
            }
            this.cleanerOpenSPCoop2ExtensionsRegistry.clean(asps);
            soggXML.addAccordoServizioParteSpecifica(asps);
            registroXML.addSoggetto(soggXML);
            JiBXUtils.objToXml((String)fileXML, RegistroServizi.class, (Object)registroXML);
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'elaborazione XML del servizio [" + idServizioOLD + "]: " + e.getMessage(), e);
        }
    }

    public void deleteAccordoServizioParteSpecifica(IDServizio idServ) throws DriverRegistroServiziException {
        if (idServ == null || idServ.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("Alcuni parametri sono null");
        }
        String idSoggetto = idServ.getSoggettoErogatore().getTipo() + idServ.getSoggettoErogatore().getNome();
        String idServizio = idServ.getTipoServizio() + idServ.getServizio();
        try {
            File definizioneXML;
            String dirSoggetto = this.pathPrefix + idSoggetto + File.separator;
            String dirServiziSoggetto = dirSoggetto + "servizi" + File.separator;
            if (this.existsIndexServizi(dirServiziSoggetto)) {
                IDServizio[] index = this.readIndexServiziFromFile(dirServiziSoggetto);
                if (index != null && index.length == 1) {
                    this.deleteIndexServizi(dirServiziSoggetto);
                } else {
                    IDServizio[] newImage = new IDServizio[index.length - 1];
                    int j = 0;
                    for (int i = 0; i < index.length; ++i) {
                        if (index[i].getTipoServizio().equals(idServ.getTipoServizio()) && index[i].getServizio().equals(idServ.getServizio())) continue;
                        newImage[j] = index[i];
                        ++j;
                    }
                    this.setContenutoIndexServizi(dirServiziSoggetto, newImage);
                }
            }
            if (!(definizioneXML = new File(dirServiziSoggetto + idServizio + ".xml")).delete()) {
                throw new DriverRegistroServiziException("Eliminazione XML del servizio [" + idServizio + "] erogato dal soggetto [" + idSoggetto + "] non riuscita");
            }
            File dirWSDL = new File(dirServiziSoggetto + "wsdl" + idServizio);
            File dirAllegati = new File(dirServiziSoggetto + "allegati" + idServizio);
            File dirSpecificheSemiformali = new File(dirServiziSoggetto + "specificheSemiformali" + idServizio);
            File dirSpecificheSicurezza = new File(dirServiziSoggetto + "specificheSicurezza" + idServizio);
            File dirSpecificheLivelliServizio = new File(dirServiziSoggetto + "specificheLivelliServizio" + idServizio);
            String[] listWSDL = dirWSDL.list();
            for (int j = 0; j < listWSDL.length; ++j) {
                File fileInterno = new File(dirWSDL.getAbsolutePath() + File.separator + listWSDL[j]);
                if (fileInterno.isDirectory()) {
                    String[] listFruitoreWSDL = fileInterno.list();
                    for (int k = 0; k < listFruitoreWSDL.length; ++k) {
                        File fileWsdlFruitore = new File(fileInterno.getAbsolutePath() + File.separator + listFruitoreWSDL[k]);
                        if (fileWsdlFruitore.delete()) continue;
                        throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileWsdlFruitore.getAbsolutePath() + "] per il servizio [" + idServizio + "] non riuscita");
                    }
                }
                if (fileInterno.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione del file wsdl [" + fileInterno.getAbsolutePath() + "] per il servizio [" + idServizio + "] non riuscita");
            }
            if (!dirWSDL.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per i WSDL del servizio [" + idServizio + "] non riuscita");
            }
            String[] listAllegati = dirAllegati.list();
            for (int j = 0; j < listAllegati.length; ++j) {
                File fileAllegati = new File(dirAllegati.getAbsolutePath() + File.separator + listAllegati[j]);
                if (fileAllegati.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione dell'allegato [" + fileAllegati.getAbsolutePath() + "] per l'accordo [" + idServizio + "] non riuscita");
            }
            if (!dirAllegati.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per gli allegati dell'accordo [" + idServizio + "] non riuscita");
            }
            String[] listSpecificheSemiformali = dirSpecificheSemiformali.list();
            for (int j = 0; j < listSpecificheSemiformali.length; ++j) {
                File fileSpecificheSemiformali = new File(dirSpecificheSemiformali.getAbsolutePath() + File.separator + listSpecificheSemiformali[j]);
                if (fileSpecificheSemiformali.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione della specifica semiformale [" + fileSpecificheSemiformali.getAbsolutePath() + "] per l'accordo [" + idServizio + "] non riuscita");
            }
            if (!dirSpecificheSemiformali.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche semiformali dell'accordo [" + idServizio + "] non riuscita");
            }
            String[] listSpecificheSicurezza = dirSpecificheSicurezza.list();
            for (int j = 0; j < listSpecificheSicurezza.length; ++j) {
                File fileSpecificheSicurezza = new File(dirSpecificheSicurezza.getAbsolutePath() + File.separator + listSpecificheSicurezza[j]);
                if (fileSpecificheSicurezza.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione della specifica di sicurezza [" + fileSpecificheSicurezza.getAbsolutePath() + "] per l'accordo [" + idServizio + "] non riuscita");
            }
            if (!dirSpecificheSicurezza.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche di sicurezza dell'accordo [" + idServizio + "] non riuscita");
            }
            String[] listSpecificheLivelliServizio = dirSpecificheLivelliServizio.list();
            for (int j = 0; j < listSpecificheLivelliServizio.length; ++j) {
                File fileSpecificheLivelliServizio = new File(dirSpecificheLivelliServizio.getAbsolutePath() + File.separator + listSpecificheLivelliServizio[j]);
                if (fileSpecificheLivelliServizio.delete()) continue;
                throw new DriverRegistroServiziException("Eliminazione della specifica dei livelli di servizio [" + fileSpecificheLivelliServizio.getAbsolutePath() + "] per l'accordo [" + idServizio + "] non riuscita");
            }
            if (!dirSpecificheLivelliServizio.delete()) {
                throw new DriverRegistroServiziException("Eliminazione della directory per le specifiche dei livelli di servizio dell'accordo [" + idServizio + "] non riuscita");
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante l'eliminazione XML del servizio [" + idServizio + "] erogato dal soggetto [" + idSoggetto + "]: " + e.getMessage(), e);
        }
    }

    public AccordoServizioParteSpecifica[] getAccordiServiziParteSpecifica() throws DriverRegistroServiziException {
        AccordoServizioParteSpecifica[] serviziRegistrati = null;
        try {
            Soggetto[] soggettiRegistrati = this.getSoggetti();
            File dir = new File(this.pathPrefix);
            File[] soggetti = dir.listFiles();
            Vector<AccordoServizioParteSpecifica> servizi = new Vector<AccordoServizioParteSpecifica>();
            int indexSoggetto = 0;
            if (soggetti != null) {
                for (int i = 0; i < soggetti.length; ++i) {
                    if (!soggetti[i].isDirectory() || "accordi".equalsIgnoreCase(soggetti[i].getName()) || "accordi_cooperazione".equalsIgnoreCase(soggetti[i].getName()) || "porte_di_dominio".equalsIgnoreCase(soggetti[i].getName())) continue;
                    File dirServiziSoggetto = new File(soggetti[i].getAbsoluteFile() + File.separator + "servizi");
                    File[] serviziSoggetto = dirServiziSoggetto.listFiles();
                    if (serviziSoggetto != null) {
                        for (int k = 0; k < serviziSoggetto.length; ++k) {
                            RegistroServizi r;
                            if (!serviziSoggetto[k].isFile() || this.isIndexServizi(serviziSoggetto[k]) || (r = (RegistroServizi)JiBXUtils.xmlToObj((String)serviziSoggetto[k].getAbsolutePath(), RegistroServizi.class)).getSoggetto(0).sizeAccordoServizioParteSpecificaList() <= 0) continue;
                            AccordoServizioParteSpecifica s = r.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                            s.getServizio().setTipoSoggettoErogatore(soggettiRegistrati[indexSoggetto].getTipo());
                            s.getServizio().setNomeSoggettoErogatore(soggettiRegistrati[indexSoggetto].getNome());
                            servizi.add(s);
                        }
                    }
                    ++indexSoggetto;
                }
            }
            if (servizi.size() > 0) {
                serviziRegistrati = new AccordoServizioParteSpecifica[1];
                serviziRegistrati = servizi.toArray(serviziRegistrati);
            }
            return serviziRegistrati;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("[XMLLib] Riscontrato errore durante la ricerca dei soggetti: " + e.getMessage(), e);
        }
    }
}

