/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.ServizioAzione;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.BindingStyle;
import org.openspcoop2.core.registry.constants.BindingUse;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_LIB {
    public static Logger log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
    private static String tipoDB = null;
    private static boolean initialize = false;

    public static void initStaticLogger(Logger aLog) {
        if (!initialize) {
            if (aLog != null) {
                log = aLog;
            }
            initialize = true;
        }
    }

    public static boolean isStaticLoggerInitialized() {
        return initialize;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    public static String getValue(StatoFunzionalita funzionalita) {
        if (funzionalita == null) {
            return null;
        }
        return funzionalita.getValue();
    }

    public static String getValue(ProfiloCollaborazione profilo) {
        if (profilo == null) {
            return null;
        }
        return profilo.getValue();
    }

    public static String getValue(BindingStyle style) {
        if (style == null) {
            return null;
        }
        return style.getValue();
    }

    public static String getValue(BindingUse use) {
        if (use == null) {
            return null;
        }
        return use.getValue();
    }

    public static StatoFunzionalita getEnumStatoFunzionalita(String value) {
        if (value == null) {
            return null;
        }
        return StatoFunzionalita.toEnumConstant(value);
    }

    public static ProfiloCollaborazione getEnumProfiloCollaborazione(String value) {
        if (value == null) {
            return null;
        }
        return ProfiloCollaborazione.toEnumConstant(value);
    }

    public static BindingStyle getEnumBindingStyle(String value) {
        if (value == null) {
            return null;
        }
        return BindingStyle.toEnumConstant(value);
    }

    public static BindingUse getEnumBindingUse(String value) {
        if (value == null) {
            return null;
        }
        return BindingUse.toEnumConstant(value);
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDPortaDominio(int type, PortaDominio pdd, Connection con) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPdd] Parametro non valido.");
        }
        String nome = pdd.getNome();
        String descrizione = pdd.getDescrizione();
        String implementazione = pdd.getImplementazione();
        String subject = pdd.getSubject();
        StatoFunzionalita client_auth = pdd.getClientAuth();
        String superuser = pdd.getSuperUser();
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("pdd");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("implementazione", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("client_auth", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject != null ? Utilities.formatSubject((String)subject) : null);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(client_auth));
                    updateStmt.setString(6, superuser);
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(7, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, implementazione, subject, client_auth)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        pdd.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    long idPdd;
                    String nomePdd = pdd.getOldNomeForUpdate();
                    if (nomePdd == null || "".equals(nomePdd)) {
                        nomePdd = pdd.getNome();
                    }
                    if ((idPdd = DriverRegistroServiziDB_LIB.getIdPortaDominio(nomePdd, con, tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(UPDATE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("pdd");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("implementazione", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("client_auth", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject != null ? Utilities.formatSubject((String)subject) : null);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(client_auth));
                    updateStmt.setString(6, superuser);
                    int param_index = 6;
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(++param_index, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setLong(++param_index, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, descrizione, implementazione, subject, client_auth, idPdd)));
                    return;
                }
                case 3: {
                    long idPdd = DriverRegistroServiziDB_LIB.getIdPortaDominio(nome, con, tipoDB);
                    if (idPdd <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(DELETE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pdd");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idPdd)));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] SQLException [" + se.getMessage() + "].");
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] Exception [" + se.getMessage() + "].");
        }
        finally {
            try {
                updateStmt.close();
                selectRS.close();
                selectStmt.close();
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDConnettore(int type, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        Statement stm = null;
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere NULL.");
        }
        if (type != 3 && (connettore.getNome() == null || connettore.getNome().trim().equals(""))) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] il nome connettore non puo essere NULL.");
        }
        String nomeConnettore = null;
        String endpointtype = null;
        boolean debug = false;
        String url = null;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        String nomeProperty = null;
        String valoreProperty = null;
        nomeConnettore = connettore.getNome();
        endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    url = valoreProperty;
                    continue;
                }
                if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                    continue;
                }
                if (!nomeProperty.equals("password")) continue;
                password = valoreProperty;
                continue;
            }
            if (!TipiConnettore.JMS.getNome().equals(endpointtype)) continue;
            if (nomeProperty.equals("location")) {
                nome = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("tipo")) {
                tipo = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("user")) {
                utente = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("password")) {
                password = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.factory.initial")) {
                initcont = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                urlpkg = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.provider.url")) {
                provurl = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("connection-factory")) {
                connectionfactory = valoreProperty;
                continue;
            }
            if (!nomeProperty.equals("send-as")) continue;
            sendas = valoreProperty;
        }
        try {
            long idConnettore = 0L;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("connettori");
                    sqlQueryObject.addInsertField("endpointtype", "?");
                    sqlQueryObject.addInsertField("url", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("initcont", "?");
                    sqlQueryObject.addInsertField("urlpkg", "?");
                    sqlQueryObject.addInsertField("provurl", "?");
                    sqlQueryObject.addInsertField("connection_factory", "?");
                    sqlQueryObject.addInsertField("send_as", "?");
                    sqlQueryObject.addInsertField("nome_connettore", "?");
                    sqlQueryObject.addInsertField("debug", "?");
                    sqlQueryObject.addInsertField("custom", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, url);
                    stm.setString(3, nome);
                    stm.setString(4, tipo);
                    stm.setString(5, utente);
                    stm.setString(6, password);
                    stm.setString(7, initcont);
                    stm.setString(8, urlpkg);
                    stm.setString(9, provurl);
                    stm.setString(10, connectionfactory);
                    stm.setString(11, sendas);
                    stm.setString(12, nomeConnettore);
                    if (debug) {
                        stm.setInt(13, 1);
                    } else {
                        stm.setInt(13, 0);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(14, 1);
                    } else {
                        stm.setInt(14, 0);
                    }
                    log.debug((Object)("CRUDConnettore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, connettore.getCustom() != null && connettore.getCustom() != false)));
                    int n = stm.executeUpdate();
                    log.debug((Object)("CRUDConnettore type = " + type + " row affected =" + n));
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("connettori");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_connettore = ?");
                    sqlQueryObject.addWhereCondition("endpointtype = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, nomeConnettore);
                    stm.setString(2, endpointtype);
                    log.debug((Object)("Recupero idConnettore inserito : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeConnettore, endpointtype)));
                    ResultSet rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                    }
                    idConnettore = rs.getLong("id");
                    rs.close();
                    stm.close();
                    if (connettore.getCustom() == null || !connettore.getCustom().booleanValue()) break;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("connettori_custom");
                    sqlQueryObject.addInsertField("name", "?");
                    sqlQueryObject.addInsertField("value", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                        nomeProperty = connettore.getProperty(i).getNome();
                        valoreProperty = connettore.getProperty(i).getValore();
                        if (valoreProperty != null && valoreProperty.equals("")) {
                            valoreProperty = null;
                        }
                        if (valoreProperty == null) {
                            throw new Exception("Property [" + nomeProperty + "] without value");
                        }
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, nomeProperty);
                        stm.setString(2, valoreProperty);
                        stm.setLong(3, idConnettore);
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 2: {
                    idConnettore = connettore.getId();
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("connettori");
                    sqlQueryObject.addUpdateField("endpointtype", "?");
                    sqlQueryObject.addUpdateField("url", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("initcont", "?");
                    sqlQueryObject.addUpdateField("urlpkg", "?");
                    sqlQueryObject.addUpdateField("provurl", "?");
                    sqlQueryObject.addUpdateField("connection_factory", "?");
                    sqlQueryObject.addUpdateField("send_as", "?");
                    sqlQueryObject.addUpdateField("nome_connettore", "?");
                    sqlQueryObject.addUpdateField("debug", "?");
                    sqlQueryObject.addUpdateField("custom", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, url);
                    stm.setString(3, nome);
                    stm.setString(4, tipo);
                    stm.setString(5, utente);
                    stm.setString(6, password);
                    stm.setString(7, initcont);
                    stm.setString(8, urlpkg);
                    stm.setString(9, provurl);
                    stm.setString(10, connectionfactory);
                    stm.setString(11, sendas);
                    stm.setString(12, nomeConnettore);
                    if (debug) {
                        stm.setInt(13, 1);
                    } else {
                        stm.setInt(13, 0);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(14, 1);
                    } else {
                        stm.setInt(14, 0);
                    }
                    stm.setLong(15, idConnettore);
                    log.debug((Object)("CRUDConnettore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, connettore.getCustom() != null && connettore.getCustom() != false, idConnettore)));
                    int n = stm.executeUpdate();
                    log.debug((Object)("CRUDConnettore type = " + type + " row affected =" + n));
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    if (connettore.getCustom() == null || !connettore.getCustom().booleanValue()) break;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("connettori_custom");
                    sqlQueryObject.addInsertField("name", "?");
                    sqlQueryObject.addInsertField("value", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                        nomeProperty = connettore.getProperty(i).getNome();
                        valoreProperty = connettore.getProperty(i).getValore();
                        if (valoreProperty != null && valoreProperty.equals("")) {
                            valoreProperty = null;
                        }
                        if (valoreProperty == null) {
                            throw new Exception("Property [" + nomeProperty + "] without value");
                        }
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, nomeProperty);
                        stm.setString(2, valoreProperty);
                        stm.setLong(3, idConnettore);
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 3: {
                    idConnettore = connettore.getId();
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("connettori");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    log.debug((Object)("CRUDConnettore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore)));
                    int n = stm.executeUpdate();
                    log.debug((Object)("CRUDConnettore type = " + type + " row affected =" + n));
                    stm.close();
                }
            }
            connettore.setId(idConnettore);
            long l = idConnettore;
            return l;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDSoggetto(int type, Soggetto soggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro non valido.");
        }
        String nome = soggetto.getNome();
        String tipo = soggetto.getTipo();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
        }
        if (tipo == null || tipo.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
        }
        String descizione = soggetto.getDescrizione();
        String identificativoPorta = soggetto.getIdentificativoPorta();
        String server = soggetto.getPortaDominio();
        Connettore connettore = soggetto.getConnettore();
        String codiceIPA = soggetto.getCodiceIpa();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Il connettore del soggetto e' null.");
        }
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idSoggetto = 0L;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("soggetti");
                    sqlQueryObject.addInsertField("nome_soggetto", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("identificativo_porta", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("server", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("profilo", "?");
                    sqlQueryObject.addInsertField("codice_ipa", "?");
                    if (soggetto.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (connettore == null) {
                        connettore = new Connettore();
                        connettore.setNome("CNT_" + tipo + "_" + nome);
                    }
                    if (connettore.getNome() == null || connettore.getNome().equals("")) {
                        connettore.setNome("CNT_" + tipo + "_" + nome);
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descizione);
                    updateStmt.setString(3, identificativoPorta);
                    updateStmt.setString(4, tipo);
                    updateStmt.setLong(5, idConnettore);
                    updateStmt.setString(6, server);
                    updateStmt.setString(7, soggetto.getSuperUser());
                    if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                        updateStmt.setInt(8, 1);
                    } else {
                        updateStmt.setInt(8, 0);
                    }
                    updateStmt.setString(9, soggetto.getVersioneProtocollo());
                    updateStmt.setString(10, codiceIPA);
                    if (soggetto.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(11, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDSoggetto CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descizione, identificativoPorta, tipo, idConnettore, server)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, tipo);
                    selectStmt.setString(2, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        idSoggetto = selectRS.getLong("id");
                    }
                    soggetto.setId(idSoggetto);
                    selectRS.close();
                    selectStmt.close();
                    break;
                }
                case 2: {
                    String oldNomeSoggetto = soggetto.getOldNomeForUpdate();
                    String oldTipoSoggetto = soggetto.getOldTipoForUpdate();
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nome;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipo;
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("soggetti");
                    sqlQueryObject.addUpdateField("nome_soggetto", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("identificativo_porta", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto", "?");
                    sqlQueryObject.addUpdateField("server", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("profilo", "?");
                    sqlQueryObject.addUpdateField("codice_ipa", "?");
                    if (soggetto.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(oldNomeSoggetto, oldTipoSoggetto, con);
                    connettore.setId(idConnettore);
                    idSoggetto = DBUtils.getIdSoggetto(oldNomeSoggetto, oldTipoSoggetto, con, tipoDB);
                    if (idSoggetto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(UPDATE)] Id Soggetto non valido.");
                    }
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descizione);
                    updateStmt.setString(3, identificativoPorta);
                    updateStmt.setString(4, tipo);
                    updateStmt.setString(5, server);
                    updateStmt.setString(6, soggetto.getSuperUser());
                    if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                        updateStmt.setInt(7, 1);
                    } else {
                        updateStmt.setInt(7, 0);
                    }
                    updateStmt.setString(8, soggetto.getVersioneProtocollo());
                    updateStmt.setString(9, codiceIPA);
                    if (soggetto.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(10, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                        updateStmt.setLong(11, idSoggetto);
                    } else {
                        updateStmt.setLong(10, idSoggetto);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    String newNomeConnettore = "CNT_" + tipo + "_" + nome;
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                    log.debug((Object)("CRUDSoggetto UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descizione, identificativoPorta, tipo, idSoggetto)));
                    break;
                }
                case 3: {
                    idSoggetto = DBUtils.getIdSoggetto(nome, tipo, con, tipoDB);
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(nome, tipo, con);
                    if (idSoggetto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(DELETE)] Id Soggetto non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                    log.debug((Object)("CRUDSoggetto DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idSoggetto)));
                }
            }
            if (type == 1) {
                long l2 = idSoggetto;
                return l2;
            }
            l = n;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
        return l;
    }

    public static long CRUDAccordoServizioParteSpecifica(int type, AccordoServizioParteSpecifica asps, Connection con, String tipoDatabase) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] asps non valido.");
        }
        Servizio servizio = asps.getServizio();
        String nomeProprietario = servizio.getNomeSoggettoErogatore();
        String tipoProprietario = servizio.getTipoSoggettoErogatore();
        String nomeServizio = servizio.getNome();
        String tipoServizio = servizio.getTipo();
        String descrizione = asps.getDescrizione();
        String stato = asps.getStatoPackage();
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Nome Proprietario non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Tipo Proprietario non valido.");
        }
        if (nomeServizio == null || nomeServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Nome Servizio non valido.");
        }
        if (tipoServizio == null || tipoServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametro Tipo Servizio non valido.");
        }
        Connettore connettore = servizio.getConnettore();
        String wsdlImplementativoErogatore = asps.getByteWsdlImplementativoErogatore() != null ? new String(asps.getByteWsdlImplementativoErogatore()) : null;
        String wsdlImplementativoFruitore = asps.getByteWsdlImplementativoFruitore() != null ? new String(asps.getByteWsdlImplementativoFruitore()) : null;
        wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
        wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
        String superUser = asps.getSuperUser();
        StatoFunzionalita servizioCorrelato = TipologiaServizio.CORRELATO.equals(servizio.getTipologiaServizio()) ? CostantiRegistroServizi.ABILITATO : CostantiRegistroServizi.DISABILITATO;
        String port_type = asps.getPortType() != null ? asps.getPortType() : null;
        long idSoggetto = -1L;
        long idAccordoLong = -1L;
        try {
            if (type != 3) {
                String uriAccordo = asps.getAccordoServizioParteComune();
                if (uriAccordo == null || uriAccordo.equals("")) {
                    throw new DriverRegistroServiziException("L'uri dell'Accordo di Servizio non puo essere null.");
                }
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordo);
                idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, con, tipoDB);
            }
        }
        catch (Exception e) {
            log.error((Object)("Driver Error for get IDAccordo nome:[" + asps.getAccordoServizioParteComune() + "]."), (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        try {
            String nomeS = nomeProprietario;
            String tipoS = tipoProprietario;
            idSoggetto = DBUtils.getIdSoggetto(nomeS, tipoS, con, tipoDB);
        }
        catch (CoreException e) {
            log.error((Object)"Driver Error.", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametri non validi. Impossibile risalire all'id del soggettoo");
        }
        if (idAccordoLong <= 0L && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Parametri non validi. Impossibile risalire all'id dell'accordo");
        }
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Il Connettore non puo essere nullo.");
        }
        Statement updateStmt = null;
        ResultSet updateRS = null;
        String updateQuery = "";
        try {
            long idServizio = 0L;
            int n = 0;
            int sizeFruitori = 0;
            int sizeAzioni = 0;
            ServizioAzione azione = null;
            asps.setIdAccordo(idAccordoLong);
            switch (type) {
                case 1: {
                    Documento doc;
                    int i;
                    int i2;
                    if (connettore == null) {
                        connettore = new Connettore();
                        connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio);
                    }
                    if (connettore.getNome() == null || connettore.getNome().equals("")) {
                        connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio);
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("servizi");
                    sqlQueryObject.addInsertField("nome_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("servizio_correlato", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("port_type", "?");
                    sqlQueryObject.addInsertField("profilo", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (asps.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addInsertField("aps_nome", "?");
                    sqlQueryObject.addInsertField("aps_versione", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nomeServizio);
                    updateStmt.setString(2, tipoServizio);
                    updateStmt.setLong(3, idSoggetto);
                    updateStmt.setLong(4, idAccordoLong);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(servizioCorrelato));
                    updateStmt.setLong(6, idConnettore);
                    updateStmt.setString(7, wsdlImplementativoErogatore);
                    updateStmt.setString(8, wsdlImplementativoFruitore);
                    updateStmt.setString(9, superUser);
                    if (asps.getPrivato() != null && asps.getPrivato().booleanValue()) {
                        updateStmt.setInt(10, 1);
                    } else {
                        updateStmt.setInt(10, 0);
                    }
                    updateStmt.setString(11, port_type);
                    updateStmt.setString(12, asps.getVersioneProtocollo());
                    updateStmt.setString(13, descrizione);
                    int index = 14;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (asps.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(asps.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setString(index, asps.getNome());
                    updateStmt.setString(++index, asps.getVersione());
                    ++index;
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, superUser)));
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nomeServizio);
                    updateStmt.setString(2, tipoServizio);
                    updateStmt.setLong(3, idSoggetto);
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica recupero l'id del servizio appena creato : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto)));
                    updateRS = updateStmt.executeQuery();
                    if (updateRS.next()) {
                        idServizio = updateRS.getLong("id");
                    }
                    updateRS.close();
                    updateStmt.close();
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(addFruitore)] id servizio non recuperato");
                    }
                    asps.setId(idServizio);
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    for (i2 = 0; i2 < sizeFruitori; ++i2) {
                        fruitore = asps.getFruitore(i2);
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaFruitore(1, fruitore, con, servizio);
                    }
                    sizeAzioni = servizio.sizeParametriAzioneList();
                    azione = null;
                    for (i2 = 0; i2 < sizeAzioni; ++i2) {
                        azione = servizio.getParametriAzione(i2);
                        log.debug((Object)("CRUD AZIONE -----------[" + azione.getNome() + "]"));
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaAzioni(1, azione, con, servizio);
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < asps.sizeAllegatoList(); ++i) {
                        doc = asps.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                        doc = asps.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                        doc = asps.getSpecificaLivelloServizio(i);
                        doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        doc = asps.getSpecificaSicurezza(i);
                        doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    break;
                }
                case 2: {
                    Documento doc;
                    int i;
                    String oldNomeSoggetto = servizio.getOldNomeSoggettoErogatoreForUpdate();
                    String oldTipoSoggetto = servizio.getOldTipoSoggettoErogatoreForUpdate();
                    String oldNomeServizio = servizio.getOldNomeForUpdate();
                    String oldTipoServizio = servizio.getOldTipoForUpdate();
                    if (oldNomeServizio == null || oldNomeServizio.equals("")) {
                        oldNomeServizio = nomeServizio;
                    }
                    if (oldTipoServizio == null || oldTipoServizio.equals("")) {
                        oldTipoServizio = tipoServizio;
                    }
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nomeProprietario;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipoProprietario;
                    }
                    if ((idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, oldNomeSoggetto, oldTipoSoggetto, con, tipoDB)) <= 0L) {
                        idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, nomeProprietario, tipoProprietario, con, tipoDB);
                    }
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(UPDATE)] Id Servizio non valido.");
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, oldNomeSoggetto, oldTipoSoggetto, con);
                    if (idConnettore <= 0L) {
                        idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, nomeProprietario, tipoProprietario, con);
                    }
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] id connettore nullo.");
                    }
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("servizi");
                    sqlQueryObject.addUpdateField("nome_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("servizio_correlato", "?");
                    sqlQueryObject.addUpdateField("id_connettore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("port_type", "?");
                    sqlQueryObject.addUpdateField("profilo", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (asps.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addUpdateField("aps_nome", "?");
                    sqlQueryObject.addUpdateField("aps_versione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nomeServizio);
                    updateStmt.setString(2, tipoServizio);
                    updateStmt.setLong(3, idSoggetto);
                    updateStmt.setLong(4, idAccordoLong);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(servizioCorrelato));
                    updateStmt.setLong(6, idConnettore);
                    updateStmt.setString(7, wsdlImplementativoErogatore);
                    updateStmt.setString(8, wsdlImplementativoFruitore);
                    updateStmt.setString(9, superUser);
                    if (asps.getPrivato() != null && asps.getPrivato().booleanValue()) {
                        updateStmt.setInt(10, 1);
                    } else {
                        updateStmt.setInt(10, 0);
                    }
                    updateStmt.setString(11, port_type);
                    updateStmt.setString(12, asps.getVersioneProtocollo());
                    updateStmt.setString(13, descrizione);
                    int index = 14;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (asps.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(asps.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setString(index, asps.getNome());
                    updateStmt.setString(++index, asps.getVersione());
                    updateStmt.setLong(++index, idServizio);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n));
                    String newNomeConnettore = "CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio;
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    DriverRegistroServiziDB_LIB.deleteAllFruitoriServizio(idServizio, con);
                    for (i = 0; i < sizeFruitori; ++i) {
                        fruitore = asps.getFruitore(i);
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaFruitore(1, fruitore, con, servizio);
                    }
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, superUser, idServizio)));
                    sizeAzioni = servizio.sizeParametriAzioneList();
                    azione = null;
                    DriverRegistroServiziDB_LIB.deleteAllAzioniServizio(idServizio, con);
                    for (i = 0; i < sizeAzioni; ++i) {
                        azione = servizio.getParametriAzione(i);
                        log.debug((Object)("CRUD AZIONE -----------[" + azione.getNome() + "]"));
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaAzioni(1, azione, con, servizio);
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < asps.sizeAllegatoList(); ++i) {
                        doc = asps.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                        doc = asps.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                        doc = asps.getSpecificaLivelloServizio(i);
                        doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        doc = asps.getSpecificaSicurezza(i);
                        doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    break;
                }
                case 3: {
                    int i;
                    idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB);
                    if (idServizio <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(DELETE)] Id Servizio non valido.");
                    }
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con);
                    if (idConnettore <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica(DELETE)] Id Connettore non valido.");
                    }
                    sizeFruitori = asps.sizeFruitoreList();
                    Fruitore fruitore = null;
                    for (i = 0; i < sizeFruitori; ++i) {
                        fruitore = asps.getFruitore(i);
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaFruitore(3, fruitore, con, servizio);
                    }
                    sizeAzioni = servizio.sizeParametriAzioneList();
                    azione = null;
                    for (i = 0; i < sizeAzioni; ++i) {
                        azione = servizio.getParametriAzione(i);
                        DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecificaAzioni(3, azione, con, servizio);
                    }
                    DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idServizio, ProprietariDocumento.servizio, con, tipoDatabase);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizio);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio)));
                }
            }
            long l = n;
            return l;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecifica] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (updateRS != null) {
                    updateRS.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static long CRUDAccordoServizioParteSpecificaFruitore(int type, Fruitore fruitore, Connection con, Servizio servizio) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idServizio = -1L;
        try {
            String tipoServ = servizio.getTipo();
            String nomeServ = servizio.getNome();
            String tipoSogg = servizio.getTipoSoggettoErogatore();
            String nomeSogg = servizio.getNomeSoggettoErogatore();
            idServizio = DBUtils.getIdServizio(nomeServ, tipoServ, nomeSogg, tipoSogg, con, tipoDB);
        }
        catch (CoreException e1) {
            log.error((Object)"Driver Error.", (Throwable)e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] ID Servizio non valido.");
        }
        Connettore connettore = fruitore.getConnettore();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] il connettore non puo essere nullo.");
        }
        String nomeSoggetto = fruitore.getNome();
        String tipoSoggetto = fruitore.getTipo();
        if (nomeSoggetto == null || nomeSoggetto.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Nome Fruitore non valido.");
        }
        if (tipoSoggetto == null || tipoSoggetto.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Tipo Fruitore non valido.");
        }
        String stato = fruitore.getStatoPackage();
        long idSoggettoFruitore = -1L;
        try {
            idSoggettoFruitore = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
        }
        catch (CoreException e1) {
            log.error((Object)"Driver Error.", (Throwable)e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idSoggettoFruitore <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaFruitore] Id Soggetto Fruitore non valido.");
        }
        String wsdlImplementativoErogatore = fruitore.getByteWsdlImplementativoErogatore() != null ? new String(fruitore.getByteWsdlImplementativoErogatore()) : null;
        wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
        String wsdlImplementativoFruitore = fruitore.getByteWsdlImplementativoFruitore() != null ? new String(fruitore.getByteWsdlImplementativoFruitore()) : null;
        wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
        StatoFunzionalita clientAuth = fruitore.getClientAuth();
        long idConnettore = 0L;
        long n = 0L;
        try {
            switch (type) {
                case 1: {
                    if (connettore == null) {
                        connettore = new Connettore();
                    }
                    connettore.setNome("CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome());
                    DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                    idConnettore = connettore.getId();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("servizi_fruitori");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addInsertField("profilo", "?");
                    sqlQueryObject.addInsertField("client_auth", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setLong(2, idSoggettoFruitore);
                    updateStmt.setLong(3, idConnettore);
                    updateStmt.setString(4, wsdlImplementativoErogatore);
                    updateStmt.setString(5, wsdlImplementativoFruitore);
                    updateStmt.setString(6, fruitore.getVersioneProtocollo());
                    updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(clientAuth));
                    int index = 8;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAccordoServizioParteSpecificaFruitore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio, idSoggettoFruitore, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idServizio);
                    selectStmt.setLong(2, idSoggettoFruitore);
                    selectStmt.setLong(3, idConnettore);
                    break;
                }
                case 2: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                    if (idConnettore < 0L) {
                        throw new DriverRegistroServiziException("Il connettore del Fruitore del Servizio e' invalido id<0");
                    }
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("servizi_fruitori");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                    sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                    sqlQueryObject.addUpdateField("profilo", "?");
                    sqlQueryObject.addUpdateField("client_auth", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id_servizio=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, wsdlImplementativoErogatore);
                    updateStmt.setString(2, wsdlImplementativoFruitore);
                    updateStmt.setString(3, fruitore.getVersioneProtocollo());
                    updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(clientAuth));
                    int index = 5;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (fruitore.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setLong(index, idServizio);
                    updateStmt.setLong(++index, idSoggettoFruitore);
                    updateStmt.setLong(++index, idConnettore);
                    ++index;
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAccordoServizioParteSpecificaFruitore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, wsdlImplementativoErogatore, wsdlImplementativoFruitore, idServizio, idSoggettoFruitore, idConnettore)));
                    log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]..."));
                    String newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome();
                    connettore.setNome(newNomeConnettore);
                    log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                    break;
                }
                case 3: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_fruitori");
                    sqlQueryObject.addWhereCondition("id_servizio=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setLong(2, idSoggettoFruitore);
                    updateStmt.setLong(3, idConnettore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecificaFruitore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio, idSoggettoFruitore, idConnettore)));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                }
            }
            log.debug((Object)("CRUDAccordoServizioParteSpecificaFruitore type = " + type + " row affected =" + n));
            if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                long sqlQueryObject = selectRS.getLong("id");
                return sqlQueryObject;
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDAccordoServizioParteSpecificaAzioni(int type, ServizioAzione azione, Connection con, Servizio servizio) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idServizio = -1L;
        try {
            String tipoServ = servizio.getTipo();
            String nomeServ = servizio.getNome();
            String tipoSogg = servizio.getTipoSoggettoErogatore();
            String nomeSogg = servizio.getNomeSoggettoErogatore();
            idServizio = DBUtils.getIdServizio(nomeServ, tipoServ, nomeSogg, tipoSogg, con, tipoDB);
        }
        catch (CoreException e1) {
            log.error((Object)"Driver Error.", (Throwable)e1);
            throw new DriverRegistroServiziException(e1);
        }
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] ID Servizio non valido.");
        }
        Connettore connettore = azione.getConnettore();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] il connettore non puo essere nullo.");
        }
        String azioneValue = azione.getNome();
        if (azioneValue == null || azioneValue.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Azione non valida.");
        }
        String nomeConnettore = "CNT_SAZIONE_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome() + "_" + azioneValue;
        if (connettore == null) {
            connettore = new Connettore();
        }
        connettore.setNome(nomeConnettore);
        long idConnettore = 0L;
        long n = 0L;
        try {
            switch (type) {
                case 1: {
                    DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                    idConnettore = connettore.getId();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("servizi_azioni");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("nome_azione", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setString(2, azioneValue);
                    updateStmt.setLong(3, idConnettore);
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAccordoServizioParteSpecificaAzioni CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio, azioneValue, idConnettore)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_servizio = ?");
                    sqlQueryObject.addWhereCondition("nome_azione = ?");
                    sqlQueryObject.addWhereCondition("id_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idServizio);
                    selectStmt.setString(2, azioneValue);
                    selectStmt.setLong(3, idConnettore);
                    break;
                }
                case 2: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioAzione(idServizio, azioneValue, con);
                    if (idConnettore < 0L) {
                        throw new DriverRegistroServiziException("Il connettore dell'azione [" + azioneValue + "] del Servizio e' invalido id<0");
                    }
                    connettore.setId(idConnettore);
                    log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]..."));
                    log.debug((Object)("nuovo nome connettore [" + connettore.getNome() + "]"));
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                    break;
                }
                case 3: {
                    idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioAzione(idServizio, azioneValue, con);
                    connettore.setId(idConnettore);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_azioni");
                    sqlQueryObject.addWhereCondition("id_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_azione=?");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idServizio);
                    updateStmt.setString(2, azioneValue);
                    updateStmt.setLong(3, idConnettore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecificaAzioni DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio, azioneValue, idConnettore)));
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                }
            }
            log.debug((Object)("CRUDAccordoServizioParteSpecificaAzioni type = " + type + " row affected =" + n));
            if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                long sqlQueryObject = selectRS.getLong("id");
                return sqlQueryObject;
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioParteSpecificaAzioni] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDAzione(int type, AccordoServizioParteComune as, Azione azione, Connection con, long idAccordo) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long n = 0L;
        if (idAccordo <= 0L) {
            new Exception("[DriverRegistroServiziDB_LIB::CRUDAzione] ID Accordo non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("accordi_azioni");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("profilo_azione", "?");
                    sqlQueryObject.addInsertField("filtro_duplicati", "?");
                    sqlQueryObject.addInsertField("conferma_ricezione", "?");
                    sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                    sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                    sqlQueryObject.addInsertField("scadenza", "?");
                    sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                    sqlQueryObject.addInsertField("correlata", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setString(2, azione.getNome());
                    updateStmt.setString(3, azione.getProfAzione());
                    log.debug((Object)("Aggiungo azione [" + azione.getNome() + "] con profilo [" + azione.getProfAzione() + "]"));
                    if ("ridefinito".equals(azione.getProfAzione())) {
                        log.debug((Object)"ridefinizione...");
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        updateStmt.setString(8, azione.getScadenza());
                        updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                    } else {
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        updateStmt.setString(8, as.getScadenza());
                        updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                    }
                    updateStmt.setString(10, azione.getCorrelata());
                    log.debug((Object)("CRUDAzione CREATE :\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idAccordo, azione.getNome(), azione.getProfAzione())));
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("accordi_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_accordo = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idAccordo);
                    selectStmt.setString(2, azione.getNome());
                    break;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("accordi_azioni");
                    sqlQueryObject.addUpdateField("profilo_azione", "?");
                    sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                    sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                    sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                    sqlQueryObject.addUpdateField("scadenza", "?");
                    sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("correlata", "?");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, azione.getProfAzione());
                    if ("ridefinito".equals(azione.getProfAzione())) {
                        updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        updateStmt.setString(6, azione.getScadenza());
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                    } else {
                        updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        updateStmt.setString(6, as.getScadenza());
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                    }
                    updateStmt.setString(8, azione.getCorrelata());
                    updateStmt.setLong(9, idAccordo);
                    updateStmt.setString(10, azione.getNome());
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_azioni");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setString(2, azione.getNome());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                }
            }
            if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                azione.setId(selectRS.getLong("id"));
                long sqlQueryObject = azione.getId();
                return sqlQueryObject;
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzione] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzione] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDPortType(int type, AccordoServizioParteComune as, PortType pt, Connection con, long idAccordo) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        Statement selectStmt = null;
        ResultSet selectRS = null;
        long n = 0L;
        if (idAccordo <= 0L) {
            new Exception("[DriverRegistroServiziDB_LIB::CRUDPortType] ID Accordo non valido.");
        }
        try {
            int i;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("port_type");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("profilo_pt", "?");
                    sqlQueryObject.addInsertField("filtro_duplicati", "?");
                    sqlQueryObject.addInsertField("conferma_ricezione", "?");
                    sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                    sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                    sqlQueryObject.addInsertField("scadenza", "?");
                    sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                    sqlQueryObject.addInsertField("soap_style", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setString(2, pt.getNome());
                    updateStmt.setString(3, pt.getDescrizione());
                    updateStmt.setString(4, pt.getProfiloPT());
                    log.debug((Object)("Aggiungo port-type [" + pt.getNome() + "] con profilo [" + pt.getProfiloPT() + "]"));
                    if ("ridefinito".equals(pt.getProfiloPT())) {
                        log.debug((Object)"ridefinizione...");
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        updateStmt.setString(9, pt.getScadenza());
                        updateStmt.setString(10, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                    } else {
                        if (pt.getFiltroDuplicati() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        } else {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        }
                        if (pt.getConfermaRicezione() != null) {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        } else {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        }
                        if (pt.getIdCollaborazione() != null) {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        } else {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        }
                        if (pt.getConsegnaInOrdine() != null) {
                            updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        } else {
                            updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        }
                        if (pt.getScadenza() != null) {
                            updateStmt.setString(9, pt.getScadenza());
                        } else {
                            updateStmt.setString(9, as.getScadenza());
                        }
                        if (pt.getProfiloCollaborazione() != null) {
                            updateStmt.setString(10, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                        } else {
                            updateStmt.setString(10, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                        }
                    }
                    updateStmt.setString(11, DriverRegistroServiziDB_LIB.getValue(pt.getStyle()));
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                    break;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("port_type");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("profilo_pt", "?");
                    sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                    sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                    sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                    sqlQueryObject.addUpdateField("scadenza", "?");
                    sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("soap_style", "?");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, pt.getDescrizione());
                    updateStmt.setString(2, pt.getProfiloPT());
                    if ("ridefinito".equals(pt.getProfiloPT())) {
                        updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        updateStmt.setString(7, pt.getScadenza());
                        updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                    } else {
                        if (pt.getFiltroDuplicati() != null) {
                            updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        } else {
                            updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        }
                        if (pt.getConfermaRicezione() != null) {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        } else {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        }
                        if (pt.getIdCollaborazione() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        } else {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        }
                        if (pt.getConsegnaInOrdine() != null) {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        } else {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        }
                        if (pt.getScadenza() != null) {
                            updateStmt.setString(7, pt.getScadenza());
                        } else {
                            updateStmt.setString(7, as.getScadenza());
                        }
                        if (pt.getProfiloCollaborazione() != null) {
                            updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                        } else {
                            updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                        }
                    }
                    updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(pt.getStyle()));
                    updateStmt.setLong(10, idAccordo);
                    updateStmt.setString(11, pt.getNome());
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                    break;
                }
                case 3: {
                    Long idPT = 0L;
                    if (!(pt.getId() != null && pt.getId() > 0L || (idPT = Long.valueOf(DriverRegistroServiziDB_LIB.getIdPortType(idAccordo, pt.getNome(), con))) != null && idPT > 0L)) {
                        throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                    }
                    for (i = 0; i < pt.sizeAzioneList(); ++i) {
                        DriverRegistroServiziDB_LIB.CRUDAzionePortType(3, as, pt, pt.getAzione(i), con, idPT);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("port_type");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setString(2, pt.getNome());
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                }
            }
            if (1 == type || 2 == type) {
                Long idPT = DriverRegistroServiziDB_LIB.getIdPortType(idAccordo, pt.getNome(), con);
                if (idPT == null || idPT <= 0L) {
                    throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                }
                log.debug((Object)("ID port type: " + idPT));
                if (2 == type) {
                    n = 0L;
                    for (int i2 = 0; i2 < pt.sizeAzioneList(); ++i2) {
                        n += DriverRegistroServiziDB_LIB.CRUDAzionePortType(3, as, pt, pt.getAzione(i2), con, idPT);
                    }
                    log.info((Object)("Cancellate " + n + " azioni del port type [" + idPT + "] associate all'accordo " + idAccordo));
                }
                Operation azione = null;
                for (i = 0; i < pt.sizeAzioneList(); ++i) {
                    azione = pt.getAzione(i);
                    DriverRegistroServiziDB_LIB.CRUDAzionePortType(1, as, pt, azione, con, idPT);
                }
                log.debug((Object)("inserite " + pt.sizeAzioneList() + " azioni relative al port type[" + pt.getNome() + "] id-porttype[" + pt.getId() + "] dell'accordo :" + IDAccordoFactory.getInstance().getUriFromAccordo(as) + " id-accordo :" + idAccordo));
            }
            long idPT = n;
            return idPT;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortType] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortType] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long CRUDAzionePortType(int type, AccordoServizioParteComune as, PortType pt, Operation azione, Connection con, long idPortType) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long n = 0L;
        if (idPortType <= 0L) {
            new Exception("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] ID Port Type non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("port_type_azioni");
                    sqlQueryObject.addInsertField("id_port_type", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("profilo_pt_azione", "?");
                    sqlQueryObject.addInsertField("filtro_duplicati", "?");
                    sqlQueryObject.addInsertField("conferma_ricezione", "?");
                    sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                    sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                    sqlQueryObject.addInsertField("scadenza", "?");
                    sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                    sqlQueryObject.addInsertField("soap_style", "?");
                    sqlQueryObject.addInsertField("soap_action", "?");
                    sqlQueryObject.addInsertField("soap_use_msg_input", "?");
                    sqlQueryObject.addInsertField("soap_namespace_msg_input", "?");
                    sqlQueryObject.addInsertField("soap_use_msg_output", "?");
                    sqlQueryObject.addInsertField("soap_namespace_msg_output", "?");
                    sqlQueryObject.addInsertField("correlata_servizio", "?");
                    sqlQueryObject.addInsertField("correlata", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idPortType);
                    updateStmt.setString(2, azione.getNome());
                    updateStmt.setString(3, azione.getProfAzione());
                    log.debug((Object)("Aggiungo azione [" + azione.getNome() + "] pt [" + pt.getNome() + "] con profilo [" + azione.getProfAzione() + "]"));
                    if ("ridefinito".equals(azione.getProfAzione())) {
                        log.debug((Object)"ridefinizione...");
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        updateStmt.setString(8, azione.getScadenza());
                        updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                    } else {
                        if (azione.getFiltroDuplicati() != null) {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        } else if (pt.getFiltroDuplicati() != null) {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        } else {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        }
                        if (azione.getConfermaRicezione() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        } else if (pt.getConfermaRicezione() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        } else {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        }
                        if (azione.getIdCollaborazione() != null) {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        } else if (pt.getIdCollaborazione() != null) {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        } else {
                            updateStmt.setString(6, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        }
                        if (azione.getConsegnaInOrdine() != null) {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        } else if (pt.getConsegnaInOrdine() != null) {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        } else {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        }
                        if (azione.getScadenza() != null) {
                            updateStmt.setString(8, azione.getScadenza());
                        } else if (pt.getScadenza() != null) {
                            updateStmt.setString(8, pt.getScadenza());
                        } else {
                            updateStmt.setString(8, as.getScadenza());
                        }
                        if (azione.getProfiloCollaborazione() != null) {
                            updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                        } else if (pt.getProfiloCollaborazione() != null) {
                            updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                        } else {
                            updateStmt.setString(9, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                        }
                    }
                    updateStmt.setString(10, DriverRegistroServiziDB_LIB.getValue(azione.getStyle()));
                    updateStmt.setString(11, azione.getSoapAction());
                    if (azione.getMessageInput() != null) {
                        updateStmt.setString(12, DriverRegistroServiziDB_LIB.getValue(azione.getMessageInput().getUse()));
                        updateStmt.setString(13, azione.getMessageInput().getSoapNamespace());
                    } else {
                        updateStmt.setString(12, null);
                        updateStmt.setString(13, null);
                    }
                    if (azione.getMessageOutput() != null) {
                        updateStmt.setString(14, DriverRegistroServiziDB_LIB.getValue(azione.getMessageOutput().getUse()));
                        updateStmt.setString(15, azione.getMessageOutput().getSoapNamespace());
                    } else {
                        updateStmt.setString(14, null);
                        updateStmt.setString(15, null);
                    }
                    updateStmt.setString(16, azione.getCorrelataServizio());
                    updateStmt.setString(17, azione.getCorrelata());
                    log.debug((Object)("CRUDPortTypeAzione CREATE :\n" + updateQuery));
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_port_type = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setLong(1, idPortType);
                    selectStmt.setString(2, azione.getNome());
                    break;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("port_type_azioni");
                    sqlQueryObject.addUpdateField("profilo_azione", "?");
                    sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                    sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                    sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                    sqlQueryObject.addUpdateField("scadenza", "?");
                    sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                    sqlQueryObject.addUpdateField("soap_style", "?");
                    sqlQueryObject.addUpdateField("soap_action", "?");
                    sqlQueryObject.addUpdateField("soap_use_msg_input", "?");
                    sqlQueryObject.addUpdateField("soap_namespace_msg_input", "?");
                    sqlQueryObject.addUpdateField("soap_use_msg_output", "?");
                    sqlQueryObject.addUpdateField("soap_namespace_msg_output", "?");
                    sqlQueryObject.addUpdateField("correlata_servizio", "?");
                    sqlQueryObject.addUpdateField("correlata", "?");
                    sqlQueryObject.addWhereCondition("id_port_type=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, azione.getProfAzione());
                    if ("ridefinito".equals(azione.getProfAzione())) {
                        updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        updateStmt.setString(6, azione.getScadenza());
                        updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                    } else {
                        if (azione.getFiltroDuplicati() != null) {
                            updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(azione.getFiltroDuplicati()));
                        } else if (pt.getFiltroDuplicati() != null) {
                            updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(pt.getFiltroDuplicati()));
                        } else {
                            updateStmt.setString(2, DriverRegistroServiziDB_LIB.getValue(as.getFiltroDuplicati()));
                        }
                        if (azione.getConfermaRicezione() != null) {
                            updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(azione.getConfermaRicezione()));
                        } else if (pt.getConfermaRicezione() != null) {
                            updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(pt.getConfermaRicezione()));
                        } else {
                            updateStmt.setString(3, DriverRegistroServiziDB_LIB.getValue(as.getConfermaRicezione()));
                        }
                        if (azione.getIdCollaborazione() != null) {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(azione.getIdCollaborazione()));
                        } else if (pt.getIdCollaborazione() != null) {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(pt.getIdCollaborazione()));
                        } else {
                            updateStmt.setString(4, DriverRegistroServiziDB_LIB.getValue(as.getIdCollaborazione()));
                        }
                        if (azione.getConsegnaInOrdine() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(azione.getConsegnaInOrdine()));
                        } else if (pt.getConsegnaInOrdine() != null) {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(pt.getConsegnaInOrdine()));
                        } else {
                            updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(as.getConsegnaInOrdine()));
                        }
                        if (azione.getScadenza() != null) {
                            updateStmt.setString(6, azione.getScadenza());
                        } else if (pt.getScadenza() != null) {
                            updateStmt.setString(6, pt.getScadenza());
                        } else {
                            updateStmt.setString(6, as.getScadenza());
                        }
                        if (azione.getProfiloCollaborazione() != null) {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(azione.getProfiloCollaborazione()));
                        } else if (pt.getProfiloCollaborazione() != null) {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(pt.getProfiloCollaborazione()));
                        } else {
                            updateStmt.setString(7, DriverRegistroServiziDB_LIB.getValue(as.getProfiloCollaborazione()));
                        }
                    }
                    updateStmt.setString(8, DriverRegistroServiziDB_LIB.getValue(azione.getStyle()));
                    updateStmt.setString(9, azione.getSoapAction());
                    if (azione.getMessageInput() != null) {
                        updateStmt.setString(10, DriverRegistroServiziDB_LIB.getValue(azione.getMessageInput().getUse()));
                        updateStmt.setString(11, azione.getMessageInput().getSoapNamespace());
                    } else {
                        updateStmt.setString(10, null);
                        updateStmt.setString(11, null);
                    }
                    if (azione.getMessageOutput() != null) {
                        updateStmt.setString(12, DriverRegistroServiziDB_LIB.getValue(azione.getMessageOutput().getUse()));
                        updateStmt.setString(13, azione.getMessageOutput().getSoapNamespace());
                    } else {
                        updateStmt.setString(12, null);
                        updateStmt.setString(13, null);
                    }
                    updateStmt.setString(14, azione.getCorrelataServizio());
                    updateStmt.setString(15, azione.getCorrelata());
                    updateStmt.setLong(16, idPortType);
                    updateStmt.setString(17, azione.getNome());
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    log.debug((Object)("CRUDAzione DELETE MESSAGES:\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, azione.getId())));
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, azione.getId());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("port_type_azioni");
                    sqlQueryObject.addWhereCondition("id_port_type=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    log.debug((Object)("CRUDAzione DELETE AZIONI:\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idPortType, azione.getNome())));
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idPortType);
                    updateStmt.setString(2, azione.getNome());
                    n = updateStmt.executeUpdate();
                    log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                }
            }
            if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                azione.setId(selectRS.getLong("id"));
                azione.setIdPortType(idPortType);
                DriverRegistroServiziDB_LIB.CRUDMessageAzionePortType(1, azione, con);
                long sqlQueryObject = azione.getId();
                return sqlQueryObject;
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDMessageAzionePortType(int type, Operation azione, Connection con) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        Statement selectStmt = null;
        ResultSet selectRS = null;
        if (azione.getId() <= 0L) {
            new Exception("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] ID Operation Port Type non valida.");
        }
        try {
            switch (type) {
                case 1: {
                    MessagePart part;
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("operation_messages");
                    sqlQueryObject.addInsertField("id_port_type_azione", "?");
                    sqlQueryObject.addInsertField("input_message", "?");
                    sqlQueryObject.addInsertField("name", "?");
                    sqlQueryObject.addInsertField("element_name", "?");
                    sqlQueryObject.addInsertField("element_namespace", "?");
                    sqlQueryObject.addInsertField("type_name", "?");
                    sqlQueryObject.addInsertField("type_namespace", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    if (azione.getMessageInput() != null) {
                        for (i = 0; i < azione.getMessageInput().sizePartList(); ++i) {
                            updateStmt = con.prepareStatement(updateQuery);
                            part = azione.getMessageInput().getPart(i);
                            updateStmt.setLong(1, azione.getId());
                            updateStmt.setInt(2, 1);
                            updateStmt.setString(3, part.getName());
                            updateStmt.setString(4, part.getElementName());
                            updateStmt.setString(5, part.getElementNamespace());
                            updateStmt.setString(6, part.getTypeName());
                            updateStmt.setString(7, part.getTypeNamespace());
                            log.debug((Object)("Aggiungo part element input  [" + part.getName() + "] per azione [" + azione.getNome() + "]"));
                            log.debug((Object)("CRUDMessageAzionePortType CREATE :\n" + updateQuery));
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    if (azione.getMessageOutput() == null) return;
                    i = 0;
                    while (i < azione.getMessageOutput().sizePartList()) {
                        updateStmt = con.prepareStatement(updateQuery);
                        part = azione.getMessageOutput().getPart(i);
                        updateStmt.setLong(1, azione.getId());
                        updateStmt.setInt(2, 0);
                        updateStmt.setString(3, part.getName());
                        updateStmt.setString(4, part.getElementName());
                        updateStmt.setString(5, part.getElementNamespace());
                        updateStmt.setString(6, part.getTypeName());
                        updateStmt.setString(7, part.getTypeNamespace());
                        log.debug((Object)("Aggiungo part element output [" + part.getName() + "] per azione [" + azione.getNome() + "]"));
                        log.debug((Object)("CRUDMessageAzionePortType CREATE :\n" + updateQuery));
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        ++i;
                    }
                    return;
                }
                case 2: {
                    throw new Exception("Non implementato");
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, azione.getId());
                    long n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDMessageAzionePortType type = " + type + " row affected =" + n));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static long getIdConnettoreSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoSoggetto);
            stm.setString(2, nomeSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    private static long getIdConnettoreServizio(String nomeServizio, String tipoServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            long l = idConnettore;
            return l;
        }
        catch (CoreException e) {
            log.error((Object)"Errore Driver.", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    private static long getIdConnettoreServizioFruitore(long idServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setLong(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            long l = idConnettore;
            return l;
        }
        catch (CoreException e) {
            log.error((Object)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    private static long getIdConnettoreServizioAzione(long idServizio, String azione, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setString(2, azione);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    private static void deleteAllFruitoriServizio(long idServizio, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<Long> listaConnettori = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            while (rs.next()) {
                listaConnettori.add(rs.getLong("id_connettore"));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("id_servizio=?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            int n = stm.executeUpdate();
            stm.close();
            log.debug((Object)("Cancellati " + n + " Fruitori del servizio " + idServizio));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            sqlQueryObject.addWhereCondition("id_connettore=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            log.debug((Object)("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori del servizio " + idServizio));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            log.debug((Object)("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori del servizio " + idServizio));
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    private static void deleteAllAzioniServizio(long idServizio, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ArrayList<Long> listaConnettori = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            while (rs.next()) {
                listaConnettori.add(rs.getLong("id_connettore"));
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azioni");
            sqlQueryObject.addWhereCondition("id_servizio=?");
            String sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            int n = stm.executeUpdate();
            stm.close();
            log.debug((Object)("Cancellati " + n + " Azioni del servizio " + idServizio));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            sqlQueryObject.addWhereCondition("id_connettore=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            log.debug((Object)("Cancellati connettori " + listaConnettori.toString() + " associati alle azioni del servizio " + idServizio));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = con.prepareStatement(sqlQuery);
            for (Long idConnettore : listaConnettori) {
                stm.setLong(1, idConnettore);
                stm.executeUpdate();
            }
            stm.close();
            log.debug((Object)("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori del servizio " + idServizio));
        }
        catch (SQLException e) {
            log.error((Object)"Errore SQL", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            log.error((Object)"Errore", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void CRUDDocumento(int type, List<Documento> documenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, Connection connection, String tipoDatabase) throws DriverRegistroServiziException {
        stm = null;
        rs = null;
        if (documenti == null && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] L'oggetto documenti non puo essere null");
        }
        if (idProprietario <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] id proprietario non definito");
        }
        jdbcAdapter = null;
        try {
            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            switch (type) {
                case 1: {
                    for (i = 0; i < documenti.size(); ++i) {
                        doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        contenuto = doc.getByteContenuto();
                        if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                            contenuto = null;
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()})));
                        n = stm.executeUpdate();
                        stm.close();
                        DriverRegistroServiziDB_LIB.log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addSelectField("ora_registrazione");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        DriverRegistroServiziDB_LIB.log.debug((Object)("Recupero idConnettore e oraRegistrazione inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()})));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        documenti.get(i).setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                        rs.close();
                        stm.close();
                    }
                    break;
                }
                case 2: {
                    oldLista = null;
                    try {
                        oldLista = DriverRegistroServiziDB_LIB.getListaDocumenti(idProprietario, tipologiaProprietarioDocumento, false, connection, tipoDatabase);
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {
                        oldLista = new ArrayList<E>();
                    }
                    for (i = 0; i < documenti.size(); ++i) {
                        doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        doc.setId(DriverRegistroServiziDB_LIB.getIdDocumento(doc.getFile(), doc.getTipo(), doc.getRuolo(), idProprietario, connection, DriverRegistroServiziDB_LIB.tipoDB, tipologiaProprietarioDocumento));
                        if (doc.getOraRegistrazione() == null) {
                            doc.setOraRegistrazione(new Date());
                        }
                        doc.setIdProprietarioDocumento(idProprietario);
                        documentoGiaPresente = false;
                        documentoDaAggiornare = false;
                        if (doc.getId() > 0L) {
                            for (j = 0; j < oldLista.size(); ++j) {
                                old = (Documento)oldLista.get(j);
                                if (doc.getId().longValue() != old.getId().longValue()) continue;
                                documentoGiaPresente = true;
                                if (doc.getOraRegistrazione() == null) {
                                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] OraRegistrazione non definita per documento, precedentemente gia inserito, [" + doc.getFile() + "]");
                                }
                                oldLista.remove(j);
                                if (!doc.getOraRegistrazione().after(old.getOraRegistrazione())) continue;
                                documentoDaAggiornare = true;
                            }
                        }
                        contenuto = null;
                        if (!documentoGiaPresente || documentoDaAggiornare) {
                            if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "]");
                            }
                            contenuto = doc.getByteContenuto();
                            if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                                contenuto = null;
                            }
                        }
                        if (documentoGiaPresente) {
                            if (!documentoDaAggiornare) continue;
                            idDocumento = doc.getId();
                            if (idDocumento <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] ID non definito per documento da aggiorare [" + doc.getFile() + "]");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addUpdateTable("documenti");
                            sqlQueryObject.addUpdateField("tipo", "?");
                            sqlQueryObject.addUpdateField("nome", "?");
                            sqlQueryObject.addUpdateField("contenuto", "?");
                            sqlQueryObject.addUpdateField("ora_registrazione", "?");
                            sqlQueryObject.addWhereCondition("id=?");
                            sqlQuery = sqlQueryObject.createSQLUpdate();
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, doc.getTipo());
                            stm.setString(2, doc.getFile());
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, 3, contenuto);
                            stm.setTimestamp(4, new Timestamp(doc.getOraRegistrazione().getTime()));
                            stm.setLong(5, idDocumento);
                            stm.executeUpdate();
                            stm.close();
                            continue;
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDDocumento UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()})));
                        n = stm.executeUpdate();
                        stm.close();
                        DriverRegistroServiziDB_LIB.log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        DriverRegistroServiziDB_LIB.log.debug((Object)("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()})));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        rs.close();
                        stm.close();
                    }
                    if (oldLista.size() <= 0) ** break;
                    for (j = 0; j < oldLista.size(); ++j) {
                        old = (Documento)oldLista.get(j);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("documenti");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, old.getId());
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 3: {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("documenti");
                    sqlQueryObject.addWhereCondition("id_proprietario=?");
                    sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, tipologiaProprietarioDocumento.toString());
                    stm.executeUpdate();
                    stm.close();
                    DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDDocumento DELETE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{idProprietario})));
                    break;
                }
                ** default:
lbl271:
                // 1 sources

                break;
            }
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static List<Documento> getListaDocumenti(long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return DriverRegistroServiziDB_LIB.getListaDocumenti(null, idProprietario, tipologiaProprietarioDocumento, readBytes, connection, tipoDatabase);
    }

    public static List<Documento> getListaDocumenti(String ruoloDocumenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Statement stm = null;
        ResultSet rs = null;
        if (idProprietario <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] id proprietario non definito");
        }
        try {
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (ruoloDocumenti != null) {
                sqlQueryObject.addWhereCondition("ruolo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, tipologiaProprietarioDocumento.toString());
            if (ruoloDocumenti != null) {
                stm.setString(3, ruoloDocumenti);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(rs.getLong("id"), readBytes, connection, tipoDatabase);
                documenti.add(doc);
            }
            if (documenti.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Documenti con ruolo[" + ruoloDocumenti + "] e idProprietario[" + idProprietario + "] non trovati");
            }
            ArrayList<Documento> arrayList = documenti;
            return arrayList;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] SQLException : " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound dnf) {
            throw dnf;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static Documento getDocumento(long id, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Statement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] id non definito");
        }
        try {
            IJDBCAdapter jdbcAdapter = null;
            if (readBytes) {
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("tipo");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addSelectField("ora_registrazione");
            sqlQueryObject.addSelectField("id");
            if (readBytes) {
                sqlQueryObject.addSelectField("contenuto");
            }
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            Documento doc = null;
            if (rs.next()) {
                doc = new Documento();
                doc.setRuolo(rs.getString("ruolo"));
                doc.setTipo(rs.getString("tipo"));
                doc.setFile(rs.getString("nome"));
                doc.setIdProprietarioDocumento(rs.getLong("id_proprietario"));
                doc.setTipoProprietarioDocumento(rs.getString("tipo_proprietario"));
                doc.setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                doc.setId(rs.getLong("id"));
                if (readBytes) {
                    doc.setByteContenuto(jdbcAdapter.getBinaryData(rs, 8));
                }
            }
            if (doc == null) {
                throw new DriverRegistroServiziNotFound("Documento con id[" + id + "] non trovato");
            }
            Documento documento = doc;
            return documento;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] SQLException : " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound dnf) {
            throw dnf;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDAccordoServizioParteComuneServizioComposto(int type, AccordoServizioParteComuneServizioComposto asServComposto, Connection con, long idAccordo) throws DriverRegistroServiziException {
        Statement updateStmt = null;
        Statement selectStmt = null;
        ResultSet selectRS = null;
        if (idAccordo <= 0L) {
            new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID Accordo non valido.");
        }
        if (asServComposto == null && (type == 1 || type == 2)) {
            new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Accordo Cooperazione non valido.");
        }
        try {
            switch (type) {
                case 1: {
                    long idAccordoCooperazione = -1L;
                    if (asServComposto.getIdAccordoCooperazione() != null) {
                        idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    }
                    if (asServComposto.getAccordoCooperazione() != null) {
                        idAccordoCooperazione = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(asServComposto.getAccordoCooperazione()), con, tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("acc_serv_composti");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setLong(2, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)"Aggiungo acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("acc_serv_composti");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    selectRS = updateStmt.executeQuery();
                    long idAccServComposto = -1L;
                    if (!selectRS.next()) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto inserito non recuperato.");
                    idAccServComposto = selectRS.getLong("id");
                    asServComposto.setId(idAccServComposto);
                    selectRS.close();
                    updateStmt.close();
                    int i = 0;
                    while (i < asServComposto.sizeServizioComponenteList()) {
                        AccordoServizioParteComuneServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            log.debug((Object)("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]"));
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)"Aggiunto acc servizio componente");
                        ++i;
                    }
                    return;
                }
                case 2: {
                    long idAccServComposto = asServComposto.getId();
                    if (idAccServComposto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito.");
                    }
                    long idAccordoCooperazione = -1L;
                    if (asServComposto.getIdAccordoCooperazione() != null) {
                        idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    }
                    if (asServComposto.getAccordoCooperazione() != null) {
                        idAccordoCooperazione = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(asServComposto.getAccordoCooperazione()), con, tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("acc_serv_composti");
                    sqlQueryObject.addUpdateField("id_accordo_cooperazione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)"Aggiornato acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    int i = 0;
                    while (i < asServComposto.sizeServizioComponenteList()) {
                        AccordoServizioParteComuneServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            log.debug((Object)("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]"));
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)"Aggiungo acc servizio componente");
                        ++i;
                    }
                    return;
                }
                case 3: {
                    String updateQuery;
                    ISQLQueryObject sqlQueryObject;
                    long idAccServComposto = -1L;
                    if (asServComposto != null) {
                        idAccServComposto = asServComposto.getId();
                        if (idAccServComposto <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito.");
                        }
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("acc_serv_composti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_accordo=?");
                        updateQuery = sqlQueryObject.createSQLQuery();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordo);
                        selectRS = updateStmt.executeQuery();
                        if (selectRS.next()) {
                            idAccServComposto = selectRS.getLong("id");
                        }
                        selectRS.close();
                        updateStmt.close();
                    }
                    if (idAccServComposto <= 0L) return;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_composti");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDAccordoCooperazione(int type, AccordoCooperazione accordoCooperazione, Connection con, String tipoDatabase) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Accordo di Cooperazione non valido.");
        }
        String nome = accordoCooperazione.getNome();
        String descrizione = accordoCooperazione.getDescrizione();
        String stato = accordoCooperazione.getStatoPackage();
        boolean privato = accordoCooperazione.getPrivato() != null && accordoCooperazione.getPrivato() != false;
        String superUser = accordoCooperazione.getSuperUser();
        if (nome == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Parametro Nome non valido.");
        if (nome.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Parametro Nome non valido.");
        }
        Statement updateStmt = null;
        ResultSet updateRS = null;
        try {
            switch (type) {
                case 1: {
                    Documento doc;
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("accordi_cooperazione");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("versione", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        sqlQueryObject.addInsertField("id_referente", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    if (accordoCooperazione.getVersione() != null && !"".equals(accordoCooperazione.getVersione())) {
                        updateStmt.setString(3, accordoCooperazione.getVersione());
                    } else {
                        updateStmt.setString(3, "");
                    }
                    if (privato) {
                        updateStmt.setInt(4, 1);
                    } else {
                        updateStmt.setInt(4, 0);
                    }
                    updateStmt.setString(5, superUser);
                    int index = 6;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idReferente = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, tipoDB);
                        if (idReferente <= 0L) {
                            throw new DriverRegistroServiziException("Soggetto Referente [" + accordoCooperazione.getSoggettoReferente().getTipo() + "/" + accordoCooperazione.getSoggettoReferente().getNome() + "] non trovato");
                        }
                        updateStmt.setLong(index, idReferente);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione)));
                    log.debug((Object)("CRUDAccordoServizioParteSpecifica type = " + type + " row affected =" + n));
                    IDAccordoCooperazione idAccordoObject = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(accordoCooperazione.getNome(), accordoCooperazione.getVersione());
                    long idAccordoCooperazione = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(idAccordoObject, con, tipoDB);
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] non riesco a trovare l'id del'Accordo inserito");
                    }
                    accordoCooperazione.setId(idAccordoCooperazione);
                    if (accordoCooperazione.getElencoPartecipanti() != null) {
                        AccordoCooperazionePartecipanti partecipanti = accordoCooperazione.getElencoPartecipanti();
                        for (i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                            IdSoggetto soggettoPartecipante = partecipanti.getSoggettoPartecipante(i);
                            long idSoggettoPartecipante = -1L;
                            if (idSoggettoPartecipante <= 0L) {
                                log.debug((Object)("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]"));
                                if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                    idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, tipoDB);
                                }
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                            sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idAccordoCooperazione);
                            updateStmt.setLong(2, idSoggettoPartecipante);
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            log.debug((Object)("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n));
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    i = 0;
                    while (true) {
                        if (i >= accordoCooperazione.sizeSpecificaSemiformaleList()) {
                            DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idAccordoCooperazione, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                            return;
                        }
                        doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                        ++i;
                    }
                }
                case 2: {
                    int i;
                    IDAccordoCooperazione idAccordoAttualeInseritoDB = null;
                    idAccordoAttualeInseritoDB = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(accordoCooperazione);
                    long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(idAccordoAttualeInseritoDB, con, tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("accordi_cooperazione");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("versione", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("id_referente", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    if (accordoCooperazione.getVersione() != null && !"".equals(accordoCooperazione.getVersione())) {
                        updateStmt.setString(3, accordoCooperazione.getVersione());
                    } else {
                        updateStmt.setString(3, "");
                    }
                    if (privato) {
                        updateStmt.setInt(4, 1);
                    } else {
                        updateStmt.setInt(4, 0);
                    }
                    updateStmt.setString(5, superUser);
                    int index = 6;
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idSRef = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, tipoDB);
                        updateStmt.setLong(index, idSRef);
                    } else {
                        updateStmt.setLong(index, 0L);
                    }
                    ++index;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    updateStmt.setLong(index, idAccordoLong);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoCooperazione type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    if (accordoCooperazione.getElencoPartecipanti() != null) {
                        AccordoCooperazionePartecipanti partecipanti = accordoCooperazione.getElencoPartecipanti();
                        for (int i2 = 0; i2 < partecipanti.sizeSoggettoPartecipanteList(); ++i2) {
                            IdSoggetto soggettoPartecipante = partecipanti.getSoggettoPartecipante(i2);
                            Long idSoggettoPartecipante = -1L;
                            if (idSoggettoPartecipante == null || idSoggettoPartecipante <= 0L) {
                                log.debug((Object)("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]"));
                                if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                    idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, tipoDB);
                                }
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                            }
                            if (idSoggettoPartecipante <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                            sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idAccordoLong);
                            updateStmt.setLong(2, idSoggettoPartecipante);
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            log.debug((Object)("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n));
                        }
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        Documento doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    i = 0;
                    while (true) {
                        if (i >= accordoCooperazione.sizeSpecificaSemiformaleList()) {
                            DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                            return;
                        }
                        Documento doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                        ++i;
                    }
                }
                case 3: {
                    IDAccordoCooperazione idAccordo = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(nome, accordoCooperazione.getVersione());
                    long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(idAccordo, con, tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoCooperazione, con, tipoDatabase);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_cooperazione");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (updateRS != null) {
                    updateRS.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static ISQLQueryObject getSQLRicercaAccordiValidi() throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addWhereExistsCondition(false, DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidi("accordi.id", false));
        return sqlQueryObject;
    }

    public static ISQLQueryObject getSQLRicercaServiziValidiByIdAccordo(boolean isErogazione) throws Exception {
        return DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidi("?", isErogazione);
    }

    private static ISQLQueryObject getSQLRicercaServiziValidi(String idAccordo, boolean isErogazione) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlQueryObject.addFromTable("port_type");
        sqlQueryObject.addWhereCondition("port_type.id_accordo=" + idAccordo);
        ISQLQueryObject sqlQueryObjectExistsAlmenoUnAzione = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlQueryObjectExistsAlmenoUnAzione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAlmenoUnAzione.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsAlmenoUnAzione);
        ISQLQueryObject sqlQueryServiziValidi = DriverRegistroServiziDB_LIB.getSQLIndividuazioneServiziValidi(tipoDB, isErogazione);
        sqlQueryObject.addWhereCondition("( " + sqlQueryServiziValidi.createSQLConditions() + " )");
        sqlQueryObject.setANDLogicOperator(true);
        return sqlQueryObject;
    }

    public static ISQLQueryObject getSQLIndividuazioneServiziValidi(String tipoDatabase, boolean isErogazione) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObject.addWhereCondition("port_type.profilo_collaborazione='oneway'");
        sqlQueryObject.addWhereCondition("port_type.profilo_collaborazione='sincrono'");
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRichiesta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRichiesta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.correlata_servizio is null");
        sqlQueryObjectExistsAsinAsimRichiesta.addWhereCondition("port_type_azioni.correlata is null");
        sqlQueryObjectExistsAsinAsimRichiesta.setANDLogicOperator(true);
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRisposta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRisposta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata_servizio is not null");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata_servizio=port_type.nome");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereCondition("port_type_azioni.correlata is not null");
        ISQLQueryObject sqlQueryObjectExistsAsinAsimRisposta_checkCorrelata = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinAsimRisposta_checkCorrelata.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinAsimRisposta_checkCorrelata.addSelectField("port_type_azioni", "nome");
        sqlQueryObjectExistsAsinAsimRisposta_checkCorrelata.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinAsimRisposta.addWhereINSelectSQLCondition(false, "port_type_azioni.correlata", sqlQueryObjectExistsAsinAsimRisposta_checkCorrelata);
        sqlQueryObjectExistsAsinAsimRisposta.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoAsimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinAsimRichiesta), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinAsimRisposta)});
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiesta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinSimRichiesta.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.correlata_servizio is null");
        sqlQueryObjectExistsAsinSimRichiesta.addWhereCondition("port_type_azioni.correlata is null");
        sqlQueryObjectExistsAsinSimRichiesta.setANDLogicOperator(true);
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        String PORT_TYPE_ALIAS_RICERCA = "ptRicerca2";
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addFromTable("port_type as " + PORT_TYPE_ALIAS_RICERCA);
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA + ".id_accordo=" + "port_type" + ".id_accordo");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA + ".profilo_collaborazione='asincronoSimmetrico'");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA + ".nome <> " + "port_type" + ".nome");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition("port_type_azioni.id_port_type=" + PORT_TYPE_ALIAS_RICERCA + ".id");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition("port_type_azioni.correlata_servizio is not null");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition("port_type_azioni.correlata_servizio=port_type.nome");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereCondition("port_type_azioni.correlata is not null");
        ISQLQueryObject sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione_checkAzione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione_checkAzione.addFromTable("port_type_azioni");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione_checkAzione.addSelectField("port_type_azioni", "nome");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione_checkAzione.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.addWhereINSelectSQLCondition(false, "port_type_azioni.correlata", sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione_checkAzione);
        sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoSimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRichiesta), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRichiesta_checkCorrelazione)});
        if (!isErogazione) {
            ISQLQueryObject sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            String PORT_TYPE_ALIAS_RICERCA_AS = "ptRicerca2";
            String PORT_TYPE_AZIONI_ALIAS_RICERCA_AS = "ptAzioniRicerca2";
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addFromTable("port_type as " + PORT_TYPE_ALIAS_RICERCA_AS);
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addFromTable("port_type_azioni as " + PORT_TYPE_AZIONI_ALIAS_RICERCA_AS);
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA_AS + ".id_accordo=" + "port_type" + ".id_accordo");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA_AS + ".profilo_collaborazione='asincronoSimmetrico'");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA_AS + ".nome <> " + "port_type" + ".nome");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_AZIONI_ALIAS_RICERCA_AS + ".id_port_type=" + PORT_TYPE_ALIAS_RICERCA_AS + ".id");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_AZIONI_ALIAS_RICERCA_AS + ".correlata_servizio is null");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_ALIAS_RICERCA_AS + ".nome=" + "port_type_azioni" + ".correlata_servizio");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_AZIONI_ALIAS_RICERCA_AS + ".correlata is null");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.addWhereCondition(PORT_TYPE_AZIONI_ALIAS_RICERCA_AS + ".nome=" + "port_type_azioni" + ".correlata");
            sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectExistsAsinSimRisposta = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectExistsAsinSimRisposta.addFromTable("port_type_azioni");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.correlata is not null");
            sqlQueryObjectExistsAsinSimRisposta.addWhereCondition("port_type_azioni.correlata_servizio is not null");
            sqlQueryObjectExistsAsinSimRisposta.addWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRisposta_checkCorrelazione);
            sqlQueryObjectExistsAsinSimRisposta.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(true, new String[]{"port_type.profilo_collaborazione='asincronoSimmetrico'", sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectExistsAsinSimRisposta)});
        }
        sqlQueryObject.setANDLogicOperator(false);
        return sqlQueryObject;
    }

    public static long getIdPortaDominio(String nome, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPdD = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPdD = rs.getLong("id");
            }
            long l = idPdD;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws CoreException {
        return DriverRegistroServiziDB_LIB.getIdAccordo(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordo = -1L;
        try {
            long idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = rs.getLong("id_accordo");
            }
            long l = idAccordo;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdPortType(Long idAccordo, String nomePortType, Connection con) throws CoreException {
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long id = -1L;
        try {
            String selectQuery = "SELECT id FROM port_type WHERE id_accordo = ? AND nome=?";
            selectStmt = con.prepareStatement(selectQuery);
            selectStmt.setLong(1, idAccordo);
            selectStmt.setString(2, nomePortType);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                id = selectRS.getLong("id");
            }
            selectRS.close();
            selectStmt.close();
            long l = id;
            return l;
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdAccordoServizioParteComune(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException, DriverRegistroServiziNotFound {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (IDAccordoFactory.getInstance().versioneNonDefinita(idAccordo.getVersione())) {
                sqlQueryObject.addWhereCondition(false, new String[]{"versione = ?", "versione is null"});
            } else {
                sqlQueryObject.addWhereCondition("versione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = 0L;
            if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                throw new DriverRegistroServiziNotFound("[getIdAccordoServizio] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            String vers = "";
            if (idAccordo.getVersione() != null) {
                vers = idAccordo.getVersione();
            }
            stm.setString(3, vers);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdAccordoCooperazione(IDAccordoCooperazione idAccordo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            if (IDAccordoFactory.getInstance().versioneNonDefinita(idAccordo.getVersione())) {
                sqlQueryObject.addWhereCondition(false, new String[]{"versione = ?", "versione is null"});
            } else {
                sqlQueryObject.addWhereCondition("versione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            String vers = "";
            if (idAccordo.getVersione() != null) {
                vers = idAccordo.getVersione();
            }
            stm.setString(2, vers);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdAccordoServizioParteSpecifica(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("aps_nome = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("aps_versione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB);
            if (idSoggettoReferente <= 0L) {
                throw new CoreException("[getIdAccordoServizio] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            stm.setString(3, idAccordo.getVersione());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdDocumento(String nome, String tipo, String ruolo, long idProprietario, Connection con, String tipoDB, ProprietariDocumento tipoProprietario) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idDoc = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("tipo = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, nome);
            stm.setString(3, tipo);
            stm.setString(4, ruolo);
            stm.setString(5, tipoProprietario.toString());
            rs = stm.executeQuery();
            if (rs.next()) {
                idDoc = rs.getLong("id");
            }
            rs.close();
            stm.close();
            long l = idDoc;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

