/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.IDriverWS;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDAccordoCooperazioneWithSoggetto;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Servizio;
import org.openspcoop2.core.registry.ServizioAzione;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.ConnettorePropertiesUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    public DataSource datasource = null;
    private Connection globalConnection = null;
    private boolean atomica = true;
    String tabellaSoggetti = "soggetti";
    private Logger log = null;
    private String tipoDB = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public String getTipoDB() {
        return this.tipoDB;
    }

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, String tipoDB) {
        this(nomeDataSource, prop, null, tipoDB);
    }

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, Logger alog, String tipoDB) {
        try {
            if (alog == null) {
                this.log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
            } else {
                this.log = alog;
                DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
            }
            this.log.info((Object)"Inizializzo DriverRegistroServiziDB..");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource != null) {
                this.create = true;
            }
            initCtx.close();
        }
        catch (NamingException ne) {
            this.log.error((Object)("Eccezione acquisendo il datasource: " + ne.getMessage()), (Throwable)ne);
            this.create = false;
        }
        if (tipoDB == null) {
            this.log.error((Object)"Il tipoDatabase non puo essere null.");
            this.create = false;
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, String tipoDB) throws DriverRegistroServiziException {
        this(connection, null, tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, Logger alog, String tipoDB) throws DriverRegistroServiziException {
        if (alog == null) {
            this.log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
        } else {
            this.log = alog;
            DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
        }
        if (connection == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    public List<List<Object>> readCustom(ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            List<List<Object>> list = DBUtils.readCustom(this.log, con, this.tipoDB, sqlQueryObject, returnTypes, paramTypes);
            return list;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readCustom]: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(idAccordo, false);
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug((Object)("richiesto getAccordoCooperazione: " + idAccordo.toString()));
        AccordoCooperazione accordoCooperazione = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm2 = null;
        ResultSet rs2 = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(idAccordo, con, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] Accordo non trovato (id:" + idAccordoLong + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            rs = stm.executeQuery();
            if (rs.next()) {
                accordoCooperazione = new AccordoCooperazione();
                accordoCooperazione.setId(rs.getLong("id"));
                String tmp = rs.getString("nome");
                accordoCooperazione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                accordoCooperazione.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(new Long(rs.getInt("id_referente")), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    accordoCooperazione.setSoggettoReferente(assr);
                }
                if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                    accordoCooperazione.setVersione(rs.getString("versione"));
                }
                accordoCooperazione.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    accordoCooperazione.setPrivato(true);
                } else {
                    accordoCooperazione.setPrivato(false);
                }
                tmp = rs.getString("superuser");
                accordoCooperazione.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoCooperazione.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
                rs = stm.executeQuery();
                while (rs.next()) {
                    IDSoggetto soggettoReferente;
                    long idAccServizioComposto = rs.getLong("id_accordo");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addSelectField("versione");
                    sqlQueryObject.addSelectField("id_referente");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idAccServizioComposto);
                    rs2 = stm2.executeQuery();
                    if (rs2.next()) {
                        soggettoReferente = null;
                        if (rs2.getLong("id_referente") > 0L) {
                            Soggetto s = this.getSoggetto(rs2.getLong("id_referente"));
                            soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                        }
                    } else {
                        throw new DriverRegistroServiziException("IDAccordo con id [" + rs.getLong("id_accordo_servizio") + "] non presente");
                    }
                    String uriAccordo = this.idAccordoFactory.getUriFromValues(rs2.getString("nome"), soggettoReferente, rs2.getString("versione"));
                    accordoCooperazione.addUriServiziComposti(uriAccordo);
                    rs2.close();
                    stm2.close();
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
                rs = stm.executeQuery();
                IdSoggetto accCompPartecipante = null;
                AccordoCooperazionePartecipanti accCopPartecipanti = null;
                while (rs.next()) {
                    accCompPartecipante = new IdSoggetto();
                    accCompPartecipante.setIdSoggetto(rs.getLong("id_soggetto"));
                    Soggetto s = this.getSoggetto(rs.getLong("id_soggetto"), con);
                    accCompPartecipante.setTipo(s.getTipo());
                    accCompPartecipante.setNome(s.getNome());
                    if (accCopPartecipanti == null) {
                        accCopPartecipanti = new AccordoCooperazionePartecipanti();
                        accordoCooperazione.setElencoPartecipanti(accCopPartecipanti);
                    }
                    accordoCooperazione.getElencoPartecipanti().addSoggettoPartecipante(accCompPartecipante);
                }
                rs.close();
                stm.close();
                try {
                    List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.tipoDB);
                    for (int i = 0; i < allegati.size(); ++i) {
                        accordoCooperazione.addAllegato(allegati.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound dNotFound) {
                    // empty catch block
                }
                try {
                    List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.tipoDB);
                    for (int i = 0; i < specificheSemiformali.size(); ++i) {
                        accordoCooperazione.addSpecificaSemiformale(specificheSemiformali.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound dNotFound) {}
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            AccordoCooperazione accordoCooperazione2 = accordoCooperazione;
            return accordoCooperazione2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDAccordoCooperazioneWithSoggetto getIdAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoCooperazione(id, null);
    }

    public IDAccordoCooperazioneWithSoggetto getIdAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getIdAccordoCooperazione: " + id));
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazioneWithSoggetto idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L && (referente = this.getIdSoggetto(idReferente, con)) == null) {
                    throw new Exception("Soggetto referente non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDAccordoCooperazione idAccordoCoop = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            idAccordo = new IDAccordoCooperazioneWithSoggetto(idAccordoCoop);
            idAccordo.setSoggettoReferente(referente);
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordo;
    }

    public AccordoCooperazione getAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(id, null);
    }

    public AccordoCooperazione getAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getAccordoCooperazione: " + id));
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazione idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return this.getAccordoCooperazione(idAccordo);
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiCooperazione...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
            }
            sqlQueryObject.addSelectField("accordi_cooperazione", "nome");
            sqlQueryObject.addSelectField("accordi_cooperazione", "versione");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione < ?");
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.nome = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.versione = ?");
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.id_referente=" + this.tabellaSoggetti + ".id");
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    this.log.debug((Object)("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.log.debug((Object)("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        this.log.debug((Object)("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        this.log.debug((Object)("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            while (rs.next()) {
                IDAccordoCooperazione idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordoCooperazione> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDServizio tupe=1");
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(1, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Errore durante la creazione dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoCooperazione(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(2, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Errore durante l'update dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDServizio type = 3");
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(3, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Errore durante la delete dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(idAccordo, false);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug((Object)("richiesto getAccordoServizioParteComune: " + idAccordo.toString()));
        AccordoServizioParteComune accordoServizio = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] Accordo non trovato (id:" + idAccordo + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            rs = stm.executeQuery();
            if (rs.next()) {
                int i;
                accordoServizio = new AccordoServizioParteComune();
                accordoServizio.setId(rs.getLong("id"));
                String tmp = rs.getString("nome");
                accordoServizio.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                accordoServizio.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                accordoServizio.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                if (accordoServizio.getProfiloCollaborazione() == null) {
                    accordoServizio.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
                }
                accordoServizio.setByteWsdlDefinitorio((tmp = rs.getString("wsdl_definitorio")) == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_concettuale");
                accordoServizio.setByteWsdlConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_logico_erogatore");
                accordoServizio.setByteWsdlLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_logico_fruitore");
                accordoServizio.setByteWsdlLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_concettuale");
                accordoServizio.setByteSpecificaConversazioneConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_erogatore");
                accordoServizio.setByteSpecificaConversazioneErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_fruitore");
                accordoServizio.setByteSpecificaConversazioneFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                accordoServizio.setUtilizzoSenzaAzione(rs.getInt("utilizzo_senza_azione") == 1);
                tmp = rs.getString("filtro_duplicati");
                accordoServizio.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                accordoServizio.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                accordoServizio.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                accordoServizio.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                accordoServizio.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("superuser");
                accordoServizio.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    accordoServizio.setPrivato(true);
                } else {
                    accordoServizio.setPrivato(false);
                }
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoServizio.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if (rs.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(new Long(rs.getInt("id_referente")), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    assr.setId(soggRef.getId());
                    accordoServizio.setSoggettoReferente(assr);
                }
                if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                    accordoServizio.setVersione(rs.getString("versione"));
                }
                accordoServizio.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
                rs = stm.executeQuery();
                Azione azione = null;
                while (rs.next()) {
                    azione = new Azione();
                    tmp = rs.getString("conferma_ricezione");
                    azione.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("consegna_in_ordine");
                    azione.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("filtro_duplicati");
                    azione.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("identificativo_collaborazione");
                    azione.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("nome");
                    azione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("scadenza");
                    azione.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("profilo_collaborazione");
                    azione.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("correlata");
                    azione.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("profilo_azione");
                    if (tmp == null || tmp.equals("")) {
                        azione.setProfAzione("default");
                    } else {
                        azione.setProfAzione(tmp);
                    }
                    long idAzione = rs.getLong("id");
                    azione.setId(idAzione);
                    accordoServizio.addAzione(azione);
                }
                rs.close();
                stm.close();
                this.readPortTypes(accordoServizio, con);
                this.readAccordoServizioComposto(accordoServizio, con);
                try {
                    List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                    for (i = 0; i < allegati.size(); ++i) {
                        accordoServizio.addAllegato(allegati.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound dNotFound) {
                    // empty catch block
                }
                try {
                    List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                    for (i = 0; i < specificheSemiformali.size(); ++i) {
                        accordoServizio.addSpecificaSemiformale(specificheSemiformali.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound dNotFound) {
                    // empty catch block
                }
                if (accordoServizio.getServizioComposto() != null) {
                    try {
                        List<Documento> specificheCoordinamento = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaCoordinamento.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                        for (i = 0; i < specificheCoordinamento.size(); ++i) {
                            accordoServizio.getServizioComposto().addSpecificaCoordinamento(specificheCoordinamento.get(i));
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {}
                }
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            AccordoServizioParteComune accordoServizioParteComune = accordoServizio;
            return accordoServizioParteComune;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComune] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void readPortTypes(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (as.getId() == null || as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId())));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortType pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(as.getId());
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                as.addPortType(pt);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void readAzioniPortTypes(PortType pt, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (pt.getId() == null || pt.getId() <= 0L) {
                throw new Exception("Port Type id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, pt.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, pt.getId())));
            rs = stm.executeQuery();
            Operation azionePT = null;
            while (rs.next()) {
                azionePT = new Operation();
                String tmp = rs.getString("conferma_ricezione");
                azionePT.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                azionePT.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                azionePT.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                azionePT.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("nome");
                azionePT.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azionePT.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azionePT.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("correlata_servizio");
                azionePT.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata");
                azionePT.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    azionePT.setProfAzione("default");
                } else {
                    azionePT.setProfAzione(tmp);
                }
                tmp = rs.getString("soap_style");
                azionePT.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("soap_action");
                azionePT.setSoapAction(tmp == null || tmp.equals("") ? null : tmp);
                azionePT.setIdPortType(pt.getId());
                long idAzionePortType = rs.getLong("id");
                azionePT.setId(idAzionePortType);
                this.readMessagesAzioniPortTypes(azionePT, con);
                String msgInput = rs.getString("soap_use_msg_input");
                if (azionePT.getMessageInput() != null || msgInput != null) {
                    if (azionePT.getMessageInput() == null) {
                        azionePT.setMessageInput(new Message());
                    }
                    azionePT.getMessageInput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgInput == null || msgInput.equals("") ? null : msgInput));
                    tmp = rs.getString("soap_namespace_msg_input");
                    azionePT.getMessageInput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                String msgOutput = rs.getString("soap_use_msg_output");
                if (azionePT.getMessageOutput() != null || msgOutput != null) {
                    if (azionePT.getMessageOutput() == null) {
                        azionePT.setMessageOutput(new Message());
                    }
                    azionePT.getMessageOutput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgOutput == null || msgOutput.equals("") ? null : msgOutput));
                    tmp = rs.getString("soap_namespace_msg_output");
                    azionePT.getMessageOutput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                pt.addAzione(azionePT);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readAzioniPortTypes] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void readMessagesAzioniPortTypes(Operation azionePT, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (azionePT.getId() == null || azionePT.getId() <= 0L) {
                throw new Exception("Port Type azione id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("operation_messages");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, azionePT.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, azionePT.getId())));
            rs = stm.executeQuery();
            Message messageInputPart = null;
            Message messageOutputPart = null;
            while (rs.next()) {
                boolean isInputMessage = false;
                if (rs.getInt("input_message") == 1) {
                    isInputMessage = true;
                }
                MessagePart part = new MessagePart();
                String name = rs.getString("name");
                name = name == null || name.equals("") ? null : name;
                part.setName(name);
                String elementName = rs.getString("element_name");
                elementName = elementName == null || elementName.equals("") ? null : elementName;
                part.setElementName(elementName);
                String elementNamespace = rs.getString("element_namespace");
                elementNamespace = elementNamespace == null || elementNamespace.equals("") ? null : elementNamespace;
                part.setElementNamespace(elementNamespace);
                String typeName = rs.getString("type_name");
                typeName = typeName == null || typeName.equals("") ? null : typeName;
                part.setTypeName(typeName);
                String typeNamespace = rs.getString("type_namespace");
                typeNamespace = typeNamespace == null || typeNamespace.equals("") ? null : typeNamespace;
                part.setTypeNamespace(typeNamespace);
                long idMessage = rs.getLong("id");
                part.setId(idMessage);
                if (isInputMessage) {
                    if (messageInputPart == null) {
                        messageInputPart = new Message();
                    }
                    messageInputPart.addPart(part);
                    continue;
                }
                if (messageOutputPart == null) {
                    messageOutputPart = new Message();
                }
                messageOutputPart.addPart(part);
            }
            if (messageInputPart != null) {
                azionePT.setMessageInput(messageInputPart);
            }
            if (messageOutputPart != null) {
                azionePT.setMessageOutput(messageOutputPart);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readMessagesAzioniPortTypes] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void readAccordoServizioComposto(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm2 = null;
        ResultSet rs2 = null;
        String sqlQuery = null;
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            if (as.getId() == null || as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId())));
            rs = stm.executeQuery();
            AccordoServizioParteComuneServizioComposto asComposto = null;
            if (rs.next()) {
                asComposto = new AccordoServizioParteComuneServizioComposto();
                asComposto.setId(rs.getLong("id"));
                asComposto.setIdAccordoCooperazione(rs.getLong("id_accordo_cooperazione"));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("versione");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm2 = con.prepareStatement(sqlQuery);
                stm2.setLong(1, rs.getLong("id_accordo_cooperazione"));
                rs2 = stm2.executeQuery();
                if (!rs2.next()) {
                    throw new DriverRegistroServiziException("IDAccordoCooperazione con id [" + rs.getLong("id_accordo_cooperazione") + "] non presente");
                }
                String uriAccordo = this.idAccordoCooperazioneFactory.getUriFromValues(rs2.getString("nome"), rs2.getString("versione"));
                asComposto.setAccordoCooperazione(uriAccordo);
                rs2.close();
                stm2.close();
            }
            rs.close();
            stm.close();
            if (asComposto != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_composto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, asComposto.getId());
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, asComposto.getId())));
                rs = stm.executeQuery();
                while (rs.next()) {
                    AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                    asComponente.setIdServizioComponente(rs.getLong("id_servizio_componente"));
                    asComponente.setAzione(rs.getString("azione"));
                    AccordoServizioParteSpecifica aspsServizioComponente = this.getAccordoServizioParteSpecifica((long)asComponente.getIdServizioComponente(), con);
                    Servizio servizioComponente = aspsServizioComponente.getServizio();
                    asComponente.setTipo(servizioComponente.getTipo());
                    asComponente.setNome(servizioComponente.getNome());
                    asComponente.setTipoSoggetto(servizioComponente.getTipoSoggettoErogatore());
                    asComponente.setNomeSoggetto(servizioComponente.getNomeSoggettoErogatore());
                    asComposto.addServizioComponente(asComponente);
                }
                rs.close();
                stm.close();
                as.setServizioComposto(asComposto);
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] SQLException :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiServizioParteComune...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
            }
            sqlQueryObject.addSelectField("accordi", "nome");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("accordi", "id_referente");
            if (filtroRicerca != null) {
                ISQLQueryObject sqlQueryObjectASComposti;
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione < ?");
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi.id_referente=" + this.tabellaSoggetti + ".id");
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                    }
                }
                if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addFromTable("accordi_cooperazione");
                    sqlQueryObjectASComposti.addSelectField("acc_serv_composti.id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.id=acc_serv_composti.id_accordo_cooperazione");
                    if (filtroRicerca.getIdAccordoCooperazione().getNome() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.nome=?");
                    }
                    if (filtroRicerca.getIdAccordoCooperazione().getVersione() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.versione=?");
                    }
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectASComposti);
                } else if (filtroRicerca.isServizioComposto() != null) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addSelectField("id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObject.addWhereExistsCondition(filtroRicerca.isServizioComposto() == false, sqlQueryObjectASComposti);
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    this.log.debug((Object)("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.log.debug((Object)("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        this.log.debug((Object)("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        this.log.debug((Object)("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                        ++indexStmt;
                    }
                }
                if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                    if (filtroRicerca.getIdAccordoCooperazione().getNome() != null) {
                        this.log.debug((Object)("nomeAccordoCooperazione stmt.setString(" + filtroRicerca.getIdAccordoCooperazione().getNome() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getIdAccordoCooperazione().getNome());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getIdAccordoCooperazione().getVersione() != null) {
                        this.log.debug((Object)("versioneAccordoCooperazione stmt.setString(" + filtroRicerca.getIdAccordoCooperazione().getVersione() + ")"));
                        stm.setString(indexStmt, filtroRicerca.getIdAccordoCooperazione().getVersione());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            while (rs.next()) {
                long idReferente = rs.getLong("id_referente");
                IDSoggetto idSoggettoReferente = null;
                if (idReferente > 0L) {
                    Soggetto soggettoReferente = this.getSoggetto(idReferente, con);
                    if (soggettoReferente == null) {
                        throw new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("nome") + "] (versione [" + rs.getString("versione") + "]) non presente?");
                    }
                    idSoggettoReferente = new IDSoggetto(soggettoReferente.getTipo(), soggettoReferente.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), idSoggettoReferente, rs.getString("versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordo> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteComune error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replaceAll("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replaceAll("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replaceAll("\n", "")) ? conversazioneFruitore : null;
        String sqlQuery = "";
        Connection connection = null;
        Statement stm = null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizioParteComune] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            Documento doc;
            int i;
            IDAccordo idAccordoObject;
            long idAccordo;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addInsertTable("accordi");
            sqlQueryObject.addInsertField("conferma_ricezione", "?");
            sqlQueryObject.addInsertField("consegna_in_ordine", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("filtro_duplicati", "?");
            sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("profilo_collaborazione", "?");
            sqlQueryObject.addInsertField("scadenza", "?");
            sqlQueryObject.addInsertField("wsdl_concettuale", "?");
            sqlQueryObject.addInsertField("wsdl_definitorio", "?");
            sqlQueryObject.addInsertField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addInsertField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addInsertField("spec_conv_concettuale", "?");
            sqlQueryObject.addInsertField("spec_conv_erogatore", "?");
            sqlQueryObject.addInsertField("spec_conv_fruitore", "?");
            sqlQueryObject.addInsertField("superuser", "?");
            sqlQueryObject.addInsertField("utilizzo_senza_azione", "?");
            sqlQueryObject.addInsertField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addInsertField("stato", "?");
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                sqlQueryObject.addInsertField("id_referente", "?");
            }
            sqlQueryObject.addInsertField("versione", "?");
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addInsertField("ora_registrazione", "?");
            }
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = connection.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, wsdlConcettuale != null && !wsdlConcettuale.trim().equals("") ? wsdlConcettuale : null);
            stm.setString(index++, wsdlDefinitorio != null && !wsdlDefinitorio.trim().equals("") ? wsdlDefinitorio : null);
            stm.setString(index++, wsdlLogicoErogatore != null && !wsdlLogicoErogatore.trim().equals("") ? wsdlLogicoErogatore : null);
            stm.setString(index++, wsdlLogicoFruitore != null && !wsdlLogicoFruitore.trim().equals("") ? wsdlLogicoFruitore : null);
            stm.setString(index++, conversazioneConcettuale != null && !conversazioneConcettuale.trim().equals("") ? conversazioneConcettuale : null);
            stm.setString(index++, conversazioneErogatore != null && !conversazioneErogatore.trim().equals("") ? conversazioneErogatore : null);
            stm.setString(index++, conversazioneFruitore != null && !conversazioneFruitore.trim().equals("") ? conversazioneFruitore : null);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index, accordoServizio.getStatoPackage());
                ++index;
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idReferente = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                if (idReferente <= 0L) {
                    throw new DriverRegistroServiziException("Soggetto Referente [" + accordoServizio.getSoggettoReferente().getTipo() + "/" + accordoServizio.getSoggettoReferente().getNome() + "] non trovato");
                }
                stm.setLong(index, idReferente);
                ++index;
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(index, accordoServizio.getVersione());
            } else {
                stm.setString(index, "");
            }
            ++index;
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
                ++index;
            }
            this.log.debug((Object)("inserisco accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, accordoServizio.getUtilizzoSenzaAzione(), accordoServizio.getPrivato() != null && accordoServizio.getPrivato() != false)));
            stm.executeUpdate();
            stm.close();
            IDSoggetto soggettoReferente = null;
            if (accordoServizio.getSoggettoReferente() != null) {
                soggettoReferente = new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome());
            }
            if ((idAccordo = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordoObject = this.idAccordoFactory.getIDAccordoFromValues(accordoServizio.getNome(), soggettoReferente, accordoServizio.getVersione()), connection, this.tipoDB)) <= 0L) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] non riesco a trovare l'id del'Accordo inserito");
            }
            accordoServizio.setId(idAccordo);
            Azione azione = null;
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                azione = accordoServizio.getAzione(i2);
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordo);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizeAzioneList() + " azioni relative all'accordo :" + nome + " id :" + idAccordo));
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordo);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordo));
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordo);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idAccordo, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
        }
        catch (SQLException se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] SQLException [" + se.getMessage() + "].", se);
        }
        catch (DriverRegistroServiziException e) {
            error = true;
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] Exception [" + e.getMessage() + "].", e);
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            if (idAccordo.getSoggettoReferente() != null && !this.existsSoggetto(idAccordo.getSoggettoReferente())) {
                boolean e = false;
                return e;
            }
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComune(long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            rs = stm.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneAzione(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComuneAzione(nome, DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneAzione(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComuneAzione(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttype(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComunePorttype(nome, DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneOperation(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneOperation] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttype(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttypeOperation(String nome, IDPortType idPortType) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            long idAccordo = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idPortType.getIdAccordo(), connection, this.tipoDB);
            boolean bl = this.existsAccordoServizioParteComunePorttypeOperation(nome, DriverRegistroServiziDB_LIB.getIdPortType(idAccordo, idPortType.getNome(), connection));
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComunePorttypeOperation(String nome, long idPortType) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idPortType);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replaceAll("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replaceAll("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replaceAll("\n", "")) ? conversazioneFruitore : null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            Documento doc;
            int i;
            IDAccordo idAccordoAttualeInseritoDB = null;
            idAccordoAttualeInseritoDB = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            long idAccordoLong = -1L;
            try {
                idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, connection, this.tipoDB);
            }
            catch (Exception e) {
                if (accordoServizio.getOldIDAccordoForUpdate() != null) {
                    idAccordoAttualeInseritoDB = accordoServizio.getSoggettoReferente() != null ? this.idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome()), idAccordoAttualeInseritoDB.getVersione()) : this.idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), null, idAccordoAttualeInseritoDB.getVersione());
                    idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, connection, this.tipoDB);
                }
                throw e;
            }
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("accordi");
            sqlQueryObject.addUpdateField("conferma_ricezione", "?");
            sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addUpdateField("filtro_duplicati", "?");
            sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
            sqlQueryObject.addUpdateField("nome", "?");
            sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
            sqlQueryObject.addUpdateField("scadenza", "?");
            sqlQueryObject.addUpdateField("wsdl_concettuale", "?");
            sqlQueryObject.addUpdateField("wsdl_definitorio", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addUpdateField("spec_conv_concettuale", "?");
            sqlQueryObject.addUpdateField("spec_conv_erogatore", "?");
            sqlQueryObject.addUpdateField("spec_conv_fruitore", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("utilizzo_senza_azione", "?");
            sqlQueryObject.addUpdateField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addUpdateField("stato", "?");
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addUpdateField("ora_registrazione", "?");
            }
            sqlQueryObject.addUpdateField("id_referente", "?");
            sqlQueryObject.addUpdateField("versione", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connection.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, wsdlConcettuale);
            stm.setString(index++, wsdlDefinitorio);
            stm.setString(index++, wsdlLogicoErogatore);
            stm.setString(index++, wsdlLogicoFruitore);
            stm.setString(index++, conversazioneConcettuale);
            stm.setString(index++, conversazioneErogatore);
            stm.setString(index++, conversazioneFruitore);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index++, accordoServizio.getStatoPackage());
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index++, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idSRef = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                stm.setLong(index++, idSRef);
            } else {
                stm.setLong(index++, 0L);
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(index++, accordoServizio.getVersione());
            } else {
                stm.setString(index++, "");
            }
            stm.setLong(index++, idAccordoLong);
            this.log.debug((Object)("update accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, utilizzioSenzaAzione, idAccordoLong)));
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " azioni associate all'accordo " + idAccordoLong));
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                Azione azione = accordoServizio.getAzione(i2);
                String profiloAzione = azione.getProfAzione();
                if (profiloAzione != null && profiloAzione.equals("default")) {
                    azione.setProfiloCollaborazione(profiloCollaborazione);
                }
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordoLong);
            }
            this.log.debug((Object)("Inserite " + accordoServizio.sizeAzioneList() + " azioni associate all'accordo " + idAccordoLong));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            this.log.debug((Object)("Trovati " + idPT.size() + " port type..."));
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                Vector<Long> idPTAzione = new Vector<Long>();
                while (rs.next()) {
                    idPTAzione.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                this.log.debug((Object)("Trovati " + idPTAzione.size() + " port type azioni..."));
                while (idPTAzione.size() > 0) {
                    Long idPortTypeAzione = (Long)idPTAzione.remove(0);
                    this.log.debug((Object)("Eliminazione message con id[" + idPortTypeAzione + "]..."));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortTypeAzione);
                    n = stm.executeUpdate();
                    stm.close();
                    this.log.debug((Object)("Cancellate " + n + " messages di un'azione con id[" + idPortTypeAzione + "] del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
                }
                this.log.debug((Object)("Elimino port type azione del port types [" + idPortType + "]..."));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " port type associate all'accordo " + idAccordoLong));
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordoLong);
            }
            this.log.debug((Object)("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordoLong));
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
        }
        catch (SQLException se) {
            this.log.error((Object)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            this.log.error((Object)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void updatePortType(PortType portType) throws DriverRegistroServiziException {
        if (portType == null) {
            throw new DriverRegistroServiziException("Il port-type non puo' essere null.");
        }
        String nome = portType.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome del port-type non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        Statement updateStmt = null;
        ResultSet rs = null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::updatePortType] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            int i;
            AccordoServizioParteComune as = this.getAccordoServizioParteComune(portType.getIdAccordo(), connection);
            Operation azione = null;
            int n = 0;
            for (i = 0; i < portType.sizeAzioneList(); ++i) {
                azione = portType.getAzione(i);
                n = (int)((long)n + DriverRegistroServiziDB_LIB.CRUDAzionePortType(3, as, portType, azione, connection, portType.getId()));
            }
            this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + portType.getId() + "]"));
            for (i = 0; i < portType.sizeAzioneList(); ++i) {
                azione = portType.getAzione(i);
                DriverRegistroServiziDB_LIB.CRUDAzionePortType(1, as, portType, azione, connection, portType.getId());
            }
            DriverRegistroServiziDB_LIB.log.debug((Object)("inserite " + portType.sizeAzioneList() + " azioni relative al port type[" + portType.getNome() + "] id-porttype[" + portType.getId() + "]"));
        }
        catch (Exception se) {
            this.log.error((Object)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortType] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stm != null) {
                    stm.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::deleteAccordoServizioParteComune] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(nome, BeanUtilities.getSoggettoReferenteID(accordoServizio.getSoggettoReferente()), accordoServizio.getVersione());
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("delete azioni :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("cancellate " + n + " azioni."));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                Vector<Long> idPortTypeAzioni = new Vector<Long>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idPortTypeAzioni.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                while (idPortTypeAzioni.size() > 0) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, (Long)idPortTypeAzioni.remove(0));
                    n = stm.executeUpdate();
                    stm.close();
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug((Object)("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong));
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug((Object)("Cancellate " + n + " port type associate all'accordo " + idAccordoLong));
            DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            sqlQueryObject.addWhereCondition("id=?");
            updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug((Object)("delete accordoServizio :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong)));
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getPortaDominio: " + nomePdD));
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD is null");
        }
        if (nomePdD.trim().equals("")) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD non e' definito");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, nomePdD);
            rs = stm.executeQuery();
            PortaDominio pdd = null;
            if (rs.next()) {
                pdd = new PortaDominio();
                pdd.setId(rs.getLong("id"));
                pdd.setNome(rs.getString("nome"));
                pdd.setDescrizione(rs.getString("descrizione"));
                pdd.setImplementazione(rs.getString("implementazione"));
                pdd.setSubject(rs.getString("subject"));
                pdd.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
                pdd.setSuperUser(rs.getString("superuser"));
                if (rs.getTimestamp("ora_registrazione") != null) {
                    pdd.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getPortaDominio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, nomePdD));
            }
            PortaDominio portaDominio = pdd;
            return portaDominio;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                stm.close();
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdPorteDominio...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome = ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug((Object)("nome stmt.setString(" + filtroRicerca.getNome() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug((Object)("tipoPdd stmt.setString(" + filtroRicerca.getTipo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<String> nomiPdd = new Vector<String>();
            while (rs.next()) {
                nomiPdd.add(rs.getString("nome"));
            }
            if (nomiPdd.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
            }
            Vector<String> vector = nomiPdd;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDPortaDominio type = 1");
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(1, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (nome == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (nome.equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsPortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error((Object)"Errore durante verifica esistenza porta di dominio :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(2, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void updateTipoPortaDominio(String nomePdd, String tipo) throws DriverRegistroServiziException {
        if (nomePdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro non valido.");
        }
        if (tipo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro.tipo non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addUpdateTable("pdd");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo);
            stm.setString(2, nomePdd);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipo, nomePdd)));
            stm.executeUpdate();
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDSoggetto type = 3");
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(3, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Errore durante l'eliminazione della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro idSoggetto is null");
        }
        String nomeSogg = idSoggetto.getNome();
        String tipoSogg = idSoggetto.getTipo();
        if (nomeSogg == null || nomeSogg.trim().equals("") || tipoSogg == null || tipoSogg.trim().equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        }
        Soggetto soggetto = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            Connettore connettore;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeSogg);
            stm.setString(2, tipoSogg);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg)));
            rs = stm.executeQuery();
            if (rs.next()) {
                soggetto = new Soggetto();
                soggetto.setId(rs.getLong("id"));
                soggetto.setNome(nomeSogg);
                soggetto.setTipo(tipoSogg);
                String tmp = rs.getString("descrizione");
                soggetto.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_porta");
                soggetto.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("server");
                soggetto.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("superuser");
                soggetto.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    soggetto.setPrivato(true);
                } else {
                    soggetto.setPrivato(false);
                }
                tmp = rs.getString("codice_ipa");
                soggetto.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    soggetto.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                long idConnettore = rs.getLong("id_connettore");
                connettore = this.getConnettore(idConnettore, con);
                String profilo = rs.getString("profilo");
                if (profilo != null) {
                    profilo = profilo.trim();
                    soggetto.setVersioneProtocollo(profilo);
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun soggetto trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
            }
            soggetto.setConnettore(connettore);
            Soggetto soggetto2 = soggetto;
            return soggetto2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                stm.close();
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdSoggettiRegistro...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                }
                if (filtroRicerca.getNomePdd() != null) {
                    sqlQueryObject.addWhereCondition("server = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug((Object)("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug((Object)("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomePdd() != null) {
                    this.log.debug((Object)("nomePdD stmt.setString(" + filtroRicerca.getNomePdd() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomePdd());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            Vector<IDSoggetto> vector = idSoggetti;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDSoggetto type = 1");
            DriverRegistroServiziDB_LIB.CRUDSoggetto(1, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome_soggetto);
            stm.setString(2, tipo_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSoggetto(long idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSoggetto(String codiceIPA) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Soggetto getSoggetto(String codiceIPA) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziNotFound("Soggetto con Codice IPA [" + codiceIPA + "] non trovato");
        }
        return this.getSoggetto(idSoggetto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodiceIPA(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String codiceIPA = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                codiceIPA = rs.getString("codice_ipa");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (codiceIPA == null) {
            throw new DriverRegistroServiziNotFound("Soggetto [" + tipo_soggetto + "/" + nome_soggetto + "] non trovato");
        }
        return codiceIPA;
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            String oldNomeSoggetto = soggetto.getOldNomeForUpdate();
            String oldTipoSoggetto = soggetto.getOldTipoForUpdate();
            String nomeSoggetto = soggetto.getNome();
            String tipoSoggetto = soggetto.getTipo();
            if (tipoSoggetto == null || tipoSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo Soggetto non valido.");
            }
            if (nomeSoggetto == null || nomeSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome Soggetto non valido.");
            }
            if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                oldNomeSoggetto = nomeSoggetto;
            }
            if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                oldTipoSoggetto = tipoSoggetto;
            }
            if (!tipoSoggetto.equals(oldTipoSoggetto) || !nomeSoggetto.equals(oldNomeSoggetto)) {
                String newNomeConnettore;
                String[] val;
                String oldNomeConnettore;
                Connettore connettore;
                long idConnettore;
                String regex = "CNT_SF_(.*)\\/(.*)_(.*)\\/(.*)_(.*)\\/(.*)";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]..."));
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + val[2] + tipoSoggetto + "/" + nomeSoggetto + val[4];
                    this.log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]..."));
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + val[3] + val[4];
                    this.log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
            }
            DriverRegistroServiziDB_LIB.CRUDSoggetto(2, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Errore durante l'aggiornamento del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDSoggetto type = 3");
            DriverRegistroServiziDB_LIB.CRUDSoggetto(3, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Errore durante l'eliminazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDSoggetto[] getSoggettiWithSuperuser(String user) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto[] idSoggetti = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            Vector<IDSoggetto> idTrovati = new Vector<IDSoggetto>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("superuser = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, user);
            this.log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, CostantiRegistroServizi.ABILITATO)));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto id = new IDSoggetto();
                id.setTipo(rs.getString("tipo_soggetto"));
                id.setNome(rs.getString("nome_soggetto"));
                idTrovati.add(id);
            }
            if (idTrovati.size() > 0) {
                idSoggetti = new IDSoggetto[1];
                idSoggetti = idTrovati.toArray(idSoggetti);
            }
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idSoggetti;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(1, idServizio, null, null, null, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(2, null, idAccordoServizioParteSpecifica, null, null, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(3, null, null, idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdServizi ...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                    }
                    if (idAccordo.getVersione() != null) {
                        sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug((Object)("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug((Object)("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    this.log.debug((Object)("tipologiaServizio stmt.setString(" + filtroRicerca.getTipologiaServizio() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipologiaServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.log.debug((Object)("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.log.debug((Object)("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        this.log.debug((Object)("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")"));
                        stm.setString(indexStmt, idAccordo.getNome());
                        ++indexStmt;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                        if (idSoggettoReferente <= 0L) {
                            throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                        }
                        this.log.debug((Object)("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")"));
                        stm.setLong(indexStmt, idSoggettoReferente);
                        ++indexStmt;
                    }
                    if (idAccordo.getVersione() != null) {
                        this.log.debug((Object)("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")"));
                        stm.setString(indexStmt, idAccordo.getVersione());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            while (rs.next()) {
                IDServizio idServ = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                IDSoggetto soggettoReferente = null;
                long idSoggettoReferente = rs.getLong("id_referente");
                if (idSoggettoReferente > 0L) {
                    Soggetto s = this.getSoggetto(idSoggettoReferente, con);
                    soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), soggettoReferente, rs.getString("versione"));
                idServ.setUriAccordo(this.idAccordoFactory.getUriFromIDAccordo(idAccordo));
                String servizioCorrelato = rs.getString("servizio_correlato");
                if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                    idServ.setTipologiaServizio(TipologiaServizio.CORRELATO.toString());
                } else {
                    idServ.setTipologiaServizio(TipologiaServizio.NORMALE.toString());
                }
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi non trovati");
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdServizi ...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                    }
                    if (idAccordo.getVersione() != null) {
                        sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug((Object)("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug((Object)("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")"));
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug((Object)("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug((Object)("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    this.log.debug((Object)("tipologiaServizio stmt.setString(" + filtroRicerca.getTipologiaServizio() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipologiaServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.log.debug((Object)("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.log.debug((Object)("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")"));
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        this.log.debug((Object)("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")"));
                        stm.setString(indexStmt, idAccordo.getNome());
                        ++indexStmt;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                        if (idSoggettoReferente <= 0L) {
                            throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                        }
                        this.log.debug((Object)("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")"));
                        stm.setLong(indexStmt, idSoggettoReferente);
                        ++indexStmt;
                    }
                    if (idAccordo.getVersione() != null) {
                        this.log.debug((Object)("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")"));
                        stm.setString(indexStmt, idAccordo.getVersione());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            while (rs.next()) {
                long idReferente = rs.getLong("id_soggetto");
                IDSoggetto idSoggettoReferente = null;
                if (idReferente > 0L) {
                    Soggetto soggettoReferente = this.getSoggetto(idReferente, con);
                    if (soggettoReferente == null) {
                        throw new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("aps_nome") + "] (versione [" + rs.getString("aps_versione") + "]) non presente?");
                    }
                    idSoggettoReferente = new IDSoggetto(soggettoReferente.getTipo(), soggettoReferente.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), idSoggettoReferente, rs.getString("aps_versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordo> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDServizio[] getAllIdServiziWithSoggettoErogatore(Long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = "getAllIdServiziWithSoggettoErogatore";
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)(operazione + "..."));
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            while (rs.next()) {
                IDServizio idServ = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati per il soggetto con id: " + idSoggetto);
            }
            IDServizio[] res = new IDServizio[1];
            IDServizio[] iDServizioArray = idServizi.toArray(res);
            return iDServizioArray;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(operazione + " error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        if (accordoServizioParteSpecifica == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDServizio tupe=1");
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(1, accordoServizioParteSpecifica, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Errore durante la creazione del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non valido.");
        }
        IDSoggetto erogatore = idServizio.getSoggettoErogatore();
        if (erogatore == null) {
            throw new DriverRegistroServiziException("Soggetto Erogatore non valido.");
        }
        String nomeServizio = idServizio.getServizio();
        String tipoServizio = idServizio.getTipoServizio();
        String nomeProprietario = erogatore.getNome();
        String tipoProprietario = erogatore.getTipo();
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            long idS = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, this.tipoDB);
            boolean bl = idS > 0L;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsAccordoServizioParteSpecifica : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean existsServizioWithTipoAndNome(String tipoServizio, String nomeServizio) throws DriverRegistroServiziException {
        if (tipoServizio == null) {
            throw new DriverRegistroServiziException("TipoServizio non valido.");
        }
        if (nomeServizio == null) {
            throw new DriverRegistroServiziException("NomeServizio non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            int idServ = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            PreparedStatement stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            boolean bl = idServ > 0;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsServizioWithTipoAndNome : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error((Object)"Errore durante verifica esistenza servizio :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            if (!this.existsSoggetto(idAccordo.getSoggettoReferente())) {
                boolean e = false;
                return e;
            }
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteSpecifica(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAccordo getIDAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        if (idServizio == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("Parametro non valido (soggetto erogatore)");
        }
        String nome_soggetto = idServizio.getSoggettoErogatore().getNome();
        String tipo_soggetto = idServizio.getSoggettoErogatore().getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome soggetto non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo soggetto non valido");
        }
        String nome_servizio = idServizio.getServizio();
        String tipo_servizio = idServizio.getTipoServizio();
        if (nome_servizio == null || nome_servizio.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome servizio non valido");
        }
        if (tipo_servizio == null || tipo_servizio.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo servizio non valido");
        }
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            stm.setString(3, tipo_servizio);
            stm.setString(4, nome_servizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), idServizio.getSoggettoErogatore(), rs.getString("aps_versione"));
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (idAccordo == null) {
            throw new DriverRegistroServiziNotFound("Servizio [" + idServizio.toString() + "] non trovato");
        }
        return idAccordo;
    }

    public int getServizioWithSoggettoAccordoServCorr(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, null);
    }

    private int _getServizioWithSoggettoAccordoServCorrPT(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        Connection connection;
        int idServ = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"nome_servizio != ?", "tipo_servizio != ?"});
            if (portType != null) {
                sqlQueryObject.addWhereCondition("port_type = ?");
            } else {
                sqlQueryObject.addWhereCondition("port_type is null");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setLong(2, idAccordo);
            stm.setString(3, servizioCorrelato);
            stm.setString(4, idServizio.getServizio());
            stm.setString(5, idServizio.getTipoServizio());
            if (portType != null) {
                stm.setString(6, portType);
            }
            if ((rs = stm.executeQuery()).next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return idServ;
    }

    public int getServizioWithSoggettoAccordoServCorrPt(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, portType);
    }

    public int getServizioFruitore(IDServizio idServizio, long idSogg) throws DriverRegistroServiziException {
        Connection connection;
        int idFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            int idServ = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, idServizio.getServizio());
            stm.setString(2, idServizio.getTipoServizio());
            stm.setString(3, idServizio.getSoggettoErogatore().getNome());
            stm.setString(4, idServizio.getSoggettoErogatore().getTipo());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServ);
            stm.setLong(2, idSogg);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return idFru;
    }

    public int getServizioFruitoreSoggettoFruitoreID(int idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        int idSoggFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreSoggettoFruitoreID] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggFru = rs.getInt("id_soggetto");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return idSoggFru;
    }

    public int getServizioFruitoreServizioID(int idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        int idServ = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreServizioID] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id_servizio");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return idServ;
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(2, servizio, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Errore durante l'update del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDServizio type = 3");
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(3, servizio, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Errore durante la delete del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean existsSoggettoServiziWithoutConnettore(int idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == 0) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_connettore = connettori.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setInt(1, idSoggetto);
            stm.setString(2, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            rs.close();
            stm.close();
            boolean bl = trovatoServ;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsSoggettoServiziWithoutConnettore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Connettore getConnettore(long idConnettore, Connection connection) throws DriverRegistroServiziException {
        Connettore connettore = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore)));
            rs = stm.executeQuery();
            if (rs.next()) {
                String endpoint = rs.getString("endpointtype");
                if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(TipiConnettore.DISABILITATO.getNome());
                    connettore.setId(idConnettore);
                } else {
                    Property prop = null;
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(endpoint);
                    connettore.setId(idConnettore);
                    if (rs.getInt("debug") == 1) {
                        prop = new Property();
                        prop.setNome("debug");
                        prop.setValore("true");
                        connettore.addProperty(prop);
                    }
                    if (endpoint.equals("http")) {
                        String pwd;
                        String value = rs.getString("url");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        String usr = rs.getString("utente");
                        if (usr != null && !usr.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("user");
                            prop.setValore(usr);
                            connettore.addProperty(prop);
                        }
                        if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("password");
                            prop.setValore(pwd);
                            connettore.addProperty(prop);
                        }
                    } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                        String provurl;
                        String urlpkg;
                        String initcont;
                        String pwd;
                        String value = rs.getString("nome");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("tipo");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
                        }
                        prop = new Property();
                        prop.setNome("tipo");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("connection_factory");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                        }
                        prop = new Property();
                        prop.setNome("connection-factory");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("send_as");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                        }
                        prop = new Property();
                        prop.setNome("send-as");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        String usr = rs.getString("utente");
                        if (usr != null && !usr.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("user");
                            prop.setValore(usr);
                            connettore.addProperty(prop);
                        }
                        if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("password");
                            prop.setValore(pwd);
                            connettore.addProperty(prop);
                        }
                        if ((initcont = rs.getString("initcont")) != null && !initcont.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.initial");
                            prop.setValore(initcont);
                            connettore.addProperty(prop);
                        }
                        if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.url.pkgs");
                            prop.setValore(urlpkg);
                            connettore.addProperty(prop);
                        }
                        if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.provider.url");
                            prop.setValore(provurl);
                            connettore.addProperty(prop);
                        }
                    } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                        if (rs.getLong("custom") == 1L) {
                            this.readPropertiesConnettoreCustom(idConnettore, connettore, connection);
                            connettore.setCustom(true);
                        } else {
                            Property[] ps = ConnettorePropertiesUtilities.getPropertiesConnettore(endpoint, connection, this.tipoDB);
                            ArrayList<Property> listCP = new ArrayList<Property>();
                            if (ps != null) {
                                for (int i = 0; i < ps.length; ++i) {
                                    listCP.add(ps[i]);
                                }
                            }
                            connettore.setPropertyList(listCP);
                        }
                    }
                }
            }
            Connettore connettore2 = connettore;
            return connettore2;
        }
        catch (SQLException sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] CoreException : " + e.getMessage(), e);
        }
        catch (Exception sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception e) {}
        }
    }

    protected void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverRegistroServiziDB_LIB.log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("name");
                String valore = rs.getString("value");
                Property prop = new Property();
                prop.setNome(nome);
                prop.setValore(valore);
                connettore.addProperty(prop);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (Exception sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Property[] getPropertiesConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    public Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverRegistroServiziException {
        try {
            return ConnettorePropertiesUtilities.getPropertiesConnettore(nomeConnettore, connection, this.tipoDB);
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] CoreException : " + e.getMessage(), e);
        }
    }

    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(int type, IDServizio idServizio, IDAccordo idAccordoServizioParteSpecifica, IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        this.log.debug((Object)("chiamato getAccordoServizioParteSpecifica type = " + type));
        switch (type) {
            case 1: {
                if (idServizio != null && idServizio.getServizio() != null && !idServizio.getServizio().trim().equals("") && idServizio.getTipoServizio() != null && !idServizio.getTipoServizio().trim().equals("") && idServizio.getSoggettoErogatore() != null && idServizio.getSoggettoErogatore().getNome() != null && !idServizio.getSoggettoErogatore().getNome().trim().equals("") && idServizio.getSoggettoErogatore().getTipo() != null && !idServizio.getSoggettoErogatore().getTipo().trim().equals("")) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            case 2: {
                if (idAccordoServizioParteSpecifica != null && idAccordoServizioParteSpecifica.getNome() != null && idAccordoServizioParteSpecifica.getSoggettoReferente() != null && idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo() != null && idAccordoServizioParteSpecifica.getSoggettoReferente().getNome() != null) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            case 3: {
                if (idAccordoServizioParteComune != null && idAccordoServizioParteComune.getNome() != null && !idAccordoServizioParteComune.getNome().trim().equals("") && idSoggetto != null && idSoggetto.getNome() != null && !idSoggetto.getNome().trim().equals("") && idSoggetto.getTipo() != null && !idSoggetto.getTipo().trim().equals("")) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            default: {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] tipo operazione incorretto. parametro type passato: " + type);
            }
        }
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nomeservizio = ?");
            sqlQueryObject.addWhereCondition("tiposervizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            accordoServizioParteSpecifica = new AccordoServizioParteSpecifica();
            Servizio servizio = new Servizio();
            accordoServizioParteSpecifica.setServizio(servizio);
            String nomeSoggEr = null;
            String tipoSoggEr = null;
            long longIdAccordoServizioParteComune = 0L;
            String nomeServizio = null;
            String tipoServizio = null;
            String superUser = null;
            long idSoggErogatore = 0L;
            long longIdAccordoServizioParteSpecifica = 0L;
            switch (type) {
                case 1: {
                    nomeServizio = idServizio.getServizio();
                    tipoServizio = idServizio.getTipoServizio();
                    nomeSoggEr = idServizio.getSoggettoErogatore().getNome();
                    tipoSoggEr = idServizio.getSoggettoErogatore().getTipo();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nomeSoggEr);
                    stm.setString(2, tipoSoggEr);
                    this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr)));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        idSoggErogatore = rs.getLong("id");
                    }
                    rs.close();
                    stm.close();
                    break;
                }
                case 2: {
                    if (!this.existsSoggetto(idAccordoServizioParteSpecifica.getSoggettoReferente())) {
                        throw new DriverRegistroServiziNotFound("Soggetto erogatore [" + idAccordoServizioParteSpecifica.getSoggettoReferente() + "] non esistente");
                    }
                    Soggetto sogErogatore = this.getSoggetto(idAccordoServizioParteSpecifica.getSoggettoReferente());
                    nomeSoggEr = sogErogatore.getNome();
                    tipoSoggEr = sogErogatore.getTipo();
                    longIdAccordoServizioParteSpecifica = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, con, this.tipoDB);
                    if (longIdAccordoServizioParteSpecifica > 0L) break;
                    throw new DriverRegistroServiziNotFound("Accordo di Servizio Parte Specifica [" + idAccordoServizioParteSpecifica.toString() + "] non esistente");
                }
                case 3: {
                    nomeSoggEr = idSoggetto.getNome();
                    tipoSoggEr = idSoggetto.getTipo();
                    longIdAccordoServizioParteComune = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordoServizioParteComune, con, this.tipoDB);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nomeSoggEr);
                    stm.setString(2, tipoSoggEr);
                    this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr)));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        idSoggErogatore = rs.getLong("id");
                    }
                    rs.close();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("id_accordo = ?");
                    sqlQueryObject.addWhereCondition("servizio_correlato = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idSoggErogatore);
                    stm.setLong(2, longIdAccordoServizioParteComune);
                    stm.setString(3, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.ABILITATO));
                    this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggErogatore, longIdAccordoServizioParteComune, CostantiRegistroServizi.ABILITATO)));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        nomeServizio = rs.getString("nome_servizio");
                        tipoServizio = rs.getString("tipo_servizio");
                        superUser = rs.getString("superuser");
                    }
                    rs.close();
                    stm.close();
                }
            }
            long idConnettore = 0L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            switch (type) {
                case 1: {
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    break;
                }
                case 2: {
                    sqlQueryObject.addWhereCondition("id = ?");
                    break;
                }
                case 3: {
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            switch (type) {
                case 1: {
                    stm.setString(1, nomeServizio);
                    stm.setString(2, tipoServizio);
                    stm.setLong(3, idSoggErogatore);
                    break;
                }
                case 2: {
                    stm.setLong(1, longIdAccordoServizioParteSpecifica);
                    break;
                }
                case 3: {
                    stm.setString(1, nomeServizio);
                    stm.setString(2, tipoServizio);
                    stm.setLong(3, idSoggErogatore);
                }
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeServizio, tipoServizio, idSoggErogatore)));
            rs = stm.executeQuery();
            if (rs.next()) {
                String profilo;
                String tmp;
                longIdAccordoServizioParteSpecifica = rs.getLong("id");
                idConnettore = rs.getLong("id_connettore");
                longIdAccordoServizioParteComune = rs.getLong("id_accordo");
                superUser = rs.getString("superuser");
                accordoServizioParteSpecifica.setId(longIdAccordoServizioParteSpecifica);
                servizio.setId(longIdAccordoServizioParteSpecifica);
                accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
                servizio.setNome(rs.getString("nome_servizio"));
                servizio.setTipo(rs.getString("tipo_servizio"));
                servizio.setConnettore(this.getConnettore(idConnettore, con));
                String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
                accordoServizioParteSpecifica.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.trim().getBytes() : null);
                String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
                accordoServizioParteSpecifica.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.trim().getBytes() : null);
                String servizioCorrelato = rs.getString("servizio_correlato");
                if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                    servizio.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    servizio.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                servizio.setTipoSoggettoErogatore(tipoSoggEr);
                servizio.setNomeSoggettoErogatore(nomeSoggEr);
                accordoServizioParteSpecifica.setIdSoggetto(idSoggErogatore);
                if (rs.getInt("privato") == 1) {
                    accordoServizioParteSpecifica.setPrivato(true);
                } else {
                    accordoServizioParteSpecifica.setPrivato(false);
                }
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoServizioParteSpecifica.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if ((tmp = rs.getString("port_type")) != null && !"".equals(tmp)) {
                    accordoServizioParteSpecifica.setPortType(tmp);
                }
                if ((profilo = rs.getString("profilo")) != null) {
                    profilo = profilo.trim();
                    accordoServizioParteSpecifica.setVersioneProtocollo(profilo);
                }
                accordoServizioParteSpecifica.setSuperUser(superUser);
                accordoServizioParteSpecifica.setDescrizione(rs.getString("descrizione"));
                accordoServizioParteSpecifica.setStatoPackage(rs.getString("stato"));
                accordoServizioParteSpecifica.setNome(rs.getString("aps_nome"));
                accordoServizioParteSpecifica.setVersione(rs.getString("aps_versione"));
            } else {
                switch (type) {
                    case 1: {
                        throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
                    }
                    case 2: {
                        throw new DriverRegistroServiziNotFound("Accordo di Servizio Parte Specifica [" + idAccordoServizioParteSpecifica.toString() + "] non esiste");
                    }
                    case 3: {
                        throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
                    }
                }
            }
            rs.close();
            stm.close();
            long idSoggFruitore = 0L;
            Fruitore fruitore = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteSpecifica);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica)));
            rs = stm.executeQuery();
            while (rs.next()) {
                String profilo;
                fruitore = new Fruitore();
                idSoggFruitore = rs.getLong("id_soggetto");
                idConnettore = rs.getLong("id_connettore");
                fruitore.setConnettore(this.getConnettore(idConnettore, con));
                String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
                fruitore.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.getBytes() : null);
                String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
                fruitore.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.getBytes() : null);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    fruitore.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if ((profilo = rs.getString("profilo")) != null) {
                    profilo = profilo.trim();
                    fruitore.setVersioneProtocollo(profilo);
                }
                fruitore.setStatoPackage(rs.getString("stato"));
                fruitore.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idSoggFruitore);
                this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore)));
                rs1 = stm1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Non ho trovato i dati del soggetto fruitore necessario eseguendo: \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
                }
                fruitore.setNome(rs1.getString("nome_soggetto"));
                fruitore.setTipo(rs1.getString("tipo_soggetto"));
                rs1.close();
                stm1.close();
                fruitore.setId(rs.getLong("id"));
                accordoServizioParteSpecifica.addFruitore(fruitore);
            }
            rs.close();
            stm.close();
            ServizioAzione azione = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteSpecifica);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica)));
            rs = stm.executeQuery();
            while (rs.next()) {
                azione = new ServizioAzione();
                azione.setNome(rs.getString("nome_azione"));
                idConnettore = rs.getLong("id_connettore");
                azione.setConnettore(this.getConnettore(idConnettore, con));
                azione.setId(rs.getLong("id"));
                servizio.addParametriAzione(azione);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteComune);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteComune)));
            rs = stm.executeQuery();
            if (rs.next()) {
                accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
                String tmp = rs.getString("nome");
                String tmpVersione = rs.getString("versione");
                long id_referente = rs.getLong("id_referente");
                IDSoggetto soggettoReferente = null;
                if (id_referente > 0L) {
                    Soggetto s = this.getSoggetto(id_referente, con);
                    if (s == null) {
                        throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                    }
                    soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                }
                accordoServizioParteSpecifica.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromValues(tmp, soggettoReferente, tmpVersione));
            }
            rs.close();
            stm.close();
            try {
                List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < allegati.size(); ++i) {
                    accordoServizioParteSpecifica.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            try {
                List<Documento> specificheLivelloServizio = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaLivelloServizio.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheLivelloServizio.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaLivelloServizio(specificheLivelloServizio.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            try {
                List<Documento> specificheSicurezza = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSicurezza.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheSicurezza.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaSicurezza(specificheSicurezza.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound dNotFound) {
                // empty catch block
            }
            AccordoServizioParteSpecifica accordoServizioParteSpecifica2 = accordoServizioParteSpecifica;
            return accordoServizioParteSpecifica2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            this.log.debug((Object)("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] SqlException:" + se.getMessage()));
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] SqlException:" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm != null) {
                    stm.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio le connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Azione> accordiAzioniList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAzioniList";
        int idLista = 14;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setId(risultato.getLong("idAzione"));
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                lista.add(az);
            }
            ArrayList<Azione> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Azione> accordiAzioniList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAzioniList";
        int idLista = 14;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("accordi_azioni.id", "cont");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?"});
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("accordi_azioni", "nome");
            sqlQueryObject.addSelectField("accordi_azioni", "conferma_ricezione");
            sqlQueryObject.addSelectField("accordi_azioni", "consegna_in_ordine");
            sqlQueryObject.addSelectField("accordi_azioni", "filtro_duplicati");
            sqlQueryObject.addSelectField("accordi_azioni", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "scadenza");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_azione");
            sqlQueryObject.addSelectField("accordi_azioni", "id_accordo");
            sqlQueryObject.addSelectField("accordi_azioni", "correlata");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?"});
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.addOrderBy("accordi_azioni.nome");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                az.setCorrelata(risultato.getString("correlata"));
                lista.add(az);
            }
            ArrayList<Azione> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziList";
        int idLista = 13;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug((Object)("query : " + queryString));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                Servizio serv = new Servizio();
                asps.setServizio(serv);
                asps.setId(risultato.getLong("id"));
                serv.setNome(risultato.getString("nome_servizio"));
                serv.setTipo(risultato.getString("tipo_servizio"));
                asps.setIdSoggetto(risultato.getLong("id_soggetto"));
                asps.setIdAccordo(risultato.getLong("id_accordo"));
                String servizio_correlato = risultato.getString("servizio_correlato");
                if (servizio_correlato != null && (servizio_correlato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizio_correlato))) {
                    serv.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                Soggetto sog = this.getSoggetto(asps.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                serv.setNomeSoggettoErogatore(nomeErogatore);
                serv.setTipoSoggettoErogatore(tipoErogatore);
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(asps.getIdAccordo(), con);
                asps.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromAccordo(as));
                asps.setStatoPackage(risultato.getString("stato"));
                lista.add(asps);
            }
            this.log.debug((Object)("size lista :" + (lista == null ? null : Integer.valueOf(lista.size()))));
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> servizioWithSoggettoFruitore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "servizioWithSoggettoFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> idServizi = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("servizi_fruitori");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.setSelectDistinct(true);
            sqlQueryObjectSoggetti.addSelectAliasField("servizi", "id", "idServizio");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioLong = risultato.getLong("idServizio");
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(idServizioLong);
                Soggetto s = this.getSoggetto(serv.getIdSoggetto());
                serv.getServizio().setTipoSoggettoErogatore(s.getTipo());
                serv.getServizio().setNomeSoggettoErogatore(s.getNome());
                idServizi.add(serv);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idServizi;
    }

    public List<AccordoServizioParteComune> accordiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, false);
    }

    public List<AccordoServizioParteComune> accordiServizioParteComuneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, true);
    }

    public List<AccordoServizioParteComune> accordiServizioCompostiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, true, false);
    }

    private List<AccordoServizioParteComune> accordiListEngine(String superuser, ISearch ricerca, boolean excludeASParteComune, boolean excludeASComposti) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiList";
        int idLista = 17;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> lista = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (excludeASComposti && excludeASParteComune) {
                throw new Exception("Non e' possibile invocare il metodo accordiListEngine con entrambi i parametri excludeASParteComune,excludeASComposti impostati al valore true");
            }
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addWhereCondition("accordi.id_referente=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition(false, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true)});
            }
            ISQLQueryObject sqlQueryObjectExclude = null;
            if (excludeASComposti || excludeASParteComune) {
                sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("accordi", "id");
                sqlQueryObject.addSelectField("accordi", "nome");
                sqlQueryObject.addSelectField("accordi", "versione");
                sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("accordi", "id");
                sqlQueryObject.addSelectField("accordi", "nome");
                sqlQueryObject.addSelectField("accordi", "versione");
                sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.superuser = ?");
                }
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            AccordoServizioParteComune accordo = null;
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                accordo = this.getAccordoServizioParteComune(id, con);
                lista.add(accordo);
            }
            this.log.debug((Object)("size lista :" + (lista == null ? null : Integer.valueOf(lista.size()))));
            ArrayList<AccordoServizioParteComune> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoCooperazione> accordiCooperazioneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCooperazioneList";
        int idLista = 34;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true)});
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true)});
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nomeAcc = risultato.getString("nome");
                String versioneAcc = risultato.getString("versione");
                IDAccordoCooperazione id = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(nomeAcc, versioneAcc);
                idAccordi.add(id);
            }
            this.log.debug((Object)("size lista :" + (idAccordi == null ? null : Integer.valueOf(idAccordi.size()))));
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        ArrayList<AccordoCooperazione> lista = new ArrayList<AccordoCooperazione>();
        for (int i = 0; i < idAccordi.size(); ++i) {
            try {
                lista.add(this.getAccordoCooperazione((IDAccordoCooperazione)idAccordi.get(i)));
                continue;
            }
            catch (DriverRegistroServiziNotFound dNot) {
                throw new DriverRegistroServiziException("Accordo non trovato con id?: " + dNot.getMessage(), dNot);
            }
        }
        return lista;
    }

    public List<IDSoggetto> accordiCoopPartecipantiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopPartecipantiList";
        int idLista = 36;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectSoggetti;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectCountField("*", "cont");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id"});
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id"});
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("tipo_soggetto");
                String nome = risultato.getString("nome_soggetto");
                IDSoggetto idSogg = new IDSoggetto(tipo, nome);
                idSoggetti.add(idSogg);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idSoggetti;
    }

    public List<AccordoCooperazione> accordiCoopWithSoggettoPartecipante(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopWithSoggettoPartecipante";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoCooperazione> idAccordoCooperazione = new ArrayList<AccordoCooperazione>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoCooperazioneLong = risultato.getLong("idAccordoCooperazione");
                idAccordoCooperazione.add(this.getAccordoCooperazione(idAccordoCooperazioneLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordoCooperazione;
    }

    public List<AccordoServizioParteComune> accordiServizio_serviziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponentiConSoggettoErogatore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordoServizio;
    }

    public List<AccordoServizioParteComune> accordiServizio_serviziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponenti";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.tipo_servizio=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.nome_servizio=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stmt.setString(2, idServizio.getSoggettoErogatore().getNome());
            stmt.setString(3, idServizio.getTipoServizio());
            stmt.setString(4, idServizio.getServizio());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordoServizio;
    }

    public List<AccordoServizioParteComune> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizioWithAccordoCooperazione";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.nome=?");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.versione=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idAccordoCooperazione.getNome());
            stmt.setString(2, idAccordoCooperazione.getVersione());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordoServizio;
    }

    public List<Soggetto> accordiErogatoriList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiErogatoriList";
        int idLista = 19;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            Soggetto sog = null;
            String oldNome = "";
            String oldTipo = "";
            while (risultato.next()) {
                String newNome = risultato.getString("nome_soggetto");
                String newTipo = risultato.getString("tipo_soggetto");
                if (sog == null || !oldTipo.equals(newTipo) || !oldNome.equals(newNome)) {
                    oldTipo = newTipo;
                    oldNome = newNome;
                    if (sog != null) {
                        lista.add(sog);
                    }
                    sog = new Soggetto();
                    sog.setId(risultato.getLong("id"));
                    sog.setNome(risultato.getString("nome_soggetto"));
                    sog.setTipo(risultato.getString("tipo_soggetto"));
                    sog.setDescrizione(risultato.getString("descrizione"));
                    sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                    sog.setCodiceIpa(risultato.getString("codice_ipa"));
                }
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setId(risultato.getLong("servid"));
                serv.setServizio(new Servizio());
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                if (risultato.getString("servizio_correlato").equals(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(risultato.getString("servizio_correlato"))) {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                sog.addAccordoServizioParteSpecifica(serv);
            }
            if (sog != null) {
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Fruitore getAccordoErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getAccordoErogatoreFruitore: " + id));
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore = new Fruitore();
            fruitore.setId(id);
            fruitore.setTipo(rs.getString("soggetti.tipo_soggetto"));
            fruitore.setNome(rs.getString("soggetti.nome_soggetto"));
            long idConnettore = rs.getLong("soggettiid_connettore");
            fruitore.setConnettore(this.getConnettore(idConnettore, con));
            Fruitore fruitore2 = fruitore;
            return fruitore2;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Fruitore getErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getErogatoreFruitore: " + id));
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
            sqlQueryObject.addSelectField("servizi_fruitori.profilo");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore = new Fruitore();
            fruitore.setId(id);
            fruitore.setTipo(rs.getString("tipo_soggetto"));
            fruitore.setNome(rs.getString("nome_soggetto"));
            fruitore.setStatoPackage(rs.getString("stato"));
            fruitore.setVersioneProtocollo(rs.getString("profilo"));
            fruitore.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
            long idConnettore = rs.getLong("id_connettore");
            fruitore.setConnettore(this.getConnettore(idConnettore, con));
            Fruitore fruitore2 = fruitore;
            return fruitore2;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public AccordoServizioParteComune[] getAllIdAccordiWithSoggettoReferente(IDSoggetto idsoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdAccordiWithSoggettoReferente...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idsoggetto.getTipo());
            stm.setString(2, idsoggetto.getNome());
            rs = stm.executeQuery();
            Vector<AccordoServizioParteComune> accordi = new Vector<AccordoServizioParteComune>();
            while (rs.next()) {
                accordi.add(this.getAccordoServizioParteComune(rs.getLong("idAccordo")));
            }
            if (accordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati con soggetto referente [" + idsoggetto + "]");
            }
            AccordoServizioParteComune[] res = new AccordoServizioParteComune[1];
            AccordoServizioParteComune[] accordoServizioParteComuneArray = accordi.toArray(res);
            return accordoServizioParteComuneArray;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiWithSoggettoReferente error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Fruitore> accordiErogatoriFruitoriList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiErogatoriFruitoriList";
        int idLista = 20;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.stato");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.stato");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            while (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("idFruitore"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setStatoPackage(risultato.getString("stato"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Fruitore> serviziFruitoriList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 18;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_fruitori.id");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_fruitori.id");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            while (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Fruitore getServizioFruitore(int idServFru) throws DriverRegistroServiziException {
        String nomeMetodo = "getServizioFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_erogatore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_fruitore");
            sqlQueryObject.addSelectField("servizi_fruitori.profilo");
            sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServFru);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            if (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                long idConnettore = risultato.getLong("id_connettore");
                f.setConnettore(this.getConnettore(idConnettore, con));
                f.setByteWsdlImplementativoErogatore(risultato.getString("wsdl_implementativo_erogatore") != null && !risultato.getString("wsdl_implementativo_erogatore").trim().equals("") ? risultato.getString("wsdl_implementativo_erogatore").trim().getBytes() : null);
                f.setByteWsdlImplementativoFruitore(risultato.getString("wsdl_implementativo_fruitore") != null && !risultato.getString("wsdl_implementativo_fruitore").trim().equals("") ? risultato.getString("wsdl_implementativo_fruitore").trim().getBytes() : null);
                f.setVersioneProtocollo(risultato.getString("profilo"));
                f.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("client_auth")));
                f.setStatoPackage(risultato.getString("stato"));
            }
            Fruitore fruitore = f;
            return fruitore;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isAccordoInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            boolean isInUso = false;
            Vector<String> nomiServizi = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, as.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeServizio = risultato.getString("tipo_soggetto") + "/" + risultato.getString("nome_soggetto") + " - " + risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
                nomiServizi.add(nomeServizio);
            }
            risultato.close();
            stmt.close();
            if (nomiServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, nomiServizi.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            boolean isInUso = false;
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            ArrayList<IDPortaDelegata> idPorteDelegate = new ArrayList<IDPortaDelegata>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, as.getId());
            risultato = stmt.executeQuery();
            String uri = this.idAccordoFactory.getUriFromAccordo(as);
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteSpecifica ss = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                IDServizio idSE = new IDServizio();
                idSE.setServizio(ss.getServizio().getNome());
                idSE.setTipoServizio(ss.getServizio().getTipo());
                idSE.setSoggettoErogatore(ss.getServizio().getTipoSoggettoErogatore(), ss.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(ss.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(uri);
                idServizi.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, as.getId());
            risultato = stmt.executeQuery();
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            while (risultato.next()) {
                isInUso = true;
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setLocationPD(risultato.getString("nome_porta"));
                Soggetto fruitore = this.getSoggetto(risultato.getLong("id_soggetto"));
                IDSoggetto idSO = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                idPD.setSoggettoFruitore(idSO);
                idPorteDelegate.add(idPD);
            }
            risultato.close();
            stmt.close();
            if (idPorteDelegate.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, idPorteDelegate);
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isServizioInUso(AccordoServizioParteSpecifica ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isServizioInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            boolean isInUso = false;
            Vector<String> nomiAccordi = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("acc_serv_composti", "id_accordo");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_componente = ?");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_composto = acc_serv_composti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(risultato.getLong("id_accordo"), con);
                nomiAccordi.add(this.idAccordoFactory.getUriFromAccordo(as));
            }
            risultato.close();
            stmt.close();
            if (nomiAccordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_SERVIZIO_COMPONENTE_IN_ACCORDI, nomiAccordi.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isAccordoCooperazioneInUso(AccordoCooperazione ac, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoCooperazioneInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            boolean isInUso = false;
            Vector<String> nomiAccordi = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo_cooperazione = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = accordi.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ac.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(risultato.getLong("id_accordo"));
                nomiAccordi.add(this.idAccordoFactory.getUriFromAccordo(as));
            }
            risultato.close();
            stmt.close();
            if (nomiAccordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_ACCORDI, nomiAccordi.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isSoggettoInUsoInPackageFinali(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, true, false);
    }

    public boolean isSoggettoInUsoInPackagePubblici(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, true);
    }

    public boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, false);
    }

    private boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            BaseBean accordo;
            boolean isInUso = false;
            Vector<String> nomiServizi = new Vector<String>();
            Vector<String> serviziFruitori = new Vector<String>();
            Vector<String> accordi = new Vector<String>();
            Vector<String> accordi_cooperazione = new Vector<String>();
            Vector<String> partecipanti = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            int index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeServizio = risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
                nomiServizi.add(nomeServizio);
            }
            risultato.close();
            stmt.close();
            if (nomiServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, nomiServizi.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            if (checkOnlyStatiFinali) {
                stmt.setString(2, StatiAccordo.finale.toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                if (checkOnlyStatiPubblici) {
                    if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) continue;
                    serviziFruitori.add(servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome());
                    continue;
                }
                serviziFruitori.add(servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome());
            }
            risultato.close();
            stmt.close();
            if (serviziFruitori.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, serviziFruitori.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.getAccordoServizioParteComune(risultato.getLong("id"));
                accordi.add(this.idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, accordi.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.getAccordoCooperazione(risultato.getLong("id"));
                accordi_cooperazione.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi_cooperazione.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE, accordi_cooperazione.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_coop_partecipanti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                accordo = this.getAccordoCooperazione(risultato.getLong("id_accordo_cooperazione"));
                if (checkOnlyStatiFinali) {
                    if (!StatiAccordo.finale.toString().equals(accordo.getStatoPackage())) continue;
                    isInUso = true;
                    partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                if (checkOnlyStatiPubblici) {
                    if (accordo.getPrivato() != null && accordo.getPrivato().booleanValue()) continue;
                    isInUso = true;
                    partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                isInUso = true;
                partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (partecipanti.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE, partecipanti.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isInUso(Soggetto ss, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            IDServizio idSE;
            AccordoServizioParteSpecifica servizio;
            boolean isInUso = false;
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            ArrayList<IDServizio> idServiziFruitori = new ArrayList<IDServizio>();
            ArrayList<IDAccordo> idAccordi = new ArrayList<IDAccordo>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            int index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                idSE = new IDServizio();
                idSE.setServizio(servizio.getServizio().getNome());
                idSE.setTipoServizio(servizio.getServizio().getTipo());
                idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                idServizi.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            if (checkOnlyStatiFinali) {
                stmt.setString(2, StatiAccordo.finale.toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                if (checkOnlyStatiPubblici) {
                    if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) continue;
                    idSE = new IDServizio();
                    idSE.setServizio(servizio.getServizio().getNome());
                    idSE.setTipoServizio(servizio.getServizio().getTipo());
                    idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                    idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                    idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                    idServiziFruitori.add(idSE);
                    continue;
                }
                idSE = new IDServizio();
                idSE.setServizio(servizio.getServizio().getNome());
                idSE.setTipoServizio(servizio.getServizio().getTipo());
                idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                idServiziFruitori.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServiziFruitori.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, idServiziFruitori);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteComune accordo = this.getAccordoServizioParteComune(risultato.getLong("id"));
                idAccordi.add(this.idAccordoFactory.getIDAccordoFromAccordo(accordo));
            }
            risultato.close();
            stmt.close();
            if (idAccordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, idAccordi);
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAzioneInUso(String nomeAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "isAzioneInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("azione = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomeAzione);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                boolean bl = true;
                return bl;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_azione = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomeAzione);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void deleteAzione(int idAccordo, String nomeAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "deleteAzione";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDAccordo getIdAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoServizioParteComune(id, null);
    }

    public IDAccordo getIdAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getIdAccordoServizioParteComune: " + id));
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L && (referente = this.getIdSoggetto(idReferente, con)) == null) {
                    throw new Exception("Soggetto referente non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordo;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, null);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getAccordoServizio: " + id));
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L) {
                    Soggetto s = this.getSoggetto(idReferente, con);
                    if (s == null) {
                        throw new Exception("Soggetto referente non presente?");
                    }
                    referente = new IDSoggetto(s.getTipo(), s.getNome());
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return this.getAccordoServizioParteComune(idAccordo);
    }

    public List<Soggetto> soggettiRegistroListByTipo(String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList("", tipoSoggetto, ricerca);
    }

    public List<Soggetto> soggettiRegistroList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList(superuser, null, ricerca);
    }

    private List<Soggetto> soggettiRegistroList(String superuser, String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiRegistroList";
        int idLista = 1;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject2.getWhereLikeCondition("nome_soggetto", search, true, true)});
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true)});
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setPortaDominio(risultato.getString("server"));
                sog.setCodiceIpa(risultato.getString("codice_ipa"));
                long idConnettore = risultato.getLong("id_connettore");
                sog.setConnettore(this.getConnettore(idConnettore, con));
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDSoggetto getIdSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdSoggetto(idSoggetto, null);
    }

    public IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto <= 0L) {
            return null;
        }
        IDSoggetto idSoggettoObject = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto)));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovat eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            idSoggettoObject = new IDSoggetto();
            idSoggettoObject.setNome(rs.getString("nome_soggetto"));
            idSoggettoObject.setTipo(rs.getString("tipo_soggetto"));
            IDSoggetto iDSoggetto = idSoggettoObject;
            return iDSoggetto;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Soggetto getSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getSoggetto(idSoggetto, null);
    }

    public Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto <= 0L) {
            return null;
        }
        Soggetto soggetto = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            Connettore connettore;
            String tmp;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto)));
            rs = stm.executeQuery();
            if (rs.next()) {
                soggetto = new Soggetto();
                soggetto.setId(rs.getLong("id"));
                soggetto.setNome(rs.getString("nome_soggetto"));
                soggetto.setTipo(rs.getString("tipo_soggetto"));
                tmp = rs.getString("descrizione");
                soggetto.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_porta");
                soggetto.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("server");
                soggetto.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("superuser");
                soggetto.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    soggetto.setPrivato(true);
                } else {
                    soggetto.setPrivato(false);
                }
                long idConnettore = rs.getLong("id_connettore");
                connettore = this.getConnettore(idConnettore, con);
                String profilo = rs.getString("profilo");
                if (profilo != null) {
                    profilo = profilo.trim();
                    soggetto.setVersioneProtocollo(profilo);
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovat eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            tmp = rs.getString("codice_ipa");
            soggetto.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
            soggetto.setConnettore(connettore);
            Soggetto soggetto2 = soggetto;
            return soggetto2;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public IDAccordo getIdAccordoServizioParteSpecifica(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoServizioParteSpecifica(id, null);
    }

    public IDAccordo getIdAccordoServizioParteSpecifica(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug((Object)("richiesto getIdAccordoServizioParteSpecifica: " + id));
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto erogatore;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = conParam != null ? conParam : (this.atomica ? this.datasource.getConnection() : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id)));
            rs = stm.executeQuery();
            if (rs.next()) {
                erogatore = null;
                long idErogatore = rs.getLong("id_soggetto");
                if (idErogatore > 0L && (erogatore = this.getIdSoggetto(idErogatore, con)) == null) {
                    throw new Exception("Soggetto erogatore non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), erogatore, rs.getString("aps_versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return idAccordo;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null, readContenutoAllegati);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, conParam, false);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] L'id del servizio deve essere > 0.");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizio] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        IDServizio idServizioObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio)));
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioObject = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                if (CostantiRegistroServizi.ABILITATO.toString().equals(rs.getString("servizio_correlato")) || TipologiaServizio.CORRELATO.toString().equals(rs.getString("servizio_correlato"))) {
                    idServizioObject.setTipologiaServizio(TipologiaServizio.CORRELATO.toString());
                } else {
                    idServizioObject.setTipologiaServizio(TipologiaServizio.NORMALE.toString());
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun Servizio trovato con id=" + idServizio);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] SqlException: " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound nf) {
            throw nf;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return this.getAccordoServizioParteSpecifica(idServizioObject, readContenutoAllegati, conParam);
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("operation_messages");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_componenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_composti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_cooperazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("soggetti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("documenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pdd");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void resetCtrlstat() throws DriverRegistroServiziException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("ruoli_sa");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("politiche_sicurezza");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_applicativi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_properties");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public long getIdServizioCorrelato(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, this.tipoDB, this.tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            stm.setString(4, CostantiRegistroServizi.ABILITATO.toString());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizio = rs.getLong("id");
            }
            long l = idServizio;
            return l;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<String> getTipi() throws DriverRegistroServiziException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException(e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ArrayList<String> lista = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("tipi");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(sqlQuery);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("nome");
                lista.add(tipo);
            }
            risultato.close();
            stmt.close();
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException(se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public String getTipoById(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException(e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("tipi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(sqlQuery);
            stmt.setLong(1, id);
            risultato = stmt.executeQuery();
            String tipo = "";
            if (!risultato.next()) {
                throw new DriverRegistroServiziNotFound("Impossibile trovare un tipo Soggetto con id=" + id);
            }
            tipo = risultato.getString("nome");
            risultato.close();
            stmt.close();
            String string = tipo;
            return string;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziNotFound(se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Fruitore> serviziFruitoriList(int idServizi, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 18;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizi);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizi);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("idFruitore"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setStatoPackage(risultato.getString("statoFruitore"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziSoggettoList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziSoggettoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("servizi.tipo_servizio");
            sqlQueryObject.addOrderBy("servizi.nome_servizio");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setServizio(new Servizio());
                serv.setId(risultato.getLong("id"));
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                lista.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziWithIdAccordoList(long idAccordo) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziWithIdAccordoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                lista.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public int getIdServizioFruitore(int idServizio, int idSoggetto) throws DriverRegistroServiziException {
        Connection connection;
        int idFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdServizioFruitore] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizio);
            stm.setInt(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return idFru;
    }

    public List<Fruitore> getServiziFruitoriWithServizio(int idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziFruitoriWithServizio";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> getServiziByIdErogatore(long idErogatore) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, null);
    }

    public List<AccordoServizioParteSpecifica> getServiziByIdErogatore(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, filters);
    }

    private List<AccordoServizioParteSpecifica> getServiziByIdErogatoreAndFilters(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByIdErogatoreAndFilters";
        int idLista = 13;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                filters.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> getServiziByFruitore(Fruitore fruitore) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            long idFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruitore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Fruitore> getSoggettiWithServizioNotFruitori(int idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getSoggettiWithServizioNotFruitori";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectWhere = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectWhere.addFromTable("servizi_fruitori");
            sqlQueryObjectWhere.addSelectField("*");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObjectWhere.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectWhere);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<PortType> accordiPorttypeList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt");
                sqlQueryObject.addSelectField("soap_style");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt");
                sqlQueryObject.addSelectField("soap_style");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<PortType> accordiPorttypeList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?"});
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("port_type", "id_accordo");
            sqlQueryObject.addSelectField("port_type", "nome");
            sqlQueryObject.addSelectField("port_type", "descrizione");
            sqlQueryObject.addSelectField("port_type", "profilo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "filtro_duplicati");
            sqlQueryObject.addSelectField("port_type", "conferma_ricezione");
            sqlQueryObject.addSelectField("port_type", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "consegna_in_ordine");
            sqlQueryObject.addSelectField("port_type", "scadenza");
            sqlQueryObject.addSelectField("port_type", "profilo_pt");
            sqlQueryObject.addSelectField("port_type", "soap_style");
            sqlQueryObject.addSelectField("port_type", "id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?"});
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Documento> accordiAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAllegatiList";
        int idLista = 33;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteComuneServizioCompostoServizioComponente> accordiComponentiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiComponentiList";
        int idLista = 38;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> lista = new ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("acc_serv_componenti", "id_servizio_componente");
            sqlQueryObject.addSelectField("acc_serv_componenti", "azione");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectField("servizi", "tipo_servizio");
            sqlQueryObject.addSelectField("servizi", "nome_servizio");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
            sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioComponente = risultato.getLong("id_servizio_componente");
                String azione = risultato.getString("azione");
                AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                asComponente.setAzione(azione);
                asComponente.setIdServizioComponente(idServizioComponente);
                asComponente.setTipo(risultato.getString("tipo_servizio"));
                asComponente.setNome(risultato.getString("nome_servizio"));
                asComponente.setTipoSoggetto(risultato.getString("tipo_soggetto"));
                asComponente.setNomeSoggetto(risultato.getString("nome_soggetto"));
                lista.add(asComponente);
            }
            ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Documento> accordiCoopAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopAllegatiList";
        int idLista = 37;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Operation> accordiPorttypeOperationList(int idPortType, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("port_type_azioni.id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?"});
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("port_type_azioni", "id_port_type");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "profilo_collaborazione", "profCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "filtro_duplicati", "filtro_duplicatiPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "conferma_ricezione", "conferma_ricezionePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "identificativo_collaborazione", "idCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "consegna_in_ordine", "consegna_in_ordinePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "scadenza", "scadenzaPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata", "correlataPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata_servizio", "correlataServizioPTAz");
            sqlQueryObject.addSelectField("port_type_azioni", "profilo_pt_azione");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "id", "idPTAz");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?"});
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type_azioni.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("Query: " + queryString));
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nomePTAz");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profCollPTAz");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicatiPTAz");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezionePTAz");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("idCollPTAz");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordinePTAz");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenzaPTAz");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataPTAz");
                op.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataServizioPTAz");
                op.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("idPTAz");
                op.setId(idOperation);
                lista.add(op);
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Operation> accordiPorttypeOperationList(int idPortType, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nome");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("id");
                op.setId(idOperation);
                lista.add(op);
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<MessagePart> accordiPorttypeOperationMessagePartList(int idOperation, boolean isInput, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationMessagePartList";
        int idLista = 52;
        if (!isInput) {
            idLista = 53;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessagePart> lista = new ArrayList<MessagePart>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("name", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idOperation);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idOperation);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessagePart mp = new MessagePart();
                String tmp = risultato.getString("name");
                mp.setName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_name");
                mp.setElementName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_namespace");
                mp.setElementNamespace(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_name");
                mp.setTypeName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_namespace");
                mp.setTypeNamespace(tmp == null || tmp.equals("") ? null : tmp);
                long idMessage = risultato.getLong("id");
                mp.setId(idMessage);
                lista.add(mp);
            }
            ArrayList<MessagePart> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isCorrelata(int idAccordo, String nomeAzione, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            boolean bl = tot > 0;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isOperationCorrelata(int idPortType, String nomeCorrelata, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, nomeCorrelata);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            boolean bl = tot > 0;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isOperationCorrelataDaAltraAzione(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, false, true);
    }

    public boolean isOperationCorrelataRichiesta(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, false);
    }

    public boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, true);
    }

    private boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare, boolean checkCorrelazioneARichiesta, boolean checkCorrelazioneDaAltraAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            boolean correlataAdUnaRichiesta = false;
            if (checkCorrelazioneARichiesta) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = ?");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{"port_type_azioni.correlata is not null", "port_type_azioni.correlata_servizio is not null"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                this.log.debug((Object)("VERIFICO CORRELAZIONE AD UNA RICHIESTA [" + idPortType + "] [" + azioneDaVerificare + "]: " + queryString));
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idPortType);
                stmt.setString(2, azioneDaVerificare);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataAdUnaRichiesta = tot > 0;
                this.log.debug((Object)("VERIFICO CORRELAZIONE AD UNA RICHIESTA, risultato [" + tot + "]: " + correlataAdUnaRichiesta));
            }
            boolean correlataDaUnAltraAzione = false;
            if (checkCorrelazioneDaAltraAzione) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                sqlQueryObject.addWhereCondition(true, new String[]{"port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio =?"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "]: " + queryString));
                stmt.setLong(1, idAzioneDaVerificare);
                stmt.setString(2, azioneDaVerificare);
                stmt.setString(3, nomePortType);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataDaUnAltraAzione = tot > 0;
                this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso), risultato [" + tot + "]: " + correlataDaUnAltraAzione));
                if (!correlataDaUnAltraAzione) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectCountField("id", "tot");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                    sqlQueryObject.addWhereCondition(true, new String[]{"port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio is null", "port_type_azioni.id_port_type = ?"});
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "] [" + azioneDaVerificare + "] [" + idPortType + "]: " + queryString));
                    stmt.setLong(1, idAzioneDaVerificare);
                    stmt.setString(2, azioneDaVerificare);
                    stmt.setLong(3, idPortType);
                    risultato = stmt.executeQuery();
                    tot = 0;
                    if (risultato.next()) {
                        tot = risultato.getInt("tot");
                    }
                    risultato.close();
                    stmt.close();
                    correlataDaUnAltraAzione = tot > 0;
                    this.log.debug((Object)("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type), risultato [" + tot + "]: " + correlataDaUnAltraAzione));
                }
            }
            if (correlataAdUnaRichiesta) {
                boolean bl = true;
                return bl;
            }
            if (correlataDaUnAltraAzione) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        if (this.atomica) {
            Connection con = null;
            Statement stmtTest = null;
            try {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connessione is null");
                }
                stmtTest = con.createStatement();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("db_info");
                sqlQueryObject.addSelectField("*");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stmtTest.execute(sqlQuery);
            }
            catch (Exception e) {
                throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        Statement stmtTest = null;
        try {
            if (this.globalConnection == null) {
                throw new Exception("Connessione is null");
            }
            stmtTest = this.globalConnection.createStatement();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("db_info");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmtTest.execute(sqlQuery);
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiServizioList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> serviziList = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                asps.setServizio(new Servizio());
                asps.setId(risultato.getLong("id"));
                asps.getServizio().setTipo(risultato.getString("tipo_servizio"));
                asps.getServizio().setNome(risultato.getString("nome_servizio"));
                serviziList.add(asps);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = serviziList;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(String superuser, ISearch ricerca, boolean[] permessiUtente) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiServizioList";
        int idLista = 13;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> serviziList = new ArrayList<AccordoServizioParteSpecifica>();
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            ISQLQueryObject sqlQueryObjectAccordiComposti = null;
            if (permessiUtente != null) {
                sqlQueryObjectAccordiComposti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectAccordiComposti.addFromTable("accordi");
                sqlQueryObjectAccordiComposti.addFromTable("acc_serv_composti");
                sqlQueryObjectAccordiComposti.addSelectField("acc_serv_composti", "id");
                sqlQueryObjectAccordiComposti.setANDLogicOperator(true);
                sqlQueryObjectAccordiComposti.addWhereCondition("servizi.id_accordo=accordi.id");
                sqlQueryObjectAccordiComposti.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addWhereCondition("servizi.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition(false, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true)});
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("aps_nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectField("aps_versione");
                sqlQueryObject.addSelectField("aps_nome");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("aps_nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("aps_nome");
                sqlQueryObject.addOrderBy("aps_versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectField("aps_versione");
                sqlQueryObject.addSelectField("aps_nome");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("aps_nome");
                sqlQueryObject.addOrderBy("aps_versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug((Object)("query : " + queryString));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setServizio(new Servizio());
                serv.setId(risultato.getLong("id"));
                serv.getServizio().setId(risultato.getLong("id"));
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                serv.setIdSoggetto(risultato.getLong("id_soggetto"));
                serv.setIdAccordo(risultato.getLong("id_accordo"));
                String servizio_correlato = risultato.getString("servizio_correlato");
                if (servizio_correlato != null && (servizio_correlato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizio_correlato))) {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                serv.setDescrizione(risultato.getString("descrizioneServizio"));
                Soggetto sog = this.getSoggetto(serv.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                serv.getServizio().setNomeSoggettoErogatore(nomeErogatore);
                serv.getServizio().setTipoSoggettoErogatore(tipoErogatore);
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(serv.getIdAccordo(), con);
                serv.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromAccordo(as));
                serv.setStatoPackage(risultato.getString("stato"));
                serv.setNome(risultato.getString("aps_nome"));
                serv.setVersione(risultato.getString("aps_versione"));
                serviziList.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = serviziList;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void createConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDConnettore type = 1");
            DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void updateConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDConnettore type = 2");
            DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void deleteConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            this.log.debug((Object)"CRUDConnettore type = 3");
            DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<PortaDominio> porteDominioList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.porteDominioList(superuser, null, ricerca);
    }

    public List<PortaDominio> porteDominioList(String superuser, String tipo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioList";
        int idLista = 23;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject2.addFromTable("pdd");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject2.addWhereCondition("tipo = ?");
                }
                sqlQueryObject2.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject2.addFromTable("pdd");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject2.addWhereCondition("tipo = ?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (tipo != null && !tipo.equals("")) {
                stmt.setString(index++, tipo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (tipo != null && !tipo.equals("")) {
                stmt.setString(index++, tipo);
            }
            risultato = stmt.executeQuery();
            lista = new ArrayList<PortaDominio>();
            while (risultato.next()) {
                String nome = risultato.getString("nome");
                PortaDominio pdd = this.getPortaDominio(nome);
                lista.add(pdd);
            }
            ArrayList<PortaDominio> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isPddInUso(PortaDominio pdd, List<String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "pddInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("server = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, pdd.getNome());
            risultato = stmt.executeQuery();
            boolean isInUso = false;
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipo_soggetto");
                String nome_soggetto = risultato.getString("nome_soggetto");
                whereIsInUso.add(tipo_soggetto + "/" + nome_soggetto);
                isInUso = true;
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Soggetto> pddSoggettiList(int idPdd, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "pddSoggettiList";
        int idLista = 0;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        ArrayList<Soggetto> lista = null;
        try {
            String nomePdd = "";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                nomePdd = risultato.getString("nome");
            }
            risultato.close();
            stmt.close();
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Soggetto>();
            Soggetto sog = null;
            while (risultato.next()) {
                long ids = risultato.getLong("id");
                sog = this.getSoggetto(ids, con);
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<IDSoggetto> getAllIdSoggettiErogatori(String tipoServizio, String nomeServizio, String uriAccordo, String nomePortType, String tipoSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getAllIdSoggettiErogatori";
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
            sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.port_type = ?");
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoServizio);
            stmt.setString(2, nomeServizio);
            stmt.setLong(3, idAccordoLong);
            stmt.setString(4, nomePortType);
            if (tipoSoggetto != null) {
                stmt.setString(5, tipoSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipoSoggetto");
                String nome_soggetto = risultato.getString("nomeSoggetto");
                lista.add(new IDSoggetto(tipo_soggetto, nome_soggetto));
            }
            ArrayList<IDSoggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public PortType getPortType(IDPortType idPT) throws DriverRegistroServiziException {
        String nomeMetodo = "getPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo=?");
            sqlQueryObject.addWhereCondition("port_type.nome=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setString(2, idPT.getNome());
            rs = stmt.executeQuery();
            PortType pt = null;
            if (rs.next()) {
                pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(idAccordoLong);
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
            }
            PortType portType = pt;
            return portType;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Vector<IDServizio> getIdServiziWithPortType(IDPortType idPT) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        try {
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.port_type=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setString(2, idPT.getNome());
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano il servizio " + idPT.getNome() + " dell'accordo di servizio " + idPT.getIdAccordo().toString());
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            throw dNot;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Vector<IDServizio> getIdServiziWithAccordo(IDAccordo idAccordo, boolean checkPTisNull) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        try {
            long idAccordoLong = DriverRegistroServiziDB_LIB.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            if (checkPTisNull) {
                sqlQueryObject.addWhereCondition("servizi.port_type is null");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano l'accordo di servizio " + idAccordo.toString());
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            throw dNot;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isUnicaAzioneInAccordi(String azione) throws DriverRegistroServiziException {
        String nomeMetodo = "isUnicaAzioneInAccordi";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("accordi_azioni.nome=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            int count = 0;
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita)");
            }
            count = rs.getInt("countAzioni");
            rs.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("port_type_azioni.nome=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita pt)");
            }
            if ((count += rs.getInt("countAzioni")) <= 0) {
                throw new Exception("Azione [" + azione + "] non trovata");
            }
            boolean bl = count == 1;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean existsDocumento(String nome, String tipo, String ruolo, long idProprietario, ProprietariDocumento proprietarioDocumento) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.datasource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsDocumento] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug((Object)("operazione atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("tipo = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, proprietarioDocumento.toString());
            stm.setString(3, nome);
            stm.setString(4, tipo);
            stm.setString(5, ruolo);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return exist;
    }

    public Documento getDocumento(String nome, String tipo, String ruolo, long idProprietario, boolean readBytes, ProprietariDocumento tipoProprietario) throws DriverRegistroServiziException {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            long idDoc = DriverRegistroServiziDB_LIB.getIdDocumento(nome, tipo, ruolo, idProprietario, con, this.tipoDB, tipoProprietario);
            Documento documento = DriverRegistroServiziDB_LIB.getDocumento(idDoc, readBytes, con, this.tipoDB);
            return documento;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public Documento getDocumento(long idDocumento, boolean readBytes) throws DriverRegistroServiziException {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            Documento e = DriverRegistroServiziDB_LIB.getDocumento(idDocumento, readBytes, con, this.tipoDB);
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<Documento> serviziAllegatiList(int idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziAllegatiList";
        int idLista = 35;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void validaStatoAccordoServizio(AccordoServizioParteComune as, boolean utilizzoAzioniDiretteInAccordoAbilitato) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block47: {
            erroreValidazione = new ValidazioneStatoPackageException("AccordoServizio", as.getStatoPackage(), null);
            try {
                if (!(as.getPrivato() != null && as.getPrivato().booleanValue() || as.getSoggettoReferente() == null)) {
                    IDSoggetto idS = new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome());
                    try {
                        Soggetto s = this.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
                if (as.getServizioComposto() != null) {
                    if (as.getServizioComposto().getIdAccordoCooperazione() > 0L) {
                        try {
                            AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                            if ((as.getPrivato() == null || !as.getPrivato().booleanValue()) && ac.getPrivato() != null && ac.getPrivato().booleanValue()) {
                                erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                            }
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            // empty catch block
                        }
                    }
                    if (as.getServizioComposto().sizeServizioComponenteList() >= 2) {
                        for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                            if (as.getServizioComposto().getServizioComponente(i).getId() <= 0L) continue;
                            try {
                                AccordoServizioParteSpecifica sc = this.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getId());
                                if (as.getPrivato() != null && as.getPrivato().booleanValue() || sc.getPrivato() == null || !sc.getPrivato().booleanValue()) continue;
                                erroreValidazione.addErroreValidazione("servizio componente [" + sc.getServizio().getTipo() + "/" + sc.getServizio().getNome() + "_" + sc.getServizio().getTipoSoggettoErogatore() + "/" + sc.getServizio().getNomeSoggettoErogatore() + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNot) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) break block47;
                if (!utilizzoAzioniDiretteInAccordoAbilitato) {
                    if (as.sizePortTypeList() == 0) {
                        erroreValidazione.addErroreValidazione("non sono definiti Servizi");
                    }
                    for (int j = 0; j < as.sizePortTypeList(); ++j) {
                        if (as.getPortType(j).sizeAzioneList() != 0) continue;
                        erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                    }
                } else {
                    if (as.sizePortTypeList() == 0 && as.sizeAzioneList() == 0 && !as.getUtilizzoSenzaAzione()) {
                        erroreValidazione.addErroreValidazione("non sono definite ne Azioni (utilizzoSenzaAzione=false) ne Servizi");
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            if (as.getPortType(j).sizeAzioneList() != 0) continue;
                            erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                        }
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            PortType pt = as.getPortType(j);
                            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                                Operation op = pt.getAzione(k);
                                ProfiloCollaborazione profiloCollaborazioneOP = op.getProfiloCollaborazione();
                                if ("default".equals(op.getProfAzione())) {
                                    profiloCollaborazioneOP = pt.getProfiloCollaborazione();
                                    if ("default".equals(pt.getProfiloPT())) {
                                        profiloCollaborazioneOP = as.getProfiloCollaborazione();
                                    }
                                }
                                if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) && !CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals(profiloCollaborazioneOP) || op.getCorrelata() != null) continue;
                                boolean trovataCorrelazione = false;
                                block17: for (int verificaPTIndex = 0; verificaPTIndex < as.sizePortTypeList(); ++verificaPTIndex) {
                                    PortType ptVerifica = as.getPortType(verificaPTIndex);
                                    for (int verificaOPIndex = 0; verificaOPIndex < ptVerifica.sizeAzioneList(); ++verificaOPIndex) {
                                        Operation opVerifica = ptVerifica.getAzione(verificaOPIndex);
                                        if (opVerifica.getCorrelata() == null || !opVerifica.getCorrelata().equals(op.getNome())) continue;
                                        if (opVerifica.getCorrelataServizio() == null) {
                                            if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) || !ptVerifica.getNome().equals(pt.getNome())) continue;
                                            trovataCorrelazione = true;
                                            continue block17;
                                        }
                                        if (!opVerifica.getCorrelataServizio().equals(pt.getNome())) continue;
                                        trovataCorrelazione = true;
                                        continue block17;
                                    }
                                }
                                if (trovataCorrelazione) continue;
                                erroreValidazione.addErroreValidazione("L'azione [" + op.getNome() + "] del servizio[" + as.getPortType(j).getNome() + "] non risulta correlata da altre azioni");
                            }
                        }
                    }
                }
                if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) break block47;
                String wsdlConcettuale = as.getByteWsdlConcettuale() != null ? new String(as.getByteWsdlConcettuale()) : null;
                String wsdlLogicoErogatore = as.getByteWsdlLogicoErogatore() != null ? new String(as.getByteWsdlLogicoErogatore()) : null;
                wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
                String string = wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
                if (wsdlConcettuale == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL Concettuale non definita");
                }
                if (wsdlLogicoErogatore == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL LogicoErogatore non definita");
                }
                if (as.getServizioComposto() == null) break block47;
                if (as.getServizioComposto().getIdAccordoCooperazione() <= 0L) {
                    erroreValidazione.addErroreValidazione("accordo di cooperazione (id) non definito");
                } else {
                    try {
                        AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                        if (!StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] in uno stato non finale [" + ac.getStatoPackage() + "]");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di cooperazione non definito");
                    }
                }
                if (as.getServizioComposto().sizeSpecificaCoordinamentoList() <= 0) {
                    erroreValidazione.addErroreValidazione("specifica di coordinamento non definita");
                }
                if (as.getServizioComposto().sizeServizioComponenteList() <= 0) {
                    erroreValidazione.addErroreValidazione("servizi componenti non definiti");
                } else if (as.getServizioComposto().sizeServizioComponenteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 servizi componenti sono necessari per realizzare un servizio composto");
                } else {
                    for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                        if (as.getServizioComposto().getServizioComponente(i).getIdServizioComponente() <= 0L) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] (id) non definito");
                            continue;
                        }
                        try {
                            AccordoServizioParteSpecifica sc = this.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getIdServizioComponente());
                            if (StatiAccordo.finale.toString().equals(sc.getStatoPackage())) continue;
                            erroreValidazione.addErroreValidazione("servizio componente [" + sc.getServizio().getTipo() + "/" + sc.getServizio().getNome() + "_" + sc.getServizio().getTipoSoggettoErogatore() + "/" + sc.getServizio().getNomeSoggettoErogatore() + "] in uno stato non finale [" + sc.getStatoPackage() + "]");
                            continue;
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] non definito");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoAccordoCooperazione(AccordoCooperazione ac) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("AccordoCooperazione", ac.getStatoPackage(), null);
        try {
            AccordoCooperazionePartecipanti partecipanti;
            if (!(ac.getPrivato() != null && ac.getPrivato().booleanValue() || ac.getSoggettoReferente() == null)) {
                IDSoggetto idS = new IDSoggetto(ac.getSoggettoReferente().getTipo(), ac.getSoggettoReferente().getNome());
                try {
                    Soggetto s = this.getSoggetto(idS);
                    if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                        erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    // empty catch block
                }
            }
            if (ac.getElencoPartecipanti() != null && (partecipanti = ac.getElencoPartecipanti()).sizeSoggettoPartecipanteList() >= 2) {
                for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                    if (partecipanti.getSoggettoPartecipante(i).getIdSoggetto() <= 0L) continue;
                    try {
                        Soggetto s = this.getSoggetto(partecipanti.getSoggettoPartecipante(i).getIdSoggetto());
                        if (s.getPrivato() == null || !s.getPrivato().booleanValue()) continue;
                        erroreValidazione.addErroreValidazione("soggetto partecipante [" + s.getTipo() + "/" + s.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        continue;
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
            }
            if (!StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                if (ac.getElencoPartecipanti() == null) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() <= 0) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 soggetti partecipanti devono essere definiti");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block22: {
            erroreValidazione = new ValidazioneStatoPackageException("Servizio", servizio.getStatoPackage(), null);
            try {
                Soggetto soggettoErogatore;
                AccordoServizioParteComune as;
                if (servizio.getPrivato() == null || !servizio.getPrivato().booleanValue()) {
                    IDSoggetto idS = new IDSoggetto(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                    try {
                        Soggetto s = this.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto erogatore [" + idS + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                    try {
                        AccordoServizioParteComune as2 = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (as2.getPrivato() != null && as2.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("accordo di servizio [" + servizio.getAccordoServizioParteComune() + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        // empty catch block
                    }
                }
                if (StatiAccordo.bozza.toString().equals(servizio.getStatoPackage())) break block22;
                if (StatiAccordo.operativo.toString().equals(servizio.getStatoPackage())) {
                    try {
                        as = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (!StatiAccordo.finale.toString().equals(as.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(as.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di servizio riferito [" + this.idAccordoFactory.getUriFromAccordo(as) + "] possiede lo stato [" + as.getStatoPackage() + "]");
                        }
                        break block22;
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                    }
                    break block22;
                }
                if (!StatiAccordo.finale.toString().equals(servizio.getStatoPackage())) break block22;
                try {
                    as = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                    if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(as) + "] in uno stato non finale [" + as.getStatoPackage() + "]");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                }
                if (TipologiaServizio.CORRELATO.equals(servizio.getServizio().getTipologiaServizio())) {
                    String wsdlImplementativoFruitore = servizio.getByteWsdlImplementativoFruitore() != null ? new String(servizio.getByteWsdlImplementativoFruitore()) : null;
                    String string = wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
                    if (wsdlImplementativoFruitore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo fruitore non definito");
                    }
                } else {
                    String wsdlImplementativoErogatore = servizio.getByteWsdlImplementativoErogatore() != null ? new String(servizio.getByteWsdlImplementativoErogatore()) : null;
                    String string = wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
                    if (wsdlImplementativoErogatore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo erogatore non definito");
                    }
                }
                if ((servizio.getServizio().getConnettore() == null || "disabilitato".equals(servizio.getServizio().getConnettore().getTipo())) && ((soggettoErogatore = this.getSoggetto(new IDSoggetto(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore()))).getConnettore() == null || "disabilitato".equals(soggettoErogatore.getConnettore().getTipo()))) {
                    erroreValidazione.addErroreValidazione("Sia l'Accordo di servizio parte specifica che il soggetto erogatore non possiedono un connettore");
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoFruitoreServizio(Fruitore fruitore, AccordoServizioParteSpecifica serv) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("FruitoreServizio", fruitore.getStatoPackage(), null);
        try {
            if (!StatiAccordo.bozza.toString().equals(fruitore.getStatoPackage())) {
                if (StatiAccordo.operativo.toString().equals(fruitore.getStatoPackage())) {
                    if (!StatiAccordo.finale.toString().equals(serv.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(serv.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("servizio riferito [" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] erogato dal soggetto [" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] possiede lo stato [" + serv.getStatoPackage() + "]");
                    }
                } else if (StatiAccordo.finale.toString().equals(fruitore.getStatoPackage()) && !StatiAccordo.finale.toString().equals(serv.getStatoPackage())) {
                    erroreValidazione.addErroreValidazione("servizio [" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] erogato dal soggetto [" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] in uno stato non finale [" + serv.getStatoPackage() + "]");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void controlloUnicitaImplementazioneAccordoPerSoggetto(String portType, IDSoggetto idSoggettoErogatore, long idSoggettoErogatoreLong, IDAccordo idAccordoServizioParteComune, long idAccordoServizioParteComuneLong, IDServizio idAccordoServizioParteSpecifica, long idAccordoServizioParteSpecificaLong, boolean isUpdate, boolean isServizioCorrelato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) throws DriverRegistroServiziException {
        String tmpServCorr = CostantiRegistroServizi.DISABILITATO.toString();
        if (isServizioCorrelato) {
            tmpServCorr = CostantiRegistroServizi.ABILITATO.toString();
        }
        String s = "servizio";
        if (isServizioCorrelato) {
            s = "servizio correlato";
        }
        if (portType == null || "-".equals(portType)) {
            if (isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto) {
                int idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorr(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, tmpServCorr);
                boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0;
                boolean changeError = false;
                if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0) {
                    boolean bl = changeError = idAccordoServizioParteSpecificaLong != (long)idAccordoServizioParteSpecificaAlreadyExists;
                }
                if (addError || changeError) {
                    throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa l'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
                }
            }
        } else if (isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) {
            int idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorrPt(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, tmpServCorr, portType);
            boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0;
            boolean changeError = false;
            if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0) {
                boolean bl = changeError = idAccordoServizioParteSpecificaLong != (long)idAccordoServizioParteSpecificaAlreadyExists;
            }
            if (addError || changeError) {
                throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa il servizio " + portType + " dell'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
            }
        }
    }

    public List<AccordoServizioParteComune> accordiCompatibiliList(ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCompatibiliList";
        int idLista = 17;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug((Object)("search : " + search));
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> lista = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true), "accordi.id_referente=soggetti.id"});
            }
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereCondition(false, new String[]{sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addWhereCondition(false, new String[]{sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            this.log.debug((Object)("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0])));
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            AccordoServizioParteComune accordo = null;
            while (risultato.next()) {
                accordo = new AccordoServizioParteComune();
                accordo.setId(risultato.getLong("id"));
                accordo.setNome(risultato.getString("nome"));
                accordo.setDescrizione(risultato.getString("descrizione"));
                accordo.setStatoPackage(risultato.getString("stato"));
                accordo.setVersione(risultato.getString("versione"));
                if (risultato.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(new Long(risultato.getInt("id_referente")), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    accordo.setSoggettoReferente(assr);
                }
                lista.add(accordo);
                this.readAccordoServizioComposto(accordo, con);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return lista;
    }

    public List<PortType> accordiPorttypeCompatibiliList(int idAccordo, boolean isErogazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeCompatibiliList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<PortaDominio> porteDominioWithSubject(String subject) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioWithSubject";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = new ArrayList<PortaDominio>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            Hashtable hashSubject = Utilities.getSubjectIntoHashtable((String)subject);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("subject");
            Enumeration keys = hashSubject.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)hashSubject.get(key);
                sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject((String)key) + "=" + Utilities.formatValueSubject((String)value) + "/", true, false);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String subjectPotenziale = risultato.getString("subject");
                if (!Utilities.sslVerify((String)subjectPotenziale, (String)subject)) continue;
                PortaDominio pdd = this.getPortaDominio(risultato.getString("nome"));
                lista.add(pdd);
            }
            ArrayList<PortaDominio> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<String> fruzioniWithClientAuthAbilitato(String nomePdD) throws DriverRegistroServiziException {
        String nomeMetodo = "fruzioniWithClientAuthAbilitato";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug((Object)("operazione this.atomica = " + this.atomica));
        try {
            ISQLQueryObject sqlQueryObjectInner = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObjectInner.addFromTable(this.tabellaSoggetti);
            sqlQueryObjectInner.addSelectField("id");
            sqlQueryObjectInner.addWhereCondition("server=?");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("client_auth=?");
            sqlQueryObject.addWhereINSelectSQLCondition(false, "id_soggetto", sqlQueryObjectInner);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("QUERY [" + queryString + "] 1[" + CostantiRegistroServizi.ABILITATO + "] 2[" + nomePdD + "]"));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.ABILITATO));
            stmt.setString(2, nomePdD);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto fruitore = this.getSoggetto(risultato.getLong("id_soggetto"));
                AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                lista.add("Fruizione da parte del soggetto " + fruitore.getTipo() + "/" + fruitore.getNome() + " verso l'accordo di servizio parte specifica " + this.idAccordoFactory.getUriFromAccordo(servizio) + ", servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome());
            }
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (error && this.atomica) {
                    this.log.debug((Object)"eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug((Object)"eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public List<IDServizioApplicativo> getAllIdServiziApplicativiAutorizzati(IDAccordo idAccordoServizioParteSpecifica, IDSoggetto idFruitore) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug((Object)"getAllIdServiziApplicativiAutorizzati...");
        try {
            this.log.debug((Object)("operazione atomica = " + this.atomica));
            con = this.atomica ? this.datasource.getConnection() : this.globalConnection;
            long idSoggettoLong = DBUtils.getIdSoggetto(idFruitore.getNome(), idFruitore.getTipo(), con, this.tipoDB);
            long idAccordoServizioParteSpecificaLong = this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, false).getId();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("politiche_sicurezza");
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_applicativi.nome");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("id_fruitore > ?");
            sqlQueryObject.addWhereCondition("id_servizio > ?");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id=politiche_sicurezza.id_servizio_applicativo");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug((Object)("eseguo query : " + sqlQuery));
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt, idSoggettoLong);
            stm.setLong(++indexStmt, idAccordoServizioParteSpecificaLong);
            ++indexStmt;
            rs = stm.executeQuery();
            Vector<IDServizioApplicativo> idServiziApplicativi = new Vector<IDServizioApplicativo>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idS);
                idSA.setNome(rs.getString("nome"));
                idServiziApplicativi.add(idSA);
            }
            if (idServiziApplicativi.size() == 0) {
                throw new DriverRegistroServiziNotFound("ServiziApplicativi non trovati per il fruitore [" + idFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]");
            }
            Vector<IDServizioApplicativo> vector = idServiziApplicativi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServiziApplicativiAutorizzati error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.atomica) {
                    this.log.debug((Object)"rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

