/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;

public class IDAccordoFactory {
    private static IDAccordoFactory factory = null;

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDAccordoFactory();
        }
    }

    public static IDAccordoFactory getInstance() {
        if (factory == null) {
            IDAccordoFactory.init();
        }
        return factory;
    }

    private IDAccordo build(String nome, IDSoggetto soggettoReferente, String versione) {
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.setNome(nome);
        idAccordo.setSoggettoReferente(soggettoReferente);
        String v = null;
        if (versione != null && !"".equals(versione)) {
            v = versione;
        }
        idAccordo.setVersione(v);
        return idAccordo;
    }

    public String getUriFromIDAccordo(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("IDAccordo non fornito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("Nome accordo non fornito");
        }
        IDSoggetto soggettoReferente = idAccordo.getSoggettoReferente();
        if (soggettoReferente != null) {
            if (soggettoReferente.getTipo() == null) {
                throw new DriverRegistroServiziException("Tipo soggetto referente non fornito?");
            }
            if (soggettoReferente.getNome() == null) {
                throw new DriverRegistroServiziException("Nome soggetto referente non fornito?");
            }
        }
        if (soggettoReferente != null && idAccordo.getVersione() != null) {
            return soggettoReferente.toString() + ":" + idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        if (idAccordo.getVersione() != null) {
            return idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        if (soggettoReferente != null) {
            return soggettoReferente.toString() + ":" + idAccordo.getNome();
        }
        return idAccordo.getNome();
    }

    public String getUriFromAccordo(AccordoServizioParteComune accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromAccordo(AccordoServizioParteSpecifica accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoErogatore(accordo.getServizio()), accordo.getVersione());
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, IDSoggetto soggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        if (soggettoReferente == null) {
            return this.getUriFromValues(nomeAS, null, null, ver);
        }
        return this.getUriFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public IDAccordo getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new Exception("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0) {
                secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1);
            }
            int terzoMarcatore = -1;
            if (secondoMarcatore > 0 && (terzoMarcatore = uriAccordo.indexOf(":", secondoMarcatore + 1)) > 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            if (primoMarcatore < 0) {
                IDAccordo idAccordo = this.build(uriAccordo, null, null);
                return idAccordo;
            }
            String tmp1 = null;
            String tmp2 = null;
            String tmp3 = null;
            if (primoMarcatore >= 0 && secondoMarcatore > 0) {
                tmp1 = uriAccordo.substring(0, primoMarcatore);
                tmp2 = uriAccordo.substring(primoMarcatore + 1, secondoMarcatore);
                tmp3 = uriAccordo.substring(secondoMarcatore + 1, uriAccordo.length());
                int divisorioSoggettoReferente = tmp1.indexOf("/");
                if (divisorioSoggettoReferente <= 0) {
                    throw new Exception("sintassi del soggetto referente non corretta, l'uri deve essere definita con la seguente forma: tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
                }
                String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
                String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
                IDAccordo idAccordo = this.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), tmp3);
                return idAccordo;
            }
            tmp1 = uriAccordo.substring(0, primoMarcatore);
            tmp2 = uriAccordo.substring(primoMarcatore + 1, uriAccordo.length());
            int divisorioSoggettoReferente = tmp1.indexOf("/");
            if (divisorioSoggettoReferente < 0) {
                IDAccordo idAccordo = this.build(tmp1, null, tmp2);
                return idAccordo;
            }
            if (divisorioSoggettoReferente == 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
            String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
            IDAccordo idAccordo = this.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), null);
            return idAccordo;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public IDAccordo getIDAccordoFromAccordo(AccordoServizioParteComune accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return idAccordo;
    }

    public IDAccordo getIDAccordoFromAccordo(AccordoServizioParteSpecifica accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), new IDSoggetto(accordo.getServizio().getTipoSoggettoErogatore(), accordo.getServizio().getNomeSoggettoErogatore()), accordo.getVersione());
        return idAccordo;
    }

    public IDAccordo getIDAccordoFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return idAccordo;
    }

    public IDAccordo getIDAccordoFromValuesWithoutCheck(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, String ver) throws DriverRegistroServiziException {
        IDSoggetto soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return idAccordo;
    }

    public IDAccordo getIDAccordoFromValues(String nomeAS, IDSoggetto soggettoReferente, String ver) throws DriverRegistroServiziException {
        if (soggettoReferente == null) {
            return this.getIDAccordoFromValues(nomeAS, null, null, ver);
        }
        return this.getIDAccordoFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public boolean versioneNonDefinita(String value) {
        return value == null || "".equals(value);
    }
}

