/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.HttpUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;

public class AccordoServizioUtils {
    private Logger logger = null;
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;

    public AccordoServizioUtils(Logger log) {
        this.logger = log != null ? log : Logger.getLogger(AccordoServizioUtils.class);
        this.xmlUtils = XMLUtils.getInstance();
        this.xsdUtils = new XSDUtils(this.xmlUtils);
    }

    public Schema buildSchema(AccordoServizioParteComune as, boolean fromBytes) throws DriverRegistroServiziException {
        File f;
        URL url;
        String location;
        String systemId;
        byte[] resource;
        boolean definitorioPresente = false;
        if (fromBytes) {
            definitorioPresente = as.getByteWsdlDefinitorio() != null;
        } else {
            boolean bl = definitorioPresente = as.getWsdlDefinitorio() != null;
        }
        if (!definitorioPresente && as.sizeAllegatoList() == 0 && as.sizeSpecificaSemiformaleList() == 0) {
            throw new DriverRegistroServiziException("L'acccordo di servizio parte comune non contiene schemi");
        }
        Hashtable<String, byte[]> resources = new Hashtable<String, byte[]>();
        Hashtable mappingNamespaceLocations = new Hashtable();
        if (fromBytes && as.getByteWsdlDefinitorio() != null || !fromBytes && as.getWsdlDefinitorio() != null) {
            byte[] resource2 = null;
            String systemId2 = null;
            if (fromBytes) {
                systemId2 = "InterfacciaDefinitoria.xsd";
                resource2 = as.getByteWsdlDefinitorio();
            } else {
                String location2 = as.getWsdlDefinitorio();
                try {
                    if (location2.startsWith("http://") || location2.startsWith("file://")) {
                        URL url2 = new URL(location2);
                        resource2 = HttpUtilities.requestHTTPFile((String)url2.toString());
                        systemId2 = new File(url2.getFile()).getName();
                    } else {
                        File f2 = new File(location2);
                        resource2 = FileSystemUtilities.readBytesFromFile((File)f2);
                        systemId2 = f2.getName();
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'acccordo di servizio parte comune indirizza un wsdl definitorio [" + location2 + "] non esistente");
                }
            }
            try {
                if (this.xsdUtils.isXSDSchema(resource2)) {
                    resources.put(systemId2, resource2);
                    this.xsdUtils.registraMappingNamespaceLocations(resource2, systemId2, mappingNamespaceLocations);
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("La lettura del wsdl definitorio ha causato un errore: " + e.getMessage(), e);
            }
        }
        if (as.sizeAllegatoList() > 0) {
            for (int i = 0; i < as.sizeAllegatoList(); ++i) {
                Documento allegato = as.getAllegato(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = allegato.getFile();
                    resource = allegato.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Allegato [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = allegato.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile((String)url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile((File)f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Allegato [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!this.xsdUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura dell'allegato [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        if (as.sizeSpecificaSemiformaleList() > 0) {
            for (int i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
                Documento specificaSemiformale = as.getSpecificaSemiformale(i);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = specificaSemiformale.getFile();
                    resource = specificaSemiformale.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = specificaSemiformale.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile((String)url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile((File)f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!this.xsdUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura della specifica semiformale [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        try {
            return this.xsdUtils.buildSchema(resources, mappingNamespaceLocations, this.logger);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }
}

