/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.id;

import java.io.Serializable;
import org.openspcoop2.core.id.IDSoggetto;

public class IDServizio
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String tipoServizio;
    protected String servizio;
    protected String versioneServizio = "1";
    protected IDSoggetto soggettoErogatore;
    protected String uriAccordo;
    protected String azione;
    private String tipologiaServizio;

    public IDServizio(IDSoggetto soggettoErogatore, String tipoServizio, String servizio, String azione) {
        this.soggettoErogatore = soggettoErogatore;
        this.tipoServizio = tipoServizio;
        this.servizio = servizio;
        this.azione = azione;
    }

    public IDServizio(IDSoggetto soggettoErogatore, String tipoServizio, String servizio) {
        this.soggettoErogatore = soggettoErogatore;
        this.tipoServizio = tipoServizio;
        this.servizio = servizio;
        this.azione = null;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto, String tipoServizio, String servizio, String azione) {
        this.soggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
        this.tipoServizio = tipoServizio;
        this.servizio = servizio;
        this.azione = azione;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto, String tipoServizio, String servizio) {
        this.soggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
        this.tipoServizio = tipoServizio;
        this.servizio = servizio;
        this.azione = null;
    }

    public IDServizio(IDSoggetto soggettoErogatore) {
        this.soggettoErogatore = soggettoErogatore;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto) {
        this.soggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
    }

    public IDServizio() {
    }

    public void setSoggettoErogatore(IDSoggetto soggettoErogatore) {
        this.soggettoErogatore = soggettoErogatore;
    }

    public void setSoggettoErogatore(String aTipoSoggetto, String aSoggetto) {
        this.soggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
    }

    public void setTipoServizio(String tipoServizio) {
        this.tipoServizio = tipoServizio;
    }

    public void setServizio(String servizio) {
        this.servizio = servizio;
    }

    public void setAzione(String azione) {
        this.azione = azione;
    }

    public IDSoggetto getSoggettoErogatore() {
        return this.soggettoErogatore;
    }

    public String getTipoServizio() {
        return this.tipoServizio;
    }

    public String getServizio() {
        return this.servizio;
    }

    public String getAzione() {
        return this.azione;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.soggettoErogatore != null) {
            bf.append(this.soggettoErogatore.getTipo());
            bf.append("/");
            bf.append(this.soggettoErogatore.getNome());
        }
        bf.append("--");
        bf.append(this.tipoServizio);
        bf.append("/");
        bf.append(this.servizio);
        if (this.versioneServizio != null) {
            bf.append(":");
            bf.append(this.versioneServizio);
        }
        if (this.azione != null) {
            bf.append("--");
            bf.append(this.azione);
        }
        return bf.toString();
    }

    public String getUriAccordo() {
        return this.uriAccordo;
    }

    public void setUriAccordo(String uriAccordo) {
        this.uriAccordo = uriAccordo;
    }

    public String getTipologiaServizio() {
        return this.tipologiaServizio;
    }

    public void setTipologiaServizio(String tipologiaServizio) {
        this.tipologiaServizio = tipologiaServizio;
    }

    public String getVersioneServizio() {
        if (this.versioneServizio == null) {
            return "1";
        }
        return this.versioneServizio;
    }

    public int getVersioneServizioAsInt() {
        return Integer.parseInt(this.getVersioneServizio());
    }

    public void setVersioneServizio(String versioneServizio) {
        this.versioneServizio = versioneServizio == null ? "1" : versioneServizio;
    }

    public boolean equals(Object servizio) {
        if (servizio == null) {
            return false;
        }
        if (!servizio.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        IDServizio id = (IDServizio)servizio;
        if (this.getTipoServizio() == null ? id.getTipoServizio() != null : !this.getTipoServizio().equals(id.getTipoServizio())) {
            return false;
        }
        if (this.getServizio() == null ? id.getServizio() != null : !this.getServizio().equals(id.getServizio())) {
            return false;
        }
        if (this.getVersioneServizio() == null ? id.getVersioneServizio() != null : !this.getVersioneServizio().equals(id.getVersioneServizio())) {
            return false;
        }
        if (this.getAzione() == null ? id.getAzione() != null : !this.getAzione().equals(id.getAzione())) {
            return false;
        }
        return !(this.getSoggettoErogatore() == null ? id.getSoggettoErogatore() != null : !this.getSoggettoErogatore().equals(id.getSoggettoErogatore()));
    }

    public IDServizio clone() {
        IDServizio s = new IDServizio();
        if (this.azione != null) {
            s.setAzione(new String(this.azione));
        }
        if (this.tipologiaServizio != null) {
            s.setTipologiaServizio(new String(this.tipologiaServizio));
        }
        if (this.servizio != null) {
            s.setServizio(new String(this.servizio));
        }
        if (this.versioneServizio != null) {
            s.setVersioneServizio(new String(this.versioneServizio));
        }
        if (this.tipoServizio != null) {
            s.setTipoServizio(new String(this.tipoServizio));
        }
        if (this.uriAccordo != null) {
            s.setUriAccordo(new String(this.uriAccordo));
        }
        if (this.soggettoErogatore != null) {
            IDSoggetto sogg = this.soggettoErogatore.clone();
            s.setSoggettoErogatore(sogg);
        }
        return s;
    }
}

