/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eccezione.errore_applicativo.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop2.core.eccezione.errore_applicativo.DatiCooperazione;
import org.openspcoop2.core.eccezione.errore_applicativo.Dominio;
import org.openspcoop2.core.eccezione.errore_applicativo.Eccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.ErroreApplicativo;
import org.openspcoop2.core.eccezione.errore_applicativo.Servizio;
import org.openspcoop2.core.eccezione.errore_applicativo.Soggetto;
import org.openspcoop2.core.eccezione.errore_applicativo.utils.XMLUtilsException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.ValidatoreXSD;
import org.openspcoop2.utils.xml.JiBXUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/openspcoopErroreApplicativo.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(ErroreApplicativo erroreApplicativo, StringBuffer motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (erroreApplicativo.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(erroreApplicativo.getDominio(), motivoErroreValidazione);
        }
        if (erroreApplicativo.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (erroreApplicativo.getDatiCooperazione() != null) {
            XMLUtils.validate(erroreApplicativo.getDatiCooperazione(), motivoErroreValidazione);
        }
        XMLUtils.validate(erroreApplicativo.getEccezione(), motivoErroreValidazione);
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuffer motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getFunzione() == null) {
            motivoErroreValidazione.append("Dominio.funzione non definito\n");
        }
        if (dominio.getModulo() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    private static void validate(DatiCooperazione datiCooperazione, StringBuffer motivoErroreValidazione) {
        if (datiCooperazione.getFruitore() != null) {
            XMLUtils.validate(datiCooperazione.getFruitore(), motivoErroreValidazione, "mittente");
        }
        if (datiCooperazione.getErogatore() != null) {
            XMLUtils.validate(datiCooperazione.getErogatore(), motivoErroreValidazione, "destinatario");
        }
        if (datiCooperazione.getServizio() != null) {
            XMLUtils.validate(datiCooperazione.getServizio(), motivoErroreValidazione);
        }
    }

    private static void validate(Soggetto soggetto, StringBuffer motivoErroreValidazione, String tipo) {
        if (soggetto.getIdentificativo() == null) {
            motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo non definita\n");
        } else {
            if (soggetto.getIdentificativo().getTipo() == null) {
                motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo.tipo non definita\n");
            }
            if (soggetto.getIdentificativo().getBase() == null) {
                motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo.base non definita\n");
            }
        }
        if (soggetto.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativoPorta non definita\n");
        }
    }

    private static void validate(Servizio servizio, StringBuffer motivoErroreValidazione) {
        if (servizio.getBase() == null) {
            motivoErroreValidazione.append("DatiCooperazione.servizio.base non definita\n");
        }
        if (servizio.getTipo() == null) {
            motivoErroreValidazione.append("DatiCooperazione.servizio.tipo non definita\n");
        }
    }

    private static void validate(Eccezione eccezione, StringBuffer motivoErroreValidazione) {
        if (eccezione == null) {
            motivoErroreValidazione.append("Eccezione non definita\n");
        } else {
            if (eccezione.getCodice() == null) {
                motivoErroreValidazione.append("Eccezione.codice non definito\n");
            } else {
                if (eccezione.getCodice().getBase() == null) {
                    motivoErroreValidazione.append("Eccezione.codice.base non definito\n");
                }
                if (eccezione.getCodice().getTipo() == null) {
                    motivoErroreValidazione.append("Eccezione.codice.tipo non definito\n");
                }
            }
            if (eccezione.getDescrizione() == null) {
                motivoErroreValidazione.append("Eccezione.descrizione non definito\n");
            }
            if (eccezione.getTipo() == null) {
                motivoErroreValidazione.append("Eccezione.tipo non definito\n");
            }
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            ErroreApplicativo erroreApplicativo = XMLUtils.getErroreApplicativo(log, bin);
            return erroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            ErroreApplicativo erroreApplicativo = XMLUtils.getErroreApplicativo(log, fin);
            return erroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getErroreApplicativo(log, m.getBytes());
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (ErroreApplicativo)JiBXUtils.xmlToObj((InputStream)binTrasformazione, ErroreApplicativo.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml((String)fileName, (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateErroreApplicativo(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateErroreApplicativo_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateErroreApplicativo_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateErroreApplicativo_engine(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JiBXUtils.objToXml((OutputStream)bout, ErroreApplicativo.class, (Object)eccezione);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, OpenSPCoop2Message msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isErroreApplicativo((Element)elem)) continue;
                        org.openspcoop2.message.XMLUtils xmlUtils = org.openspcoop2.message.XMLUtils.getInstance();
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        ErroreApplicativo de = XMLUtils.getErroreApplicativo(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isErroreApplicativo(byte[] doc) {
        try {
            org.openspcoop2.message.XMLUtils xmlUtils = org.openspcoop2.message.XMLUtils.getInstance();
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Element elemXML) {
        return XMLUtils.isErroreApplicativo_engine(elemXML);
    }

    public static boolean isErroreApplicativo(Node nodeXml) {
        return XMLUtils.isErroreApplicativo_engine(nodeXml);
    }

    private static boolean isErroreApplicativo_engine(Node nodeXml) {
        try {
            return "errore-applicativo".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/eccezione/errore_applicativo".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

