/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.driver.utils.XMLDataConverter;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.Loader;

public class TestXMLDataConverter {
    private static Boolean resetEffettuata = false;

    public static void main(String[] argoments) throws Exception {
        boolean condivisioneDBRegservPddValue;
        String tipoDatabase;
        String driver;
        String password;
        String username;
        String connection;
        boolean connectionDB;
        String superUser;
        AccessoConfigurazionePdD acCRUD;
        boolean isGestioneConfigurazione;
        boolean gestioneSoggetti;
        boolean reset;
        String protocolloDefault;
        Logger log;
        String args_tipoConversione;
        String args_sorgenteXML;
        block29: {
            if (argoments.length < 8) {
                String errorMsg = "ERROR, Usage:  java TestXMLDataConverter sorgenteXML tipoConfigurazioneCRUD proprietaConfigurazioneCRUD reset isGestioneConfigurazione tipoConversione gestioneSoggetti protocolloDefault [Logger]";
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
            args_sorgenteXML = argoments[0].trim();
            String args_tipoConfigurazioneCRUD = argoments[1].trim();
            String args_proprietaConfigurazioneCRUD = argoments[2].trim();
            String args_reset = argoments[3].trim();
            String args_isGestioneConfigurazione = argoments[4].trim();
            args_tipoConversione = argoments[5].trim();
            String args_gestioneSoggetti = argoments[6].trim();
            String args_protocolloDefault = argoments[7].trim();
            String args_logger = null;
            if (argoments.length > 8) {
                args_logger = argoments[8].trim();
            }
            String loggerValue = null;
            try {
                loggerValue = args_logger != null ? args_logger : "/xml2backend.log4j.properties";
                PropertyConfigurator.configure((String)loggerValue);
            }
            catch (Exception e) {
                String errorMsg = "Errore durante il caricamento del file di log loggerValue[" + loggerValue + "] : " + e.getMessage();
                System.err.println(errorMsg);
                throw new Exception(errorMsg);
            }
            log = Logger.getLogger((String)"gestoreDatiConfigurazione");
            Properties reader = new Properties();
            try {
                reader.load(new FileInputStream(args_proprietaConfigurazioneCRUD));
            }
            catch (IOException e) {
                String errorMsg = "Errore durante il caricamento del file di properties [" + args_proprietaConfigurazioneCRUD + "] : " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
            protocolloDefault = args_protocolloDefault;
            reset = Boolean.parseBoolean(args_reset);
            gestioneSoggetti = Boolean.parseBoolean(args_gestioneSoggetti);
            isGestioneConfigurazione = Boolean.parseBoolean(args_isGestioneConfigurazione);
            acCRUD = new AccessoConfigurazionePdD();
            superUser = null;
            connectionDB = false;
            connection = null;
            username = null;
            password = null;
            driver = null;
            tipoDatabase = null;
            condivisioneDBRegservPddValue = false;
            try {
                acCRUD.setTipo(args_tipoConfigurazioneCRUD);
                superUser = reader.getProperty("openspcoop2.superuser");
                if (superUser != null) {
                    superUser.trim();
                }
                if (!"db".equals(args_tipoConfigurazioneCRUD)) break block29;
                tipoDatabase = reader.getProperty("openspcoop2.configurazione.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String condivisioneDBRegservPdd = reader.getProperty("openspcoop2.configurazione.db.condivisioneDBRegserv");
                try {
                    condivisioneDBRegservPddValue = Boolean.parseBoolean(condivisioneDBRegservPdd.trim());
                }
                catch (Exception e) {
                    throw new Exception("Non e' stato definita o e' definita non correttamente la proprieta' [openspcoop2.configurazione.db.condivisioneDBRegserv]: " + e.getMessage());
                }
                String dataSource = reader.getProperty("openspcoop2.configurazione.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties((String)"openspcoop2.configurazione.db.context.", (Properties)reader);
                    acCRUD.setLocation(dataSource);
                    acCRUD.setContext(context);
                    acCRUD.setTipoDatabase(tipoDatabase);
                } else {
                    connectionDB = true;
                    connection = reader.getProperty("openspcoop2.configurazione.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    driver = reader.getProperty("openspcoop2.configurazione.db.driver");
                    if (driver == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driver = driver.trim();
                    username = reader.getProperty("openspcoop2.configurazione.db.user");
                    password = reader.getProperty("openspcoop2.configurazione.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                }
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la lettura del file di properties [" + args_proprietaConfigurazioneCRUD + "] : " + e.getMessage();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
        }
        Connection connectionSQL = null;
        try {
            File fSorgente = new File(args_sorgenteXML);
            if (connectionDB) {
                Loader.getInstance().newInstance(driver);
                connectionSQL = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
            }
            TestXMLDataConverter.letturaSorgenti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, acCRUD, condivisioneDBRegservPddValue, superUser, protocolloDefault, args_tipoConversione, isGestioneConfigurazione, reset, gestioneSoggetti);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la conversione XML dei dati: " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            try {
                if (connectionSQL != null) {
                    connectionSQL.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reset(boolean b) {
        if (b) {
            Boolean bl = resetEffettuata;
            synchronized (bl) {
                if (!resetEffettuata.booleanValue()) {
                    resetEffettuata = true;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void letturaSorgenti(File fSorgente, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, AccessoConfigurazionePdD acCRUD, boolean condivisioneDBRegservPddValue, String superUser, String protocolloDefault, String tipoConversione, boolean isGestioneConfigurazione, boolean reset, boolean gestioneSoggetti) throws Exception {
        if (fSorgente.isFile()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Sorgente XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            if (fSorgente.getName().endsWith(".xml")) {
                TestXMLDataConverter.converti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, acCRUD, condivisioneDBRegservPddValue, superUser, protocolloDefault, tipoConversione, isGestioneConfigurazione, reset, gestioneSoggetti);
            } else {
                log.debug((Object)("File [" + fSorgente.getAbsolutePath() + "] ignorato. Non possiede l'estensione .xml"));
            }
        } else if (fSorgente.isDirectory()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Directory contenente gli XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            File[] f = fSorgente.listFiles();
            if (f == null || f.length <= 0) {
                throw new Exception("Directory [" + fSorgente.getAbsolutePath() + "] non contiene XML");
            }
            for (int i = 0; i < f.length; ++i) {
                TestXMLDataConverter.letturaSorgenti(f[i], connectionDB, connectionSQL, tipoDatabase, log, acCRUD, condivisioneDBRegservPddValue, superUser, protocolloDefault, tipoConversione, isGestioneConfigurazione, reset, gestioneSoggetti);
            }
        }
    }

    private static void converti(File f, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, AccessoConfigurazionePdD acCRUD, boolean condivisioneDBRegservPddValue, String superUser, String protocolloDefault, String tipoConversione, boolean isGestioneConfigurazione, boolean reset, boolean gestioneSoggetti) throws Exception {
        XMLDataConverter dataConverter = null;
        Logger logDriver = null;
        dataConverter = connectionDB ? new XMLDataConverter(f, connectionSQL, tipoDatabase, isGestioneConfigurazione, condivisioneDBRegservPddValue, superUser, protocolloDefault, log, logDriver) : new XMLDataConverter(f, acCRUD, isGestioneConfigurazione, condivisioneDBRegservPddValue, superUser, protocolloDefault, log, logDriver);
        if ("insertUpdate".equals(tipoConversione)) {
            log.info((Object)"Inizio conversione...");
            dataConverter.convertXML(TestXMLDataConverter.reset(reset), gestioneSoggetti);
            log.info((Object)"Conversione terminata.");
        } else if ("delete".equals(tipoConversione)) {
            log.info((Object)"Inizio conversione...");
            dataConverter.delete(gestioneSoggetti);
            log.info((Object)"Conversione terminata.");
        } else {
            throw new Exception("Valore opzione 'tipoConversioneConfigurazione' non gestito (valori possibili insertUpdate/delete): " + tipoConversione);
        }
    }
}

