/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCParameterUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCSqlLogger;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBUtils {
    public static String estraiTipoDatabaseFromLocation(String location) throws CoreException {
        if (location == null) {
            throw new CoreException("Location del db is null");
        }
        if (location.indexOf("@") == -1) {
            throw new CoreException("Tipo di database non indicato nella location, sintassi corretta e' tipoDatabase@datasource");
        }
        String tipoDatabase = location.split("@")[0].trim();
        if (!TipiDatabase.isAMember((String)tipoDatabase)) {
            throw new CoreException("Tipo di database indicato nella location [" + tipoDatabase + "] non supportato");
        }
        return tipoDatabase;
    }

    public static List<List<Object>> readCustom(Logger log, Connection connection, String tipoDB, ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (returnTypes == null || returnTypes.size() <= 0) {
                throw new CoreException("Non sono stati definiti tipi da ritornare");
            }
            ArrayList<List<Object>> lista = new ArrayList<List<Object>>();
            String sql = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sql);
            JDBCParameterUtilities jdbcParameterUtilities = new JDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDB));
            JDBCObject[] paramsArray = null;
            if (paramTypes != null && paramTypes.size() > 0) {
                paramsArray = paramTypes.toArray(new JDBCObject[1]);
            }
            jdbcParameterUtilities.setParameters((PreparedStatement)stm, paramsArray);
            JDBCSqlLogger sqlLogger = new JDBCSqlLogger(log);
            sqlLogger.infoSql(sql, paramsArray);
            rs = stm.executeQuery();
            while (rs.next()) {
                ArrayList<Object> listaInterna = new ArrayList<Object>();
                for (int i = 0; i < returnTypes.size(); ++i) {
                    listaInterna.add(jdbcParameterUtilities.readParameter(rs, i + 1, returnTypes.get(i)));
                }
                lista.add(listaInterna);
            }
            ArrayList<List<Object>> arrayList = lista;
            return arrayList;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB, "soggetti");
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoSoggetto);
            stm.setString(2, nomeSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            long l = idSoggetto;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdConnettore(String nomeConnettore, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_connettore = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nomeConnettore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, testServizioNonCorrelato, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            if (testServizioNonCorrelato) {
                query = query + " AND servizio_correlato=?";
            }
            stm = con.prepareStatement(query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            if (testServizioNonCorrelato) {
                stm.setString(4, "disabilitato");
            }
            if ((rs = stm.executeQuery()).next()) {
                idServizio = rs.getLong("id");
            }
            long l = idServizio;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPortaApplicativa = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaApplicativa = rs.getLong("id");
            }
            long l = idPortaApplicativa;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }
}

