/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.api.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.api.HeaderParameter;
import org.openspcoop2.core.api.HeaderParameters;
import org.openspcoop2.core.api.Invocation;
import org.openspcoop2.core.api.Resource;
import org.openspcoop2.core.api.UrlParameter;
import org.openspcoop2.core.api.UrlParameters;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception e) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fout.flush();
            }
            catch (Exception e) {}
            try {
                fout.close();
            }
            catch (Exception e) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                bout.flush();
            }
            catch (Exception e) {}
            try {
                bout.close();
            }
            catch (Exception e) {}
        }
        return bout;
    }

    public void write(String fileName, UrlParameter urlParameter) throws SerializerException {
        this.objToXml(fileName, UrlParameter.class, (Object)urlParameter, false);
    }

    public void write(String fileName, UrlParameter urlParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, UrlParameter.class, (Object)urlParameter, prettyPrint);
    }

    public void write(File file, UrlParameter urlParameter) throws SerializerException {
        this.objToXml(file, UrlParameter.class, (Object)urlParameter, false);
    }

    public void write(File file, UrlParameter urlParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, UrlParameter.class, (Object)urlParameter, prettyPrint);
    }

    public void write(OutputStream out, UrlParameter urlParameter) throws SerializerException {
        this.objToXml(out, UrlParameter.class, (Object)urlParameter, false);
    }

    public void write(OutputStream out, UrlParameter urlParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, UrlParameter.class, (Object)urlParameter, prettyPrint);
    }

    public byte[] toByteArray(UrlParameter urlParameter) throws SerializerException {
        return this.objToXml(UrlParameter.class, urlParameter, false).toByteArray();
    }

    public byte[] toByteArray(UrlParameter urlParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameter.class, urlParameter, prettyPrint).toByteArray();
    }

    public String toString(UrlParameter urlParameter) throws SerializerException {
        return this.objToXml(UrlParameter.class, urlParameter, false).toString();
    }

    public String toString(UrlParameter urlParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameter.class, urlParameter, prettyPrint).toString();
    }

    public void write(String fileName, Resource resource) throws SerializerException {
        this.objToXml(fileName, Resource.class, (Object)resource, false);
    }

    public void write(String fileName, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Resource.class, (Object)resource, prettyPrint);
    }

    public void write(File file, Resource resource) throws SerializerException {
        this.objToXml(file, Resource.class, (Object)resource, false);
    }

    public void write(File file, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Resource.class, (Object)resource, prettyPrint);
    }

    public void write(OutputStream out, Resource resource) throws SerializerException {
        this.objToXml(out, Resource.class, (Object)resource, false);
    }

    public void write(OutputStream out, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Resource.class, (Object)resource, prettyPrint);
    }

    public byte[] toByteArray(Resource resource) throws SerializerException {
        return this.objToXml(Resource.class, resource, false).toByteArray();
    }

    public byte[] toByteArray(Resource resource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Resource.class, resource, prettyPrint).toByteArray();
    }

    public String toString(Resource resource) throws SerializerException {
        return this.objToXml(Resource.class, resource, false).toString();
    }

    public String toString(Resource resource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Resource.class, resource, prettyPrint).toString();
    }

    public void write(String fileName, Invocation invocation) throws SerializerException {
        this.objToXml(fileName, Invocation.class, (Object)invocation, false);
    }

    public void write(String fileName, Invocation invocation, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Invocation.class, (Object)invocation, prettyPrint);
    }

    public void write(File file, Invocation invocation) throws SerializerException {
        this.objToXml(file, Invocation.class, (Object)invocation, false);
    }

    public void write(File file, Invocation invocation, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Invocation.class, (Object)invocation, prettyPrint);
    }

    public void write(OutputStream out, Invocation invocation) throws SerializerException {
        this.objToXml(out, Invocation.class, (Object)invocation, false);
    }

    public void write(OutputStream out, Invocation invocation, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Invocation.class, (Object)invocation, prettyPrint);
    }

    public byte[] toByteArray(Invocation invocation) throws SerializerException {
        return this.objToXml(Invocation.class, invocation, false).toByteArray();
    }

    public byte[] toByteArray(Invocation invocation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Invocation.class, invocation, prettyPrint).toByteArray();
    }

    public String toString(Invocation invocation) throws SerializerException {
        return this.objToXml(Invocation.class, invocation, false).toString();
    }

    public String toString(Invocation invocation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Invocation.class, invocation, prettyPrint).toString();
    }

    public void write(String fileName, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(fileName, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(String fileName, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public void write(File file, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(file, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(File file, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public void write(OutputStream out, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(out, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(OutputStream out, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public byte[] toByteArray(UrlParameters urlParameters) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, false).toByteArray();
    }

    public byte[] toByteArray(UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, prettyPrint).toByteArray();
    }

    public String toString(UrlParameters urlParameters) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, false).toString();
    }

    public String toString(UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, prettyPrint).toString();
    }

    public void write(String fileName, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(fileName, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(String fileName, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public void write(File file, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(file, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(File file, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public void write(OutputStream out, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(out, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(OutputStream out, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public byte[] toByteArray(HeaderParameters headerParameters) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, false).toByteArray();
    }

    public byte[] toByteArray(HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, prettyPrint).toByteArray();
    }

    public String toString(HeaderParameters headerParameters) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, false).toString();
    }

    public String toString(HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, prettyPrint).toString();
    }

    public void write(String fileName, HeaderParameter headerParameter) throws SerializerException {
        this.objToXml(fileName, HeaderParameter.class, (Object)headerParameter, false);
    }

    public void write(String fileName, HeaderParameter headerParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, HeaderParameter.class, (Object)headerParameter, prettyPrint);
    }

    public void write(File file, HeaderParameter headerParameter) throws SerializerException {
        this.objToXml(file, HeaderParameter.class, (Object)headerParameter, false);
    }

    public void write(File file, HeaderParameter headerParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, HeaderParameter.class, (Object)headerParameter, prettyPrint);
    }

    public void write(OutputStream out, HeaderParameter headerParameter) throws SerializerException {
        this.objToXml(out, HeaderParameter.class, (Object)headerParameter, false);
    }

    public void write(OutputStream out, HeaderParameter headerParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, HeaderParameter.class, (Object)headerParameter, prettyPrint);
    }

    public byte[] toByteArray(HeaderParameter headerParameter) throws SerializerException {
        return this.objToXml(HeaderParameter.class, headerParameter, false).toByteArray();
    }

    public byte[] toByteArray(HeaderParameter headerParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameter.class, headerParameter, prettyPrint).toByteArray();
    }

    public String toString(HeaderParameter headerParameter) throws SerializerException {
        return this.objToXml(HeaderParameter.class, headerParameter, false).toString();
    }

    public String toString(HeaderParameter headerParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameter.class, headerParameter, prettyPrint).toString();
    }
}

