/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.api.utils.serializer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.openspcoop2.core.api.HeaderParameter;
import org.openspcoop2.core.api.HeaderParameters;
import org.openspcoop2.core.api.Invocation;
import org.openspcoop2.core.api.Resource;
import org.openspcoop2.core.api.UrlParameter;
import org.openspcoop2.core.api.UrlParameters;
import org.openspcoop2.generic_project.exception.DeserializerException;

public abstract class AbstractDeserializer {
    protected abstract Object _xmlToObj(InputStream var1, Class<?> var2) throws Exception;

    private Object xmlToObj(InputStream is, Class<?> c) throws DeserializerException {
        try {
            return this._xmlToObj(is, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e);
        }
    }

    private Object xmlToObj(String fileName, Class<?> c) throws DeserializerException {
        try {
            return this.xmlToObj(new File(fileName), c);
        }
        catch (Exception e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e);
        }
    }

    private Object xmlToObj(File file, Class<?> c) throws DeserializerException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            Object object = this._xmlToObj(fin, c);
            return object;
        }
        catch (Exception e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception e) {}
        }
    }

    private Object xmlToObj(byte[] file, Class<?> c) throws DeserializerException {
        ByteArrayInputStream fin = null;
        try {
            fin = new ByteArrayInputStream(file);
            Object object = this._xmlToObj(fin, c);
            return object;
        }
        catch (Exception e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception e) {}
        }
    }

    public UrlParameter readUrlParameter(String fileName) throws DeserializerException {
        return (UrlParameter)this.xmlToObj(fileName, UrlParameter.class);
    }

    public UrlParameter readUrlParameter(File file) throws DeserializerException {
        return (UrlParameter)this.xmlToObj(file, UrlParameter.class);
    }

    public UrlParameter readUrlParameter(InputStream in) throws DeserializerException {
        return (UrlParameter)this.xmlToObj(in, UrlParameter.class);
    }

    public UrlParameter readUrlParameter(byte[] in) throws DeserializerException {
        return (UrlParameter)this.xmlToObj(in, UrlParameter.class);
    }

    public UrlParameter readUrlParameterFromString(String in) throws DeserializerException {
        return (UrlParameter)this.xmlToObj(in.getBytes(), UrlParameter.class);
    }

    public Resource readResource(String fileName) throws DeserializerException {
        return (Resource)this.xmlToObj(fileName, Resource.class);
    }

    public Resource readResource(File file) throws DeserializerException {
        return (Resource)this.xmlToObj(file, Resource.class);
    }

    public Resource readResource(InputStream in) throws DeserializerException {
        return (Resource)this.xmlToObj(in, Resource.class);
    }

    public Resource readResource(byte[] in) throws DeserializerException {
        return (Resource)this.xmlToObj(in, Resource.class);
    }

    public Resource readResourceFromString(String in) throws DeserializerException {
        return (Resource)this.xmlToObj(in.getBytes(), Resource.class);
    }

    public Invocation readInvocation(String fileName) throws DeserializerException {
        return (Invocation)this.xmlToObj(fileName, Invocation.class);
    }

    public Invocation readInvocation(File file) throws DeserializerException {
        return (Invocation)this.xmlToObj(file, Invocation.class);
    }

    public Invocation readInvocation(InputStream in) throws DeserializerException {
        return (Invocation)this.xmlToObj(in, Invocation.class);
    }

    public Invocation readInvocation(byte[] in) throws DeserializerException {
        return (Invocation)this.xmlToObj(in, Invocation.class);
    }

    public Invocation readInvocationFromString(String in) throws DeserializerException {
        return (Invocation)this.xmlToObj(in.getBytes(), Invocation.class);
    }

    public UrlParameters readUrlParameters(String fileName) throws DeserializerException {
        return (UrlParameters)this.xmlToObj(fileName, UrlParameters.class);
    }

    public UrlParameters readUrlParameters(File file) throws DeserializerException {
        return (UrlParameters)this.xmlToObj(file, UrlParameters.class);
    }

    public UrlParameters readUrlParameters(InputStream in) throws DeserializerException {
        return (UrlParameters)this.xmlToObj(in, UrlParameters.class);
    }

    public UrlParameters readUrlParameters(byte[] in) throws DeserializerException {
        return (UrlParameters)this.xmlToObj(in, UrlParameters.class);
    }

    public UrlParameters readUrlParametersFromString(String in) throws DeserializerException {
        return (UrlParameters)this.xmlToObj(in.getBytes(), UrlParameters.class);
    }

    public HeaderParameters readHeaderParameters(String fileName) throws DeserializerException {
        return (HeaderParameters)this.xmlToObj(fileName, HeaderParameters.class);
    }

    public HeaderParameters readHeaderParameters(File file) throws DeserializerException {
        return (HeaderParameters)this.xmlToObj(file, HeaderParameters.class);
    }

    public HeaderParameters readHeaderParameters(InputStream in) throws DeserializerException {
        return (HeaderParameters)this.xmlToObj(in, HeaderParameters.class);
    }

    public HeaderParameters readHeaderParameters(byte[] in) throws DeserializerException {
        return (HeaderParameters)this.xmlToObj(in, HeaderParameters.class);
    }

    public HeaderParameters readHeaderParametersFromString(String in) throws DeserializerException {
        return (HeaderParameters)this.xmlToObj(in.getBytes(), HeaderParameters.class);
    }

    public HeaderParameter readHeaderParameter(String fileName) throws DeserializerException {
        return (HeaderParameter)this.xmlToObj(fileName, HeaderParameter.class);
    }

    public HeaderParameter readHeaderParameter(File file) throws DeserializerException {
        return (HeaderParameter)this.xmlToObj(file, HeaderParameter.class);
    }

    public HeaderParameter readHeaderParameter(InputStream in) throws DeserializerException {
        return (HeaderParameter)this.xmlToObj(in, HeaderParameter.class);
    }

    public HeaderParameter readHeaderParameter(byte[] in) throws DeserializerException {
        return (HeaderParameter)this.xmlToObj(in, HeaderParameter.class);
    }

    public HeaderParameter readHeaderParameterFromString(String in) throws DeserializerException {
        return (HeaderParameter)this.xmlToObj(in.getBytes(), HeaderParameter.class);
    }
}

