/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.api.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.openspcoop2.core.api.HeaderParameter;
import org.openspcoop2.core.api.Invocation;
import org.openspcoop2.core.api.UrlParameter;
import org.openspcoop2.core.api.constants.MessageType;
import org.openspcoop2.core.api.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageException;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.utils.resources.HttpUtilities;
import org.openspcoop2.utils.resources.TransportUtils;
import org.w3c.dom.Node;

public class Sbustamento {
    private OpenSPCoop2Message message;
    private Invocation apiObject;
    private byte[] body;
    private String nomePorta;

    public Sbustamento(OpenSPCoop2Message message) throws OpenSPCoop2MessageException {
        this.message = message;
        try {
            Object nome;
            if (this.message == null) {
                throw new OpenSPCoop2MessageException("Message not defined");
            }
            if (this.message.getSOAPBody() == null) {
                throw new OpenSPCoop2MessageException("Message (SOAPBody) not defined");
            }
            Vector childs = SoapUtils.getNotEmptyChildNodes((Node)this.message.getSOAPBody(), (boolean)false);
            if (childs == null || childs.size() <= 0) {
                throw new OpenSPCoop2MessageException("Message (SOAPBody) empty");
            }
            if (childs.size() > 1) {
                throw new OpenSPCoop2MessageException("Message (SOAPBody) uncorrect (size:" + childs.size() + ")");
            }
            Node child = (Node)childs.get(0);
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                byte[] childAsByte = XMLUtils.getInstance().toByteArray(child, true);
                this.apiObject = deserializer.readInvocation(childAsByte);
            }
            catch (Exception e) {
                throw new OpenSPCoop2MessageException("Message Parsing error: " + e.getMessage(), (Throwable)e);
            }
            int countAttach = this.message.countAttachments();
            if (countAttach > 0) {
                if (countAttach > 1) {
                    throw new OpenSPCoop2MessageException("Message (Attachments) uncorrect (size:" + countAttach + ")");
                }
                boolean isRichiesta = MessageType.REQUEST.equals(this.apiObject.getResource().getType());
                if (!HttpUtilities.isHttpBodyPermitted((boolean)isRichiesta, (String)this.apiObject.getResource().getMethod().name(), (String)this.apiObject.getResource().getMediaType())) {
                    if (isRichiesta) {
                        throw new OpenSPCoop2MessageException("Http don't support body in " + this.apiObject.getResource().getMethod().name() + " request method");
                    }
                    throw new OpenSPCoop2MessageException("Http don't support body in " + this.apiObject.getResource().getMethod().name() + " response method");
                }
                AttachmentPart ap = (AttachmentPart)this.message.getAttachments().next();
                this.body = this.readAttachment(ap);
            }
            if ((nome = this.message.getContextProperty("API_PORTA")) != null) {
                this.nomePorta = (String)nome;
            }
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException("Message reader error: " + e.getMessage(), (Throwable)e);
        }
    }

    private byte[] readAttachment(AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getBodyLength() {
        if (this.body != null) {
            return this.body.length;
        }
        return 0;
    }

    public String buildUrl(String url, Properties propertiesUrlBased) {
        String[] split;
        String baseUrl = url;
        String parameterOriginalUrl = null;
        if (url.contains("?")) {
            baseUrl = url.split("\\?")[0];
            if (baseUrl != null) {
                baseUrl.trim();
            }
            if ((parameterOriginalUrl = url.split("\\?")[1]) != null) {
                parameterOriginalUrl.trim();
            }
        }
        StringBuffer newUrl = new StringBuffer();
        newUrl.append(baseUrl);
        String resourcePath = this.apiObject.getResource().getPath();
        if (resourcePath != null) {
            String resourcePathBuild = new String(resourcePath);
            if (resourcePathBuild.startsWith("/")) {
                resourcePathBuild = resourcePathBuild.substring(1);
            }
            if (this.nomePorta != null && resourcePathBuild.startsWith(this.nomePorta)) {
                resourcePathBuild = resourcePathBuild.substring(this.nomePorta.length());
            }
            if (resourcePathBuild.startsWith("/")) {
                resourcePathBuild = resourcePathBuild.substring(1);
            }
            if (!baseUrl.endsWith("/")) {
                newUrl.append("/");
            }
            newUrl.append(resourcePathBuild);
        }
        Properties parameters = null;
        if (propertiesUrlBased != null && propertiesUrlBased.size() > 0 || this.apiObject.getUrlParameters() != null && this.apiObject.getUrlParameters().sizeUrlParameterList() > 0) {
            parameters = new Properties();
            if (propertiesUrlBased != null && propertiesUrlBased.size() > 0) {
                parameters.putAll((Map<?, ?>)propertiesUrlBased);
            }
            if (this.apiObject.getUrlParameters() != null && this.apiObject.getUrlParameters().sizeUrlParameterList() > 0) {
                for (UrlParameter urlParameter : this.apiObject.getUrlParameters().getUrlParameterList()) {
                    parameters.put(urlParameter.getNome(), urlParameter.getBase());
                }
            }
        }
        if (parameterOriginalUrl != null && (split = parameterOriginalUrl.split("&")) != null) {
            if (parameters == null) {
                parameters = new Properties();
            }
            for (int i = 0; i < split.length; ++i) {
                String valore;
                String[] splitNomeValore;
                if (!split[i].contains("=") || (splitNomeValore = split[i].split("=")) == null) continue;
                String nome = splitNomeValore[0];
                if (nome != null) {
                    nome = nome.trim();
                }
                if ((valore = splitNomeValore[1]) != null) {
                    valore = valore.trim();
                }
                if (nome == null || valore == null) continue;
                parameters.put(nome, valore);
            }
        }
        return TransportUtils.buildLocationWithURLBasedParameter((Properties)parameters, (String)newUrl.toString());
    }

    public String getContentType() {
        return this.apiObject.getResource().getMediaType();
    }

    public Properties getTransportProperties() {
        Properties parameters = null;
        if (this.apiObject.getHeaderParameters() != null && this.apiObject.getHeaderParameters().sizeHeaderParameterList() > 0) {
            parameters = new Properties();
        }
        if (this.apiObject.getHeaderParameters() != null && this.apiObject.getHeaderParameters().sizeHeaderParameterList() > 0) {
            for (HeaderParameter headerParameter : this.apiObject.getHeaderParameters().getHeaderParameterList()) {
                parameters.put(headerParameter.getNome(), headerParameter.getBase());
            }
        }
        return parameters;
    }

    public String getHttpMethod() {
        return this.apiObject.getResource().getMethod().getValue();
    }

    public int getResponseStatus() {
        return this.apiObject.getResource().getResponseStatus();
    }

    public String getResponseMessage() {
        return this.apiObject.getResource().getResponseMessage();
    }
}

