/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.api.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.core.api.HeaderParameter;
import org.openspcoop2.core.api.HeaderParameters;
import org.openspcoop2.core.api.Invocation;
import org.openspcoop2.core.api.Resource;
import org.openspcoop2.core.api.UrlParameter;
import org.openspcoop2.core.api.UrlParameters;
import org.openspcoop2.core.api.constants.MessageType;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.core.api.utils.ProjectInfo;
import org.openspcoop2.core.api.utils.serializer.JaxbSerializer;
import org.openspcoop2.message.MailcapActivationReader;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.HttpHeaderTypes;
import org.w3c.dom.Element;

public class Imbustamento {
    private Invocation apiObject = new Invocation();
    private OpenSPCoop2Message message = null;

    public Imbustamento(SOAPVersion soapVersion, NotifierInputStreamParams nisParams, InputStream is, MethodType method, String contentType, Properties headerBased, Properties urlBased, String resourcePath, List<String> whiteListHeader) throws UtilsException {
        this(soapVersion, nisParams, is, true, method, contentType, headerBased, urlBased, resourcePath, null, null, whiteListHeader);
    }

    public Imbustamento(SOAPVersion soapVersion, NotifierInputStreamParams nisParams, InputStream is, MethodType method, String contentType, Properties headerBased, Integer responseStatus, String responseMessage, List<String> whiteListHeader) throws UtilsException {
        this(soapVersion, nisParams, is, false, method, contentType, headerBased, null, null, responseStatus, responseMessage, whiteListHeader);
    }

    private Imbustamento(SOAPVersion soapVersion, NotifierInputStreamParams nisParams, InputStream is, boolean isRichiesta, MethodType method, String contentType, Properties headerBased, Properties urlBased, String resourcePath, Integer responseStatus, String responseMessage, List<String> whiteListHeader) throws UtilsException {
        this.apiObject.setResource(new Resource());
        if (isRichiesta) {
            this.apiObject.getResource().setPath(resourcePath);
        }
        this.apiObject.getResource().setMethod(method);
        if (isRichiesta) {
            this.apiObject.getResource().setType(MessageType.REQUEST);
        } else {
            this.apiObject.getResource().setType(MessageType.RESPONSE);
        }
        this.apiObject.getResource().setMediaType(contentType);
        this.apiObject.getResource().setResponseStatus(responseStatus);
        this.apiObject.getResource().setResponseMessage(responseMessage);
        if (urlBased != null && urlBased.size() > 0) {
            this.apiObject.setUrlParameters(new UrlParameters());
            Enumeration<Object> enumUrl = urlBased.keys();
            while (enumUrl.hasMoreElements()) {
                String key = (String)enumUrl.nextElement();
                UrlParameter urlParameter = new UrlParameter();
                urlParameter.setNome(key);
                urlParameter.setBase(urlBased.getProperty(key));
                this.apiObject.getUrlParameters().addUrlParameter(urlParameter);
            }
        }
        ArrayList<HeaderParameter> listHeader = new ArrayList<HeaderParameter>();
        HttpHeaderTypes httpHeader = HttpHeaderTypes.getInstance();
        List headers = httpHeader.getHeaders();
        if (headerBased != null && headerBased.size() > 0) {
            Enumeration<Object> enumHeader = headerBased.keys();
            while (enumHeader.hasMoreElements()) {
                String key = (String)enumHeader.nextElement();
                if (!isRichiesta && "ReturnCode".equalsIgnoreCase(key) || headers.contains(key) && !whiteListHeader.contains(key)) continue;
                HeaderParameter headerParameter = new HeaderParameter();
                headerParameter.setNome(key);
                headerParameter.setBase(headerBased.getProperty(key));
                listHeader.add(headerParameter);
            }
        }
        if (listHeader.size() > 0) {
            this.apiObject.setHeaderParameters(new HeaderParameters());
            this.apiObject.getHeaderParameters().setHeaderParameterList(listHeader);
        }
        AttachmentPart ap = null;
        if (is != null) {
            try {
                byte[] originalContent = Utilities.getAsByteArray((InputStream)is);
                if (originalContent != null && originalContent.length > 0) {
                    OpenSPCoop2Message message = SoapUtils.imbustamentoMessaggioConAttachment((SOAPVersion)soapVersion, (byte[])originalContent, (String)contentType, (boolean)MailcapActivationReader.existsDataContentHandler((String)contentType), (String)contentType, (String)ProjectInfo.getInstance().getProjectNamespace());
                    ap = (AttachmentPart)message.getAttachments().next();
                }
            }
            catch (Exception e) {
                throw new UtilsException("BodyMessage create failed: " + e.getMessage(), (Throwable)e);
            }
        }
        OpenSPCoop2MessageFactory messageFactory = null;
        try {
            messageFactory = OpenSPCoop2MessageFactory.getMessageFactory();
            this.message = messageFactory.createEmptySOAPMessage(soapVersion, nisParams);
        }
        catch (Exception e) {
            throw new UtilsException("EmptyMessage create failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            JaxbSerializer serializer = new JaxbSerializer();
            byte[] elemByte = serializer.toByteArray(this.apiObject);
            Element elem = XMLUtils.getInstance().newElement(elemByte);
            SOAPElement soapElem = null;
            switch (soapVersion) {
                case SOAP11: {
                    soapElem = messageFactory.getSoapFactory11().createElement(elem);
                    break;
                }
                case SOAP12: {
                    soapElem = messageFactory.getSoapFactory12().createElement(elem);
                }
            }
            this.message.getSOAPBody().addChildElement(soapElem);
            this.message.addContextProperty("MESSAGGIO_API", (Object)true);
        }
        catch (Exception e) {
            throw new UtilsException("ApiMessage create failed: " + e.getMessage(), (Throwable)e);
        }
        if (ap != null) {
            try {
                this.message.addAttachmentPart(ap);
            }
            catch (Exception e) {
                throw new UtilsException("ApiMessage (attach) create failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Invocation getApiObject() {
        return this.apiObject;
    }

    public OpenSPCoop2Message getMessage() {
        return this.message;
    }
}

