/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_ruoli {
    protected static boolean isRuoloConfigInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloInUsoEngine(con, tipoDB, idRuolo, false, true, whereIsInUso, normalizeObjectIds);
    }

    protected static boolean isRuoloRegistryInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloInUsoEngine(con, tipoDB, idRuolo, true, false, whereIsInUso, normalizeObjectIds);
    }

    protected static boolean isRuoloInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloInUsoEngine(con, tipoDB, idRuolo, true, true, whereIsInUso, normalizeObjectIds);
    }

    private static boolean isRuoloInUsoEngine(Connection con, String tipoDB, IDRuolo idRuolo, boolean registry, boolean config, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "_isRuoloInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            ResultPorta resultPorta;
            String nome;
            String nomeSoggetto;
            String tipoSoggetto;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            long idR = DBUtils.getIdRuolo((IDRuolo)idRuolo, (Connection)con, (String)tipoDB);
            boolean isInUso = false;
            List<String> soggettiList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_SOGGETTI);
            List<String> serviziApplicativiList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_SERVIZI_APPLICATIVI);
            List<String> porteApplicativeList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porteApplicativeModiList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE_MODI);
            List<String> porteDelegateList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> mappingErogazionePAList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingErogazionePAModiList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA_MODI);
            List<String> mappingFruizionePDList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> porteApplicativeTokenList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA);
            List<String> porteApplicativeTokenModiList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI);
            List<String> porteDelegateTokenList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PD);
            List<String> mappingErogazioneTokenPAList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA);
            List<String> mappingErogazioneTokenPAModiList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI);
            List<String> mappingFruizioneTokenPDList = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PD);
            List<String> ctList = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            List<String> allarmeList = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
            List<String> modiSignalHubList = whereIsInUso.get(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB);
            if (soggettiList == null) {
                soggettiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SOGGETTI, soggettiList);
            }
            if (serviziApplicativiList == null) {
                serviziApplicativiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI_APPLICATIVI, serviziApplicativiList);
            }
            if (porteApplicativeList == null) {
                porteApplicativeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porteApplicativeList);
            }
            if (porteApplicativeModiList == null) {
                porteApplicativeModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE_MODI, porteApplicativeModiList);
            }
            if (porteDelegateList == null) {
                porteDelegateList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porteDelegateList);
            }
            if (mappingErogazionePAList == null) {
                mappingErogazionePAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePAList);
            }
            if (mappingErogazionePAModiList == null) {
                mappingErogazionePAModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA_MODI, mappingErogazionePAModiList);
            }
            if (mappingFruizionePDList == null) {
                mappingFruizionePDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePDList);
            }
            if (porteApplicativeTokenList == null) {
                porteApplicativeTokenList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA, porteApplicativeTokenList);
            }
            if (porteApplicativeTokenModiList == null) {
                porteApplicativeTokenModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI, porteApplicativeTokenModiList);
            }
            if (porteDelegateTokenList == null) {
                porteDelegateTokenList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PD, porteDelegateTokenList);
            }
            if (mappingErogazioneTokenPAList == null) {
                mappingErogazioneTokenPAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA, mappingErogazioneTokenPAList);
            }
            if (mappingErogazioneTokenPAModiList == null) {
                mappingErogazioneTokenPAModiList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI, mappingErogazioneTokenPAModiList);
            }
            if (mappingFruizioneTokenPDList == null) {
                mappingFruizioneTokenPDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PD, mappingFruizioneTokenPDList);
            }
            if (ctList == null) {
                ctList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ctList);
            }
            if (allarmeList == null) {
                allarmeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarmeList);
            }
            if (modiSignalHubList == null) {
                modiSignalHubList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB, modiSignalHubList);
            }
            if (registry) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("soggetti_ruoli.id_ruolo = ?");
                sqlQueryObject.addWhereCondition("soggetti_ruoli.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idR);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipoSoggetto = risultato.getString("tipo_soggetto");
                    nomeSoggetto = risultato.getString("nome_soggetto");
                    IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                    if (normalizeObjectIds) {
                        String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
                        soggettiList.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelSoggetto(protocollo, idSoggetto));
                    } else {
                        soggettiList.add(tipoSoggetto + "/" + nomeSoggetto);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("servizi_applicativi.nome");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("sa_ruoli.ruolo = ?");
                sqlQueryObject.addWhereCondition("sa_ruoli.id_servizio_applicativo = servizi_applicativi.id");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idRuolo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipoSoggetto = risultato.getString("tipo_soggetto");
                    nomeSoggetto = risultato.getString("nome_soggetto");
                    String nome2 = risultato.getString("nome");
                    IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                    if (normalizeObjectIds) {
                        String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipoSoggetto);
                        serviziApplicativiList.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome2 + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idSoggetto));
                    } else {
                        serviziApplicativiList.add(tipoSoggetto + "/" + nomeSoggetto + "_" + nome2);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pa_ruoli.ruolo = ?");
                sqlQueryObject.addWhereCondition("pa_ruoli.id_porta = porte_applicative.id");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idRuolo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        if (resultPorta.erogazioneModi) {
                            mappingErogazionePAModiList.add(resultPorta.label);
                        } else {
                            mappingErogazionePAList.add(resultPorta.label);
                        }
                    } else if (resultPorta.erogazioneModi) {
                        porteApplicativeModiList.add(resultPorta.label);
                    } else {
                        porteApplicativeList.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pa_token_ruoli");
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pa_token_ruoli.ruolo = ?");
                sqlQueryObject.addWhereCondition("pa_token_ruoli.id_porta = porte_applicative.id");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idRuolo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        if (resultPorta.erogazioneModi) {
                            mappingErogazioneTokenPAModiList.add(resultPorta.label);
                        } else {
                            mappingErogazioneTokenPAList.add(resultPorta.label);
                        }
                    } else if (resultPorta.erogazioneModi) {
                        porteApplicativeTokenModiList.add(resultPorta.label);
                    } else {
                        porteApplicativeTokenList.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pd_ruoli.ruolo = ?");
                sqlQueryObject.addWhereCondition("pd_ruoli.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idRuolo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingFruizionePDList.add(resultPorta.label);
                    } else {
                        porteDelegateList.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pd_token_ruoli");
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pd_token_ruoli.ruolo = ?");
                sqlQueryObject.addWhereCondition("pd_token_ruoli.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idRuolo.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingFruizioneTokenPDList.add(resultPorta.label);
                    } else {
                        porteDelegateTokenList.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                int max = 2;
                if (!CostantiDB.isAllarmiEnabled()) {
                    max = 1;
                }
                for (int i = 0; i < max; ++i) {
                    String tabella = "ct_active_policy";
                    String identificativoColumn = "active_policy_id";
                    String aliasColumn = "policy_alias";
                    List<String> list = ctList;
                    String oggetto = "Policy";
                    if (i == 1) {
                        tabella = "allarmi";
                        identificativoColumn = "nome";
                        aliasColumn = "alias";
                        list = allarmeList;
                        oggetto = "Allarme";
                    }
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject2.addFromTable(tabella);
                    sqlQueryObject2.addSelectField(identificativoColumn);
                    sqlQueryObject2.addSelectField(aliasColumn);
                    sqlQueryObject2.addSelectField("filtro_ruolo");
                    sqlQueryObject2.addSelectField("filtro_porta");
                    sqlQueryObject2.setANDLogicOperator(false);
                    sqlQueryObject2.addWhereCondition(true, new String[]{tabella + ".filtro_ruolo_fruitore = ?"});
                    sqlQueryObject2.addWhereCondition(true, new String[]{tabella + ".filtro_ruolo_erogatore = ?"});
                    queryString = sqlQueryObject2.createSQLQuery();
                    sqlQueryObject2.addOrderBy("filtro_ruolo");
                    sqlQueryObject2.addOrderBy("filtro_porta");
                    stmt = con.prepareStatement(queryString);
                    int index = 1;
                    stmt.setString(index++, idRuolo.getNome());
                    stmt.setString(index++, idRuolo.getNome());
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String alias = risultato.getString(aliasColumn);
                        if (alias == null || "".equals(alias)) {
                            alias = risultato.getString(identificativoColumn);
                        }
                        String nomePorta = risultato.getString("filtro_porta");
                        String filtroRuolo = risultato.getString("filtro_ruolo");
                        if (nomePorta != null) {
                            ResultPorta resultPorta2;
                            String tipo = null;
                            String label = null;
                            if ("delegata".equals(filtroRuolo)) {
                                try {
                                    resultPorta2 = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                                    if (resultPorta2.mapping) {
                                        label = "Fruizione di Servizio " + resultPorta2.label;
                                    }
                                }
                                catch (Exception e) {
                                    tipo = "Outbound";
                                }
                            } else if ("applicativa".equals(filtroRuolo)) {
                                try {
                                    resultPorta2 = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                                    if (resultPorta2.mapping) {
                                        label = "Erogazione di Servizio " + resultPorta2.label;
                                    }
                                }
                                catch (Exception e) {
                                    tipo = "Inbound";
                                }
                            } else {
                                tipo = filtroRuolo;
                            }
                            if (label == null) {
                                list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta + "' ");
                            } else {
                                list.add(oggetto + " '" + alias + "' attiva nella " + label);
                            }
                        } else {
                            list.add(oggetto + " '" + alias + "'");
                        }
                        isInUso = true;
                    }
                    risultato.close();
                    stmt.close();
                }
            }
            ISQLQueryObject sqlQueryObject3 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject3.addFromTable("servizi");
            sqlQueryObject3.addFromTable("soggetti");
            sqlQueryObject3.addFromTable("protocol_properties");
            sqlQueryObject3.addSelectAliasField("servizi", "tipo_servizio", "tipoServizio");
            sqlQueryObject3.addSelectAliasField("servizi", "nome_servizio", "nomeServizio");
            sqlQueryObject3.addSelectAliasField("servizi", "versione_servizio", "versioneServizio");
            sqlQueryObject3.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
            sqlQueryObject3.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
            sqlQueryObject3.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject3.addWhereCondition("servizi.id = protocol_properties.id_proprietario");
            sqlQueryObject3.addWhereCondition("protocol_properties.tipo_proprietario=?");
            sqlQueryObject3.addWhereCondition("protocol_properties.name=?");
            sqlQueryObject3.addWhereCondition("protocol_properties.value_string=?");
            sqlQueryObject3.setANDLogicOperator(true);
            queryString = sqlQueryObject3.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA.name());
            stmt.setString(index++, "modipaInfoGenSignalHubPulisherRole");
            stmt.setString(index++, idRuolo.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDServizio idS = IDServizioFactory.getInstance().getIDServizioFromValues(risultato.getString("tipoServizio"), risultato.getString("nomeServizio"), risultato.getString("tipoSoggetto"), risultato.getString("nomeSoggetto"), risultato.getInt("versioneServizio"));
                IDPortaApplicativa idPA = DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idS, (Connection)con, (String)tipoDB);
                if (idPA != null) {
                    ResultPorta resultPorta3 = DBOggettiInUsoUtils.formatPortaApplicativa(idPA.getNome(), tipoDB, con, normalizeObjectIds);
                    modiSignalHubList.add(resultPorta3.label);
                } else {
                    modiSignalHubList.add(idS.toString());
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_ruoli.toString(idRuolo, whereIsInUso, prefix, separator, " non eliminabile perch&egrave; :");
    }

    protected static String toString(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        StringBuilder msgBuilder = new StringBuilder("Ruolo '" + idRuolo.getNome() + "'" + intestazione + separator);
        if (!prefix) {
            msgBuilder = new StringBuilder("");
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block19: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && !messages.isEmpty()) {
                msgBuilder.append(separatorCategorie);
            }
            switch (key) {
                case IN_USO_IN_SOGGETTI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nei Soggetti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_SERVIZI_APPLICATIVI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato negli Applicativi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo Accessi - Autorizzazione Trasporto): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_PORTE_APPLICATIVE_MODI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo Accessi - Autorizzazione Canale): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Outbound (Controllo Accessi - Autorizzazione Trasporto): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Erogazioni (Controllo Accessi - Autorizzazione Trasporto): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Erogazioni (Controllo Accessi - Autorizzazione Canale): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Fruizioni (Controllo Accessi - Autorizzazione Trasporto): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_PA: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Inbound (Controllo Accessi - Autorizzazione Messaggio): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_PD: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Porte Outbound (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Erogazioni (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_MAPPING_PA_MODI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Erogazioni (Controllo Accessi - Autorizzazione Messaggio): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case RUOLI_TOKEN_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato nelle Fruizioni (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato in Policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case ALLARMI: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("utilizzato in Allarmi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
                case IS_RIFERITA_MODI_SIGNAL_HUB: {
                    if (messages == null || messages.isEmpty()) continue block19;
                    msgBuilder.append("riferito nella configurazione 'SignalHub' dell'erogazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block19;
                }
            }
            msgBuilder.append("utilizzato in oggetto non codificato (" + key + ")" + separator);
        }
        return msgBuilder.toString();
    }
}

