/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_canali {
    protected static boolean isCanaleInUsoRegistro(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_canali.isCanaleInUso(con, tipoDB, canale, whereIsInUso, normalizeObjectIds, true, true, false);
    }

    protected static boolean isCanaleInUso(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_canali.isCanaleInUso(con, tipoDB, canale, whereIsInUso, normalizeObjectIds, true, true, true);
    }

    protected static boolean isCanaleInUso(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean registry, boolean config, boolean nodi) throws UtilsException {
        String nomeMetodo = "_isCanaleInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            String nome;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            String nomeCanale = canale.getNome();
            boolean isInUso = false;
            List<String> accordi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_ACCORDI);
            List<String> porte_applicative_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porte_delegate_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> mappingErogazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePD_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> nodi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_CANALE_NODO);
            if (accordi_list == null) {
                accordi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_ACCORDI, accordi_list);
            }
            if (porte_applicative_list == null) {
                porte_applicative_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porte_applicative_list);
            }
            if (porte_delegate_list == null) {
                porte_delegate_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porte_delegate_list);
            }
            if (mappingErogazionePA_list == null) {
                mappingErogazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePA_list);
            }
            if (mappingFruizionePD_list == null) {
                mappingFruizionePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePD_list);
            }
            if (nodi_list == null) {
                nodi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_CANALE_NODO, nodi_list);
            }
            if (registry) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("accordi.canale = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nomeCanale);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    isInUso = true;
                    String nomeAccordo = risultato.getString("nome");
                    int versione = risultato.getInt("versione");
                    long idReferente = risultato.getLong("id_referente");
                    IDSoggetto idReferenteObject = null;
                    if (idReferente > 0L) {
                        ISQLQueryObject sqlQueryObjectReferente = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectReferente.addFromTable("soggetti");
                        sqlQueryObjectReferente.addSelectField("*");
                        sqlQueryObjectReferente.addWhereCondition("id=?");
                        sqlQueryObjectReferente.setANDLogicOperator(true);
                        String queryStringReferente = sqlQueryObjectReferente.createSQLQuery();
                        stmt2 = con.prepareStatement(queryStringReferente);
                        stmt2.setLong(1, idReferente);
                        risultato2 = stmt2.executeQuery();
                        if (risultato2.next()) {
                            idReferenteObject = new IDSoggetto();
                            idReferenteObject.setTipo(risultato2.getString("tipo_soggetto"));
                            idReferenteObject.setNome(risultato2.getString("nome_soggetto"));
                        }
                        risultato2.close();
                        risultato2 = null;
                        stmt2.close();
                        stmt2 = null;
                    }
                    if (normalizeObjectIds && idReferenteObject != null) {
                        String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idReferenteObject.getTipo());
                        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idReferenteObject, Integer.valueOf(versione));
                        accordi_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo));
                        continue;
                    }
                    StringBuilder bf = new StringBuilder();
                    bf.append(idReferenteObject != null ? idReferenteObject.getTipo() : "?");
                    bf.append("/");
                    bf.append(idReferenteObject != null ? idReferenteObject.getNome() : "?");
                    bf.append(":");
                    bf.append(nomeAccordo);
                    if (idReferente > 0L) {
                        bf.append(":");
                        bf.append(versione);
                    }
                    accordi_list.add(bf.toString());
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("porte_applicative.canale = ?");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nomeCanale);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingErogazionePA_list.add(resultPorta.label);
                    } else {
                        porte_applicative_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("porte_delegate.canale = ?");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nomeCanale);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingFruizionePD_list.add(resultPorta.label);
                    } else {
                        porte_delegate_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (nodi) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("canali_nodi");
                sqlQueryObject.addSelectField("canali_nodi.nome");
                sqlQueryObject.setANDLogicOperator(false);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("canali_nodi.canali = ?");
                sqlQueryObject.addWhereLikeCondition("canali_nodi.canali", nomeCanale + ",", LikeConfig.startsWith((boolean)false));
                sqlQueryObject.addWhereLikeCondition("canali_nodi.canali", "," + nomeCanale, LikeConfig.endsWith((boolean)false));
                sqlQueryObject.addWhereLikeCondition("canali_nodi.canali", "," + nomeCanale + ",", true, false);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, nomeCanale);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome");
                    nodi_list.add(nome);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            JDBCUtilities.closeResources(risultato2, stmt2);
            JDBCUtilities.closeResources(risultato, stmt);
        }
    }

    protected static String toString(CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_canali.toString(canale, whereIsInUso, prefix, separator, " non eliminabile perch&egrave; :");
    }

    protected static String toString(CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = "Canale '" + canale.getNome() + "'" + intestazione + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block8: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IN_USO_IN_ACCORDI: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "associato all'API: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "utilizzato nelle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "utilizzato nelle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "in uso in Porte Delegate: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "in uso in Porte Applicative: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_CANALE_NODO: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "utilizzato nei Nodi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

