/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.registry;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReaderInUso;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.slf4j.Logger;

public class ConfigIntegrationReaderInUso
implements IConfigIntegrationReaderInUso {
    private IDriverConfigurazioneGet driverConfigurazioneGET;
    private Logger log;

    public void init(IDriverConfigurazioneGet driverConfigurazione, Logger log) {
        this.driverConfigurazioneGET = driverConfigurazione;
        this.log = log;
    }

    public boolean inUso(IDServizioApplicativo idServizioApplicativo, boolean verificaRuoli) throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driverDB = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDServizioApplicativo)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isServizioApplicativoInUso(connection, driverDB.getTipoDB(), idServizioApplicativo, whereIsInUso, true, normalizeObjectIds, verificaRuoli);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new UtilsRuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDServizioApplicativo idServizioApplicativo, boolean verificaRuoli) throws RegistryException {
        if (this.driverConfigurazioneGET instanceof DriverConfigurazioneDB) {
            DriverConfigurazioneDB driverDB = (DriverConfigurazioneDB)this.driverConfigurazioneGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDServizioApplicativo)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isServizioApplicativoInUso(connection, driverDB.getTipoDB(), idServizioApplicativo, whereIsInUso, true, normalizeObjectIds, verificaRuoli);
                if (inUso) {
                    String string = DBOggettiInUsoUtils.toString(idServizioApplicativo, whereIsInUso, false, "\n", normalizeObjectIds);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new UtilsRuntimeException("Not Implemented");
    }
}

