/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.constants.ModalitaIdentificazione;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.FunctionContextCustom;
import org.openspcoop2.protocol.sdk.state.FunctionContextsCustom;
import org.slf4j.Logger;

public class MappingProperties {
    private Logger log;
    private Properties propertiesReader;

    protected MappingProperties(String fileNameProperties, InputStream properties, Logger log) throws IOException {
        this.log = log;
        this.propertiesReader = new Properties();
        try {
            this.propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error("Riscontrato errore durante la lettura del file '" + fileNameProperties + "': \n\n" + e.getMessage());
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getUrlWithoutContext(String protocol, String urlWithContext, IDService idService, FunctionContextsCustom customContexts) throws ProtocolException {
        IProtocolFactory<?> pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
        Openspcoop2 manifestProtocol = pf.getManifest();
        String urlWithoutContext = null;
        ArrayList<Object> paContexts = new ArrayList<Object>();
        if (IDService.PORTA_APPLICATIVA.equals((Object)idService) || IDService.PORTA_APPLICATIVA_NIO.equals((Object)idService)) {
            List list;
            paContexts.add("/PA");
            if (customContexts != null && (list = customContexts.getContexts()) != null && list.size() > 0) {
                for (FunctionContextCustom functionContextCustom : list) {
                    if (functionContextCustom.getIdService() != null) {
                        if (!idService.equals((Object)functionContextCustom.getIdService())) continue;
                        paContexts.add("/" + functionContextCustom.getContext());
                        continue;
                    }
                    if (functionContextCustom.getSubcontext() == null || functionContextCustom.getSubcontext().size() <= 0) continue;
                    for (String subcontext : functionContextCustom.getSubcontext().keySet()) {
                        IDService idServiceSubContext = (IDService)functionContextCustom.getSubcontext().get(subcontext);
                        if (!idService.equals((Object)idServiceSubContext)) continue;
                        paContexts.add("/" + functionContextCustom.getContext() + "/" + subcontext);
                    }
                }
            }
        } else {
            throw new ProtocolException("Service [" + idService + "] non gestito tramite UrlMapping");
        }
        for (int i = 0; i < manifestProtocol.getWeb().sizeContextList(); ++i) {
            String context = manifestProtocol.getWeb().getContext(i).getName();
            boolean found = false;
            for (int j = 0; j < paContexts.size(); ++j) {
                String prefixProtocol = context + (String)paContexts.get(j);
                if (!urlWithContext.contains(prefixProtocol)) continue;
                if (urlWithContext.endsWith(prefixProtocol)) {
                    urlWithoutContext = "";
                } else {
                    int offset = urlWithContext.indexOf(prefixProtocol);
                    urlWithoutContext = urlWithContext.substring(offset + prefixProtocol.length(), urlWithContext.length());
                }
                found = true;
                break;
            }
            if (found) break;
        }
        if (urlWithoutContext == null && manifestProtocol.getWeb().getEmptyContext() != null && manifestProtocol.getWeb().getEmptyContext().getEnabled()) {
            for (int j = 0; j < paContexts.size(); ++j) {
                String prefixProtocol = (String)paContexts.get(j);
                if (!urlWithContext.contains(prefixProtocol)) continue;
                if (urlWithContext.endsWith(prefixProtocol)) {
                    urlWithoutContext = "";
                    break;
                }
                int offset = urlWithContext.indexOf(prefixProtocol);
                urlWithoutContext = urlWithContext.substring(offset + prefixProtocol.length(), urlWithContext.length());
                break;
            }
        }
        if (urlWithoutContext == null) {
            throw new ProtocolException("Identificazione URL senza contesto applicazione e protocollo non riuscita (protocollo [" + protocol + "], url [" + urlWithContext + "])");
        }
        return urlWithoutContext;
    }

    protected String getMappingName(String protocol, String urlWithContext, IDService idService, FunctionContextsCustom customContexts) throws ProtocolException {
        String prefix = protocol + ".pa.";
        String suffix = ".url";
        String urlWithoutContext = this.getUrlWithoutContext(protocol, urlWithContext, idService, customContexts);
        Enumeration<Object> keys = this.propertiesReader.keys();
        while (keys.hasMoreElements()) {
            String mapping;
            Object tmpurl;
            String propertyName = (String)keys.nextElement();
            if (!propertyName.startsWith(prefix) || !propertyName.endsWith(suffix) || (tmpurl = this.propertiesReader.getProperty(propertyName)) == null) continue;
            if (!((String)(tmpurl = ((String)tmpurl).trim())).startsWith("/") && !((String)tmpurl).equals("*")) {
                tmpurl = "/" + (String)tmpurl;
            }
            boolean match = false;
            match = ((String)tmpurl).endsWith("*") ? urlWithoutContext.startsWith(((String)tmpurl).substring(0, ((String)tmpurl).length() - 1)) : urlWithoutContext.equals(tmpurl);
            if (!match || (mapping = propertyName.substring(prefix.length(), propertyName.length() - suffix.length())) == null || mapping.equals("")) continue;
            return mapping;
        }
        throw new ProtocolException("Non risulta configurata nessuna configurazione di mapping nel protocollo [" + protocol + "] per la url [" + urlWithContext + "]");
    }

    protected ModalitaIdentificazione getModalita(String protocol, String mappingName, String attribute) throws ProtocolException {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute;
        String modalita = this.propertiesReader.getProperty(propertyName);
        if (modalita == null) {
            throw new ProtocolException("Nessuna modalita configurata per la proprieta' [" + propertyName + "].");
        }
        modalita = modalita.trim();
        ModalitaIdentificazione m = ModalitaIdentificazione.toEnumConstant(modalita);
        if (m == null) {
            throw new ProtocolException("La modalita' [" + modalita + "] configurata per la proprieta [" + propertyName + "] non e' supportata.");
        }
        return m;
    }

    protected String getValue(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".value";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getPattern(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".pattern";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getName(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".name";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getAnonymous(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".anonymous";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

