/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.LetturaParametriBusta;
import org.openspcoop2.protocol.engine.driver.BustaNonRiscontrata;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.ProtocolRandomUtilities;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.registry.RisultatoValidazione;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class ProfiloDiCollaborazione {
    private Logger log = null;
    private IState state;
    private IGestoreRepository gestoreRepositoryBuste;
    private IProtocolFactory<?> protocolFactory;
    private IProtocolConfiguration protocolConfiguration;
    private IProtocolManager protocolManager;
    private ITraduttore protocolTraduttore;

    private void initProtocolFactory(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.protocolTraduttore = this.protocolFactory.createTraduttore();
        this.protocolConfiguration = this.protocolFactory.createProtocolConfiguration();
    }

    public ProfiloDiCollaborazione(IState state, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(state, Configurazione.getLibraryLog(), protocolFactory);
    }

    public ProfiloDiCollaborazione(IState state, Logger alog, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.state = state;
        this.gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger((String)ProfiloDiCollaborazione.class.getName());
        if (protocolFactory != null) {
            this.initProtocolFactory(protocolFactory);
        }
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void registraBustaInviata(String id) throws ProtocolException {
        this.registraBusta(id, "OUTBOX");
    }

    public void eliminaBustaInviata(String id, boolean forzaEliminazioneDB) throws ProtocolException {
        this.eliminaBusta(id, "OUTBOX", forzaEliminazioneDB);
    }

    public void eliminaBustaInviata(String id) throws ProtocolException {
        this.eliminaBusta(id, "OUTBOX");
    }

    public void registraBustaRicevuta(String id) throws ProtocolException {
        this.registraBusta(id, "INBOX");
    }

    public void eliminaBustaRicevuta(String id, boolean forzaEliminazioneDB) throws ProtocolException {
        this.eliminaBusta(id, "INBOX", forzaEliminazioneDB);
    }

    public void eliminaBustaRicevuta(String id) throws ProtocolException {
        this.eliminaBusta(id, "INBOX");
    }

    public void registraBusta(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE saveBustaForProfilo" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE, Errore di registrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    public void eliminaBusta(String id, String tipoBusta) throws ProtocolException {
        this.eliminaBusta(id, tipoBusta, false);
    }

    public void eliminaBusta(String id, String tipoBusta, boolean forzaEliminazioneDB) throws ProtocolException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDB) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(false));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, tipoBusta);
                state.getPreparedStatement().put("UPDATE eliminaBustaForProfilo" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE, Errore di cancellazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    public boolean sincrono_validazioneRiferimentoMessaggio(String riferimentoMessaggio) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateful, this.log, this.protocolFactory);
                return repositoryBuste.isRegistrataIntoOutBox(riferimentoMessaggio);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error(errorMsg);
                return false;
            }
        }
        return true;
    }

    public boolean sincrono_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateful, this.log, this.protocolFactory);
                if (repositoryBuste.isRegistrataIntoOutBox(riferimentoMessaggio)) {
                    return idCollaborazione.equals(repositoryBuste.getCollaborazioneFromOutBox(riferimentoMessaggio));
                }
                return false;
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error(errorMsg);
                return false;
            }
        }
        return true;
    }

    public void sincrono_eliminaRichiestaInOutBox(String id) throws ProtocolException {
        try {
            this.eliminaBustaInviata(id);
        }
        catch (ProtocolException e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_eliminaRichiestaInOutBox " + id + ": " + e.getMessage();
            this.log.error(errorMsg);
            throw e;
        }
    }

    public Busta sincrono_generaBustaRisposta(String id, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Busta busta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)stateMSG, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            parametri.setIndirizziTelematici(this.protocolConfiguration.isSupportoIndirizzoRisposta());
            busta = repository.getSomeValuesFromInBox(id, parametri);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la getBusta dal repository " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        String mitt = busta.getMittente();
        String tipoMitt = busta.getTipoMittente();
        String portaMitt = busta.getIdentificativoPortaMittente();
        String indMitt = busta.getIndirizzoMittente();
        busta.setMittente(busta.getDestinatario());
        busta.setTipoMittente(busta.getTipoDestinatario());
        busta.setIdentificativoPortaMittente(busta.getIdentificativoPortaDestinatario());
        busta.setIndirizzoMittente(busta.getIndirizzoDestinatario());
        busta.setDestinatario(mitt);
        busta.setTipoDestinatario(tipoMitt);
        busta.setIdentificativoPortaDestinatario(portaMitt);
        busta.setIndirizzoDestinatario(indMitt);
        busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO);
        busta.setRiferimentoMessaggio(id);
        busta.setOraRegistrazione(DateManager.getDate());
        busta.setTipoOraRegistrazione(tipoTempo, this.protocolTraduttore.toString(tipoTempo));
        this.eliminaBustaRicevuta(busta.getRiferimentoMessaggio());
        return busta;
    }

    public Eccezione sincrono_validazioneCorrelazione(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            Eccezione eccValidazione;
            String msgErrore;
            StatefulMessage stateful = (StatefulMessage)this.state;
            Busta bustaRichiesta = null;
            try {
                RepositoryBuste repository = new RepositoryBuste((IState)stateful, this.log, this.protocolFactory);
                LetturaParametriBusta parametri = new LetturaParametriBusta();
                parametri.setMittente(true);
                parametri.setDestinatario(true);
                parametri.setServizio(true);
                parametri.setAzione(true);
                bustaRichiesta = repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_SINCRONO, Errore durante la sincrono_validazioneCorrelazione, get dal repository " + bustaDaValidare.getRiferimentoMessaggio() + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
                msgErrore = "Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
                msgErrore = "Mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                eccValidazione = new Eccezione(ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
                msgErrore = "Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
                msgErrore = "Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                eccValidazione = new Eccezione(ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    msgErrore = "Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                    eccValidazione = new Eccezione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    msgErrore = "Servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono";
                    eccValidazione = new Eccezione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
                if (bustaDaValidare.getAzione() != null && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
                    msgErrore = "Azione diversa da quello atteso nella gestione del profilo di collaborazione Sincrono";
                    eccValidazione = new Eccezione(ErroriCooperazione.AZIONE_NON_VALIDA.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
            }
            return null;
        }
        return null;
    }

    public void asincronoSimmetrico_registraRichiestaInviata(String id, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, Integer versioneServizioCorrelato, boolean ricevutaApplicativa, Integrazione integrazione, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraInvio = DateManager.getTimestamp();
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO  ");
            query.append("ASINCRONO");
            query.append(" (ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO");
            query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
            query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )");
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, id);
            pstmt.setString(index++, "OUTBOX");
            pstmt.setTimestamp(index++, oraInvio);
            pstmt.setInt(index++, 0);
            pstmt.setString(index++, tipoServizioCorrelato);
            pstmt.setString(index++, servizioCorrelato);
            if (versioneServizioCorrelato != null) {
                pstmt.setInt(index++, versioneServizioCorrelato);
            } else {
                pstmt.setNull(index++, 4);
            }
            pstmt.setInt(index++, 1);
            pstmt.setString(index++, id);
            pstmt.setString(index++, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(index++, 1);
            } else {
                pstmt.setInt(index++, 0);
            }
            state.getPreparedStatement().put("INSERT save_RichiestaAsincronaSimmetricaInviata" + id, (PreparedStatement)pstmt);
            if (this.state instanceof StatefulMessage) {
                this.registraBustaInviata(id);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = this.protocolManager.getIntervalloScadenzaBuste();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                repository.aggiornaInfoIntegrazioneIntoOutBox(id, integrazione);
                this.registraBustaInviata(id);
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + id, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore di registrazione richiesta inviata " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Integrazione asincronoSimmetrico_getDatiConsegnaRisposta(String riferimentoMessaggio) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        try {
            History history = new History((IState)state, this.log);
            history.registraBustaInviata(riferimentoMessaggio);
            RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            Integrazione integrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
            if (integrazione == null) {
                throw new Exception("Dati di integrazione non trovati");
            }
            return integrazione;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore durante la asincronoSimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Integrazione asincronoSimmetrico_getDatiConsegnaRicevuta(String riferimentoMessaggio) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        try {
            RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            Integrazione integrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
            if (integrazione == null) {
                throw new Exception("Dati di integrazione non trovati");
            }
            return integrazione;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore durante la asincronoSimmetrico_getDatiConsegnaRicevuta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void asincronoSimmetrico_registraRichiestaRicevuta(String id, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, Integer versioneServizioCorrelato, boolean ricevutaApplicativa, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        Statement pstmtUpdate = null;
        ResultSet rs = null;
        try {
            Timestamp oraRicezione = DateManager.getTimestamp();
            StringBuilder querySearch = new StringBuilder();
            querySearch.append("SELECT ID_MESSAGGIO FROM ");
            querySearch.append("ASINCRONO");
            querySearch.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(querySearch.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            boolean exists = rs.next();
            rs.close();
            pstmt.close();
            StringBuilder query = new StringBuilder();
            if (exists) {
                query.append("UPDATE ");
                query.append("ASINCRONO");
                query.append(" SET ID_MESSAGGIO=?,TIPO=?,ORA_REGISTRAZIONE=?,RICEVUTA_ASINCRONA=?,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,VERSIONE_SERVIZIO_CORRELATO=?,IS_RICHIESTA=?,ID_ASINCRONO=?,ID_COLLABORAZIONE=?,RICEVUTA_APPLICATIVA=? WHERE ID_MESSAGGIO=? AND TIPO=?");
            } else {
                query.append("INSERT INTO  ");
                query.append("ASINCRONO");
                query.append(" (ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO");
                query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
                query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, id);
            pstmt.setString(index++, "INBOX");
            pstmt.setTimestamp(index++, oraRicezione);
            pstmt.setInt(index++, 1);
            pstmt.setString(index++, tipoServizioCorrelato);
            pstmt.setString(index++, servizioCorrelato);
            if (versioneServizioCorrelato != null) {
                pstmt.setInt(index++, versioneServizioCorrelato);
            } else {
                pstmt.setNull(index++, 4);
            }
            pstmt.setInt(index++, 1);
            pstmt.setString(index++, id);
            pstmt.setString(index++, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(index++, 1);
            } else {
                pstmt.setInt(index++, 0);
            }
            if (exists) {
                pstmt.setString(index++, id);
                pstmt.setString(index++, "INBOX");
            }
            if (exists) {
                state.getPreparedStatement().put("UPDATE save_RichiestaAsincronaSimmetricaRicevuta" + id, (PreparedStatement)pstmt);
            } else {
                state.getPreparedStatement().put("INSERT save_RichiestaAsincronaSimmetricaRicevuta" + id, (PreparedStatement)pstmt);
            }
            if (this.state instanceof StatefulMessage) {
                this.registraBustaRicevuta(id);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = this.protocolManager.getIntervalloScadenzaBuste();
                }
                RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
                String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + statelessMessage.getBusta().getID();
                if (repository.isRegistrataIntoInBox(statelessMessage.getBusta().getID())) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else if (state.getPreparedStatement().containsKey(key)) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else {
                    repository.registraBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                }
                this.registraBustaRicevuta(id);
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, "INBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloINBOX_" + id, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore di registrazione richiesta ricevuta " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Busta asincronoSimmetrico_getBustaRisposta(String id, String idRisposta, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            if (!repository.exists(id, "INBOX")) {
                throw new Exception("Busta non trovata");
            }
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizioCorrelato(true);
            busta = repository.getSomeValuesFromInBox(id, parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore durante la getBusta dal repository " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
        Statement pstmtCheck = null;
        ResultSet rsCheck = null;
        String oldIDRisposta = null;
        String oldTipoRisposta = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_MESSAGGIO,TIPO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE BACKUP_ID_RICHIESTA=?");
            pstmtCheck = connectionDB.prepareStatement(query.toString());
            pstmtCheck.setString(1, id);
            rsCheck = pstmtCheck.executeQuery();
            if (rsCheck == null) {
                throw new ProtocolException("RS Check Null?");
            }
            if (rsCheck.next()) {
                oldIDRisposta = rsCheck.getString("ID_MESSAGGIO");
                oldTipoRisposta = rsCheck.getString("TIPO");
            }
            rsCheck.close();
            pstmtCheck.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, asincronoSimmetrico_getBustaRisposta " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rsCheck != null) {
                    rsCheck.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtCheck != null) {
                    pstmtCheck.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        Statement pstmt = null;
        try {
            Timestamp oraInvioRisposta = DateManager.getTimestamp();
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET IS_RICHIESTA=0, RICEVUTA_ASINCRONA=0, ORA_REGISTRAZIONE=?, ID_MESSAGGIO=?, TIPO=?, BACKUP_ID_RICHIESTA=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setTimestamp(1, oraInvioRisposta);
            pstmt.setString(2, idRisposta);
            pstmt.setString(3, "OUTBOX");
            pstmt.setString(4, id);
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmt.setString(5, oldIDRisposta);
                pstmt.setString(6, oldTipoRisposta);
            } else {
                pstmt.setString(5, id);
                pstmt.setString(6, "INBOX");
            }
            state.getPreparedStatement().put("UPDATE save_RispostaAsincronaSimmetricaInviata" + id, (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore di registrazione risposta inviata " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (busta.getTipoServizioCorrelato() == null || busta.getServizioCorrelato() == null) {
            Statement pstmtServizioCorrelato = null;
            ResultSet rsServizioCorrelato = null;
            String tipoSC = null;
            String nomeSC = null;
            Integer versioneSC = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                pstmtServizioCorrelato = connectionDB.prepareStatement(query.toString());
                if (oldIDRisposta != null && oldTipoRisposta != null) {
                    pstmtServizioCorrelato.setString(1, oldIDRisposta);
                    pstmtServizioCorrelato.setString(2, oldTipoRisposta);
                } else {
                    pstmtServizioCorrelato.setString(1, id);
                    pstmtServizioCorrelato.setString(2, "INBOX");
                }
                rsServizioCorrelato = pstmtServizioCorrelato.executeQuery();
                if (rsServizioCorrelato == null) {
                    throw new ProtocolException("RS Check Null?");
                }
                if (rsServizioCorrelato.next()) {
                    tipoSC = rsServizioCorrelato.getString("TIPO_SERVIZIO_CORRELATO");
                    nomeSC = rsServizioCorrelato.getString("SERVIZIO_CORRELATO");
                    versioneSC = rsServizioCorrelato.getInt("VERSIONE_SERVIZIO_CORRELATO");
                    if (rsServizioCorrelato.wasNull()) {
                        versioneSC = null;
                    }
                }
                rsServizioCorrelato.close();
                pstmtServizioCorrelato.close();
                if (tipoSC == null || nomeSC == null || versioneSC == null) {
                    throw new Exception("Tipo/Nome/Versione servizio correlato non trovato");
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, asincronoSimmetrico_getBustaRisposta " + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rsServizioCorrelato != null) {
                        rsServizioCorrelato.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmtServizioCorrelato != null) {
                        pstmtServizioCorrelato.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
            busta.setTipoServizioCorrelato(tipoSC);
            busta.setServizioCorrelato(nomeSC);
            busta.setVersioneServizioCorrelato(versioneSC);
        }
        if (this.state instanceof StatefulMessage) {
            this.registraBustaInviata(idRisposta);
        } else {
            Statement pstmtUpdate = null;
            try {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = this.protocolManager.getIntervalloScadenzaBuste();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                this.registraBustaInviata(idRisposta);
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idRisposta);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idRisposta, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore di aggiornamento busta di risposta " + idRisposta + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        if (oldIDRisposta != null && oldTipoRisposta != null) {
            this.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
        }
        return busta;
    }

    public Busta asincronoSimmetrico_getBustaRicevuta(String id, String rifMsgRicevuta, boolean isRichiesta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setServizioCorrelato(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            parametri.setIndirizziTelematici(this.protocolConfiguration.isSupportoIndirizzoRisposta());
            if (isRichiesta) {
                busta = repository.getSomeValuesFromInBox(id, parametri, true);
            } else {
                busta = repository.getSomeValuesFromOutBox(id, parametri, true);
                this.eliminaBustaInviata(id, true);
            }
            busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
            if (isRichiesta) {
                String mitt = busta.getMittente();
                String tipoMitt = busta.getTipoMittente();
                String portaMitt = busta.getIdentificativoPortaMittente();
                String indMitt = busta.getIndirizzoMittente();
                busta.setMittente(busta.getDestinatario());
                busta.setTipoMittente(busta.getTipoDestinatario());
                busta.setIdentificativoPortaMittente(busta.getIdentificativoPortaDestinatario());
                busta.setIndirizzoMittente(busta.getIndirizzoDestinatario());
                busta.setDestinatario(mitt);
                busta.setTipoDestinatario(tipoMitt);
                busta.setIdentificativoPortaDestinatario(portaMitt);
                busta.setIndirizzoDestinatario(indMitt);
            }
            if (!isRichiesta) {
                String tipoServizioCorrelato = busta.getTipoServizioCorrelato();
                String servizioCorrelato = busta.getServizioCorrelato();
                Integer versioneServizioCorrelato = busta.getVersioneServizioCorrelato();
                if (tipoServizioCorrelato == null || servizioCorrelato == null || versioneServizioCorrelato == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                    PreparedStatement pstmtServizioCorrelato = null;
                    ResultSet rsServizioCorrelato = null;
                    try {
                        pstmtServizioCorrelato = connectionDB.prepareStatement(query.toString());
                        pstmtServizioCorrelato.setString(1, id);
                        pstmtServizioCorrelato.setString(2, "OUTBOX");
                        rsServizioCorrelato = pstmtServizioCorrelato.executeQuery();
                        if (rsServizioCorrelato.next()) {
                            tipoServizioCorrelato = rsServizioCorrelato.getString("TIPO_SERVIZIO_CORRELATO");
                            servizioCorrelato = rsServizioCorrelato.getString("SERVIZIO_CORRELATO");
                            versioneServizioCorrelato = rsServizioCorrelato.getInt("VERSIONE_SERVIZIO_CORRELATO");
                            if (rsServizioCorrelato.wasNull()) {
                                versioneServizioCorrelato = null;
                            }
                        }
                        if (tipoServizioCorrelato == null || servizioCorrelato == null || versioneServizioCorrelato == null) {
                            throw new Exception("Tipo/Nome/Versione servizio correlato non trovato");
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Lettura Servizio correlato non riuscita " + e.getMessage(), e);
                    }
                    finally {
                        try {
                            if (rsServizioCorrelato != null) {
                                rsServizioCorrelato.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        try {
                            if (pstmtServizioCorrelato != null) {
                                pstmtServizioCorrelato.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
                busta.setTipoServizio(tipoServizioCorrelato);
                busta.setServizio(servizioCorrelato);
            }
            busta.setRiferimentoMessaggio(rifMsgRicevuta);
            busta.setOraRegistrazione(DateManager.getDate());
            busta.setTipoOraRegistrazione(tipoTempo, this.protocolTraduttore.toString(tipoTempo));
            busta.setTipoServizioCorrelato(null);
            busta.setServizioCorrelato(null);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore durante la asincronoSimmetrico_getBustaRicevuta dal repository " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        return busta;
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_ricevutaRichiesta(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, true, false, false, protocolFactory);
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_risposta(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, false, true, false, protocolFactory);
    }

    public Eccezione asincronoSimmetrico_validazioneCorrelazione_ricevutaRisposta(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoSimmetrico_validazioneCorrelazione(bustaDaValidare, false, false, true, protocolFactory);
    }

    private Eccezione asincronoSimmetrico_validazioneCorrelazione(Busta bustaDaValidare, boolean isRicevutaRichiesta, boolean isRisposta, boolean isRicevutaRisposta, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        Eccezione eccValidazione;
        String msgErrore;
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta bustaRichiesta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            bustaRichiesta = isRisposta && bustaDaValidare.getRiferimentoMessaggio() == null ? repository.getSomeValuesFromOutBox(bustaDaValidare.getCollaborazione(), parametri, true) : repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, Errore durante la validazioneCorrelazione, get dal repository " + bustaDaValidare.getRiferimentoMessaggio() + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (isRicevutaRichiesta) {
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    msgErrore = "Tipo del servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
                    eccValidazione = new Eccezione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    msgErrore = "Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
                    eccValidazione = new Eccezione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
            }
        } else if (isRisposta || isRicevutaRisposta && bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                if (isRisposta && bustaDaValidare.getRiferimentoMessaggio() == null) {
                    pstmt.setString(1, bustaDaValidare.getCollaborazione());
                } else {
                    pstmt.setString(1, bustaDaValidare.getRiferimentoMessaggio());
                }
                pstmt.setString(2, "OUTBOX");
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                String tipoServizioCorrelatoRegistrato = null;
                String servizioCorrelatoRegistrato = null;
                Integer versioneServizioCorrelatoRegistrato = null;
                if (rs.next()) {
                    tipoServizioCorrelatoRegistrato = rs.getString("TIPO_SERVIZIO_CORRELATO");
                    servizioCorrelatoRegistrato = rs.getString("SERVIZIO_CORRELATO");
                    versioneServizioCorrelatoRegistrato = rs.getInt("VERSIONE_SERVIZIO_CORRELATO");
                    if (rs.wasNull()) {
                        versioneServizioCorrelatoRegistrato = null;
                    }
                }
                rs.close();
                pstmt.close();
                if (!bustaDaValidare.getTipoServizio().equals(tipoServizioCorrelatoRegistrato)) {
                    String msgErrore2 = "Tipo del servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
                    Eccezione eccValidazione2 = new Eccezione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore2), true, null, protocolFactory);
                    this.log.error(msgErrore2);
                    return eccValidazione2;
                }
                if (!bustaDaValidare.getServizio().equals(servizioCorrelatoRegistrato)) {
                    String msgErrore3 = "Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
                    Eccezione eccValidazione3 = new Eccezione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore3), true, null, protocolFactory);
                    this.log.error(msgErrore3);
                    return eccValidazione3;
                }
                if (versioneServizioCorrelatoRegistrato == null) {
                    versioneServizioCorrelatoRegistrato = -1;
                }
                if (bustaDaValidare.getVersioneServizio().intValue() != versioneServizioCorrelatoRegistrato.intValue()) {
                    String msgErrore4 = "Versione del servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
                    Eccezione eccValidazione4 = new Eccezione(ErroriCooperazione.VERSIONE_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore4), true, null, protocolFactory);
                    this.log.error(msgErrore4);
                    return eccValidazione4;
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, validazioneCorrelazioneRichiesta RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
                this.log.error(errorMsg);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg);
            }
        }
        if (bustaDaValidare.getAzione() != null && !isRisposta && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
            msgErrore = "Azione diverso da quello attesa nella gestione del profilo di collaborazione Asincrono Simmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.AZIONE_NON_VALIDA.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
            msgErrore = "Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
            msgErrore = "Mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
            msgErrore = "Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
            msgErrore = "Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Simmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        return null;
    }

    public boolean asincronoSimmetrico_validazioneRiferimentoMessaggio(String riferimentoMessaggio) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_MESSAGGIO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            return value && repositoryBuste.isRegistrataIntoOutBox(riferimentoMessaggio);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincronoSimmetrico_validazioneCollaborazione_risposta(String riferimentoMessaggio, String idCollaborazione) throws ProtocolException {
        return this.asincronoSimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, true);
    }

    public boolean asincronoSimmetrico_validazioneCollaborazione_ricevuta(String riferimentoMessaggio, String idCollaborazione) throws ProtocolException {
        return this.asincronoSimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, false);
    }

    private boolean asincronoSimmetrico_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione, boolean isRisposta) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_COLLABORAZIONE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            if (isRisposta && riferimentoMessaggio == null) {
                pstmt.setString(1, idCollaborazione);
            } else {
                pstmt.setString(1, riferimentoMessaggio);
            }
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            String value = null;
            if (rs.next()) {
                value = rs.getString("ID_COLLABORAZIONE");
            }
            rs.close();
            pstmt.close();
            return idCollaborazione.equals(value);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOSIMMETRICO, validazioneCollaborazione " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void asincronoAsimmetrico_registraRichiestaInviata(String id, String idCollaborazione, boolean ricevutaApplicativa, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraInvio = DateManager.getTimestamp();
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO  ");
            query.append("ASINCRONO");
            query.append(" (ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO");
            query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
            query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?, ?)");
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, id);
            pstmt.setString(index++, "OUTBOX");
            pstmt.setTimestamp(index++, oraInvio);
            pstmt.setInt(index++, 0);
            pstmt.setString(index++, null);
            pstmt.setString(index++, null);
            pstmt.setNull(index++, 4);
            pstmt.setInt(index++, 1);
            pstmt.setString(index++, id);
            pstmt.setString(index++, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(index++, 1);
            } else {
                pstmt.setInt(index++, 0);
            }
            state.getPreparedStatement().put("INSERT save_RichiestaAsincronaAsimmetricaInviata" + id, (PreparedStatement)pstmt);
            if (this.state instanceof StatefulMessage) {
                this.registraBustaInviata(id);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = this.protocolManager.getIntervalloScadenzaBuste();
                }
                repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
                this.registraBustaInviata(id);
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + id, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore di registrazione richiesta inviata " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public IDServizio asincronoAsimmetrico_getDatiConsegnaRisposta(String riferimentoMessaggio) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmtPooling = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET RICEVUTA_APPLICATIVA=1 WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtPooling = connectionDB.prepareStatement(query.toString());
            pstmtPooling.setString(1, riferimentoMessaggio);
            pstmtPooling.setString(2, "INBOX");
            state.getPreparedStatement().put("UPDATE asincronoAsimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio, (PreparedStatement)pstmtPooling);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore asincronoAsimmetrico_getDatiConsegnaRisposta, update RICEVUTA_APPLICATIVA " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtPooling != null) {
                    pstmtPooling.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        try {
            History history = new History((IState)state, this.log);
            history.registraBustaRicevuta(riferimentoMessaggio);
            RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            Busta busta = repositoryBuste.getSomeValuesFromInBox(riferimentoMessaggio, parametri, true);
            if (busta == null) {
                throw new Exception("Dati non trovati");
            }
            IDServizio id = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
            id.setAzione(busta.getAzione());
            return id;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore durante la asincronoAsimmetrico_getDatiConsegnaRisposta " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Integrazione asincronoAsimmetrico_getDatiConsegnaRicevuta(String riferimentoMessaggio) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            try {
                RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateful, this.log, this.protocolFactory);
                Integrazione integrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(riferimentoMessaggio);
                if (integrazione == null) {
                    throw new Exception("Dati di integrazione non trovati");
                }
                return integrazione;
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore durante la asincronoAsimmetrico_getDatiConsegnaRicevuta " + riferimentoMessaggio + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public void asincronoAsimmetrico_registraRichiestaRicevuta(String id, String idCollaborazione, String tipoServizioCorrelato, String servizioCorrelato, Integer versioneServizioCorrelato, boolean ricevutaApplicativa, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        Statement pstmtUpdate = null;
        try {
            Timestamp oraRicezione = DateManager.getTimestamp();
            StringBuilder querySearch = new StringBuilder();
            querySearch.append("SELECT ID_MESSAGGIO FROM ");
            querySearch.append("ASINCRONO");
            querySearch.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(querySearch.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "INBOX");
            rs = pstmt.executeQuery();
            boolean exists = rs.next();
            rs.close();
            pstmt.close();
            StringBuilder query = new StringBuilder();
            if (exists) {
                query.append("UPDATE ");
                query.append("ASINCRONO");
                query.append(" SET ID_MESSAGGIO=?,TIPO=?,ORA_REGISTRAZIONE=?,RICEVUTA_ASINCRONA=?,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,VERSIONE_SERVIZIO_CORRELATO=?,IS_RICHIESTA=?,ID_ASINCRONO=?,ID_COLLABORAZIONE=?,RICEVUTA_APPLICATIVA=? WHERE ID_MESSAGGIO=? AND TIPO=?");
            } else {
                query.append("INSERT INTO  ");
                query.append("ASINCRONO");
                query.append(" (ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RICEVUTA_ASINCRONA,TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO");
                query.append(",IS_RICHIESTA,ID_ASINCRONO,ID_COLLABORAZIONE,RICEVUTA_APPLICATIVA) ");
                query.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmt.setString(index++, id);
            pstmt.setString(index++, "INBOX");
            pstmt.setTimestamp(index++, oraRicezione);
            pstmt.setInt(index++, 1);
            pstmt.setString(index++, tipoServizioCorrelato);
            pstmt.setString(index++, servizioCorrelato);
            if (versioneServizioCorrelato != null) {
                pstmt.setInt(index++, versioneServizioCorrelato);
            } else {
                pstmt.setNull(index++, 4);
            }
            pstmt.setInt(index++, 0);
            pstmt.setString(index++, id);
            pstmt.setString(index++, idCollaborazione);
            if (ricevutaApplicativa) {
                pstmt.setInt(index++, 1);
            } else {
                pstmt.setInt(index++, 0);
            }
            if (exists) {
                pstmt.setString(index++, id);
                pstmt.setString(index++, "INBOX");
            }
            if (exists) {
                state.getPreparedStatement().put("UPDATE save_RichiestaAsincronaAsimmetricaRicevuta" + id, (PreparedStatement)pstmt);
            } else {
                state.getPreparedStatement().put("INSERT save_RichiestaAsincronaAsimmetricaRicevuta" + id, (PreparedStatement)pstmt);
            }
            if (this.state instanceof StatefulMessage) {
                this.registraBustaRicevuta(id);
            } else {
                StatelessMessage statelessMessage = (StatelessMessage)this.state;
                long scadenza = scadenzaMessaggi;
                if (scadenza <= 0L) {
                    scadenza = this.protocolManager.getIntervalloScadenzaBuste();
                }
                RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
                String key = "INSERT RegistrazioneBustaForHistoryINBOX_" + statelessMessage.getBusta().getID();
                if (repository.isRegistrataIntoInBox(statelessMessage.getBusta().getID())) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else if (state.getPreparedStatement().containsKey(key)) {
                    repository.aggiornaBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                } else {
                    repository.registraBustaIntoInBox(statelessMessage.getBusta(), scadenza);
                }
                this.registraBustaInviata(id);
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, "INBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloINBOX_" + id, (PreparedStatement)pstmtUpdate);
            }
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore di registrazione richiesta ricevuta " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Busta asincronoAsimmetrico_getBustaRisposta(String id, String idRisposta, long scadenzaMessaggi) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta busta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizioCorrelato(true);
            busta = repository.getSomeValuesFromOutBox(id, parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore durante la getBusta dal repository " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
        Statement pstmtCheck = null;
        ResultSet rsCheck = null;
        String oldIDRisposta = null;
        String oldTipoRisposta = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_MESSAGGIO,TIPO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE BACKUP_ID_RICHIESTA=?");
            pstmtCheck = connectionDB.prepareStatement(query.toString());
            pstmtCheck.setString(1, id);
            rsCheck = pstmtCheck.executeQuery();
            if (rsCheck == null) {
                throw new ProtocolException("RS Check Null?");
            }
            if (rsCheck.next()) {
                oldIDRisposta = rsCheck.getString("ID_MESSAGGIO");
                oldTipoRisposta = rsCheck.getString("TIPO");
            }
            rsCheck.close();
            pstmtCheck.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, asincronoAsimmetrico_getBustaRisposta " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rsCheck != null) {
                    rsCheck.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtCheck != null) {
                    pstmtCheck.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        String tipoServizioCorrelato = null;
        String servizioCorrelato = null;
        Integer versioneServizioCorrelato = null;
        Statement pstmtRead = null;
        ResultSet rsRead = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmtRead = connectionDB.prepareStatement(query.toString());
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmtRead.setString(1, oldIDRisposta);
                pstmtRead.setString(2, oldTipoRisposta);
            } else {
                pstmtRead.setString(1, id);
                pstmtRead.setString(2, "OUTBOX");
            }
            rsRead = pstmtRead.executeQuery();
            if (rsRead == null) {
                throw new ProtocolException("RS Read Null?");
            }
            if (rsRead.next()) {
                tipoServizioCorrelato = rsRead.getString("TIPO_SERVIZIO_CORRELATO");
                servizioCorrelato = rsRead.getString("SERVIZIO_CORRELATO");
                versioneServizioCorrelato = rsRead.getInt("VERSIONE_SERVIZIO_CORRELATO");
                if (rsRead.wasNull()) {
                    versioneServizioCorrelato = null;
                }
            }
            rsRead.close();
            pstmtRead.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, asincronoAsimmetrico_getBustaRisposta, raccolta servizio correlato, " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rsRead != null) {
                    rsRead.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtRead != null) {
                    pstmtRead.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        busta.setTipoServizioCorrelato(tipoServizioCorrelato);
        busta.setServizioCorrelato(servizioCorrelato);
        busta.setVersioneServizioCorrelato(versioneServizioCorrelato);
        Statement pstmt = null;
        try {
            Timestamp oraInvioRisposta = DateManager.getTimestamp();
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("ASINCRONO");
            query.append(" SET IS_RICHIESTA=0, RICEVUTA_ASINCRONA=0, ORA_REGISTRAZIONE=?, ID_MESSAGGIO=?, TIPO=?, BACKUP_ID_RICHIESTA=?, RICEVUTA_APPLICATIVA=1 WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setTimestamp(1, oraInvioRisposta);
            pstmt.setString(2, idRisposta);
            pstmt.setString(3, "OUTBOX");
            pstmt.setString(4, id);
            if (oldIDRisposta != null && oldTipoRisposta != null) {
                pstmt.setString(5, oldIDRisposta);
                pstmt.setString(6, oldTipoRisposta);
            } else {
                pstmt.setString(5, id);
                pstmt.setString(6, "OUTBOX");
            }
            state.getPreparedStatement().put("UPDATE save_RispostaAsincronaAsimmetricaInviata" + id, (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore di registrazione risposta inviata " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        History history = new History((IState)state, this.log);
        history.registraBustaInviata(id);
        if (this.state instanceof StatefulMessage) {
            this.registraBustaInviata(idRisposta);
        } else {
            StatelessMessage statelessMessage = (StatelessMessage)this.state;
            long scadenza = scadenzaMessaggi;
            if (scadenza <= 0L) {
                scadenza = this.protocolManager.getIntervalloScadenzaBuste();
            }
            RepositoryBuste repository = new RepositoryBuste(this.state, this.log, true, this.protocolFactory);
            repository.registraBustaIntoOutBox(statelessMessage.getBusta(), scadenza);
            this.registraBustaInviata(idRisposta);
            Statement pstmtUpdate = null;
            try {
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(true));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, idRisposta);
                pstmtUpdate.setString(2, "OUTBOX");
                state.getPreparedStatement().put("UPDATE saveBustaForProfiloOUTBOX_" + idRisposta, (PreparedStatement)pstmtUpdate);
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore di aggiornamento busta di risposta " + idRisposta + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        history.registraBustaInviata(idRisposta);
        if (oldIDRisposta != null && oldTipoRisposta != null) {
            this.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
            history.eliminaBusta(oldIDRisposta, oldTipoRisposta, true);
        }
        return busta;
    }

    public Busta asincronoAsimmetrico_getBustaRicevuta(String id, String rifMsgRicevuta, boolean isRichiesta, boolean generazioneAttributiAsincroni, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        String tipoServizioCorrelato = null;
        String servizioCorrelato = null;
        Integer versioneServizioCorrelato = null;
        Statement pstmtRead = null;
        ResultSet rsRead = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmtRead = connectionDB.prepareStatement(query.toString());
            pstmtRead.setString(1, id);
            pstmtRead.setString(2, "INBOX");
            rsRead = pstmtRead.executeQuery();
            if (rsRead == null) {
                throw new ProtocolException("RS Read Null?");
            }
            if (rsRead.next()) {
                tipoServizioCorrelato = rsRead.getString("TIPO_SERVIZIO_CORRELATO");
                servizioCorrelato = rsRead.getString("SERVIZIO_CORRELATO");
                versioneServizioCorrelato = rsRead.getInt("VERSIONE_SERVIZIO_CORRELATO");
                if (rsRead.wasNull()) {
                    versioneServizioCorrelato = null;
                }
            }
            rsRead.close();
            pstmtRead.close();
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, asincronoAsimmetrico_getBustaRicevuta, raccolta servizio correlato, " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rsRead != null) {
                    rsRead.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtRead != null) {
                    pstmtRead.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        Busta busta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            parametri.setCollaborazione(true);
            parametri.setProfiloTrasmissione(true);
            parametri.setIndirizziTelematici(this.protocolConfiguration.isSupportoIndirizzoRisposta());
            busta = repository.getSomeValuesFromInBox(id, parametri, true);
            if (!isRichiesta) {
                this.eliminaBustaRicevuta(id, true);
            }
            busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
            String mitt = busta.getMittente();
            String tipoMitt = busta.getTipoMittente();
            String portaMitt = busta.getIdentificativoPortaMittente();
            String indMitt = busta.getIndirizzoMittente();
            busta.setMittente(busta.getDestinatario());
            busta.setTipoMittente(busta.getTipoDestinatario());
            busta.setIdentificativoPortaMittente(busta.getIdentificativoPortaDestinatario());
            busta.setIndirizzoMittente(busta.getIndirizzoDestinatario());
            busta.setDestinatario(mitt);
            busta.setTipoDestinatario(tipoMitt);
            busta.setIdentificativoPortaDestinatario(portaMitt);
            busta.setIndirizzoDestinatario(indMitt);
            if (isRichiesta) {
                if (generazioneAttributiAsincroni) {
                    busta.setTipoServizioCorrelato(tipoServizioCorrelato);
                    busta.setServizioCorrelato(servizioCorrelato);
                    busta.setVersioneServizioCorrelato(versioneServizioCorrelato);
                }
            } else {
                busta.setTipoServizio(tipoServizioCorrelato);
                busta.setServizio(servizioCorrelato);
                busta.setVersioneServizio(versioneServizioCorrelato);
            }
            busta.setRiferimentoMessaggio(rifMsgRicevuta);
            busta.setOraRegistrazione(DateManager.getDate());
            busta.setTipoOraRegistrazione(tipoTempo, this.protocolTraduttore.toString(tipoTempo));
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore durante la asincronoAsimmetrico_getBustaRicevuta dal repository " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        return busta;
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiesta(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, true, false, false, protocolFactory);
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_richiestaStato(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, false, true, false, protocolFactory);
    }

    public Eccezione asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiestaStato(Busta bustaDaValidare, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneCorrelazione(bustaDaValidare, false, false, true, protocolFactory);
    }

    private Eccezione asincronoAsimmetrico_validazioneCorrelazione(Busta bustaDaValidare, boolean isRicevutaRichiesta, boolean isRichiestaStato, boolean isRicevutaRichiestaStato, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        Eccezione eccValidazione;
        String msgErrore;
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Busta bustaRichiesta = null;
        try {
            RepositoryBuste repository = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            LetturaParametriBusta parametri = new LetturaParametriBusta();
            parametri.setMittente(true);
            parametri.setDestinatario(true);
            parametri.setServizio(true);
            parametri.setAzione(true);
            bustaRichiesta = isRichiestaStato ? (bustaDaValidare.getRiferimentoMessaggio() == null ? repository.getSomeValuesFromInBox(bustaDaValidare.getCollaborazione(), parametri, true) : repository.getSomeValuesFromInBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true)) : repository.getSomeValuesFromOutBox(bustaDaValidare.getRiferimentoMessaggio(), parametri, true);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, Errore durante la validazioneCorrelazione, get dal repository RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (isRicevutaRichiesta) {
            if (bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
                if (!bustaRichiesta.getTipoServizio().equals(bustaDaValidare.getTipoServizio())) {
                    msgErrore = "Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                    eccValidazione = new Eccezione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
                if (!bustaRichiesta.getServizio().equals(bustaDaValidare.getServizio())) {
                    msgErrore = "Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                    eccValidazione = new Eccezione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                    this.log.error(msgErrore);
                    return eccValidazione;
                }
            }
        } else if (isRichiestaStato || isRicevutaRichiestaStato && bustaDaValidare.getServizio() != null && bustaDaValidare.getTipoServizio() != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("SELECT TIPO_SERVIZIO_CORRELATO,SERVIZIO_CORRELATO,VERSIONE_SERVIZIO_CORRELATO FROM ");
                query.append("ASINCRONO");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                if (isRichiestaStato && bustaDaValidare.getRiferimentoMessaggio() == null) {
                    pstmt.setString(1, bustaDaValidare.getCollaborazione());
                } else {
                    pstmt.setString(1, bustaDaValidare.getRiferimentoMessaggio());
                }
                if (isRichiestaStato) {
                    pstmt.setString(2, "INBOX");
                } else {
                    pstmt.setString(2, "OUTBOX");
                }
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                String tipoServizioCorrelatoRegistrato = null;
                String servizioCorrelatoRegistrato = null;
                Integer versioneServizioCorrelatoRegistrato = null;
                if (rs.next()) {
                    tipoServizioCorrelatoRegistrato = rs.getString("TIPO_SERVIZIO_CORRELATO");
                    servizioCorrelatoRegistrato = rs.getString("SERVIZIO_CORRELATO");
                    versioneServizioCorrelatoRegistrato = rs.getInt("VERSIONE_SERVIZIO_CORRELATO");
                }
                rs.close();
                pstmt.close();
                if (!bustaDaValidare.getTipoServizio().equals(tipoServizioCorrelatoRegistrato)) {
                    String msgErrore2 = "Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                    Eccezione eccValidazione2 = new Eccezione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore2), true, null, protocolFactory);
                    this.log.error(msgErrore2);
                    return eccValidazione2;
                }
                if (!bustaDaValidare.getServizio().equals(servizioCorrelatoRegistrato)) {
                    String msgErrore3 = "Servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                    Eccezione eccValidazione3 = new Eccezione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore3), true, null, protocolFactory);
                    this.log.error(msgErrore3);
                    return eccValidazione3;
                }
                if (versioneServizioCorrelatoRegistrato == null) {
                    versioneServizioCorrelatoRegistrato = -1;
                }
                if (bustaDaValidare.getVersioneServizio().intValue() != versioneServizioCorrelatoRegistrato.intValue()) {
                    String msgErrore4 = "Versione del servizio diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                    Eccezione eccValidazione4 = new Eccezione(ErroriCooperazione.VERSIONE_SERVIZIO_NON_VALIDO.getErroreCooperazione(msgErrore4), true, null, protocolFactory);
                    this.log.error(msgErrore4);
                    return eccValidazione4;
                }
            }
            catch (Exception e) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, validazioneCorrelazione RifMsg(" + bustaDaValidare.getRiferimentoMessaggio() + ") Collab(" + bustaDaValidare.getCollaborazione() + "): " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        if (bustaDaValidare.getAzione() != null && !isRichiestaStato && !bustaDaValidare.getAzione().equals(bustaRichiesta.getAzione())) {
            msgErrore = "Azione diversa da quello attesa nella gestione del profilo di collaborazione Asincrono Asimmetrico";
            eccValidazione = new Eccezione(ErroriCooperazione.AZIONE_NON_VALIDA.getErroreCooperazione(msgErrore), true, null, protocolFactory);
            this.log.error(msgErrore);
            return eccValidazione;
        }
        if (isRichiestaStato) {
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoMittente())) {
                msgErrore = "Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getMittente())) {
                msgErrore = "Mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoDestinatario())) {
                msgErrore = "Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getDestinatario())) {
                msgErrore = "Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
        } else {
            if (!bustaRichiesta.getTipoDestinatario().equals(bustaDaValidare.getTipoMittente())) {
                msgErrore = "Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getDestinatario().equals(bustaDaValidare.getMittente())) {
                msgErrore = "Mittente diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getTipoMittente().equals(bustaDaValidare.getTipoDestinatario())) {
                msgErrore = "Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
            if (!bustaRichiesta.getMittente().equals(bustaDaValidare.getDestinatario())) {
                msgErrore = "Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Asincrono Asimmetrico";
                eccValidazione = new Eccezione(ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione(msgErrore), true, null, protocolFactory);
                this.log.error(msgErrore);
                return eccValidazione;
            }
        }
        return null;
    }

    public boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio_richiestaStato(String riferimentoMessaggio) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneRiferimentoMessaggio(riferimentoMessaggio, true);
    }

    public boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio_ricevuta(String riferimentoMessaggio) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneRiferimentoMessaggio(riferimentoMessaggio, false);
    }

    private boolean asincronoAsimmetrico_validazioneRiferimentoMessaggio(String riferimentoMessaggio, boolean isRichiestaStato) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_MESSAGGIO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            if (isRichiestaStato) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, this.log, this.protocolFactory);
            if (isRichiestaStato) {
                return value && repositoryBuste.isRegistrataIntoInBox(riferimentoMessaggio);
            }
            return value && repositoryBuste.isRegistrataIntoOutBox(riferimentoMessaggio);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, validazioneRiferimentoMessaggio " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincronoAsimmetrico_validazioneCollaborazione_richiestaStato(String riferimentoMessaggio, String idCollaborazione) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, true);
    }

    public boolean asincronoAsimmetrico_validazioneCollaborazione_ricevuta(String riferimentoMessaggio, String idCollaborazione) throws ProtocolException {
        return this.asincronoAsimmetrico_validazioneCollaborazione(riferimentoMessaggio, idCollaborazione, false);
    }

    private boolean asincronoAsimmetrico_validazioneCollaborazione(String riferimentoMessaggio, String idCollaborazione, boolean isRichiestaStato) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_COLLABORAZIONE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            if (isRichiestaStato && riferimentoMessaggio == null) {
                pstmt.setString(1, idCollaborazione);
            } else {
                pstmt.setString(1, riferimentoMessaggio);
            }
            if (isRichiestaStato) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            String value = null;
            if (rs.next()) {
                value = rs.getString("ID_COLLABORAZIONE");
            }
            rs.close();
            pstmt.close();
            return idCollaborazione.equals(value);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONOASIMMETRICO, validazioneCollaborazione " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    @Deprecated
    public List<Busta> asincrono_getBusteAsincronePerUlterioreInoltro_serializable(long timeout) throws ProtocolException {
        return this.asincrono_getBusteAsincronePerUlterioreInoltro_serializable(timeout, 60L, 100);
    }

    @Deprecated
    public List<Busta> asincrono_getBusteAsincronePerUlterioreInoltro_serializable(long timeout, long attesaAttiva, int checkInterval) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                JDBCUtilities.setTransactionIsolationSerializable((String)Configurazione.getSqlQueryObjectType(), (Connection)connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro(setIsolation): " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
            boolean getBusteOK = false;
            ArrayList<Busta> busteNonRingraziate = new ArrayList<Busta>();
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!getBusteOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmt = null;
                ResultSet rs = null;
                ArrayList<String> IDBuste = new ArrayList<String>();
                try {
                    long nowTime = DateManager.getTimeMillis() - timeout * 60L * 1000L;
                    Timestamp scadenzaRingraziamento = new Timestamp(nowTime);
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ORA_REGISTRAZIONE < ? AND TIPO=? AND RICEVUTA_ASINCRONA=0 AND RICEVUTA_APPLICATIVA=0 FOR UPDATE");
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setTimestamp(1, scadenzaRingraziamento);
                    pstmt.setString(2, "OUTBOX");
                    rs = pstmt.executeQuery();
                    if (rs == null) {
                        pstmt.close();
                        return null;
                    }
                    while (rs.next()) {
                        String id = rs.getString("ID_MESSAGGIO");
                        IDBuste.add(id);
                    }
                    rs.close();
                    pstmt.close();
                    if (IDBuste.size() > 0) {
                        RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateful, this.log, this.protocolFactory);
                        for (int i = 0; i < IDBuste.size(); ++i) {
                            String id = (String)IDBuste.get(i);
                            try {
                                Busta busta = repositoryBuste.getBustaFromOutBox(id);
                                busteNonRingraziate.add(busta);
                                continue;
                            }
                            catch (Exception e) {
                                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro (read busta [" + id + "]): " + e.getMessage();
                                this.log.error(errorMsg);
                            }
                        }
                    }
                    connectionDB.commit();
                    getBusteOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (getBusteOK) continue;
                try {
                    Utilities.sleep((long)ProtocolRandomUtilities.getRandom().nextInt(checkInterval));
                }
                catch (Exception exception) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la getBusteAsincronePerUlterioreInoltro(ripristinoIsolation): " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
            return busteNonRingraziate;
        }
        if (this.state instanceof StatelessMessage) {
            throw new ProtocolException("Metodo non invocabile in modalita Stateless");
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public List<BustaNonRiscontrata> asincrono_getBusteAsincronePerUlterioreInoltro(long timeout, int limit, int offset, boolean logQuery) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            ArrayList<String> IDBuste = new ArrayList<String>();
            String queryString = null;
            try {
                long nowTime = DateManager.getTimeMillis() - timeout * 60L * 1000L;
                Timestamp scadenzaRingraziamento = new Timestamp(nowTime);
                IGestoreRepository gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ORA_REGISTRAZIONE < ? AND TIPO=? AND RICEVUTA_ASINCRONA=0 AND RICEVUTA_APPLICATIVA=0");
                    query.append(" AND NOT EXISTS (SELECT ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(".TIPO=");
                    query.append("ASINCRONO");
                    query.append(".TIPO");
                    query.append(" AND ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(".ID_MESSAGGIO=");
                    query.append("ASINCRONO");
                    query.append(".ID_MESSAGGIO");
                    query.append(" AND ");
                    query.append(gestoreRepositoryBuste.createSQLCondition_PdD(false));
                    query.append(" AND ");
                    query.append(gestoreRepositoryBuste.createSQLCondition_ProfiloCollaborazione(false));
                    query.append(" ) ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField("RICEVUTA_ASINCRONA");
                    sqlQueryObject.addSelectField("RICEVUTA_APPLICATIVA");
                    sqlQueryObject.addFromTable("ASINCRONO");
                    sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE < ?");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition("RICEVUTA_ASINCRONA=0");
                    sqlQueryObject.addWhereCondition("RICEVUTA_APPLICATIVA=0");
                    ISQLQueryObject sqlQueryObjectNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectNotExists.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObjectNotExists.addSelectField("REPOSITORY_BUSTE", "ID_MESSAGGIO");
                    sqlQueryObjectNotExists.addWhereCondition("REPOSITORY_BUSTE.TIPO=ASINCRONO.TIPO");
                    sqlQueryObjectNotExists.addWhereCondition("REPOSITORY_BUSTE.ID_MESSAGGIO=ASINCRONO.ID_MESSAGGIO");
                    sqlQueryObjectNotExists.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_PdD(false));
                    sqlQueryObjectNotExists.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_ProfiloCollaborazione(false));
                    sqlQueryObjectNotExists.setANDLogicOperator(true);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.setLimit(limit);
                    sqlQueryObject.setOffset(offset);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setTimestamp(1, scadenzaRingraziamento);
                pstmt.setString(2, "OUTBOX");
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (RicevuteAsincrone) [" + queryString + "] 1[" + scadenzaRingraziamento + "] 2[OUTBOX]...");
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (RicevuteAsincrone) [" + queryString + "] 1[" + scadenzaRingraziamento + "] 2[OUTBOX] effettuata in " + secondSQLCommand + " secondi");
                }
                if (rs == null) {
                    pstmt.close();
                    return null;
                }
                int countLimit = 0;
                int countOffset = 0;
                while (rs.next()) {
                    String id;
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        if (countOffset >= offset) {
                            id = rs.getString("ID_MESSAGGIO");
                            IDBuste.add(id);
                            if (++countLimit != limit) continue;
                            break;
                        }
                        ++countOffset;
                        continue;
                    }
                    id = rs.getString("ID_MESSAGGIO");
                    IDBuste.add(id);
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String errorMsg = "[ProfiloDiCollaborazione.asincrono_getBusteAsincronePerUlterioreInoltro] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
            ArrayList<BustaNonRiscontrata> listaBustaNonRiscontrata = new ArrayList<BustaNonRiscontrata>();
            for (int i = 0; i < IDBuste.size(); ++i) {
                BustaNonRiscontrata bustaNonRiscontrata = new BustaNonRiscontrata();
                bustaNonRiscontrata.setIdentificativo((String)IDBuste.get(i));
                Statement pstmtReadProfilo = null;
                ResultSet rsReadProfilo = null;
                try {
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        StringBuilder query = new StringBuilder();
                        query.append("SELECT PROFILO_DI_COLLABORAZIONE FROM ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(" WHERE ID_MESSAGGIO=? AND TIPO=? ");
                        queryString = query.toString();
                    } else {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                        sqlQueryObject.addSelectField("PROFILO_DI_COLLABORAZIONE");
                        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                        sqlQueryObject.addWhereCondition("ID_MESSAGGIO=?");
                        sqlQueryObject.addWhereCondition("TIPO=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        queryString = sqlQueryObject.createSQLQuery();
                    }
                    pstmtReadProfilo = connectionDB.prepareStatement(queryString);
                    pstmtReadProfilo.setString(1, bustaNonRiscontrata.getIdentificativo());
                    pstmtReadProfilo.setString(2, "OUTBOX");
                    rsReadProfilo = pstmtReadProfilo.executeQuery();
                    if (rsReadProfilo.next()) {
                        bustaNonRiscontrata.setProfiloCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)rsReadProfilo.getString("PROFILO_DI_COLLABORAZIONE")));
                    }
                    listaBustaNonRiscontrata.add(bustaNonRiscontrata);
                    continue;
                }
                catch (Exception e) {
                    String errorMsg = "[ProfiloDiCollaborazione.asincrono_getBusteAsincronePerUlterioreInoltro] errore, queryString[" + queryString + "]: " + e.getMessage();
                    this.log.error(errorMsg, (Throwable)e);
                    throw new ProtocolException(errorMsg, (Throwable)e);
                }
                finally {
                    try {
                        if (rsReadProfilo != null) {
                            rsReadProfilo.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (pstmtReadProfilo != null) {
                            pstmtReadProfilo.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            return listaBustaNonRiscontrata;
        }
        if (this.state instanceof StatelessMessage) {
            throw new ProtocolException("Metodo non invocabile in modalita stateless");
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public boolean asincrono_isRicevutaRichiesta(String riferimentoMessaggio) throws ProtocolException {
        return this.asincrono_isRicevuta(riferimentoMessaggio, true);
    }

    public boolean asincrono_isRicevutaRisposta(String riferimentoMessaggio) throws ProtocolException {
        return this.asincrono_isRicevuta(riferimentoMessaggio, false);
    }

    private boolean asincrono_isRicevuta(String riferimentoMessaggio, boolean isRicevutaRichiesta) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ID_ASINCRONO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=? AND RICEVUTA_ASINCRONA=0");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, riferimentoMessaggio);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = false;
            if (rs.next()) {
                value = riferimentoMessaggio.equals(rs.getString("ID_ASINCRONO")) ? isRicevutaRichiesta : !isRicevutaRichiesta;
            }
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, isRicevutaAsincrono " + riferimentoMessaggio + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    @Deprecated
    public void asincrono_valdazioneRicevuta_serializable(Busta ricevuta) throws ProtocolException {
        this.asincrono_validazioneRicevuta_serializable(ricevuta, 60L, 100);
    }

    @Deprecated
    public void asincrono_validazioneRicevuta_serializable(Busta ricevuta, long attesaAttiva, int checkInterval) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            String idRicevuta = ricevuta.getRiferimentoMessaggio();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                JDBCUtilities.setTransactionIsolationSerializable((String)Configurazione.getSqlQueryObjectType(), (Connection)connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + "(setIsolation): " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
            boolean validazioneRicevutaOK = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!validazioneRicevutaOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmtValidazione = null;
                Statement pstmt = null;
                ResultSet rs = null;
                try {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA,ID_ASINCRONO FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ID_MESSAGGIO=? AND TIPO=? FOR UPDATE");
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setString(1, idRicevuta);
                    pstmt.setString(2, "OUTBOX");
                    rs = pstmt.executeQuery();
                    if (rs == null) {
                        throw new ProtocolException("RS Null?");
                    }
                    boolean isRichiesta = false;
                    boolean validaRicevuta = false;
                    String idCollaborazione = null;
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        return;
                    }
                    if (rs.getInt("IS_RICHIESTA") == 1) {
                        isRichiesta = true;
                    }
                    if (rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                        validaRicevuta = true;
                    }
                    idCollaborazione = rs.getString("ID_ASINCRONO");
                    rs.close();
                    pstmt.close();
                    if (!validaRicevuta) {
                        String tipoRicevuta = "ricevuta di una richiesta asincrona";
                        if (!isRichiesta) {
                            tipoRicevuta = "ricevuta di una risposta asincrona";
                        }
                        this.log.warn("Validazione " + tipoRicevuta + " non effettuata, poiche' inutile: ricevuta precedentemente gia' analizzata.");
                    }
                    if (isRichiesta) {
                        query.delete(0, query.length());
                        query.append("UPDATE ");
                        query.append("ASINCRONO");
                        if (ricevuta.getServizioCorrelato() != null && org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                            query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,VERSIONE_SERVIZIO_CORRELATO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, ricevuta.getTipoServizioCorrelato());
                            pstmtValidazione.setString(2, ricevuta.getServizioCorrelato());
                            if (ricevuta.getVersioneServizioCorrelato() != null) {
                                pstmt.setInt(3, ricevuta.getVersioneServizioCorrelato());
                            } else {
                                pstmt.setNull(3, 4);
                            }
                            pstmtValidazione.setString(4, idRicevuta);
                            pstmtValidazione.setString(5, "OUTBOX");
                        } else {
                            query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0 WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, idRicevuta);
                            pstmtValidazione.setString(2, "OUTBOX");
                        }
                        pstmtValidazione.execute();
                        pstmtValidazione.close();
                    } else {
                        if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                            this.eliminaBustaRicevuta(idCollaborazione);
                        } else {
                            this.eliminaBustaInviata(idCollaborazione);
                        }
                        if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                            query.delete(0, query.capacity());
                            query.append("DELETE FROM ");
                            query.append("ASINCRONO");
                            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                            pstmtValidazione = connectionDB.prepareStatement(query.toString());
                            pstmtValidazione.setString(1, idRicevuta);
                            pstmtValidazione.setString(2, "OUTBOX");
                            pstmtValidazione.execute();
                            pstmtValidazione.close();
                        }
                        this.eliminaBustaInviata(idRicevuta);
                        stateful.executePreparedStatement();
                    }
                    connectionDB.commit();
                    validazioneRicevutaOK = true;
                }
                catch (Throwable e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (pstmtValidazione != null) {
                            pstmtValidazione.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (validazioneRicevutaOK) continue;
                try {
                    Utilities.sleep((long)ProtocolRandomUtilities.getRandom().nextInt(checkInterval));
                }
                catch (Exception exception) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
            }
            catch (Exception er) {
                String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + "(ripristinoIsolation): " + er.getMessage();
                this.log.error(errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public void asincrono_valdazioneRicevuta(Busta ricevuta) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        String idRicevuta = ricevuta.getRiferimentoMessaggio();
        Statement pstmtValidazione = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA,ID_ASINCRONO FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, idRicevuta);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean isRichiesta = false;
            boolean validaRicevuta = false;
            String idCollaborazione = null;
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                return;
            }
            if (rs.getInt("IS_RICHIESTA") == 1) {
                isRichiesta = true;
            }
            if (rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                validaRicevuta = true;
            }
            idCollaborazione = rs.getString("ID_ASINCRONO");
            rs.close();
            pstmt.close();
            if (!validaRicevuta) {
                String tipoRicevuta = "ricevuta di una richiesta asincrona";
                if (!isRichiesta) {
                    tipoRicevuta = "ricevuta di una risposta asincrona";
                }
                this.log.warn("Validazione " + tipoRicevuta + " non effettuata, poiche' inutile: ricevuta precedentemente gia' analizzata.");
            }
            if (isRichiesta) {
                query.delete(0, query.length());
                query.append("UPDATE ");
                query.append("ASINCRONO");
                if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                    String tipoServizioCorrelato = ricevuta.getTipoServizioCorrelato();
                    String servizioCorrelato = ricevuta.getServizioCorrelato();
                    Integer versioneServizioCorrelato = ricevuta.getVersioneServizioCorrelato();
                    if (servizioCorrelato == null || tipoServizioCorrelato == null || versioneServizioCorrelato == null) {
                        IDSoggetto fruitore = new IDSoggetto(ricevuta.getTipoDestinatario(), ricevuta.getDestinatario());
                        IDServizio servizio = IDServizioFactory.getInstance().getIDServizioFromValues(ricevuta.getTipoServizio(), ricevuta.getServizio(), ricevuta.getTipoMittente(), ricevuta.getMittente(), ricevuta.getVersioneServizio().intValue());
                        servizio.setAzione(ricevuta.getAzione());
                        RisultatoValidazione validazione = RegistroServiziManager.getInstance((StateMessage)state).validaServizio(fruitore, servizio, null);
                        if (validazione == null || !validazione.getServizioRegistrato()) {
                            throw new Exception("Servizio [" + servizio.toString() + "] non esiste nel registro dei servizi");
                        }
                        if (validazione.getServizioCorrelato() == null || validazione.getTipoServizioCorrelato() == null || validazione.getVersioneServizioCorrelato() == null) {
                            throw new Exception("Servizio [" + servizio.toString() + "] non possiede un servizio correlato associato");
                        }
                        tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
                        servizioCorrelato = validazione.getServizioCorrelato();
                        versioneServizioCorrelato = validazione.getVersioneServizioCorrelato();
                    }
                    query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0,TIPO_SERVIZIO_CORRELATO=?,SERVIZIO_CORRELATO=?,VERSIONE_SERVIZIO_CORRELATO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, tipoServizioCorrelato);
                    pstmtValidazione.setString(2, servizioCorrelato);
                    if (versioneServizioCorrelato != null) {
                        pstmtValidazione.setInt(3, versioneServizioCorrelato);
                    } else {
                        pstmtValidazione.setNull(3, 4);
                    }
                    pstmtValidazione.setString(4, idRicevuta);
                    pstmtValidazione.setString(5, "OUTBOX");
                } else {
                    query.append(" SET RICEVUTA_ASINCRONA=1,IS_RICHIESTA=0 WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, idRicevuta);
                    pstmtValidazione.setString(2, "OUTBOX");
                }
                state.getPreparedStatement().put("UPDATE validazioneRicevutaRichiestaAsincrona_" + idRicevuta, (PreparedStatement)pstmtValidazione);
            } else {
                if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                    this.eliminaBustaRicevuta(idCollaborazione, true);
                } else {
                    this.eliminaBustaInviata(idCollaborazione, true);
                }
                if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)ricevuta.getProfiloDiCollaborazione())) {
                    query.delete(0, query.capacity());
                    query.append("DELETE FROM ");
                    query.append("ASINCRONO");
                    query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                    pstmtValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtValidazione.setString(1, idRicevuta);
                    pstmtValidazione.setString(2, "OUTBOX");
                    state.getPreparedStatement().put("UPDATE validazioneRicevutaRispostaAsincrona_" + idRicevuta, (PreparedStatement)pstmtValidazione);
                }
                this.eliminaBustaInviata(idRicevuta, true);
            }
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception isRichiesta) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception isRichiesta) {
                // empty catch block
            }
            try {
                if (pstmtValidazione != null) {
                    pstmtValidazione.close();
                }
            }
            catch (Exception isRichiesta) {
                // empty catch block
            }
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante la validazioneRicevutaAsincrona " + idRicevuta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincrono_isRisposta(Busta busta) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (busta.getRiferimentoMessaggio() == null && busta.getCollaborazione() == null) {
                return false;
            }
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ");
            if (busta.getRiferimentoMessaggio() != null && busta.getCollaborazione() != null) {
                query.append(" (ID_MESSAGGIO=? OR ID_MESSAGGIO=?) ");
            } else {
                query.append(" ID_MESSAGGIO=? ");
            }
            query.append(" AND TIPO=?");
            String tipo = null;
            tipo = org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) ? "OUTBOX" : "INBOX";
            pstmt = connectionDB.prepareStatement(query.toString());
            if (busta.getRiferimentoMessaggio() != null && busta.getCollaborazione() != null) {
                pstmt.setString(1, busta.getRiferimentoMessaggio());
                pstmt.setString(2, busta.getCollaborazione());
                pstmt.setString(3, tipo);
            } else if (busta.getRiferimentoMessaggio() != null) {
                pstmt.setString(1, busta.getRiferimentoMessaggio());
                pstmt.setString(2, tipo);
            } else {
                pstmt.setString(1, busta.getCollaborazione());
                pstmt.setString(2, tipo);
            }
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = false;
            if (rs.next() && rs.getInt("IS_RICHIESTA") == 0 && rs.getInt("RICEVUTA_ASINCRONA") == 1 && rs.getString("TIPO_SERVIZIO_CORRELATO") != null && rs.getString("TIPO_SERVIZIO_CORRELATO").equals(busta.getTipoServizio()) && rs.getString("SERVIZIO_CORRELATO") != null && rs.getString("SERVIZIO_CORRELATO").equals(busta.getServizio()) && rs.getInt("VERSIONE_SERVIZIO_CORRELATO") == busta.getVersioneServizio().intValue()) {
                value = true;
            }
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_isRisposta " + busta.getRiferimentoMessaggio() + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincrono_ricevutaApplicativaAbilitata(String id) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("RICEVUTA_APPLICATIVA") == 0) {
                    rs.close();
                    pstmt.close();
                    return false;
                }
                rs.close();
                pstmt.close();
                return true;
            }
            throw new Exception("?Valore non trovato nella tabella asincrona?");
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_ricevutaApplicativaAbilitata " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincrono_spedizioneRichiestaInCorso(String id) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("IS_RICHIESTA") == 1 && rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_spedizioneRichiestaInCorso " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean asincrono_spedizioneRispostaInCorso(String id) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT IS_RICHIESTA,RICEVUTA_ASINCRONA FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, "OUTBOX");
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            if (rs.next()) {
                if (rs.getInt("IS_RICHIESTA") == 0 && rs.getInt("RICEVUTA_ASINCRONA") == 0) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, asincrono_spedizioneRispostaInCorso " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void asincrono_eliminaRegistrazione(String id, String tipoBusta, Date data) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append("ASINCRONO");
            query.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
            if (data != null) {
                query.append(" AND ORA_REGISTRAZIONE<=?");
            }
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            Timestamp nowT = null;
            if (data != null) {
                nowT = new Timestamp(data.getTime());
                pstmt.setTimestamp(3, nowT);
            }
            state.getPreparedStatement().put("DELETE delete_datiAsincroni" + id, (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            String errorMsg = "PROFILO_DI_COLLABORAZIONE_ASINCRONO, Errore durante l'asincrono_eliminaRegistrazione " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }
}

