/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.Eccezione;
import org.openspcoop2.core.eccezione.details.constants.TipoEccezione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.builder.CodeDetailsError;
import org.openspcoop2.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807Builder;
import org.slf4j.Logger;

public class ImbustamentoErrore {
    private static Random _rnd = null;
    protected OpenSPCoop2MessageFactory errorFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
    private Logger log = null;
    private IProtocolFactory<?> protocolFactory;
    private MessageXMLUtils xmlUtils;
    private IProtocolManager protocolManager;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioEccezioneOpenSPCoop2Builder;
    private ServiceBinding serviceBinding;
    private Imbustamento imbustamento;
    private IState state;
    private IErroreApplicativoBuilder erroreApplicativoBuilder;
    private String defaultFaultCodeIntegrationNamespace;
    private String defaultFaultCodeProtocolNamespace;
    private String actorInternalSoapFault;
    private String idTransazione;

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (_rnd == null) {
            ImbustamentoErrore.initRandom();
        }
        return _rnd;
    }

    public ImbustamentoErrore(Logger aLog, IProtocolFactory<?> protocolFactory, IState state, ServiceBinding serviceBinding, String defaultFaultCodeIntegrationNamespace, String defaultFaultCodeProtocolNamespace, String actorInternalSoapFault, String idTransazione) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(ImbustamentoErrore.class);
        this.protocolFactory = protocolFactory;
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.errorFactory);
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.dettaglioEccezioneOpenSPCoop2Builder = new DettaglioEccezioneOpenSPCoop2Builder(aLog, protocolFactory);
        this.serviceBinding = serviceBinding;
        this.state = state;
        this.imbustamento = new Imbustamento(this.log, protocolFactory, state);
        this.erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
        this.defaultFaultCodeIntegrationNamespace = defaultFaultCodeIntegrationNamespace;
        this.defaultFaultCodeProtocolNamespace = defaultFaultCodeProtocolNamespace;
        this.actorInternalSoapFault = actorInternalSoapFault;
        this.idTransazione = idTransazione;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    public Busta buildMessaggioErroreProtocollo_Validazione(List<org.openspcoop2.protocol.sdk.Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        return this.buildMessaggioErroreProtocollo(eccezioni, busta, id_busta, tipoTempo);
    }

    public Busta buildMessaggioErroreProtocollo_Processamento(List<org.openspcoop2.protocol.sdk.Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        return this.buildMessaggioErroreProtocollo(eccezioni, busta, id_busta, tipoTempo);
    }

    public Busta buildMessaggioErroreProtocollo_Processamento(org.openspcoop2.protocol.sdk.Eccezione ecc, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        ArrayList<org.openspcoop2.protocol.sdk.Eccezione> eccs = new ArrayList<org.openspcoop2.protocol.sdk.Eccezione>();
        eccs.add(ecc);
        return this.buildMessaggioErroreProtocollo(eccs, busta, id_busta, tipoTempo);
    }

    private Busta buildMessaggioErroreProtocollo(List<org.openspcoop2.protocol.sdk.Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        block26: {
            block25: {
                block24: {
                    if (busta == null) {
                        throw new ProtocolException("Busta param is null");
                    }
                    boolean mittentePresente = busta.getMittente() != null;
                    String tipoDest = busta.getTipoMittente();
                    String dest = busta.getMittente();
                    String indTdest = busta.getIndirizzoMittente();
                    String codicePorta = busta.getIdentificativoPortaMittente();
                    busta.setTipoMittente(busta.getTipoDestinatario());
                    busta.setMittente(busta.getDestinatario());
                    busta.setIndirizzoMittente(busta.getIndirizzoDestinatario());
                    busta.setIdentificativoPortaMittente(busta.getIdentificativoPortaDestinatario());
                    if (mittentePresente) {
                        busta.setTipoDestinatario(tipoDest);
                        busta.setDestinatario(dest);
                        busta.setIndirizzoDestinatario(indTdest);
                        busta.setIdentificativoPortaDestinatario(codicePorta);
                    } else {
                        busta.setTipoDestinatario(null);
                        busta.setDestinatario(null);
                        busta.setIndirizzoDestinatario(null);
                        busta.setIdentificativoPortaDestinatario(null);
                    }
                    try {
                        this.protocolFactory.createTraduttore().toProtocolOrganizationType(busta.getTipoMittente());
                    }
                    catch (Exception e) {
                        if (this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) break block24;
                        busta.setTipoMittente(this.protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault());
                    }
                }
                try {
                    if (busta.getTipoDestinatario() != null) {
                        this.protocolFactory.createTraduttore().toProtocolOrganizationType(busta.getTipoDestinatario());
                    }
                }
                catch (Exception e) {
                    if (this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) break block25;
                    busta.setTipoDestinatario(this.protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault());
                }
            }
            if (busta.getTipoServizio() != null) {
                try {
                    this.protocolFactory.createTraduttore().toProtocolServiceType(busta.getTipoServizio());
                }
                catch (Exception e) {
                    if (this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) break block26;
                    busta.setTipoServizio(this.protocolFactory.createProtocolConfiguration().getTipoServizioDefault(null));
                }
            }
        }
        busta.setRiferimentoMessaggio(busta.getID());
        busta.setID(id_busta);
        busta.setOraRegistrazione(DateManager.getDate());
        busta.setTipoOraRegistrazione(tipoTempo, this.protocolFactory.createTraduttore().toString(tipoTempo));
        while (busta.sizeListaTrasmissioni() != 0) {
            busta.removeTrasmissione(0);
        }
        while (busta.sizeListaEccezioni() != 0) {
            busta.removeEccezione(0);
        }
        while (busta.sizeListaRiscontri() != 0) {
            busta.removeRiscontro(0);
        }
        if (eccezioni != null) {
            while (eccezioni.size() > 0) {
                org.openspcoop2.protocol.sdk.Eccezione e = eccezioni.remove(0);
                busta.addEccezione(e);
            }
        }
        if (!this.protocolFactory.createProtocolManager().isGenerazioneElementiNonValidabiliRispettoXSD()) {
            if (busta.getProfiloDiCollaborazione() != null) {
                if (!(ProfiloDiCollaborazione.ONEWAY.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()))) {
                    busta.setProfiloDiCollaborazione(null);
                    busta.setTipoServizioCorrelato(null);
                    busta.setServizioCorrelato(null);
                } else if (busta.getTipoServizioCorrelato() != null && !this.protocolFactory.createProtocolConfiguration().getTipiServizi(this.serviceBinding).contains(busta.getTipoServizioCorrelato())) {
                    busta.setTipoServizioCorrelato(null);
                }
            }
            if (busta.getRiferimentoMessaggio() != null) {
                ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
                proprietaValidazione.setValidazioneIDCompleta(false);
                if (!this.protocolFactory.createValidazioneSemantica(this.state).validazioneID(busta.getRiferimentoMessaggio(), null, proprietaValidazione)) {
                    busta.setRiferimentoMessaggio(null);
                }
            }
            if (busta.getInoltro() != null && !Inoltro.CON_DUPLICATI.equals((Object)busta.getInoltro()) && !Inoltro.SENZA_DUPLICATI.equals((Object)busta.getInoltro())) {
                busta.setInoltro(null, null);
            }
        }
        return busta;
    }

    private String getFaultCodePrefix(MessageType messageType, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        if (setSoapPrefixBackwardCompatibilityOpenSPCoop1 && this.protocolFactory != null && this.protocolFactory.getProtocol() != null && this.protocolFactory.getProtocol().equals("spcoop") && MessageType.SOAP_11.equals((Object)messageType)) {
            return "soap";
        }
        return null;
    }

    public OpenSPCoop2Message buildFaultProtocollo_processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, Throwable eProcessamento, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) {
        boolean useProblemRFC7807 = rfc7807 != null;
        try {
            DettaglioEccezione dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, errore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(errore), returnConfig, functionError);
            if (this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() && eProcessamento != null) {
                this.dettaglioEccezioneOpenSPCoop2Builder.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
            }
            return this.buildFaultProtocollo_processamento(dettaglioEccezione, this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento(), messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
        }
        catch (Exception e) {
            return this.errorFactory.createFaultMessage(messageType, useProblemRFC7807, "Errore buildSoapFaultProtocollo_processamento: " + e.getMessage());
        }
    }

    public OpenSPCoop2Message buildFaultProtocollo_processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) {
        return this.buildFaultProtocollo_processamento(identitaPdD, tipoPdD, modulo, errore, null, messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
    }

    public OpenSPCoop2Message buildFaultProtocollo_processamento(DettaglioEccezione dettaglioEccezione, boolean generazioneDettaglioEccezione, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) {
        return this.buildFaultProtocollo(false, dettaglioEccezione, generazioneDettaglioEccezione, messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
    }

    public OpenSPCoop2Message buildFaultProtocollo_intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, CodiceErroreCooperazione codiceErrore, String msgErrore, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) throws ProtocolException {
        DettaglioEccezione dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, codiceErrore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(codiceErrore, msgErrore), returnConfig, functionError);
        return this.buildFaultProtocollo_intestazione(dettaglioEccezione, this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneValidazione(), messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
    }

    public OpenSPCoop2Message buildFaultProtocollo_intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) throws ProtocolException {
        DettaglioEccezione dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, errore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(errore), returnConfig, functionError);
        return this.buildFaultProtocollo_intestazione(dettaglioEccezione, this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneValidazione(), messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
    }

    public OpenSPCoop2Message buildFaultProtocollo_intestazione(DettaglioEccezione dettaglioEccezione, boolean generazioneDettaglioEccezione, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) {
        return this.buildFaultProtocollo(true, dettaglioEccezione, generazioneDettaglioEccezione, messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
    }

    /*
     * Exception decompiling
     */
    private OpenSPCoop2Message buildFaultProtocollo(boolean erroreValidazione, DettaglioEccezione dettaglioEccezione, boolean generazioneDettaglioEccezione, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, Context context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ProblemRFC7807 _buildProblemRFC7807(ErroriProperties erroriProperties, CodeDetailsError codeDetailsErrorWrapper, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, String transactionId, DettaglioEccezione dettaglioEccezione) throws ProtocolException {
        try {
            String webSite;
            ProblemRFC7807Builder rfc7807ProblemBuilder = null;
            rfc7807ProblemBuilder = erroriProperties.isTypeEnabled() ? ((webSite = erroriProperties.getWebSite(functionError)) != null && !"".equals(webSite) ? new ProblemRFC7807Builder(webSite) : (rfc7807.isType() ? new ProblemRFC7807Builder(rfc7807.getTypeFormat()) : new ProblemRFC7807Builder(false))) : new ProblemRFC7807Builder(false);
            Eccezione eccezione = null;
            if (dettaglioEccezione.getExceptions() != null && dettaglioEccezione.getExceptions().sizeExceptionList() > 0) {
                eccezione = dettaglioEccezione.getExceptions().getException(0);
            }
            if (eccezione != null) {
                codeDetailsErrorWrapper.setDetails(eccezione.getDescription());
                if (eccezione.getCode() != null) {
                    String code = eccezione.getCode();
                    String prefixCodeStatus = null;
                    prefixCodeStatus = eccezione.getType() != null && TipoEccezione.PROTOCOL.equals((Object)eccezione.getType()) ? "protocol:" : "integration:";
                    codeDetailsErrorWrapper.setPrefixCode(prefixCodeStatus);
                    codeDetailsErrorWrapper.setCode(code);
                }
            }
            ProblemRFC7807 problemRFC7807 = rfc7807ProblemBuilder.buildProblem(returnConfig.getGovwayReturnCode());
            if (rfc7807.isDetails()) {
                boolean genericDetails = returnConfig.isGenericDetails();
                if (!genericDetails && erroriProperties.isForceGenericDetails(functionError).booleanValue()) {
                    genericDetails = true;
                }
                if (Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                    genericDetails = false;
                }
                if (codeDetailsErrorWrapper.getDetails() != null && !genericDetails) {
                    problemRFC7807.setDetail(codeDetailsErrorWrapper.getDetails());
                } else {
                    problemRFC7807.setDetail(erroriProperties.getGenericDetails(functionError));
                }
            }
            if (rfc7807.isGovwayType()) {
                String govwayType = erroriProperties.getErrorType(functionError);
                if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE().booleanValue()) {
                    if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CAMEL_CASE_DECODE().booleanValue()) {
                        problemRFC7807.setTitle(StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)govwayType), (char)' '));
                    } else {
                        problemRFC7807.setTitle(govwayType);
                    }
                    if (Costanti.isPROBLEM_RFC7807_ENRICH_TITLE_AS_GOVWAY_TYPE_CUSTOM_CLAIM().booleanValue()) {
                        problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE(), govwayType);
                    }
                } else {
                    problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TYPE(), govwayType);
                }
            }
            if (Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO() && rfc7807.isGovwayStatus() && codeDetailsErrorWrapper.getCode() != null && codeDetailsErrorWrapper.getPrefixCode() != null) {
                problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_CODE(), codeDetailsErrorWrapper.getPrefixCode() + codeDetailsErrorWrapper.getCode());
            }
            if (Costanti.isTRANSACTION_ERROR_INSTANCE_ID_ABILITATO() && rfc7807.isInstance()) {
                problemRFC7807.setInstance(nomePorta);
            }
            if (rfc7807.isGovwayTransactionId()) {
                problemRFC7807.getCustom().put(Costanti.getPROBLEM_RFC7807_GOVWAY_TRANSACTION_ID(), transactionId);
            }
            return problemRFC7807;
        }
        catch (Exception e) {
            throw new ProtocolException("toProblemRFC7807 failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(Busta busta) {
        if (!this.protocolManager.isGenerazioneListaEccezioniErroreProcessamento()) {
            while (busta.sizeListaEccezioni() > 0) {
                org.openspcoop2.protocol.sdk.Eccezione eccezione = busta.removeEccezione(0);
            }
        }
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, List<org.openspcoop2.protocol.sdk.Eccezione> errori, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        return this.msgErroreProtocollo_Processamento(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, null, errori, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        return this.msgErroreProtocollo_Processamento(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, erroreCooperazione, null, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreIntegrazione erroreIntegrazione, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        return this.msgErroreProtocollo_Processamento(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, null, null, erroreIntegrazione, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
    }

    private OpenSPCoop2Message msgErroreProtocollo_Processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, List<org.openspcoop2.protocol.sdk.Eccezione> errori, ErroreIntegrazione erroreIntegrazione, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        boolean useProblemRFC7807 = rfc7807 != null;
        try {
            ProtocolMessage protocolMessage;
            org.openspcoop2.protocol.sdk.Eccezione ecc;
            Busta bustaRichiesta = null;
            if (busta != null) {
                bustaRichiesta = busta.newInstance();
            }
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            if (busta != null) {
                for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
                }
            }
            String id_bustaErrore = this.imbustamento.buildID(identitaPdD, idTransazione, attesaAttiva, checkInterval, RuoloMessaggio.RISPOSTA);
            if (errori == null) {
                errori = new ArrayList<org.openspcoop2.protocol.sdk.Eccezione>();
            }
            if (erroreCooperazione != null) {
                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneProcessamento((ErroreCooperazione)erroreCooperazione, this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            if (erroreIntegrazione != null) {
                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(erroreIntegrazione.getDescrizione(this.protocolFactory)), this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            busta = this.buildMessaggioErroreProtocollo_Processamento(errori, busta, id_bustaErrore, tipoTempo);
            DettaglioEccezione dettaglioEccezione = null;
            if (this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento() || useProblemRFC7807 && (rfc7807.isDetails() || rfc7807.isGovwayStatus())) {
                dettaglioEccezione = erroreIntegrazione != null ? this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezioneProcessamentoBusta(identitaPdD, tipoPdD, modulo, erroreIntegrazione, erroreIntegrazione.getDescrizione(this.protocolFactory), eProcessamento, returnConfig, functionError) : this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezioneFromBusta(identitaPdD, tipoPdD, modulo, null, busta, eProcessamento);
            }
            this.gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(busta);
            String nomePorta = null;
            if (integrazione != null) {
                nomePorta = integrazione.getNomePorta();
            }
            OpenSPCoop2Message responseMessage = this.buildFaultProtocollo_processamento(dettaglioEccezione, this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneProcessamento(), messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    boolean tipoOrigineValido = true;
                    try {
                        this.protocolFactory.createTraduttore().toProtocolOrganizationType(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    }
                    catch (Exception e) {
                        tipoOrigineValido = false;
                    }
                    if (!tipoOrigineValido) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    tras.setIdentificativoPortaDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getIdentificativoPortaOrigine());
                }
                if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                    tras.setDestinazione(busta.getDestinatario());
                    tras.setTipoDestinazione(busta.getTipoDestinatario());
                    try {
                        String dominio = RegistroServiziManager.getInstance((IState)this.state).getDominio(new IDSoggetto(tras.getTipoDestinazione(), tras.getDestinazione()), null, this.protocolFactory, requestInfo);
                        tras.setIdentificativoPortaDestinazione(dominio);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            if ((protocolMessage = this.imbustamento.imbustamentoRisposta(responseMessage, context, busta, bustaRichiesta, integrazione, null, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO)) != null && !protocolMessage.isPhaseUnsupported()) {
                responseMessage = protocolMessage.getMessage();
            }
            if (messageSecurityPropertiesResponse != null && messageSecurityPropertiesResponse.size() > 0) {
                messageSecurityContext.setOutgoingProperties(messageSecurityPropertiesResponse);
                if (!messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)context, tempiElaborazione)) {
                    responseMessage = this.msgErroreProtocollo_Intestazione(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
                }
            }
            if ((protocolMessage = this.imbustamento.imbustamentoRisposta(responseMessage, context, busta, bustaRichiesta, integrazione, null, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO)) != null && !protocolMessage.isPhaseUnsupported()) {
                responseMessage = protocolMessage.getMessage();
            }
            return responseMessage;
        }
        catch (Exception e) {
            this.log.error("Build msgErroreProcessamento non riuscito: " + e.getMessage(), (Throwable)e);
            return this.errorFactory.createFaultMessage(messageType, useProblemRFC7807);
        }
    }

    public OpenSPCoop2Message msgErroreProtocollo_Intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, List<org.openspcoop2.protocol.sdk.Eccezione> errori, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        return this.msgErroreProtocollo_Intestazione(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, null, errori, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        return this.msgErroreProtocollo_Intestazione(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, erroreCooperazione, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
    }

    private OpenSPCoop2Message msgErroreProtocollo_Intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, Context context, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, List<org.openspcoop2.protocol.sdk.Eccezione> errori, Map<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1, boolean useInternalFault, TempiElaborazione tempiElaborazione, RequestInfo requestInfo) {
        boolean useProblemRFC7807 = rfc7807 != null;
        try {
            ProtocolMessage protocolMessage;
            Busta bustaRichiesta = null;
            if (busta != null) {
                bustaRichiesta = busta.newInstance();
            }
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            if (busta != null) {
                for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
                }
            }
            String id_bustaErrore = this.imbustamento.buildID(identitaPdD, idTransazione, attesaAttiva, checkInterval, RuoloMessaggio.RISPOSTA);
            if (errori == null) {
                errori = new ArrayList<org.openspcoop2.protocol.sdk.Eccezione>();
            }
            if (erroreCooperazione != null) {
                org.openspcoop2.protocol.sdk.Eccezione ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)erroreCooperazione, this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            busta = this.buildMessaggioErroreProtocollo_Validazione(errori, busta, id_bustaErrore, tipoTempo);
            DettaglioEccezione dettaglioEccezione = null;
            if (this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneValidazione() || useProblemRFC7807 && (rfc7807.isDetails() || rfc7807.isGovwayStatus())) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezioneFromBusta(identitaPdD, tipoPdD, modulo, null, busta, null);
            }
            String nomePorta = null;
            if (integrazione != null) {
                nomePorta = integrazione.getNomePorta();
            }
            OpenSPCoop2Message responseMessage = this.buildFaultProtocollo_intestazione(dettaglioEccezione, this.protocolManager.isGenerazioneDetailsFaultProtocollo_EccezioneValidazione(), messageType, rfc7807, returnConfig, functionError, nomePorta, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, context);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    boolean tipoOrigineValido = true;
                    try {
                        this.protocolFactory.createTraduttore().toProtocolOrganizationType(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    }
                    catch (Exception e) {
                        tipoOrigineValido = false;
                    }
                    if (!tipoOrigineValido) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    tras.setIdentificativoPortaDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getIdentificativoPortaOrigine());
                }
                if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                    tras.setDestinazione(busta.getDestinatario());
                    tras.setTipoDestinazione(busta.getTipoDestinatario());
                    try {
                        String dominio = RegistroServiziManager.getInstance((IState)this.state).getDominio(new IDSoggetto(tras.getTipoDestinazione(), tras.getDestinazione()), null, this.protocolFactory, requestInfo);
                        tras.setIdentificativoPortaDestinazione(dominio);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            if ((protocolMessage = this.imbustamento.imbustamentoRisposta(responseMessage, context, busta, bustaRichiesta, integrazione, null, FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO)) != null && !protocolMessage.isPhaseUnsupported()) {
                responseMessage = protocolMessage.getMessage();
            }
            if (messageSecurityPropertiesResponse != null && messageSecurityPropertiesResponse.size() > 0) {
                messageSecurityContext.setOutgoingProperties(messageSecurityPropertiesResponse);
                if (!messageSecurityContext.processOutgoing(responseMessage, (org.openspcoop2.utils.Map)context, tempiElaborazione)) {
                    responseMessage = this.msgErroreProtocollo_Intestazione(identitaPdD, tipoPdD, context, modulo, busta, integrazione, idTransazione, ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, messageType, rfc7807, returnConfig, functionError, setSoapPrefixBackwardCompatibilityOpenSPCoop1, useInternalFault, tempiElaborazione, requestInfo);
                }
            }
            if ((protocolMessage = this.imbustamento.imbustamentoRisposta(responseMessage, context, busta, bustaRichiesta, integrazione, null, FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO)) != null && !protocolMessage.isPhaseUnsupported()) {
                responseMessage = protocolMessage.getMessage();
            }
            return responseMessage;
        }
        catch (Exception e) {
            this.log.error("Build msgErroreProtocollo_Validazione non riuscito: " + e.getMessage(), (Throwable)e);
            return this.errorFactory.createFaultMessage(messageType, useProblemRFC7807);
        }
    }
}

