/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class Imbustamento {
    private Logger log = null;
    private IProtocolFactory<?> protocolFactory;
    private IState state;
    public static int prefixLenght = 0;

    public Imbustamento(Logger aLog, IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(Imbustamento.class);
        this.protocolFactory = protocolFactory;
        this.state = state;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public String buildID(IDSoggetto idSoggetto, String idTransazione, long attesaAttiva, int checkInterval, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        try {
            return this.protocolFactory.createBustaBuilder(this.state).newID(idSoggetto, idTransazione, ruoloMessaggio);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public ProtocolMessage imbustamentoRichiesta(OpenSPCoop2Message msg, Context context, Busta busta, Integrazione integrazione, boolean gestioneManifest, boolean scartaBody, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        return this._imbustamento(msg, context, busta, null, integrazione, gestioneManifest, RuoloMessaggio.RICHIESTA, scartaBody, proprietaManifestAttachments, faseImbustamento);
    }

    public ProtocolMessage imbustamentoRisposta(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, Integrazione integrazione, boolean gestioneManifest, boolean scartaBody, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        return this._imbustamento(msg, context, busta, bustaRichiesta, integrazione, gestioneManifest, RuoloMessaggio.RISPOSTA, scartaBody, proprietaManifestAttachments, faseImbustamento);
    }

    public ProtocolMessage imbustamentoRisposta(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, Integrazione integrazione, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        return this._imbustamento(msg, context, busta, bustaRichiesta, integrazione, false, RuoloMessaggio.RISPOSTA, false, proprietaManifestAttachments, faseImbustamento);
    }

    private ProtocolMessage _imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, Integrazione integrazione, boolean gestioneManifest, RuoloMessaggio ruoloMessaggio, boolean scartaBody, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (proprietaManifestAttachments == null) {
            proprietaManifestAttachments = new ProprietaManifestAttachments();
        }
        proprietaManifestAttachments.setGestioneManifest(gestioneManifest);
        proprietaManifestAttachments.setScartaBody(scartaBody);
        return this.protocolFactory.createBustaBuilder(this.state).imbustamento(msg, context, busta, bustaRichiesta, ruoloMessaggio, proprietaManifestAttachments, faseImbustamento);
    }

    public ProtocolMessage addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, boolean readQualifiedAttribute, FaseImbustamento faseImbustamento) throws ProtocolException {
        return this.protocolFactory.createBustaBuilder(this.state).addTrasmissione(message, trasmissione, faseImbustamento);
    }
}

