/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.protocol.sdk.ChannelSecurityToken;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class SecurityTokenUtilities {
    private SecurityTokenUtilities() {
    }

    public static SecurityToken readSecurityToken(Context context) {
        SecurityToken securityTokenForContext = null;
        if (context.containsKey(Costanti.SECURITY_TOKEN)) {
            securityTokenForContext = (SecurityToken)context.getObject(Costanti.SECURITY_TOKEN);
        }
        return securityTokenForContext;
    }

    public static SecurityToken newSecurityToken(Context context) {
        SecurityToken securityTokenForContext = null;
        if (context.containsKey(Costanti.SECURITY_TOKEN)) {
            securityTokenForContext = (SecurityToken)context.getObject(Costanti.SECURITY_TOKEN);
        } else {
            RequestInfo requestInfo;
            securityTokenForContext = new SecurityToken();
            context.addObject(Costanti.SECURITY_TOKEN, (Object)securityTokenForContext);
            if (context.containsKey(Costanti.REQUEST_INFO) && (requestInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO)) != null && requestInfo.getProtocolContext() != null && requestInfo.getProtocolContext().getCredential() != null && requestInfo.getProtocolContext().getCredential().getCertificate() != null && requestInfo.getProtocolContext().getCredential().getCertificate().getCertificate() != null) {
                ChannelSecurityToken channelSecurityToken = new ChannelSecurityToken();
                channelSecurityToken.setCertificate(requestInfo.getProtocolContext().getCredential().getCertificate().getCertificate());
                securityTokenForContext.setChannel(channelSecurityToken);
            }
        }
        return securityTokenForContext;
    }
}

