/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.protocol.basic.BasicEmptyRawContentFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.engine.BasicProtocolManager;
import org.openspcoop2.protocol.engine.BasicProtocolVersionManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.slf4j.Logger;

public class BasicProtocolFactory
extends BasicEmptyRawContentFactory {
    private static final long serialVersionUID = -7718343905236594865L;
    private static Map<String, IProtocolManager> staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;

    public BasicProtocolFactory(Logger log) {
        this.log = log;
    }

    protected void initStaticInstance(BasicStaticInstanceConfig staticInstanceConfig) throws ProtocolException {
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null && staticInstanceConfig.isStaticConfig()) {
            if (staticInstanceProtocolManager == null) {
                BasicProtocolFactory.initStaticInstanceProtocolManager();
            }
            this.createProtocolManager();
            if (staticInstanceProtocolVersionManager == null) {
                BasicProtocolFactory.initStaticInstanceProtocolVersionManager();
            }
            this.createProtocolVersionManager("-");
        }
    }

    private static synchronized void initStaticInstanceProtocolManager() {
        if (staticInstanceProtocolManager == null) {
            staticInstanceProtocolManager = new HashMap<String, IProtocolManager>();
        }
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        if (staticInstanceProtocolManager != null) {
            if (!staticInstanceProtocolManager.containsKey(this.getProtocol())) {
                this.initProtocolManager(this.getProtocol());
            }
            return staticInstanceProtocolManager.get(this.getProtocol());
        }
        return new BasicProtocolManager((IProtocolFactory<?>)this);
    }

    private synchronized void initProtocolManager(String protocol) throws ProtocolException {
        if (!staticInstanceProtocolManager.containsKey(protocol)) {
            staticInstanceProtocolManager.put(protocol, (IProtocolManager)new BasicProtocolManager((IProtocolFactory<?>)this));
        }
    }

    private static synchronized void initStaticInstanceProtocolVersionManager() {
        if (staticInstanceProtocolVersionManager == null) {
            staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
        }
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(this.getProtocol())) {
                this.initProtocolVersioneManager(this.getProtocol());
            }
            return staticInstanceProtocolVersionManager.get(this.getProtocol());
        }
        return new BasicProtocolVersionManager((IProtocolFactory<?>)this);
    }

    private synchronized void initProtocolVersioneManager(String protocol) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(protocol)) {
            staticInstanceProtocolVersionManager.put(protocol, (IProtocolVersionManager)new BasicProtocolVersionManager((IProtocolFactory<?>)this));
        }
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return null;
    }
}

