/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v2_1.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.slf4j.Logger;

public class IdConverter {
    private DriverRegistroServiziDB driverRegistroOp1;
    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB driverRegistro;
    private boolean dsModeIn;
    private boolean dsModeOut;
    private Connection connection;
    private Connection connectionOut;
    private Logger log = LoggerWrapperFactory.getLogger((String)"migrazione");

    public void closeConnection() throws SQLException {
        if (!this.dsModeIn) {
            this.connection.close();
        }
        if (!this.dsModeOut) {
            this.connectionOut.close();
        }
    }

    public IdConverter(DatabaseProperties initIn, DatabaseProperties initOut) throws Exception {
        try {
            this.dsModeIn = initIn.isDataSourceMode();
            this.dsModeOut = initOut.isDataSourceMode();
            if (this.dsModeIn) {
                this.driverRegistroOp1 = new DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                this.driverRegistroOp1 = new DriverRegistroServiziDB(this.connection, initIn.getTipoDatabase());
            }
            if (this.dsModeOut) {
                this.driverRegistro = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB(initOut.getJndiName(), initOut.getJndiProp(), initOut.getTipoDatabase());
            } else {
                Class.forName(initOut.getDriverJDBC());
                this.connectionOut = DriverManager.getConnection(initOut.getConnectionURL(), initOut.getUsername(), initOut.getPassword());
                this.driverRegistro = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB(this.connectionOut, this.log, initOut.getTipoDatabase());
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), e);
        }
    }

    public Long getIdSoggetto(Long idSoggetto) throws Exception {
        Soggetto soggetto = this.driverRegistroOp1.getSoggetto(idSoggetto.longValue());
        IDSoggetto id = new IDSoggetto();
        id.setNome(soggetto.getNome());
        id.setTipo(soggetto.getTipo());
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoOp2 = this.driverRegistro.getSoggetto(id);
        return soggettoOp2.getId();
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune getAccordoPC(Long idAccordo) throws Exception {
        return this.getAccordoPC(this.driverRegistroOp1.getAccordoServizioParteComune(idAccordo.longValue()));
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune getAccordoPC(AccordoServizioParteComune accordo) throws Exception {
        IDAccordo id;
        IDSoggetto soggettoReferente = new IDSoggetto();
        if (accordo.getSoggettoReferente() != null) {
            soggettoReferente.setNome(accordo.getSoggettoReferente().getNome());
            soggettoReferente.setTipo(accordo.getSoggettoReferente().getTipo());
        } else {
            MigrazioneProperties p = null;
            try {
                p = MigrazioneProperties.getInstance();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            soggettoReferente.setTipo(p.getTipoSoggettoReferenteDefault());
            soggettoReferente.setNome(p.getNomeSoggettoReferenteDefault());
        }
        if (accordo.getVersione() == null || accordo.getVersione().isEmpty()) {
            accordo.setVersione("1");
        }
        String soggetto = (id = IDAccordoFactory.getInstance().getIDAccordoFromValues(accordo.getNome(), soggettoReferente, accordo.getVersione())).getSoggettoReferente() != null ? id.getSoggettoReferente().getTipo() + "/" + id.getSoggettoReferente().getNome() : "";
        this.log.debug("Cerco accordo con id nome[" + id.getNome() + "] soggetto[" + soggetto + "] versione[" + id.getVersione() + "]");
        return this.driverRegistro.getAccordoServizioParteComune(id);
    }

    public Long getIdAccordo(Long idAccordo) throws Exception {
        return this.getAccordoPC(idAccordo).getId();
    }
}

