/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import it.gov.fatturapa.sdi.messaggi.v1_0.utils.ProjectInfo;
import it.gov.fatturapa.sdi.messaggi.v1_0.utils.XMLUtils;
import org.slf4j.Logger;

public class SDICompatibilitaNamespaceErrati {
    private static ProjectInfo pInfo = new ProjectInfo();
    private static final String NAMESPACE_SENZA_GOV = XMLUtils.NAMESPACE_SENZA_GOV;

    public static byte[] convertiXmlNamespaceSenzaGov(Logger log, byte[] xml) {
        try {
            String xmlAsAstring = new String(xml);
            if (xmlAsAstring.contains(NAMESPACE_SENZA_GOV)) {
                int count = 0;
                while (xmlAsAstring.contains(NAMESPACE_SENZA_GOV) && count < 1000) {
                    ++count;
                    xmlAsAstring = xmlAsAstring.replace(NAMESPACE_SENZA_GOV, pInfo.getProjectNamespace());
                }
                return xmlAsAstring.getBytes();
            }
        }
        catch (Exception e) {
            log.debug("Compatibilita' Namespace senza Gov abilitata, la modifica al namespace non e' riuscita (Puo' darsi che fosse sbagliato gia' il documento originale, prendere questo messaggio come informazione di debug): " + e.getMessage(), (Throwable)e);
        }
        return xml;
    }

    public static byte[] produciXmlNamespaceSenzaGov(Logger log, byte[] xml) {
        try {
            String xmlAsAstring = new String(xml);
            if (xmlAsAstring.contains(pInfo.getProjectNamespace())) {
                int count = 0;
                while (xmlAsAstring.contains(pInfo.getProjectNamespace()) && count < 1000) {
                    ++count;
                    xmlAsAstring = xmlAsAstring.replace(pInfo.getProjectNamespace(), NAMESPACE_SENZA_GOV);
                }
                return xmlAsAstring.getBytes();
            }
        }
        catch (Exception e) {
            log.debug("Generazione Namespace senza Gov abilitata, la modifica al namespace non e' riuscita (Puo' darsi che fosse sbagliato gia' il documento originale, prendere questo messaggio come informazione di debug): " + e.getMessage(), (Throwable)e);
        }
        return xml;
    }
}

