/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.sdk.ModIPropertiesUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIValidazioneSemanticaProfiloSicurezza;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.slf4j.Logger;

public class ModIUtils {
    public static final String INTEGRITY = "integrity";
    public static final String DIGEST_RICHIESTA = "request-digest";
    public static final String CORNICE_SICUREZZA = "user-info";
    public static final String CORNICE_SICUREZZA_PATTERN = "user-info-pattern";
    public static final String CORNICE_SICUREZZA_SCHEMA = "user-info-schema";
    public static final String HEADER_DUPLICATI = "contemporary-headers";
    private static final String API_PREFIX = "api-";
    public static final String API_SICUREZZA_CANALE_PATTERN = "api-channel-security-pattern";
    public static final String API_SICUREZZA_MESSAGGIO_PREFIX = "api-message-security";
    public static final String API_SICUREZZA_MESSAGGIO_PATTERN = "api-message-security-pattern";
    public static final String API_SICUREZZA_MESSAGGIO_SORGENTE_TOKEN_ID_AUTH = "api-message-security-sorgente-token-id-auth";
    public static final String API_SICUREZZA_MESSAGGIO_HTTP_HEADER = "api-message-security-http-header";
    public static final String API_SICUREZZA_MESSAGGIO_APPLICABILITA = "api-message-security-applicability";
    public static final String API_SICUREZZA_MESSAGGIO_REQUEST_DIGEST = "api-message-security-request-digest";
    public static final String API_SICUREZZA_MESSAGGIO_USER_INFO = "api-message-security-user-info";
    private static final String REQUEST_PREFIX = "request-";
    private static final String RESPONSE_PREFIX = "response-";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_SIGNATURE_ALGORITHM = "signature-algorithm";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_CANONICALIZATION_ALGORITHM = "canonicalization-algorithm";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_DIGEST_ENCODING = "digest-encoding";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_HTTP_HEADER_FIRMATI = "signed-http-headers";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_SOAP_HEADER_FIRMATI = "signed-soap-headers";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_RIFERIMENTO_X509 = "x509-reference";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_CATENA_CERTIFICATI_X509 = "x509-certificate-chain";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_INCLUDE_SIGNATURE_TOKEN = "include-signature-token";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_TTL = "ttl";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_AUDIENCE = "audience";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_VERIFICA_AUDIENCE = "audience-verify";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_INTEGRITY_AUDIENCE = "integrity-audience";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_FRUIZIONE_KEYSTORE_MODE = "fruizione-keystore-mode";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_X5U_CERTIFICATE_URL = "x5u-certificate-url";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX = "audit-info-";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_AUDIT_AUDIENCE = "audit-audience";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_STORE_TYPE = "type";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH = "path";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_STORE_CRLS = "crls";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_STORE_OCSP_POLICY = "ocsp";
    public static final String API_IMPL_SICUREZZA_MESSAGGIO_KEY_ALIAS = "key-alias";
    public static final String API_IMPL_SICUREZZA_OAUTH_IDENTIFICATIVO = "oauth-id";
    public static final String API_IMPL_SICUREZZA_OAUTH_KID = "oauth-kid";
    public static final String API_IMPL_INFO_ESERVICE_ID = "info-eservice-id";
    public static final String API_IMPL_INFO_DESCRIPTOR_ID = "info-descriptor-id";
    public static final String API_IMPL_INFO_SIGNAL_HUB = "info-signal-hub";
    public static final String HSM = "hsm";
    public static final String API_PDND_EVENTS_KEYS_PATH = "api-pdnd-eventsKeys-path";
    public static final String API_PDND_EVENTS_KEYS_PARAMETER_LASTEVENTID = "api-pdnd-eventsKeys-parameterLastEventId";
    public static final String API_PDND_EVENTS_KEYS_PARAMETER_LIMIT = "api-pdnd-eventsKeys-parameterLimit";
    public static final String API_PDND_CLIENTS_PATH = "api-pdnd-clients-path";
    public static final String API_PDND_CLIENTS_ORGANIZATION_JSON_PATH = "api-pdnd-clients-organizationJsonPath";
    public static final String API_PDND_ORGANIZATIONS_PATH = "api-pdnd-organizations-path";
    public static final String CLASS_MODIPA_PROPERTIES = "org.openspcoop2.protocol.modipa.config.ModIProperties";
    public static final String PROPRIETA_INTERMEDIARIO = "intermediario";
    public static final MapKey<String> MODIPA_OPENSPCOOP2_MSG_CONTEXT_USE_JTI_AUTHORIZATION = Map.newMapKey((String)"MODIPA_USE_JTI_AUTHORIZATION");

    private ModIUtils() {
    }

    public static boolean isBooleanIndicator(String key) {
        return INTEGRITY.equals(key) || DIGEST_RICHIESTA.equals(key) || CORNICE_SICUREZZA.equals(key) || HEADER_DUPLICATI.equals(key);
    }

    public static String extractInfoFromMetadati(java.util.Map<String, String> metadati, String key, String description) throws ProtocolException {
        if (metadati == null || metadati.isEmpty() || !metadati.containsKey(key)) {
            throw new ProtocolException(description + " not found");
        }
        String v = metadati.get(key);
        if (v == null || StringUtils.isEmpty((String)v.trim())) {
            throw new ProtocolException(description + " undefined");
        }
        return v;
    }

    public static java.util.Map<String, String> configToMap(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, String urlInvocazione, Fruitore fruitore, String urlConnettoreFruitoreModI) throws ProtocolException {
        boolean gestioneErogatori = fruitore == null;
        boolean gestioneFruitori = !gestioneErogatori;
        HashMap<String, String> map = new HashMap<String, String>();
        List protocolPropertyList = gestioneErogatori ? asps.getProtocolPropertyList() : fruitore.getProtocolPropertyList();
        boolean rest = ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
        boolean digest = ModIUtils.isProfiloSicurezzaMessaggioConIntegritaX509(aspc, asps.getPortType()) || ModIUtils.isProfiloSicurezzaMessaggioConIntegritaKid(aspc, asps.getPortType());
        boolean digestRichiesta = ModIUtils.isProfiloSicurezzaMessaggioRequestDigest(aspc, asps.getPortType());
        boolean corniceSicurezza = ModIUtils.isProfiloSicurezzaMessaggioCorniceSicurezza(aspc, asps.getPortType());
        String patternDatiCorniceSicurezza = null;
        String schemaDatiCorniceSicurezza = null;
        if (corniceSicurezza) {
            patternDatiCorniceSicurezza = ModIUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaPattern(aspc, asps.getPortType());
            if (patternDatiCorniceSicurezza == null) {
                patternDatiCorniceSicurezza = "old";
            }
            if (!"old".equals(patternDatiCorniceSicurezza)) {
                schemaDatiCorniceSicurezza = ModIUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema(aspc, asps.getPortType());
            }
        }
        boolean headerDuplicati = false;
        if (rest) {
            headerDuplicati = ModIUtils.isProfiloSicurezzaMessaggioConHeaderDuplicati(aspc, asps.getPortType());
        }
        map.put(INTEGRITY, "" + digest);
        map.put(DIGEST_RICHIESTA, "" + digestRichiesta);
        map.put(CORNICE_SICUREZZA, "" + corniceSicurezza);
        if (corniceSicurezza) {
            map.put(CORNICE_SICUREZZA_PATTERN, patternDatiCorniceSicurezza);
            if (schemaDatiCorniceSicurezza != null) {
                map.put(CORNICE_SICUREZZA_SCHEMA, schemaDatiCorniceSicurezza);
            }
        }
        map.put(HEADER_DUPLICATI, "" + headerDuplicati);
        String v = ModIUtils.getStringValue(aspc.getProtocolPropertyList(), "modipaSecurityChannelProfile");
        String canale = null;
        if ("idac01".equals(v)) {
            canale = "ID_AUTH_CHANNEL_01";
        } else if ("idac02".equals(v)) {
            canale = "ID_AUTH_CHANNEL_02";
        }
        if (canale != null) {
            map.put(API_SICUREZZA_CANALE_PATTERN, canale);
        }
        boolean sicurezzaMessaggio = false;
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageProfile", (AccordoServizioParteComune)aspc, (String)asps.getPortType(), (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            StringBuilder sbMes = new StringBuilder();
            for (Object pattern : tmp) {
                if ("idam01".equals(pattern)) {
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append(rest ? "ID_AUTH_REST_01" : "ID_AUTH_SOAP_01");
                    continue;
                }
                if ("idam02".equals(pattern)) {
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append(rest ? "ID_AUTH_REST_02" : "ID_AUTH_SOAP_02");
                    continue;
                }
                if ("idam0301".equals(pattern)) {
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append(rest ? "INTEGRITY_REST_01 con ID_AUTH_REST_01" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_01");
                    continue;
                }
                if ("idam0302".equals(pattern)) {
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append(rest ? "INTEGRITY_REST_01 con ID_AUTH_REST_02" : "INTEGRITY_SOAP_01 con ID_AUTH_SOAP_02");
                    continue;
                }
                if ("idam0401".equals(pattern) && rest) {
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append("INTEGRITY_REST_02 con ID_AUTH_REST_01");
                    continue;
                }
                if (!"idam0402".equals(pattern) || !rest) continue;
                if (sbMes.length() > 0) {
                    sbMes.append(", ");
                }
                sbMes.append("INTEGRITY_REST_02 con ID_AUTH_REST_02");
            }
            if (sbMes.length() > 0) {
                sicurezzaMessaggio = true;
                map.put(API_SICUREZZA_MESSAGGIO_PATTERN, sbMes.toString());
            }
        }
        boolean sicurezzaMessaggioPdnd = false;
        if (sicurezzaMessaggio) {
            StringBuilder sbMes;
            tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageSorgenteToken", (AccordoServizioParteComune)aspc, (String)asps.getPortType(), (boolean)false);
            if (tmp != null && !tmp.isEmpty()) {
                sbMes = new StringBuilder();
                for (Object mode : tmp) {
                    if ("locale".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Authorization ModI");
                        continue;
                    }
                    if ("pdnd".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Authorization PDND");
                        sicurezzaMessaggioPdnd = true;
                        continue;
                    }
                    if (!"oauth".equals(mode)) continue;
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append("Authorization OAuth");
                }
                if (sbMes.length() > 0) {
                    map.put(API_SICUREZZA_MESSAGGIO_SORGENTE_TOKEN_ID_AUTH, sbMes.toString());
                }
            }
            if (rest && (tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageHeaderName", (AccordoServizioParteComune)aspc, (String)asps.getPortType(), (boolean)false)) != null && !tmp.isEmpty()) {
                sbMes = new StringBuilder();
                String headerModI = ModIUtils.getHeaderModI();
                for (String mode : tmp) {
                    if ("modipa".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Letto da property".replace("Letto da property", headerModI));
                        continue;
                    }
                    if ("authorization".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Authorization Bearer");
                        continue;
                    }
                    if ("autonlyreq_modipa".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Letto da property + Authorization Bearer".replace("Letto da property", headerModI));
                        continue;
                    }
                    if ("authorization_modipa".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Letto da property + Authorization Bearer anche nella risposta".replace("Letto da property", headerModI));
                        continue;
                    }
                    if ("custom".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Custom-JWT-Signature");
                        continue;
                    }
                    if ("autonlyreq_custom".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Custom-JWT-Signature + Authorization Bearer");
                        continue;
                    }
                    if (!"authorization_custom".equals(mode)) continue;
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append("Custom-JWT-Signature + Authorization Bearer anche nella risposta");
                }
                if (sbMes.length() > 0) {
                    map.put(API_SICUREZZA_MESSAGGIO_HTTP_HEADER, sbMes.toString());
                }
            }
            if ((tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageConfig", (AccordoServizioParteComune)aspc, (String)asps.getPortType(), (boolean)false)) != null && !tmp.isEmpty()) {
                sbMes = new StringBuilder();
                for (Object mode : tmp) {
                    if ("entrambi".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Richiesta e Risposta");
                        continue;
                    }
                    if ("richiesta".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Richiesta");
                        continue;
                    }
                    if ("risposta".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Risposta");
                        continue;
                    }
                    if ("entrambi_attachments".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Richiesta e Risposta (con firma degli allegati)");
                        continue;
                    }
                    if ("richiesta_attachments".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Richiesta (con firma degli allegati)");
                        continue;
                    }
                    if ("risposta_attachments".equals(mode)) {
                        if (sbMes.length() > 0) {
                            sbMes.append(", ");
                        }
                        sbMes.append("Risposta (con firma degli allegati)");
                        continue;
                    }
                    if (!"custom".equals(mode)) continue;
                    if (sbMes.length() > 0) {
                        sbMes.append(", ");
                    }
                    sbMes.append("Personalizza criteri di applicabilit\u00e0");
                }
                if (sbMes.length() > 0) {
                    map.put(API_SICUREZZA_MESSAGGIO_APPLICABILITA, sbMes.toString());
                }
            }
            map.put(API_SICUREZZA_MESSAGGIO_REQUEST_DIGEST, digestRichiesta ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            if (corniceSicurezza) {
                if ("old".equals(patternDatiCorniceSicurezza)) {
                    map.put(API_SICUREZZA_MESSAGGIO_USER_INFO, "AUDIT_LEGACY");
                } else if ("audit01".equals(patternDatiCorniceSicurezza)) {
                    map.put(API_SICUREZZA_MESSAGGIO_USER_INFO, "AUDIT_REST_01 (schema:" + schemaDatiCorniceSicurezza + ")");
                } else if ("audit02".equals(patternDatiCorniceSicurezza)) {
                    map.put(API_SICUREZZA_MESSAGGIO_USER_INFO, "AUDIT_REST_02 (schema:" + schemaDatiCorniceSicurezza + ")");
                }
            } else {
                map.put(API_SICUREZZA_MESSAGGIO_USER_INFO, StatoFunzionalita.DISABILITATO.getValue());
            }
            boolean request = true;
            ModIUtils.addProfiloModISicurezza(map, protocolPropertyList, rest, gestioneFruitori, request, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, urlInvocazione, urlConnettoreFruitoreModI);
            ModIUtils.addProfiloModISicurezza(map, protocolPropertyList, rest, gestioneFruitori, !request, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, urlInvocazione, urlConnettoreFruitoreModI);
        } else if (gestioneFruitori) {
            v = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityOauthId");
            if (v != null && StringUtils.isNotEmpty((String)v)) {
                map.put(API_IMPL_SICUREZZA_OAUTH_IDENTIFICATIVO, v);
            }
            if ((v = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityOauthKid")) != null && StringUtils.isNotEmpty((String)v)) {
                map.put(API_IMPL_SICUREZZA_OAUTH_KID, v);
            }
            ModIUtils.addStore(map, protocolPropertyList, "", false, false);
        }
        if (sicurezzaMessaggioPdnd && gestioneErogatori) {
            v = ModIUtils.getStringValue(protocolPropertyList, "modipaInfoGenEserviceId");
            if (v != null && StringUtils.isNotEmpty((String)v)) {
                map.put(API_IMPL_INFO_ESERVICE_ID, v);
            }
            if ((v = ModIUtils.getStringValue(protocolPropertyList, "modipaInfoGenDescriptorId")) != null && StringUtils.isNotEmpty((String)v)) {
                map.put(API_IMPL_INFO_DESCRIPTOR_ID, v);
            }
            if ((v = ModIUtils.getStringValue(protocolPropertyList, "modipaInfoGenSignalHub")) != null && StringUtils.isNotEmpty((String)v)) {
                map.put(API_IMPL_INFO_SIGNAL_HUB, "true".equals(v) ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            } else if (ModIUtils.isSignalHubEnabled()) {
                map.put(API_IMPL_INFO_SIGNAL_HUB, StatoFunzionalita.DISABILITATO.getValue());
            }
        }
        return map;
    }

    public static String getPrefixKey(boolean fruizione, boolean request) {
        String prefixKey = null;
        if (fruizione) {
            // empty if block
        }
        prefixKey = request ? REQUEST_PREFIX : RESPONSE_PREFIX;
        return prefixKey;
    }

    private static void addProfiloModISicurezza(java.util.Map<String, String> map, List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, boolean rest, boolean fruizione, boolean request, boolean digest, String patternDatiCorniceSicurezza, String schemaDatiCorniceSicurezza, boolean headerDuplicati, String urlInvocazione, String urlConnettoreFruitoreModI) {
        String idAuditDifferent;
        String idAudit;
        String v;
        String stato;
        String v2;
        String rifX509Id;
        String v3;
        String idProfiloSicurezzaMessaggioAlgItem;
        String prefixKey = ModIUtils.getPrefixKey(fruizione, request);
        boolean x5u = false;
        if (rest) {
            block113: {
                idProfiloSicurezzaMessaggioAlgItem = null;
                if (fruizione && request) {
                    idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageRestRequestAlg";
                } else if (!fruizione && !request) {
                    idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageRestResponseAlg";
                }
                if (idProfiloSicurezzaMessaggioAlgItem != null) {
                    String v4 = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioAlgItem);
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_SIGNATURE_ALGORITHM, v4);
                }
                String idProfiloSicurezzaMessaggioDigestEncodingItem = null;
                if (fruizione && request) {
                    idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestRequestDigestEncoding";
                } else if (!fruizione && !request) {
                    idProfiloSicurezzaMessaggioDigestEncodingItem = "modipaSecurityMessageRestResponseDigestEncoding";
                }
                if (idProfiloSicurezzaMessaggioDigestEncodingItem != null) {
                    v3 = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioDigestEncodingItem);
                    if (v3 != null) {
                        try {
                            DigestEncoding de = DigestEncoding.valueOf((String)v3);
                            if (DigestEncoding.BASE64.equals((Object)de)) {
                                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_DIGEST_ENCODING, "Base64");
                                break block113;
                            }
                            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_DIGEST_ENCODING, "Hex");
                        }
                        catch (Exception t) {
                            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_DIGEST_ENCODING, v3);
                        }
                    } else {
                        map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_DIGEST_ENCODING, v3);
                    }
                }
            }
            if (digest && (request && fruizione || !request && !fruizione)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_HTTP_HEADER_FIRMATI, ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityMessageHttpHeaders"));
            }
            rifX509Id = request ? "modipaSecurityMessageRestRequestX509Cert" : "modipaSecurityMessageRestResponseX509Cert";
            String v5 = ModIUtils.getStringValue(protocolPropertyList, rifX509Id);
            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_RIFERIMENTO_X509, v5);
            x5u = v5 != null && v5.contains("x5u");
            String rifX509Xc5ChainId = null;
            if (fruizione && request) {
                rifX509Xc5ChainId = "modipaSecurityMessageRestRequestX509CertUseCertificateChain";
            } else if (!fruizione && !request) {
                rifX509Xc5ChainId = "modipaSecurityMessageRestResponseX509CertUseCertificateChain";
            }
            if (rifX509Xc5ChainId != null) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CATENA_CERTIFICATI_X509, ModIUtils.getBooleanValueAsStato(protocolPropertyList, rifX509Xc5ChainId));
            }
        } else {
            String certId;
            idProfiloSicurezzaMessaggioAlgItem = null;
            if (fruizione && request) {
                idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageSoapRequestAlg";
            } else if (!fruizione && !request) {
                idProfiloSicurezzaMessaggioAlgItem = "modipaSecurityMessageSoapResponseAlg";
            }
            if (idProfiloSicurezzaMessaggioAlgItem != null) {
                String algoLabel = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioAlgItem);
                if (algoLabel != null && algoLabel.contains("#") && !algoLabel.endsWith("#")) {
                    algoLabel = algoLabel.substring(algoLabel.indexOf("#") + 1, algoLabel.length()).toUpperCase();
                }
                if (algoLabel != null) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_SIGNATURE_ALGORITHM, algoLabel);
                }
            }
            String idProfiloSicurezzaMessaggioAlgC14NItem = null;
            if (fruizione && request) {
                idProfiloSicurezzaMessaggioAlgC14NItem = "modipaSecurityMessageSoapRequestCanonicalizationAlg";
            } else if (!fruizione && !request) {
                idProfiloSicurezzaMessaggioAlgC14NItem = "modipaSecurityMessageSoapResponseCanonicalizationAlg";
            }
            if (idProfiloSicurezzaMessaggioAlgC14NItem != null) {
                String algoLabel = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioAlgC14NItem);
                if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(algoLabel)) {
                    algoLabel = "Canonical XML 1.0";
                } else if ("http://www.w3.org/2006/12/xml-c14n11".equals(algoLabel)) {
                    algoLabel = "Canonical XML 1.1";
                } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(algoLabel)) {
                    algoLabel = "Exclusive XML Canonicalization 1.0";
                }
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CANONICALIZATION_ALGORITHM, algoLabel);
            }
            if (digest && (request && fruizione || !request && !fruizione) && (v3 = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityMessageSoapHeaders")) != null) {
                for (int index = 0; v3.contains("\n") && index < 1000; ++index) {
                    v3 = v3.replace("\n", ", ");
                }
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_SOAP_HEADER_FIRMATI, v3);
            }
            rifX509Id = null;
            if (fruizione && request) {
                rifX509Id = "modipaSecurityMessageSoapRequestX509Cert";
            } else if (!fruizione && !request) {
                rifX509Id = "modipaSecurityMessageSoapResponseX509Cert";
            }
            boolean useCertificateChain = false;
            boolean includeSignatureToken = false;
            if (rifX509Id != null) {
                String refLabel = ModIUtils.getStringValue(protocolPropertyList, rifX509Id);
                if ("DirectReference".equals(refLabel)) {
                    refLabel = "Binary Security Token";
                    useCertificateChain = true;
                } else if ("IssuerSerial".equals(refLabel)) {
                    refLabel = "Issuer-Serial Security Token Reference";
                    includeSignatureToken = true;
                } else if ("X509KeyIdentifier".equals(refLabel)) {
                    refLabel = "X509 Key Identifier";
                } else if ("Thumbprint".equals(refLabel)) {
                    refLabel = "Thumbprint Key Identifier";
                    includeSignatureToken = true;
                } else if ("SKIKeyIdentifier".equals(refLabel)) {
                    refLabel = "SKI Key Identifier";
                    includeSignatureToken = true;
                }
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_RIFERIMENTO_X509, refLabel);
            }
            if (useCertificateChain) {
                certId = null;
                if (fruizione && request) {
                    certId = "modipaSecurityMessageSoapRequestX509CertUseCertificateChain";
                } else if (!fruizione && !request) {
                    certId = "modipaSecurityMessageSoapResponseX509CertUseCertificateChain";
                }
                if (certId != null) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CATENA_CERTIFICATI_X509, ModIUtils.getBooleanValueAsStato(protocolPropertyList, certId));
                }
            }
            if (includeSignatureToken) {
                certId = null;
                if (fruizione && request) {
                    certId = "modipaSecurityMessageSoapRequestX509CertIncludeSignatureToken";
                } else if (!fruizione && !request) {
                    certId = "modipaSecurityMessageSoapResponseX509CertIncludeSignatureToken";
                }
                if (certId != null) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_INCLUDE_SIGNATURE_TOKEN, ModIUtils.getBooleanValueAsStato(protocolPropertyList, certId));
                }
            }
        }
        String idProfiloSicurezzaMessaggioIatTtlItem = null;
        String idProfiloSicurezzaMessaggioIatTtlSecondsItem = null;
        if (fruizione && !request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageResponseIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageResponseIatTtl";
        } else if (!fruizione && request) {
            idProfiloSicurezzaMessaggioIatTtlItem = "modipaSecurityMessageRequestIatMode";
            idProfiloSicurezzaMessaggioIatTtlSecondsItem = "modipaSecurityMessageRequestIatTtl";
        }
        if (idProfiloSicurezzaMessaggioIatTtlItem != null && idProfiloSicurezzaMessaggioIatTtlSecondsItem != null) {
            v3 = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioIatTtlItem);
            if (v3 == null || StringUtils.isEmpty((String)v3) || "default".equals(v3)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_TTL, "Default");
            } else {
                v3 = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioIatTtlSecondsItem);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_TTL, v3);
            }
        }
        String idProfiloSicurezzaMessaggioExpItem = null;
        if (fruizione && request) {
            idProfiloSicurezzaMessaggioExpItem = "modipaSecurityMessageRequestExp";
        } else if (!fruizione && !request) {
            idProfiloSicurezzaMessaggioExpItem = "modipaSecurityMessageResponseExp";
        }
        if (idProfiloSicurezzaMessaggioExpItem != null && (v2 = ModIUtils.getStringValue(protocolPropertyList, idProfiloSicurezzaMessaggioExpItem)) != null && StringUtils.isNotEmpty((String)v2)) {
            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_TTL, v2);
        }
        boolean audit = false;
        if (request) {
            String v6 = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityMessageRequestAud");
            String aud = null;
            aud = v6 != null ? v6 : (fruizione ? urlConnettoreFruitoreModI : urlInvocazione);
            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_AUDIENCE, aud);
            audit = true;
        } else if (fruizione && (stato = ModIUtils.getBooleanValueAsStato(protocolPropertyList, "modipaSecurityMessageResponseAud")) != null && StringUtils.isNotEmpty((String)stato)) {
            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_VERIFICA_AUDIENCE, stato);
            if (StatoFunzionalita.ABILITATO.getValue().equals(stato)) {
                audit = true;
                v = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityMessageResponseAudExpected");
                if (v != null && StringUtils.isNotEmpty((String)v)) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_AUDIENCE, v);
                }
            }
        }
        if (x5u) {
            String id = null;
            if (request && fruizione) {
                id = "modipaSecurityMessageRestRequestX509Url";
            }
            if (!request && !fruizione) {
                id = "modipaSecurityMessageRestResponseX509Url";
            }
            if (id != null && (v = ModIUtils.getStringValue(protocolPropertyList, id)) != null && StringUtils.isNotEmpty((String)v)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_X5U_CERTIFICATE_URL, v);
            }
        }
        if (patternDatiCorniceSicurezza != null) {
            if ("old".equals(patternDatiCorniceSicurezza)) {
                String claimCodiceEnte = "Codice Ente";
                String idCodiceEnteMode = "modipaSecurityMessageCorniceSicurezzaCodiceEnteMode";
                String vCodiceEnteMode = ModIUtils.getStringValue(protocolPropertyList, idCodiceEnteMode);
                if (vCodiceEnteMode != null && "ridefinisci".equals(vCodiceEnteMode)) {
                    String idValue = "modipaSecurityMessageCorniceSicurezzaCodiceEnte";
                    String value = ModIUtils.getStringValue(protocolPropertyList, idValue);
                    if (value != null) {
                        map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimCodiceEnte, value);
                    }
                } else {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimCodiceEnte, "default");
                }
                Iterator claimUser = "UserID Utente";
                String idUserMode = "modipaSecurityMessageCorniceSicurezzaUserMode";
                String vUserMode = ModIUtils.getStringValue(protocolPropertyList, idUserMode);
                if (vUserMode != null && "ridefinisci".equals(vUserMode)) {
                    String idValue = "modipaSecurityMessageCorniceSicurezzaUser";
                    String value = ModIUtils.getStringValue(protocolPropertyList, idValue);
                    if (value != null) {
                        map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimUser, value);
                    }
                } else {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimUser, "default");
                }
                String claimUserIP = "Indirizzo IP Utente";
                String idUserIPMode = "modipaSecurityMessageCorniceSicurezzaIPUserMode";
                String vUserIPMode = ModIUtils.getStringValue(protocolPropertyList, idUserIPMode);
                if (vUserIPMode != null && "ridefinisci".equals(vUserIPMode)) {
                    String idValue = "modipaSecurityMessageCorniceSicurezzaIPUser";
                    String value = ModIUtils.getStringValue(protocolPropertyList, idValue);
                    if (value != null) {
                        map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimUserIP, value);
                    }
                } else {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + claimUserIP, "default");
                }
            } else if (schemaDatiCorniceSicurezza != null) {
                String idAuditDifferent2 = "modipaSecurityMessageRequestAuditAudMode";
                v = ModIUtils.getStringValue(protocolPropertyList, idAuditDifferent2);
                if ("different".equals(v) && (v = ModIUtils.getStringValue(protocolPropertyList, idAudit = "modipaSecurityMessageRequestAuditAud")) != null && StringUtils.isNotEmpty((String)v)) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_AUDIT_AUDIENCE, v);
                }
                ArrayList<String> l = new ArrayList<String>();
                for (org.openspcoop2.core.registry.ProtocolProperty pp : protocolPropertyList) {
                    if (!pp.getName().startsWith("modipaSecurityMessageCorniceSicurezzaSchemaMode")) continue;
                    String claim = pp.getName().substring("modipaSecurityMessageCorniceSicurezzaSchemaMode".length());
                    l.add(claim);
                }
                if (l != null && !l.isEmpty()) {
                    for (String c : l) {
                        String idMode = "modipaSecurityMessageCorniceSicurezzaSchemaMode" + c;
                        String vMode = ModIUtils.getStringValue(protocolPropertyList, idMode);
                        if (vMode != null && "ridefinisci".equals(vMode)) {
                            String idValue = "modipaSecurityMessageCorniceSicurezzaSchemaValue" + c;
                            String value = ModIUtils.getStringValue(protocolPropertyList, idValue);
                            if (value == null) continue;
                            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + c, value);
                            continue;
                        }
                        map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_CORNICE_SICUREZZA_PREFIX + c, "default");
                    }
                }
            }
        }
        if (rest && headerDuplicati && (!request && fruizione || request && !fruizione) && audit && "different".equals(v = ModIUtils.getStringValue(protocolPropertyList, idAuditDifferent = request ? "modipaSecurityMessageRequestIntegrityAudMode" : "modipaSecurityMessageResponseIntegrityAudMode")) && (v = ModIUtils.getStringValue(protocolPropertyList, idAudit = request ? "modipaSecurityMessageRequestIntegrityAud" : "modipaSecurityMessageResponseIntegrityAud")) != null && StringUtils.isNotEmpty((String)v)) {
            map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_INTEGRITY_AUDIENCE, v);
        }
        if (fruizione && request) {
            String v7 = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityOauthId");
            if (v7 != null && StringUtils.isNotEmpty((String)v7)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_OAUTH_IDENTIFICATIVO, v7);
            }
            if ((v7 = ModIUtils.getStringValue(protocolPropertyList, "modipaSecurityOauthKid")) != null && StringUtils.isNotEmpty((String)v7)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_OAUTH_KID, v7);
            }
        }
        if (fruizione && !request || !fruizione && request) {
            ModIUtils.addStore(map, protocolPropertyList, prefixKey, false, true);
            if (rest && x5u) {
                ModIUtils.addStore(map, protocolPropertyList, prefixKey, true, false);
            }
        }
        if (!fruizione && !request) {
            ModIUtils.addStore(map, protocolPropertyList, prefixKey, false, false);
        }
        if (fruizione && request) {
            boolean keystoreDefinitoInFruizione = false;
            String idFruizioneKeystoreFruizioneMode = "modipaKeystoreFruizioneMode";
            String v8 = ModIUtils.getStringValue(protocolPropertyList, idFruizioneKeystoreFruizioneMode);
            if ("fruizione".equals(v8)) {
                keystoreDefinitoInFruizione = true;
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_FRUIZIONE_KEYSTORE_MODE, "Definito nella fruizione");
            } else if ("token".equals(v8)) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_FRUIZIONE_KEYSTORE_MODE, "Definito nella token policy");
            } else {
                String idFruizioneKeystoreMode;
                String vMode;
                if ((v8 == null || StringUtils.isEmpty((String)v8)) && "ridefinisci".equals(vMode = ModIUtils.getStringValue(protocolPropertyList, idFruizioneKeystoreMode = "modipaKeystoreCertMode"))) {
                    keystoreDefinitoInFruizione = true;
                }
                if (keystoreDefinitoInFruizione) {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_FRUIZIONE_KEYSTORE_MODE, "Definito nella fruizione");
                } else {
                    map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_FRUIZIONE_KEYSTORE_MODE, "Definito nell'applicativo");
                }
            }
            if (keystoreDefinitoInFruizione) {
                ModIUtils.addStore(map, protocolPropertyList, prefixKey, false, false);
            }
        }
    }

    public static String getPrefixKeyStore(boolean prefix, String prefixKey, boolean ssl, boolean truststore) {
        String s = null;
        s = ssl ? prefixKey + "truststore-ssl" : (truststore ? prefixKey + "truststore" : prefixKey + "keystore");
        return prefix ? s + "-" : s;
    }

    private static void addStore(java.util.Map<String, String> map, List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, String prefixKeyParam, boolean ssl, boolean truststore) {
        String id = null;
        id = ssl ? "modipaSslTruststoreMode" : (truststore ? "modipaTruststoreMode" : "modipaKeystoreCertMode");
        String v = ModIUtils.getStringValue(protocolPropertyList, id);
        if (v == null || StringUtils.isEmpty((String)v) || "default".equals(v)) {
            String store = ModIUtils.getPrefixKeyStore(false, prefixKeyParam, ssl, truststore);
            if ("default".equals(v)) {
                map.put(store, "Default");
            }
        } else {
            String prefixKey = ModIUtils.getPrefixKeyStore(true, prefixKeyParam, ssl, truststore);
            String type = null;
            String path = null;
            String crl = null;
            String ocsp = null;
            String aliasKey = null;
            boolean keystoreModePath = false;
            boolean keystoreModeArchive = false;
            boolean keystoreModeHsm = false;
            if (ssl) {
                type = "modipaSslTruststoreType";
                path = "modipaSslTruststorePath";
                crl = "modipaSslTruststoreCRLs";
                ocsp = "modipaSslTruststoreOCSP";
            } else if (truststore) {
                type = "modipaTruststoreType";
                path = "modipaTruststorePath";
                crl = "modipaTruststoreCRLs";
                ocsp = "modipaTruststoreOCSP";
            } else {
                type = "modipaKeystoreType";
                aliasKey = "modipaKeyAlias";
                String mode = ModIUtils.getStringValue(protocolPropertyList, "modipaKeystoreMode");
                if ("archive".equals(mode)) {
                    keystoreModeArchive = true;
                } else if (API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH.equals(mode)) {
                    keystoreModePath = true;
                    path = "modipaKeystorePath";
                } else if (HSM.equals(mode)) {
                    keystoreModeHsm = true;
                }
            }
            String vType = null;
            if (type != null) {
                vType = ModIUtils.getStringValue(protocolPropertyList, type);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_TYPE, vType);
            }
            if (keystoreModePath) {
                // empty if block
            }
            boolean hsm = false;
            if (ssl || truststore) {
                if (vType != null) {
                    hsm = HSMUtils.isKeystoreHSM((String)vType);
                }
            } else {
                hsm = keystoreModeHsm;
            }
            map.put(prefixKey + HSM, "" + hsm);
            if (hsm) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH, "HSM");
            } else if (path != null) {
                String vPath = ModIUtils.getStringValue(protocolPropertyList, path);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH, vPath);
            } else if (keystoreModeArchive) {
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH, "Archivio caricato");
            }
            if (crl != null) {
                String vCrl = ModIUtils.getStringValue(protocolPropertyList, crl);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_CRLS, vCrl);
            }
            if (ocsp != null) {
                String vOcsp = ModIUtils.getStringValue(protocolPropertyList, ocsp);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_STORE_OCSP_POLICY, vOcsp);
            }
            if (aliasKey != null) {
                String vAliasKey = ModIUtils.getStringValue(protocolPropertyList, aliasKey);
                map.put(prefixKey + API_IMPL_SICUREZZA_MESSAGGIO_KEY_ALIAS, vAliasKey);
            }
        }
    }

    private static boolean isProfiloSicurezzaMessaggioConIntegritaX509(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageProfile", (AccordoServizioParteComune)api, (String)portType, (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String profiloSicurezzaMessaggio : tmp) {
                if (!"idam0301".equals(profiloSicurezzaMessaggio) && !"idam0302".equals(profiloSicurezzaMessaggio)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProfiloSicurezzaMessaggioConIntegritaKid(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageProfile", (AccordoServizioParteComune)api, (String)portType, (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String profiloSicurezzaMessaggio : tmp) {
                if (!"idam0401".equals(profiloSicurezzaMessaggio) && !"idam0402".equals(profiloSicurezzaMessaggio)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProfiloSicurezzaMessaggioCorniceSicurezza(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageCorniceSicurezza", (AccordoServizioParteComune)api, (String)portType, (boolean)true);
        if (tmp != null && !tmp.isEmpty()) {
            for (String v : tmp) {
                if (v == null || !"true".equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getProfiloSicurezzaMessaggioCorniceSicurezzaPattern(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageCorniceSicurezzaPattern", (AccordoServizioParteComune)api, (String)portType, (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            return (String)tmp.get(0);
        }
        return null;
    }

    private static String getProfiloSicurezzaMessaggioCorniceSicurezzaSchema(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageCorniceSicurezzaSchema", (AccordoServizioParteComune)api, (String)portType, (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            return (String)tmp.get(0);
        }
        return null;
    }

    private static boolean isProfiloSicurezzaMessaggioRequestDigest(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageRequestDigest", (AccordoServizioParteComune)api, (String)portType, (boolean)true);
        if (tmp != null && !tmp.isEmpty()) {
            for (String v : tmp) {
                if (v == null || !"true".equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProfiloSicurezzaMessaggioConHeaderDuplicati(AccordoServizioParteComune api, String portType) {
        List tmp = RegistroServiziUtils.fillPropertyProtocollo((String)"modipaSecurityMessageHeaderName", (AccordoServizioParteComune)api, (String)portType, (boolean)false);
        if (tmp != null && !tmp.isEmpty()) {
            for (String profiloSicurezzaMessaggio : tmp) {
                if (!"autonlyreq_modipa".equals(profiloSicurezzaMessaggio) && !"authorization_modipa".equals(profiloSicurezzaMessaggio) && !"autonlyreq_custom".equals(profiloSicurezzaMessaggio) && !"authorization_custom".equals(profiloSicurezzaMessaggio)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getModiProperties() throws ProtocolException {
        return ModIPropertiesUtils.getModiProperties();
    }

    public static String getHeaderModI() throws ProtocolException {
        return ModIPropertiesUtils.getHeaderModI();
    }

    public static boolean isTokenOAuthUseJtiIntegrityAsMessageId() throws ProtocolException {
        return ModIPropertiesUtils.isTokenOAuthUseJtiIntegrityAsMessageId();
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig() throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDClientConfig();
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(Logger log) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDClientConfig(log);
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(String details) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDClientConfig(details);
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(String details, Logger log) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDClientConfig(details, log);
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig() throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDOrganizationConfig();
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(Logger log) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDOrganizationConfig(log);
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDOrganizationConfig(details);
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details, Logger log) throws ProtocolException {
        return ModIPropertiesUtils.getAPIPDNDOrganizationConfig(details, log);
    }

    public static IDAccordo buildSignalHubPushIdAPI(IDSoggetto idSoggettoDefault) throws ProtocolException {
        return ModIPropertiesUtils.buildSignalHubPushIdAPI(idSoggettoDefault);
    }

    public static boolean isSignalHubEnabled() throws ProtocolException {
        return ModIPropertiesUtils.isSignalHubEnabled();
    }

    public static boolean isTracingPDNDEnabled() throws ProtocolException {
        return ModIPropertiesUtils.isTracingPDNDEnabled();
    }

    public static boolean isTracingPDNDEnabledSafe() {
        try {
            return ModIUtils.isTracingPDNDEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<RemoteStoreConfig> getRemoteStoreConfig() throws ProtocolException {
        return ModIPropertiesUtils.getRemoteStoreConfig();
    }

    public static RemoteKeyType getRemoteKeyType(String name) throws ProtocolException {
        return ModIPropertiesUtils.getRemoteKeyType(name);
    }

    public static KeystoreParams getSicurezzaMessaggioCertificatiTrustStore() throws ProtocolException {
        return ModIPropertiesUtils.getSicurezzaMessaggioCertificatiTrustStore();
    }

    public static KeystoreParams getSicurezzaMessaggioSslTrustStore() throws ProtocolException {
        return ModIPropertiesUtils.getSicurezzaMessaggioSslTrustStore();
    }

    public static KeystoreParams getSicurezzaMessaggioCertificatiKeyStore() throws ProtocolException {
        return ModIPropertiesUtils.getSicurezzaMessaggioCertificatiKeyStore();
    }

    public static KeystoreParams getApplicativoKeystoreParams(List<ProtocolProperty> protocolPropertyList) {
        if (protocolPropertyList == null || protocolPropertyList.isEmpty()) {
            return null;
        }
        KeystoreParams keystoreParams = null;
        String sicurezza = ModIUtils.getStringValueConfig(protocolPropertyList, "modipaSecurityMessage");
        if ("true".equals(sicurezza)) {
            boolean keystoreModePath = false;
            boolean keystoreModeArchive = false;
            boolean keystoreModeHsm = false;
            String mode = ModIUtils.getStringValueConfig(protocolPropertyList, "modipaKeystoreMode");
            String path = null;
            String type = "modipaKeystoreType";
            if ("archive".equals(mode)) {
                keystoreModeArchive = true;
            } else if (API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH.equals(mode)) {
                keystoreModePath = true;
                path = "modipaKeystorePath";
            } else if (HSM.equals(mode)) {
                keystoreModeHsm = true;
            }
            String vType = null;
            if (type != null) {
                vType = ModIUtils.getStringValueConfig(protocolPropertyList, type);
            }
            if (keystoreModePath) {
                // empty if block
            }
            String vPath = null;
            byte[] vStore = null;
            if (keystoreModeHsm) {
                vPath = "HSM";
            } else if (path != null) {
                vPath = ModIUtils.getStringValueConfig(protocolPropertyList, path);
            } else if (keystoreModeArchive) {
                vPath = "Archivio caricato";
                vStore = ModIUtils.getBinaryValueConfig(protocolPropertyList, "modipaKeystoreArchive");
            }
            String pw = "modipaKeystorePassword";
            String vPassword = ModIUtils.getStringValueConfig(protocolPropertyList, pw);
            String aliasKey = "modipaKeyAlias";
            String vAliasKey = ModIUtils.getStringValueConfig(protocolPropertyList, aliasKey);
            String passwordKey = "modipaKeyPassword";
            String vPassordKey = ModIUtils.getStringValueConfig(protocolPropertyList, passwordKey);
            String vPathPublicKey = null;
            if (KeystoreType.KEY_PAIR.getNome().equals(vType)) {
                vPathPublicKey = ModIUtils.getStringValueConfig(protocolPropertyList, "modipaKeystorePathPublicKey");
            }
            String vKeyPairAlgorithm = null;
            if (KeystoreType.KEY_PAIR.getNome().equals(vType) || KeystoreType.PUBLIC_KEY.getNome().equals(vType)) {
                vKeyPairAlgorithm = ModIUtils.getStringValueConfig(protocolPropertyList, "modipaKeystoreKeyPairAlgo");
            }
            String byok = "modipaKeystoreByokPolicy";
            String vByok = null;
            if (!keystoreModeArchive && !keystoreModeHsm) {
                vByok = ModIUtils.getStringValueConfig(protocolPropertyList, byok);
            }
            keystoreParams = new KeystoreParams();
            keystoreParams.setType(vType);
            keystoreParams.setPath(vPath);
            keystoreParams.setStore(vStore);
            keystoreParams.setPassword(vPassword);
            keystoreParams.setKeyAlias(vAliasKey);
            keystoreParams.setKeyPassword(vPassordKey);
            keystoreParams.setKeyPairPublicKeyPath(vPathPublicKey);
            keystoreParams.setKeyPairAlgorithm(vKeyPairAlgorithm);
            keystoreParams.setByokPolicy(vByok);
        }
        return keystoreParams;
    }

    public static byte[] getApplicativoKeystoreCertificate(List<ProtocolProperty> protocolPropertyList) {
        byte[] b = null;
        if (protocolPropertyList == null || protocolPropertyList.isEmpty()) {
            return b;
        }
        String sicurezza = ModIUtils.getStringValueConfig(protocolPropertyList, "modipaSecurityMessage");
        if ("true".equals(sicurezza)) {
            return ModIUtils.getBinaryValueConfig(protocolPropertyList, "modipaKeystoreCertificate");
        }
        return b;
    }

    public static boolean existsStoreConfig(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, boolean includeRemoteStore, boolean checkModeFruizioneKeystoreId) throws ProtocolException {
        boolean existsStore;
        KeystoreParams keystoreParams = null;
        try {
            keystoreParams = ModIUtils.getKeyStoreParams(protocolPropertyList, checkModeFruizioneKeystoreId);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        KeystoreParams truststoreParams = null;
        try {
            truststoreParams = ModIUtils.getTrustStoreParams(protocolPropertyList);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        KeystoreParams truststoreSslParams = null;
        try {
            truststoreSslParams = ModIUtils.getTrustStoreSSLParams(protocolPropertyList);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        boolean bl = existsStore = keystoreParams != null || truststoreParams != null || truststoreSslParams != null;
        if (!includeRemoteStore) {
            return existsStore;
        }
        List<RemoteStoreConfig> trustStoreRemoteConfig = null;
        try {
            trustStoreRemoteConfig = ModIUtils.getRemoteStoreConfig();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        return existsStore || trustStoreRemoteConfig != null && !trustStoreRemoteConfig.isEmpty();
    }

    public static KeystoreParams getKeyStoreParams(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, boolean checkModeFruizioneKeystoreId) throws ProtocolException {
        return ModIUtils.getKeystoreParamsEngine(protocolPropertyList, false, false, checkModeFruizioneKeystoreId);
    }

    public static KeystoreParams getTrustStoreParams(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList) throws ProtocolException {
        return ModIUtils.getKeystoreParamsEngine(protocolPropertyList, false, true, false);
    }

    public static KeystoreParams getTrustStoreSSLParams(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList) throws ProtocolException {
        return ModIUtils.getKeystoreParamsEngine(protocolPropertyList, true, false, false);
    }

    private static KeystoreParams getKeystoreParamsEngine(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, boolean ssl, boolean truststore, boolean checkModeFruizioneKeystoreId) throws ProtocolException {
        String v;
        if (protocolPropertyList == null || protocolPropertyList.isEmpty()) {
            return null;
        }
        if (checkModeFruizioneKeystoreId && (v = ModIUtils.getStringValue(protocolPropertyList, "modipaKeystoreFruizioneMode")) != null && !StringUtils.isEmpty((String)v) && !"fruizione".equals(v)) {
            return null;
        }
        KeystoreParams keystoreParams = null;
        String id = null;
        id = ssl ? "modipaSslTruststoreMode" : (truststore ? "modipaTruststoreMode" : "modipaKeystoreCertMode");
        String v2 = ModIUtils.getStringValue(protocolPropertyList, id);
        if (v2 != null && !StringUtils.isEmpty((String)v2) && !"-".equals(v2)) {
            if ("default".equals(v2)) {
                keystoreParams = ssl ? ModIUtils.getSicurezzaMessaggioSslTrustStore() : (truststore ? ModIUtils.getSicurezzaMessaggioCertificatiTrustStore() : ModIUtils.getSicurezzaMessaggioCertificatiKeyStore());
            } else if ("ridefinisci".equals(v2)) {
                String type = null;
                String path = null;
                String archive = null;
                String pw = null;
                String crl = null;
                String ocsp = null;
                String aliasKey = null;
                String pwKey = null;
                String byok = null;
                boolean keystoreModePath = false;
                boolean keystoreModeArchive = false;
                boolean keystoreModeHsm = false;
                if (ssl) {
                    type = "modipaSslTruststoreType";
                    path = "modipaSslTruststorePath";
                    pw = "modipaSslTruststorePassword";
                    crl = "modipaSslTruststoreCRLs";
                    ocsp = "modipaSslTruststoreOCSP";
                } else if (truststore) {
                    type = "modipaTruststoreType";
                    path = "modipaTruststorePath";
                    pw = "modipaTruststorePassword";
                    crl = "modipaTruststoreCRLs";
                    ocsp = "modipaTruststoreOCSP";
                } else {
                    type = "modipaKeystoreType";
                    pw = "modipaKeystorePassword";
                    aliasKey = "modipaKeyAlias";
                    pwKey = "modipaKeyPassword";
                    String mode = ModIUtils.getStringValue(protocolPropertyList, "modipaKeystoreMode");
                    if ("archive".equals(mode)) {
                        keystoreModeArchive = true;
                        archive = "modipaKeystoreArchive";
                    } else if (API_IMPL_SICUREZZA_MESSAGGIO_STORE_PATH.equals(mode)) {
                        keystoreModePath = true;
                        path = "modipaKeystorePath";
                        byok = "modipaKeystoreByokPolicy";
                    } else if (HSM.equals(mode)) {
                        keystoreModeHsm = true;
                    }
                }
                String vType = null;
                if (type != null) {
                    vType = ModIUtils.getStringValue(protocolPropertyList, type);
                }
                if (keystoreModePath) {
                    // empty if block
                }
                String vPassword = null;
                if (pw != null) {
                    vPassword = ModIUtils.getStringValue(protocolPropertyList, pw);
                }
                boolean hsm = false;
                if (ssl || truststore) {
                    if (vType != null) {
                        hsm = HSMUtils.isKeystoreHSM((String)vType);
                    }
                } else {
                    hsm = keystoreModeHsm;
                }
                String vPath = null;
                byte[] vStore = null;
                if (hsm) {
                    vPath = "HSM";
                } else if (path != null) {
                    vPath = ModIUtils.getStringValue(protocolPropertyList, path);
                } else if (keystoreModeArchive) {
                    vPath = "Archivio caricato";
                    vStore = ModIUtils.getBinaryValue(protocolPropertyList, archive);
                }
                String vCrl = null;
                if (crl != null) {
                    vCrl = ModIUtils.getStringValue(protocolPropertyList, crl);
                }
                String vOcsp = null;
                if (ocsp != null) {
                    vOcsp = ModIUtils.getStringValue(protocolPropertyList, ocsp);
                }
                String vAliasKey = null;
                if (aliasKey != null) {
                    vAliasKey = ModIUtils.getStringValue(protocolPropertyList, aliasKey);
                }
                String vPasswordKey = null;
                if (pwKey != null) {
                    vPasswordKey = ModIUtils.getStringValue(protocolPropertyList, pwKey);
                }
                String vPathPublicKey = null;
                if (KeystoreType.KEY_PAIR.getNome().equals(vType)) {
                    vPathPublicKey = ModIUtils.getStringValue(protocolPropertyList, "modipaKeystorePathPublicKey");
                }
                String vKeyPairAlgorithm = null;
                if (KeystoreType.KEY_PAIR.getNome().equals(vType) || KeystoreType.PUBLIC_KEY.getNome().equals(vType)) {
                    vKeyPairAlgorithm = ModIUtils.getStringValue(protocolPropertyList, "modipaKeystoreKeyPairAlgo");
                }
                String vByok = null;
                if (byok != null) {
                    vByok = ModIUtils.getStringValue(protocolPropertyList, byok);
                }
                keystoreParams = new KeystoreParams();
                keystoreParams.setType(vType);
                keystoreParams.setPath(vPath);
                keystoreParams.setStore(vStore);
                keystoreParams.setPassword(vPassword);
                keystoreParams.setCrls(vCrl);
                keystoreParams.setOcspPolicy(vOcsp);
                keystoreParams.setKeyAlias(vAliasKey);
                keystoreParams.setKeyPassword(vPasswordKey);
                keystoreParams.setKeyPairPublicKeyPath(vPathPublicKey);
                keystoreParams.setKeyPairAlgorithm(vKeyPairAlgorithm);
                keystoreParams.setByokPolicy(vByok);
            }
        }
        return keystoreParams;
    }

    private static String getStringValue(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, String id) {
        for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            if (StringUtils.isNotEmpty((String)protocolProperty.getValue())) {
                return protocolProperty.getValue();
            }
            if (protocolProperty.getNumberValue() != null) {
                return protocolProperty.getNumberValue().toString();
            }
            if (protocolProperty.getBooleanValue() != null) {
                return protocolProperty.getBooleanValue().toString();
            }
            if (protocolProperty.getByteFile() != null) {
                return "Archivio binario";
            }
            return null;
        }
        return null;
    }

    private static String getBooleanValueAsStato(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, String id) {
        for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            return protocolProperty.getBooleanValue() != null && protocolProperty.getBooleanValue() != false ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
        }
        return null;
    }

    static byte[] getBinaryValue(List<org.openspcoop2.core.registry.ProtocolProperty> protocolPropertyList, String id) {
        byte[] b = null;
        for (org.openspcoop2.core.registry.ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            return protocolProperty.getByteFile();
        }
        return b;
    }

    private static String getStringValueConfig(List<ProtocolProperty> protocolPropertyList, String id) {
        for (ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            if (StringUtils.isNotEmpty((String)protocolProperty.getValue())) {
                return protocolProperty.getValue();
            }
            if (protocolProperty.getNumberValue() != null) {
                return protocolProperty.getNumberValue().toString();
            }
            if (protocolProperty.getBooleanValue() != null) {
                return protocolProperty.getBooleanValue().toString();
            }
            if (protocolProperty.getByteFile() != null) {
                return "Archivio binario";
            }
            return null;
        }
        return null;
    }

    static String getBooleanValueAsStatoConfig(List<ProtocolProperty> protocolPropertyList, String id) {
        for (ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            return protocolProperty.getBooleanValue() != null && protocolProperty.getBooleanValue() != false ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
        }
        return null;
    }

    private static byte[] getBinaryValueConfig(List<ProtocolProperty> protocolPropertyList, String id) {
        byte[] b = null;
        for (ProtocolProperty protocolProperty : protocolPropertyList) {
            if (!protocolProperty.getName().equals(id)) continue;
            return protocolProperty.getByteFile();
        }
        return b;
    }

    public static boolean isSoggettoCanaleIntermediario(Soggetto soggettoCanale, Logger log) {
        try {
            if (soggettoCanale.sizeProprietaList() > 0) {
                for (Proprieta proprieta : soggettoCanale.getProprieta()) {
                    if (!PROPRIETA_INTERMEDIARIO.equals(proprieta.getNome())) continue;
                    return "true".equalsIgnoreCase(proprieta.getValore());
                }
            }
        }
        catch (Exception e) {
            log.error("[isSoggettoCanaleIntermediario] Process failed: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getMessaggioErroreDominioCanaleDifferenteDominioApplicativo(IDServizioApplicativo idServizioApplicativoMessaggio, IDSoggetto idSoggettoMittenteCanale) {
        return "Token di sicurezza firmato da un applicativo '" + idServizioApplicativoMessaggio.getNome() + "' risiedente nel dominio del soggetto '" + idServizioApplicativoMessaggio.getIdSoggettoProprietario().toString() + "'; il dominio differisce dal soggetto identificato sul canale di trasporto (" + idSoggettoMittenteCanale + ")";
    }

    public static String convertProfiloSicurezzaToSDKValue(String securityMessageProfile, boolean rest) {
        String profilo = securityMessageProfile.toUpperCase();
        profilo = rest ? profilo.replace("M", "R") : profilo.replace("M", "S");
        return profilo;
    }

    public static String convertProfiloSicurezzaToConfigurationValue(String securityMessageProfileSDKValue) {
        String securityMessageProfile = securityMessageProfileSDKValue.toLowerCase();
        securityMessageProfile = securityMessageProfile.replace("r", "m");
        securityMessageProfile = securityMessageProfile.replace("s", "m");
        return securityMessageProfile;
    }

    public static String convertProfiloSicurezzaSorgenteTokenToSDKValue(String sorgenteToken) {
        if ("locale".equals(sorgenteToken)) {
            return "Authorization ModI";
        }
        if ("pdnd".equals(sorgenteToken)) {
            return "Authorization PDND";
        }
        if ("oauth".equals(sorgenteToken)) {
            return "Authorization OAuth";
        }
        return "Authorization ModI";
    }

    public static String convertProfiloSicurezzaSorgenteTokenToConfigurationValue(String sorgenteTokenSDKValue) throws ProtocolException {
        if ("Authorization ModI".equals(sorgenteTokenSDKValue)) {
            return "locale";
        }
        if ("Authorization PDND".equals(sorgenteTokenSDKValue)) {
            return "pdnd";
        }
        if ("Authorization OAuth".equals(sorgenteTokenSDKValue)) {
            return "oauth";
        }
        throw ModIUtils.newProtocolExceptionUnknown("Source label", sorgenteTokenSDKValue);
    }

    public static String convertProfiloAuditToSDKValue(String patternCorniceSicurezza) throws ProtocolException {
        if ("old".equals(patternCorniceSicurezza)) {
            return "AUDIT_LEGACY";
        }
        if ("audit01".equals(patternCorniceSicurezza)) {
            return "AUDIT_REST_01";
        }
        if ("audit02".equals(patternCorniceSicurezza)) {
            return "AUDIT_REST_02";
        }
        throw ModIUtils.newProtocolExceptionUnknown("Pattern value", patternCorniceSicurezza);
    }

    public static String convertProfiloAuditToConfigurationValue(String patternCorniceSicurezzaSDKValue) throws ProtocolException {
        if ("AUDIT_LEGACY".equals(patternCorniceSicurezzaSDKValue)) {
            return "old";
        }
        if ("AUDIT_REST_01".equals(patternCorniceSicurezzaSDKValue)) {
            return "audit01";
        }
        if ("AUDIT_REST_02".equals(patternCorniceSicurezzaSDKValue)) {
            return "audit02";
        }
        throw ModIUtils.newProtocolExceptionUnknown("Pattern label", patternCorniceSicurezzaSDKValue);
    }

    public static ProtocolException newProtocolExceptionUnknown(String prefix, String value) {
        return new ProtocolException(prefix + " '" + value + "' unknown");
    }

    public static boolean useJtiAuthorizationObject(OpenSPCoop2Message msg) {
        Object useJtiAuthorizationObject = msg.getContextProperty(MODIPA_OPENSPCOOP2_MSG_CONTEXT_USE_JTI_AUTHORIZATION);
        boolean useJtiAuthorization = false;
        if (useJtiAuthorizationObject instanceof Boolean) {
            useJtiAuthorization = (Boolean)useJtiAuthorizationObject;
        }
        return useJtiAuthorization;
    }

    public static void replaceBustaIdWithJtiTokenId(ModIValidazioneSemanticaProfiloSicurezza modIValidazioneSemanticaProfiloSicurezza, String jtiClaimReceived) {
        if (jtiClaimReceived != null && !StringUtils.isEmpty((String)jtiClaimReceived)) {
            Busta busta = modIValidazioneSemanticaProfiloSicurezza.getBusta();
            String idIntegrity = busta.getID();
            busta.removeProperty("ProfiloSicurezzaMessaggio-MessageId");
            if (modIValidazioneSemanticaProfiloSicurezza.isSicurezzaMessaggio()) {
                busta.addProperty("ProfiloSicurezzaMessaggio-MessageId", idIntegrity);
            }
            busta.setID(jtiClaimReceived);
        }
    }

    public static String readJti(String token, Logger log) {
        try {
            String[] tmp;
            if (token != null && token.contains(".") && (tmp = token.split("\\.")) != null && tmp.length >= 3) {
                String jsonBase64 = tmp[1];
                String json = new String(Base64Utilities.decode((byte[])jsonBase64.getBytes()));
                return JsonPathExpressionEngine.extractAndConvertResultAsString((String)json, (String)"$.jti", (Logger)log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

