/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.state;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class StateMap {
    private Map<String, PreparedStatement> tablePstmt;
    private Logger log = null;

    public StateMap(Logger log) {
        this.tablePstmt = new HashMap<String, PreparedStatement>();
        this.log = log;
    }

    public StateMap(HashMap<String, PreparedStatement> preparedStatement, Logger log) {
        this.tablePstmt = preparedStatement;
        this.log = log;
    }

    public Map<String, PreparedStatement> getPreparedStatement() {
        return this.tablePstmt;
    }

    public void setPreparedStatement(Map<String, PreparedStatement> pstm) {
        this.tablePstmt = pstm;
    }

    public void put(String key, PreparedStatement pstmt) {
        if (this.tablePstmt.containsKey(key)) {
            try {
                this.tablePstmt.get(key).close();
            }
            catch (Exception e) {
                this.log.debug("ClosePreparedStatement already exists error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e);
            }
        }
        this.tablePstmt.put(key, pstmt);
    }

    public int size() {
        return this.tablePstmt.size();
    }

    public List<String> keys() {
        ArrayList<String> keys = null;
        if (!this.tablePstmt.isEmpty()) {
            keys = new ArrayList<String>();
            for (String key : this.tablePstmt.keySet()) {
                keys.add(key);
            }
        }
        return keys;
    }

    public boolean containsKey(String key) {
        return this.tablePstmt.containsKey(key);
    }
}

