/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.state;

import java.util.Map;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestConfig;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestRateLimitingConfig;
import org.openspcoop2.protocol.sdk.state.RequestThreadContext;
import org.slf4j.Logger;

public class RequestInfoConfigUtilities {
    private static final String CACHE_NON_UTILIZZABILE_AZIONE = "Cache della richiesta non utilizzabile con la modalit\u00e0 di identificazione dell'azione '";

    private RequestInfoConfigUtilities() {
    }

    public static void checkRequestInfoConfig(PortaApplicativa paDefault, Logger logCore, ServiceBinding serviceBinding, OpenSPCoop2MessageSoapStreamReader soapStreamReader, RequestInfo requestInfo) {
        if (requestInfo == null || requestInfo.getRequestConfig() == null || requestInfo.getRequestRateLimitingConfig() == null) {
            if (requestInfo != null) {
                requestInfo.setRequestConfig(null);
                requestInfo.setRequestRateLimitingConfig(null);
            }
            return;
        }
        boolean identificazioneByInterfaccia = false;
        boolean identificazioneByInterfacciaForceMode = false;
        if (paDefault != null && paDefault.getAzione() != null && paDefault.getAzione().getIdentificazione() != null) {
            if (PortaApplicativaAzioneIdentificazione.CONTENT_BASED.equals((Object)paDefault.getAzione().getIdentificazione()) || PortaApplicativaAzioneIdentificazione.PROTOCOL_BASED.equals((Object)paDefault.getAzione().getIdentificazione()) || PortaApplicativaAzioneIdentificazione.INPUT_BASED.equals((Object)paDefault.getAzione().getIdentificazione()) || PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals((Object)paDefault.getAzione().getIdentificazione())) {
                String msg = CACHE_NON_UTILIZZABILE_AZIONE + paDefault.getAzione().getIdentificazione() + "'";
                logCore.debug(msg);
                requestInfo.setRequestConfig(null);
                requestInfo.setRequestRateLimitingConfig(null);
                return;
            }
            identificazioneByInterfaccia = PortaApplicativaAzioneIdentificazione.INTERFACE_BASED.equals((Object)paDefault.getAzione().getIdentificazione());
            boolean bl = identificazioneByInterfacciaForceMode = paDefault.getAzione().getForceInterfaceBased() == null || StatoFunzionalita.ABILITATO.equals((Object)paDefault.getAzione().getForceInterfaceBased());
        }
        if (identificazioneByInterfaccia && ServiceBinding.SOAP.equals((Object)serviceBinding) && (soapStreamReader == null || soapStreamReader.getRootElementLocalName() == null || soapStreamReader.getRootElementNamespace() == null)) {
            String msg = CACHE_NON_UTILIZZABILE_AZIONE + paDefault.getAzione().getIdentificazione() + "' e soapStreamReader root element non disponibile";
            logCore.debug(msg);
            requestInfo.setRequestConfig(null);
            requestInfo.setRequestRateLimitingConfig(null);
            return;
        }
        if (identificazioneByInterfacciaForceMode && ServiceBinding.SOAP.equals((Object)serviceBinding) && (soapStreamReader == null || soapStreamReader.getRootElementLocalName() == null || soapStreamReader.getRootElementNamespace() == null)) {
            logCore.debug("Cache della richiesta non utilizzabile con la modalit\u00e0 di identificazione dell'azione basata sull'interfaccia (force) e soapStreamReader root element non disponibile");
            requestInfo.setRequestConfig(null);
            requestInfo.setRequestRateLimitingConfig(null);
        }
    }

    public static void checkRequestInfoConfig(PortaDelegata pdDefault, Logger logCore, ServiceBinding serviceBinding, OpenSPCoop2MessageSoapStreamReader soapStreamReader, RequestInfo requestInfo) {
        boolean identificazioneByInterfaccia = false;
        boolean identificazioneByInterfacciaForceMode = false;
        if (pdDefault != null && pdDefault.getAzione() != null && pdDefault.getAzione().getIdentificazione() != null) {
            if (PortaDelegataAzioneIdentificazione.CONTENT_BASED.equals((Object)pdDefault.getAzione().getIdentificazione()) || PortaDelegataAzioneIdentificazione.INPUT_BASED.equals((Object)pdDefault.getAzione().getIdentificazione()) || PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)pdDefault.getAzione().getIdentificazione())) {
                String msg = CACHE_NON_UTILIZZABILE_AZIONE + pdDefault.getAzione().getIdentificazione() + "'";
                logCore.debug(msg);
                requestInfo.setRequestConfig(null);
                requestInfo.setRequestRateLimitingConfig(null);
                return;
            }
            identificazioneByInterfaccia = PortaDelegataAzioneIdentificazione.INTERFACE_BASED.equals((Object)pdDefault.getAzione().getIdentificazione());
            boolean bl = identificazioneByInterfacciaForceMode = pdDefault.getAzione().getForceInterfaceBased() == null || StatoFunzionalita.ABILITATO.equals((Object)pdDefault.getAzione().getForceInterfaceBased());
        }
        if (identificazioneByInterfaccia && ServiceBinding.SOAP.equals((Object)serviceBinding) && (soapStreamReader == null || soapStreamReader.getRootElementLocalName() == null || soapStreamReader.getRootElementNamespace() == null)) {
            String msg = CACHE_NON_UTILIZZABILE_AZIONE + pdDefault.getAzione().getIdentificazione() + "' e soapStreamReader root element non disponibile";
            logCore.debug(msg);
            requestInfo.setRequestConfig(null);
            requestInfo.setRequestRateLimitingConfig(null);
            return;
        }
        if (identificazioneByInterfacciaForceMode && ServiceBinding.SOAP.equals((Object)serviceBinding) && (soapStreamReader == null || soapStreamReader.getRootElementLocalName() == null || soapStreamReader.getRootElementNamespace() == null)) {
            logCore.debug("Cache della richiesta non utilizzabile con la modalit\u00e0 di identificazione dell'azione basata sull'interfaccia (force) e soapStreamReader root element non disponibile");
            requestInfo.setRequestConfig(null);
            requestInfo.setRequestRateLimitingConfig(null);
        }
    }

    public static RequestInfo normalizeRequestInfoBeforeSerialization(OpenSPCoop2Message msg) {
        Object oRequestInfo = msg.getContextProperty(Costanti.REQUEST_INFO);
        if (oRequestInfo instanceof RequestInfo) {
            RequestInfo requestInfo = (RequestInfo)oRequestInfo;
            return RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerializationEngine(requestInfo);
        }
        return null;
    }

    public static RequestInfo normalizeRequestInfoBeforeSerialization(Context context) {
        Object oRequestInfo = context.get(Costanti.REQUEST_INFO);
        if (oRequestInfo instanceof RequestInfo) {
            RequestInfo requestInfo = (RequestInfo)oRequestInfo;
            return RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerializationEngine(requestInfo);
        }
        return null;
    }

    private static RequestInfo normalizeRequestInfoBeforeSerializationEngine(RequestInfo requestInfo) {
        RequestConfig preRequestConfig = requestInfo.getPreRequestConfig();
        requestInfo.setPreRequestConfig(null);
        RequestConfig requestConfig = requestInfo.getRequestConfig();
        requestInfo.setRequestConfig(null);
        RequestRateLimitingConfig requestRateLimitingConfig = requestInfo.getRequestRateLimitingConfig();
        requestInfo.setRequestRateLimitingConfig(null);
        RequestThreadContext requestThreadContext = requestInfo.getRequestThreadContext();
        requestInfo.setRequestThreadContext(null);
        Map<String, Object> dynamicMap = requestInfo.getDynamicMap();
        requestInfo.setDynamicMap(null);
        RequestInfo requestInfoBackup = new RequestInfo();
        requestInfoBackup.setPreRequestConfig(preRequestConfig);
        requestInfoBackup.setRequestConfig(requestConfig);
        requestInfoBackup.setRequestRateLimitingConfig(requestRateLimitingConfig);
        requestInfoBackup.setRequestThreadContext(requestThreadContext);
        requestInfoBackup.setDynamicMap(dynamicMap);
        return requestInfoBackup;
    }

    public static void restoreRequestInfoAfterSerialization(OpenSPCoop2Message msg, RequestInfo requestInfoBackup) {
        if (requestInfoBackup == null) {
            return;
        }
        Object oRequestInfo = msg.getContextProperty(Costanti.REQUEST_INFO);
        if (oRequestInfo instanceof RequestInfo) {
            RequestInfo requestInfo = (RequestInfo)oRequestInfo;
            RequestInfoConfigUtilities.restoreRequestInfoAfterSerializationEngine(requestInfo, requestInfoBackup);
        }
    }

    public static void restoreRequestInfoAfterSerialization(Context context, RequestInfo requestInfoBackup) {
        if (requestInfoBackup == null) {
            return;
        }
        Object oRequestInfo = context.get(Costanti.REQUEST_INFO);
        if (oRequestInfo instanceof RequestInfo) {
            RequestInfo requestInfo = (RequestInfo)oRequestInfo;
            RequestInfoConfigUtilities.restoreRequestInfoAfterSerializationEngine(requestInfo, requestInfoBackup);
        }
    }

    private static void restoreRequestInfoAfterSerializationEngine(RequestInfo requestInfo, RequestInfo requestInfoBackup) {
        requestInfo.setPreRequestConfig(requestInfoBackup.getPreRequestConfig());
        requestInfo.setRequestConfig(requestInfoBackup.getRequestConfig());
        requestInfo.setRequestRateLimitingConfig(requestInfoBackup.getRequestRateLimitingConfig());
        requestInfo.setRequestThreadContext(requestInfoBackup.getRequestThreadContext());
        requestInfo.setDynamicMap(requestInfoBackup.getDynamicMap());
    }
}

